/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public abstract class ReferenceBinding
extends TypeBinding {
    public char[][] compoundName;
    public char[] sourceName;
    public int modifiers;
    public PackageBinding fPackage;
    char[] fileName;
    char[] constantPoolName;
    char[] signature;
    private SimpleLookupTable compatibleCache;
    int typeBits;
    protected MethodBinding[] singleAbstractMethod;
    public static final ReferenceBinding LUB_GENERIC = new ReferenceBinding(){
        {
            this.id = 0;
        }

        public boolean hasTypeBit(int n) {
            return false;
        }
    };
    private static final Comparator<FieldBinding> FIELD_COMPARATOR = new Comparator<FieldBinding>(){

        @Override
        public int compare(FieldBinding fieldBinding, FieldBinding fieldBinding2) {
            char[] cArray = fieldBinding.name;
            char[] cArray2 = fieldBinding2.name;
            return ReferenceBinding.compare(cArray, cArray2, cArray.length, cArray2.length);
        }
    };
    private static final Comparator<MethodBinding> METHOD_COMPARATOR = new Comparator<MethodBinding>(){

        @Override
        public int compare(MethodBinding methodBinding, MethodBinding methodBinding2) {
            MethodBinding methodBinding3 = methodBinding;
            MethodBinding methodBinding4 = methodBinding2;
            char[] cArray = methodBinding3.selector;
            char[] cArray2 = methodBinding4.selector;
            int n = ReferenceBinding.compare(cArray, cArray2, cArray.length, cArray2.length);
            return n == 0 ? methodBinding3.parameters.length - methodBinding4.parameters.length : n;
        }
    };
    protected static ProblemMethodBinding samProblemBinding = new ProblemMethodBinding(TypeConstants.ANONYMOUS_METHOD, null, 17);

    public ReferenceBinding(ReferenceBinding referenceBinding) {
        super(referenceBinding);
        this.compoundName = referenceBinding.compoundName;
        this.sourceName = referenceBinding.sourceName;
        this.modifiers = referenceBinding.modifiers;
        this.fPackage = referenceBinding.fPackage;
        this.fileName = referenceBinding.fileName;
        this.constantPoolName = referenceBinding.constantPoolName;
        this.signature = referenceBinding.signature;
        this.compatibleCache = referenceBinding.compatibleCache;
        this.typeBits = referenceBinding.typeBits;
        this.singleAbstractMethod = referenceBinding.singleAbstractMethod;
    }

    public ReferenceBinding() {
    }

    public static FieldBinding binarySearch(char[] cArray, FieldBinding[] fieldBindingArray) {
        if (fieldBindingArray == null) {
            return null;
        }
        int n = fieldBindingArray.length;
        if (n == 0) {
            return null;
        }
        int n2 = 0;
        int n3 = n - 1;
        int n4 = cArray.length;
        int n5 = 0;
        while (n2 <= n3) {
            n5 = n2 + (n3 - n2) / 2;
            char[] cArray2 = fieldBindingArray[n5].name;
            int n6 = ReferenceBinding.compare(cArray, fieldBindingArray[n5].name, n4, cArray2.length);
            if (n6 < 0) {
                n3 = n5 - 1;
                continue;
            }
            if (n6 > 0) {
                n2 = n5 + 1;
                continue;
            }
            return fieldBindingArray[n5];
        }
        return null;
    }

    public static long binarySearch(char[] cArray, MethodBinding[] methodBindingArray) {
        if (methodBindingArray == null) {
            return -1L;
        }
        int n = methodBindingArray.length;
        if (n == 0) {
            return -1L;
        }
        int n2 = 0;
        int n3 = n - 1;
        int n4 = cArray.length;
        int n5 = 0;
        while (n2 <= n3) {
            n5 = n2 + (n3 - n2) / 2;
            char[] cArray2 = methodBindingArray[n5].selector;
            int n6 = ReferenceBinding.compare(cArray, methodBindingArray[n5].selector, n4, cArray2.length);
            if (n6 < 0) {
                n3 = n5 - 1;
                continue;
            }
            if (n6 > 0) {
                n2 = n5 + 1;
                continue;
            }
            int n7 = n5;
            int n8 = n5;
            while (n7 > n2 && CharOperation.equals(methodBindingArray[n7 - 1].selector, cArray)) {
                --n7;
            }
            while (n8 < n3 && CharOperation.equals(methodBindingArray[n8 + 1].selector, cArray)) {
                ++n8;
            }
            return (long)n7 + ((long)n8 << 32);
        }
        return -1L;
    }

    static int compare(char[] cArray, char[] cArray2, int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = cArray[n4];
            if (c2 == (c = cArray2[n4++])) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static void sortFields(FieldBinding[] fieldBindingArray, int n, int n2) {
        Arrays.sort(fieldBindingArray, n, n2, FIELD_COMPARATOR);
    }

    public static void sortMethods(MethodBinding[] methodBindingArray, int n, int n2) {
        Arrays.sort(methodBindingArray, n, n2, METHOD_COMPARATOR);
    }

    public FieldBinding[] availableFields() {
        return this.fields();
    }

    public MethodBinding[] availableMethods() {
        return this.methods();
    }

    public boolean canBeInstantiated() {
        return (this.modifiers & 0x6600) == 0;
    }

    public boolean canBeSeenBy(PackageBinding packageBinding) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return packageBinding == this.fPackage;
    }

    public boolean canBeSeenBy(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        block18: {
            ReferenceBinding referenceBinding3;
            block19: {
                block20: {
                    if (this.isPublic()) {
                        return true;
                    }
                    if (TypeBinding.equalsEquals(referenceBinding2, this) && TypeBinding.equalsEquals(referenceBinding2, referenceBinding)) {
                        return true;
                    }
                    if (this.isProtected()) {
                        if (TypeBinding.equalsEquals(referenceBinding2, this)) {
                            return true;
                        }
                        if (referenceBinding2.fPackage == this.fPackage) {
                            return true;
                        }
                        TypeBinding typeBinding = referenceBinding2.erasure();
                        TypeBinding typeBinding2 = this.enclosingType().erasure();
                        if (TypeBinding.equalsEquals(typeBinding2, referenceBinding2)) {
                            return true;
                        }
                        if (typeBinding2 == null) {
                            return false;
                        }
                        do {
                            if (typeBinding.findSuperTypeOriginatingFrom(typeBinding2) == null) continue;
                            return true;
                        } while ((typeBinding = typeBinding.enclosingType()) != null);
                        return false;
                    }
                    if (!this.isPrivate()) break block18;
                    if (TypeBinding.equalsEquals(referenceBinding, this) || TypeBinding.equalsEquals(referenceBinding, this.enclosingType())) break block19;
                    if (!referenceBinding.isTypeVariable()) break block20;
                    referenceBinding3 = (TypeVariableBinding)referenceBinding;
                    if (((TypeVariableBinding)referenceBinding3).environment.globalOptions.complianceLevel <= 0x320000L && (((TypeVariableBinding)referenceBinding3).isErasureBoundTo(this.erasure()) || ((TypeVariableBinding)referenceBinding3).isErasureBoundTo(this.enclosingType().erasure()))) break block19;
                }
                return false;
            }
            if (TypeBinding.notEquals(referenceBinding2, this)) {
                referenceBinding3 = referenceBinding2;
                ReferenceBinding referenceBinding4 = referenceBinding3.enclosingType();
                while (referenceBinding4 != null) {
                    referenceBinding3 = referenceBinding4;
                    referenceBinding4 = referenceBinding4.enclosingType();
                }
                ReferenceBinding referenceBinding5 = (ReferenceBinding)this.erasure();
                referenceBinding4 = referenceBinding5.enclosingType();
                while (referenceBinding4 != null) {
                    referenceBinding5 = referenceBinding4;
                    referenceBinding4 = referenceBinding4.enclosingType();
                }
                if (TypeBinding.notEquals(referenceBinding3, referenceBinding5)) {
                    return false;
                }
            }
            return true;
        }
        if (referenceBinding2.fPackage != this.fPackage) {
            return false;
        }
        ReferenceBinding referenceBinding6 = referenceBinding;
        TypeBinding typeBinding = (this.enclosingType() == null ? this : this.enclosingType()).original();
        do {
            if (referenceBinding6.isCapture() ? TypeBinding.equalsEquals(typeBinding, referenceBinding6.erasure().original()) : TypeBinding.equalsEquals(typeBinding, referenceBinding6.original())) {
                return true;
            }
            PackageBinding packageBinding = referenceBinding6.fPackage;
            if (packageBinding == null || packageBinding == this.fPackage) continue;
            return false;
        } while ((referenceBinding6 = referenceBinding6.superclass()) != null);
        return false;
    }

    public boolean canBeSeenBy(Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (TypeBinding.equalsEquals(sourceTypeBinding, this)) {
            return true;
        }
        if (sourceTypeBinding == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.fPackage;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding.fPackage == this.fPackage) {
                return true;
            }
            TypeBinding typeBinding = this.enclosingType();
            if (typeBinding == null) {
                return false;
            }
            typeBinding = typeBinding.erasure();
            TypeBinding typeBinding2 = sourceTypeBinding.erasure();
            do {
                if (TypeBinding.equalsEquals(typeBinding, sourceTypeBinding)) {
                    return true;
                }
                if (typeBinding2.findSuperTypeOriginatingFrom(typeBinding) == null) continue;
                return true;
            } while ((typeBinding2 = typeBinding2.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            ReferenceBinding referenceBinding = sourceTypeBinding;
            ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
            while (referenceBinding2 != null) {
                referenceBinding = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            ReferenceBinding referenceBinding3 = (ReferenceBinding)this.erasure();
            referenceBinding2 = referenceBinding3.enclosingType();
            while (referenceBinding2 != null) {
                referenceBinding3 = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            return TypeBinding.equalsEquals(referenceBinding, referenceBinding3);
        }
        return sourceTypeBinding.fPackage == this.fPackage;
    }

    public char[] computeGenericTypeSignature(TypeVariableBinding[] typeVariableBindingArray) {
        char[] cArray;
        boolean bl;
        boolean bl2 = bl = this.isMemberType() && (this.enclosingType().modifiers & 0x40000000) != 0;
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES && !bl) {
            return this.signature();
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (bl) {
            cArray = this.enclosingType().genericTypeSignature();
            stringBuffer.append(cArray, 0, cArray.length - 1);
            stringBuffer.append('.');
            stringBuffer.append(this.sourceName);
        } else {
            cArray = this.signature();
            stringBuffer.append(cArray, 0, cArray.length - 1);
        }
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            stringBuffer.append(';');
        } else {
            stringBuffer.append('<');
            int n = 0;
            int n2 = typeVariableBindingArray.length;
            while (n < n2) {
                stringBuffer.append(typeVariableBindingArray[n].genericTypeSignature());
                ++n;
            }
            stringBuffer.append(">;");
        }
        int n = stringBuffer.length();
        char[] cArray2 = new char[n];
        stringBuffer.getChars(0, n, cArray2, 0);
        return cArray2;
    }

    public void computeId() {
        block0 : switch (this.compoundName.length) {
            case 3: {
                char[] cArray = this.compoundName[0];
                switch (cArray.length) {
                    case 3: {
                        if (CharOperation.equals(TypeConstants.ORG_JUNIT_ASSERT, this.compoundName)) {
                            this.id = 70;
                        }
                        return;
                    }
                    case 4: {
                        if (CharOperation.equals(TypeConstants.JAVA, cArray)) break;
                        return;
                    }
                    case 5: {
                        switch (cArray[1]) {
                            case 'a': {
                                if (CharOperation.equals(TypeConstants.JAVAX_ANNOTATION_INJECT_INJECT, this.compoundName)) {
                                    this.id = 80;
                                }
                                return;
                            }
                            case 'u': {
                                if (CharOperation.equals(TypeConstants.JUNIT_FRAMEWORK_ASSERT, this.compoundName)) {
                                    this.id = 69;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    default: {
                        return;
                    }
                }
                cArray = this.compoundName[1];
                if (cArray.length == 0) {
                    return;
                }
                char[] cArray2 = this.compoundName[2];
                if (cArray2.length == 0) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.LANG, this.compoundName[1])) {
                    switch (cArray[0]) {
                        case 'i': {
                            if (CharOperation.equals(cArray, TypeConstants.IO)) {
                                switch (cArray2[0]) {
                                    case 'C': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_CLOSEABLE[2])) {
                                            this.typeBits |= 2;
                                        }
                                        return;
                                    }
                                    case 'E': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_EXTERNALIZABLE[2])) {
                                            this.id = 56;
                                        }
                                        return;
                                    }
                                    case 'I': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_IOEXCEPTION[2])) {
                                            this.id = 58;
                                        }
                                        return;
                                    }
                                    case 'O': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_OBJECTSTREAMEXCEPTION[2])) {
                                            this.id = 57;
                                        }
                                        return;
                                    }
                                    case 'P': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_PRINTSTREAM[2])) {
                                            this.id = 53;
                                        }
                                        return;
                                    }
                                    case 'S': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_IO_SERIALIZABLE[2])) {
                                            this.id = 37;
                                        }
                                        return;
                                    }
                                }
                            }
                            return;
                        }
                        case 'u': {
                            if (CharOperation.equals(cArray, TypeConstants.UTIL)) {
                                switch (cArray2[0]) {
                                    case 'C': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_UTIL_COLLECTION[2])) {
                                            this.id = 59;
                                        }
                                        return;
                                    }
                                    case 'I': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_UTIL_ITERATOR[2])) {
                                            this.id = 39;
                                        }
                                        return;
                                    }
                                    case 'O': {
                                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_UTIL_OBJECTS[2])) {
                                            this.id = 74;
                                        }
                                        return;
                                    }
                                }
                            }
                            return;
                        }
                    }
                    return;
                }
                switch (cArray2[0]) {
                    case 'A': {
                        switch (cArray2.length) {
                            case 13: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_AUTOCLOSEABLE[2])) {
                                    this.id = 62;
                                    this.typeBits |= 1;
                                }
                                return;
                            }
                            case 14: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ASSERTIONERROR[2])) {
                                    this.id = 35;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'B': {
                        switch (cArray2.length) {
                            case 4: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_BYTE[2])) {
                                    this.id = 26;
                                }
                                return;
                            }
                            case 7: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_BOOLEAN[2])) {
                                    this.id = 33;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'C': {
                        switch (cArray2.length) {
                            case 5: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_CLASS[2])) {
                                    this.id = 16;
                                }
                                return;
                            }
                            case 9: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_CHARACTER[2])) {
                                    this.id = 28;
                                } else if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_CLONEABLE[2])) {
                                    this.id = 36;
                                }
                                return;
                            }
                            case 22: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_CLASSNOTFOUNDEXCEPTION[2])) {
                                    this.id = 23;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'D': {
                        switch (cArray2.length) {
                            case 6: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_DOUBLE[2])) {
                                    this.id = 32;
                                }
                                return;
                            }
                            case 10: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_DEPRECATED[2])) {
                                    this.id = 44;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'E': {
                        switch (cArray2.length) {
                            case 4: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ENUM[2])) {
                                    this.id = 41;
                                }
                                return;
                            }
                            case 5: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ERROR[2])) {
                                    this.id = 19;
                                }
                                return;
                            }
                            case 9: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_EXCEPTION[2])) {
                                    this.id = 25;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'F': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_FLOAT[2])) {
                            this.id = 31;
                        } else if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_FUNCTIONAL_INTERFACE[2])) {
                            this.id = 77;
                        }
                        return;
                    }
                    case 'I': {
                        switch (cArray2.length) {
                            case 7: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_INTEGER[2])) {
                                    this.id = 29;
                                }
                                return;
                            }
                            case 8: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ITERABLE[2])) {
                                    this.id = 38;
                                }
                                return;
                            }
                            case 24: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_ILLEGALARGUMENTEXCEPTION[2])) {
                                    this.id = 42;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'L': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_LONG[2])) {
                            this.id = 30;
                        }
                        return;
                    }
                    case 'N': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_NOCLASSDEFERROR[2])) {
                            this.id = 22;
                        }
                        return;
                    }
                    case 'O': {
                        switch (cArray2.length) {
                            case 6: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_OBJECT[2])) {
                                    this.id = 1;
                                }
                                return;
                            }
                            case 8: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_OVERRIDE[2])) {
                                    this.id = 47;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'R': {
                        if (!CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION[2])) break block0;
                        this.id = 24;
                        break block0;
                    }
                    case 'S': {
                        switch (cArray2.length) {
                            case 5: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_SHORT[2])) {
                                    this.id = 27;
                                }
                                return;
                            }
                            case 6: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_STRING[2])) {
                                    this.id = 11;
                                } else if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_SYSTEM[2])) {
                                    this.id = 18;
                                }
                                return;
                            }
                            case 11: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_SAFEVARARGS[2])) {
                                    this.id = 60;
                                }
                                return;
                            }
                            case 12: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_STRINGBUFFER[2])) {
                                    this.id = 17;
                                }
                                return;
                            }
                            case 13: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_STRINGBUILDER[2])) {
                                    this.id = 40;
                                }
                                return;
                            }
                            case 16: {
                                if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_SUPPRESSWARNINGS[2])) {
                                    this.id = 49;
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'T': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_THROWABLE[2])) {
                            this.id = 21;
                        }
                        return;
                    }
                    case 'V': {
                        if (CharOperation.equals(cArray2, TypeConstants.JAVA_LANG_VOID[2])) {
                            this.id = 34;
                        }
                        return;
                    }
                }
                break;
            }
            case 4: {
                if (CharOperation.equals(TypeConstants.COM_GOOGLE_INJECT_INJECT, this.compoundName)) {
                    this.id = 81;
                    return;
                }
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
                    return;
                }
                char[] cArray = this.compoundName[1];
                if (cArray.length == 0) {
                    return;
                }
                cArray = this.compoundName[2];
                if (cArray.length == 0) {
                    return;
                }
                char[] cArray3 = this.compoundName[3];
                if (cArray3.length == 0) {
                    return;
                }
                switch (cArray[0]) {
                    case 'a': {
                        if (CharOperation.equals(cArray, TypeConstants.ANNOTATION)) {
                            switch (cArray3[0]) {
                                case 'A': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION[3])) {
                                        this.id = 43;
                                    }
                                    return;
                                }
                                case 'D': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED[3])) {
                                        this.id = 45;
                                    }
                                    return;
                                }
                                case 'E': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE[3])) {
                                        this.id = 52;
                                    }
                                    return;
                                }
                                case 'I': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_INHERITED[3])) {
                                        this.id = 46;
                                    }
                                    return;
                                }
                                case 'R': {
                                    switch (cArray3.length) {
                                        case 9: {
                                            if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_RETENTION[3])) {
                                                this.id = 48;
                                            }
                                            return;
                                        }
                                        case 10: {
                                            if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_REPEATABLE[3])) {
                                                this.id = 90;
                                            }
                                            return;
                                        }
                                        case 15: {
                                            if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY[3])) {
                                                this.id = 51;
                                            }
                                            return;
                                        }
                                    }
                                    return;
                                }
                                case 'T': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_ANNOTATION_TARGET[3])) {
                                        this.id = 50;
                                    }
                                    return;
                                }
                            }
                        }
                        return;
                    }
                    case 'i': {
                        if (CharOperation.equals(cArray, TypeConstants.INVOKE)) {
                            if (cArray3.length == 0) {
                                return;
                            }
                            switch (cArray3[0]) {
                                case 'M': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_$_POLYMORPHICSIGNATURE[3])) {
                                        this.id = 61;
                                    }
                                    return;
                                }
                            }
                        }
                        return;
                    }
                    case 'r': {
                        if (CharOperation.equals(cArray, TypeConstants.REFLECT)) {
                            switch (cArray3[0]) {
                                case 'C': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_REFLECT_CONSTRUCTOR[2])) {
                                        this.id = 20;
                                    }
                                    return;
                                }
                                case 'F': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_REFLECT_FIELD[2])) {
                                        this.id = 54;
                                    }
                                    return;
                                }
                                case 'M': {
                                    if (CharOperation.equals(cArray3, TypeConstants.JAVA_LANG_REFLECT_METHOD[2])) {
                                        this.id = 55;
                                    }
                                    return;
                                }
                            }
                        }
                        return;
                    }
                }
                break;
            }
            case 5: {
                char[] cArray = this.compoundName[0];
                switch (cArray[0]) {
                    case 'j': {
                        if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
                            return;
                        }
                        cArray = this.compoundName[1];
                        if (cArray.length == 0) {
                            return;
                        }
                        if (CharOperation.equals(TypeConstants.LANG, cArray)) {
                            cArray = this.compoundName[2];
                            if (cArray.length == 0) {
                                return;
                            }
                            switch (cArray[0]) {
                                case 'i': {
                                    if (CharOperation.equals(cArray, TypeConstants.INVOKE)) {
                                        char[] cArray4 = this.compoundName[3];
                                        if (cArray4.length == 0) {
                                            return;
                                        }
                                        switch (cArray4[0]) {
                                            case 'M': {
                                                char[] cArray5 = this.compoundName[4];
                                                if (cArray5.length == 0) {
                                                    return;
                                                }
                                                if (CharOperation.equals(cArray4, TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_POLYMORPHICSIGNATURE[3]) && CharOperation.equals(cArray5, TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_POLYMORPHICSIGNATURE[4])) {
                                                    this.id = 61;
                                                }
                                                return;
                                            }
                                        }
                                    }
                                    return;
                                }
                            }
                            return;
                        }
                        return;
                    }
                    case 'o': {
                        if (!CharOperation.equals(TypeConstants.ORG, this.compoundName[0])) {
                            return;
                        }
                        cArray = this.compoundName[1];
                        if (cArray.length == 0) {
                            return;
                        }
                        switch (cArray[0]) {
                            case 'e': {
                                if (CharOperation.equals(TypeConstants.ECLIPSE, cArray)) {
                                    cArray = this.compoundName[2];
                                    if (cArray.length == 0) {
                                        return;
                                    }
                                    switch (cArray[0]) {
                                        case 'c': {
                                            if (CharOperation.equals(cArray, TypeConstants.CORE)) {
                                                char[] cArray6 = this.compoundName[3];
                                                if (cArray6.length == 0) {
                                                    return;
                                                }
                                                switch (cArray6[0]) {
                                                    case 'r': {
                                                        char[] cArray7 = this.compoundName[4];
                                                        if (cArray7.length == 0) {
                                                            return;
                                                        }
                                                        if (CharOperation.equals(cArray6, TypeConstants.ORG_ECLIPSE_CORE_RUNTIME_ASSERT[3]) && CharOperation.equals(cArray7, TypeConstants.ORG_ECLIPSE_CORE_RUNTIME_ASSERT[4])) {
                                                            this.id = 68;
                                                        }
                                                        return;
                                                    }
                                                }
                                            }
                                            return;
                                        }
                                    }
                                    return;
                                }
                                return;
                            }
                            case 'a': {
                                if (CharOperation.equals(TypeConstants.APACHE, cArray) && CharOperation.equals(TypeConstants.COMMONS, this.compoundName[2])) {
                                    if (CharOperation.equals(TypeConstants.ORG_APACHE_COMMONS_LANG_VALIDATE, this.compoundName)) {
                                        this.id = 71;
                                    } else if (CharOperation.equals(TypeConstants.ORG_APACHE_COMMONS_LANG3_VALIDATE, this.compoundName)) {
                                        this.id = 72;
                                    }
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 'c': {
                        if (!CharOperation.equals(TypeConstants.COM, this.compoundName[0])) {
                            return;
                        }
                        if (CharOperation.equals(TypeConstants.COM_GOOGLE_COMMON_BASE_PRECONDITIONS, this.compoundName)) {
                            this.id = 73;
                        }
                        return;
                    }
                }
                break;
            }
            case 6: {
                if (!CharOperation.equals(TypeConstants.ORG, this.compoundName[0])) break;
                if (CharOperation.equals(TypeConstants.SPRING, this.compoundName[1])) {
                    if (CharOperation.equals(TypeConstants.AUTOWIRED, this.compoundName[5]) && CharOperation.equals(TypeConstants.ORG_SPRING_AUTOWIRED, this.compoundName)) {
                        this.id = 82;
                    }
                    return;
                }
                if (!CharOperation.equals(TypeConstants.JDT, this.compoundName[2]) || !CharOperation.equals(TypeConstants.ITYPEBINDING, this.compoundName[5])) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.ORG_ECLIPSE_JDT_CORE_DOM_ITYPEBINDING, this.compoundName)) break;
                this.typeBits |= 0x10;
                break;
            }
            case 7: {
                if (!CharOperation.equals(TypeConstants.JDT, this.compoundName[2]) || !CharOperation.equals(TypeConstants.TYPEBINDING, this.compoundName[6])) {
                    return;
                }
                if (!CharOperation.equals(TypeConstants.ORG_ECLIPSE_JDT_INTERNAL_COMPILER_LOOKUP_TYPEBINDING, this.compoundName)) break;
                this.typeBits |= 0x10;
            }
        }
    }

    public void computeId(LookupEnvironment lookupEnvironment) {
        lookupEnvironment.getUnannotatedType(this);
    }

    public char[] computeUniqueKey(boolean bl) {
        if (!bl) {
            return this.signature();
        }
        return this.genericTypeSignature();
    }

    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        this.constantPoolName = CharOperation.concatWith(this.compoundName, '/');
        return this.constantPoolName;
    }

    public String debugName() {
        return this.compoundName != null ? (this.hasTypeAnnotations() ? this.annotatedDebugName() : new String(this.readableName())) : "UNNAMED TYPE";
    }

    public int depth() {
        int n = 0;
        ReferenceBinding referenceBinding = this;
        while ((referenceBinding = referenceBinding.enclosingType()) != null) {
            ++n;
        }
        return n;
    }

    public boolean detectAnnotationCycle() {
        if ((this.tagBits & 0x100000000L) != 0L) {
            return false;
        }
        if ((this.tagBits & 0x80000000L) != 0L) {
            return true;
        }
        this.tagBits |= 0x80000000L;
        MethodBinding[] methodBindingArray = this.methods();
        boolean bl = false;
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            MethodDeclaration methodDeclaration;
            TypeBinding typeBinding = methodBindingArray[n].returnType.leafComponentType().erasure();
            if (TypeBinding.equalsEquals(this, typeBinding)) {
                if (this instanceof SourceTypeBinding) {
                    methodDeclaration = (MethodDeclaration)methodBindingArray[n].sourceMethod();
                    ((SourceTypeBinding)this).scope.problemReporter().annotationCircularity(this, this, methodDeclaration != null ? methodDeclaration.returnType : null);
                }
            } else if (typeBinding.isAnnotationType() && ((ReferenceBinding)typeBinding).detectAnnotationCycle()) {
                if (this instanceof SourceTypeBinding) {
                    methodDeclaration = (MethodDeclaration)methodBindingArray[n].sourceMethod();
                    ((SourceTypeBinding)this).scope.problemReporter().annotationCircularity(this, typeBinding, methodDeclaration != null ? methodDeclaration.returnType : null);
                }
                bl = true;
            }
            ++n;
        }
        if (bl) {
            return true;
        }
        this.tagBits |= 0x100000000L;
        return false;
    }

    public final ReferenceBinding enclosingTypeAt(int n) {
        ReferenceBinding referenceBinding = this;
        while (n-- > 0 && referenceBinding != null) {
            referenceBinding = referenceBinding.enclosingType();
        }
        return referenceBinding;
    }

    public int enumConstantCount() {
        int n = 0;
        FieldBinding[] fieldBindingArray = this.fields();
        int n2 = 0;
        int n3 = fieldBindingArray.length;
        while (n2 < n3) {
            if ((fieldBindingArray[n2].modifiers & 0x4000) != 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int fieldCount() {
        return this.fields().length;
    }

    public FieldBinding[] fields() {
        return Binding.NO_FIELDS;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public AnnotationBinding[] getAnnotations() {
        return this.retrieveAnnotations(this);
    }

    public long getAnnotationTagBits() {
        return this.tagBits;
    }

    public int getEnclosingInstancesSlotSize() {
        if (this.isStatic()) {
            return 0;
        }
        return this.enclosingType() == null ? 0 : 1;
    }

    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        return null;
    }

    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        return null;
    }

    public FieldBinding getField(char[] cArray, boolean bl) {
        return null;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public ReferenceBinding getMemberType(char[] cArray) {
        ReferenceBinding[] referenceBindingArray = this.memberTypes();
        int n = referenceBindingArray.length;
        while (--n >= 0) {
            if (!CharOperation.equals(referenceBindingArray[n].sourceName, cArray)) continue;
            return referenceBindingArray[n];
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] cArray) {
        return Binding.NO_METHODS;
    }

    public MethodBinding[] getMethods(char[] cArray, int n) {
        return this.getMethods(cArray);
    }

    public int getOuterLocalVariablesSlotSize() {
        return 0;
    }

    public PackageBinding getPackage() {
        return this.fPackage;
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        TypeVariableBinding[] typeVariableBindingArray = this.typeVariables();
        int n = typeVariableBindingArray.length;
        while (--n >= 0) {
            if (!CharOperation.equals(typeVariableBindingArray[n].sourceName, cArray)) continue;
            return typeVariableBindingArray[n];
        }
        return null;
    }

    public int hashCode() {
        return this.compoundName == null || this.compoundName.length == 0 ? super.hashCode() : CharOperation.hashCode(this.compoundName[this.compoundName.length - 1]);
    }

    public boolean hasIncompatibleSuperType(ReferenceBinding referenceBinding) {
        int n;
        TypeBinding typeBinding;
        if (TypeBinding.equalsEquals(this, referenceBinding)) {
            return false;
        }
        ReferenceBinding[] referenceBindingArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding2 = this;
        do {
            if ((typeBinding = referenceBinding.findSuperTypeOriginatingFrom(referenceBinding2)) != null && typeBinding.isProvablyDistinct(referenceBinding2)) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray2 = referenceBinding2.superInterfaces();
            if (referenceBindingArray2 == null || referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray == null) {
                referenceBindingArray = referenceBindingArray2;
                n2 = referenceBindingArray.length;
                continue;
            }
            int n3 = referenceBindingArray2.length;
            if (n2 + n3 >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
            }
            n = 0;
            while (n < n3) {
                block16: {
                    ReferenceBinding referenceBinding3 = referenceBindingArray2[n];
                    int n4 = 0;
                    while (n4 < n2) {
                        if (!TypeBinding.equalsEquals(referenceBinding3, referenceBindingArray[n4])) {
                            ++n4;
                            continue;
                        }
                        break block16;
                    }
                    referenceBindingArray[n2++] = referenceBinding3;
                }
                ++n;
            }
        } while ((referenceBinding2 = referenceBinding2.superclass()) != null);
        int n5 = 0;
        while (n5 < n2) {
            referenceBinding2 = referenceBindingArray[n5];
            if (TypeBinding.equalsEquals(referenceBinding2, referenceBinding)) {
                return false;
            }
            typeBinding = referenceBinding.findSuperTypeOriginatingFrom(referenceBinding2);
            if (typeBinding != null && typeBinding.isProvablyDistinct(referenceBinding2)) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray4 = referenceBinding2.superInterfaces();
            if (referenceBindingArray4 != null && referenceBindingArray4 != Binding.NO_SUPERINTERFACES) {
                n = referenceBindingArray4.length;
                if (n2 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray5 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                    System.arraycopy(referenceBindingArray5, 0, referenceBindingArray, 0, n2);
                }
                int n6 = 0;
                while (n6 < n) {
                    block17: {
                        ReferenceBinding referenceBinding4 = referenceBindingArray4[n6];
                        int n7 = 0;
                        while (n7 < n2) {
                            if (!TypeBinding.equalsEquals(referenceBinding4, referenceBindingArray[n7])) {
                                ++n7;
                                continue;
                            }
                            break block17;
                        }
                        referenceBindingArray[n2++] = referenceBinding4;
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        return false;
    }

    public boolean hasMemberTypes() {
        return false;
    }

    boolean hasNonNullDefaultFor(int n, boolean bl) {
        ReferenceBinding referenceBinding = this;
        while (referenceBinding != null) {
            if (bl) {
                int n2 = ((ReferenceBinding)referenceBinding.original()).getNullDefault();
                if (n2 != 0) {
                    return (n2 & n) != 0;
                }
            } else {
                if ((referenceBinding.tagBits & 0x200000000000000L) != 0L) {
                    return true;
                }
                if ((referenceBinding.tagBits & 0x400000000000000L) != 0L) {
                    return false;
                }
            }
            referenceBinding = referenceBinding.enclosingType();
        }
        if (bl) {
            return (this.getPackage().defaultNullness & n) != 0;
        }
        return this.getPackage().defaultNullness == 1;
    }

    int getNullDefault() {
        return 0;
    }

    public boolean acceptsNonNullDefault() {
        return true;
    }

    public final boolean hasRestrictedAccess() {
        return (this.modifiers & 0x40000) != 0;
    }

    public boolean implementsInterface(ReferenceBinding referenceBinding, boolean bl) {
        int n;
        if (TypeBinding.equalsEquals(this, referenceBinding)) {
            return true;
        }
        ReferenceBinding[] referenceBindingArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding2 = this;
        do {
            ReferenceBinding[] referenceBindingArray2;
            if ((referenceBindingArray2 = referenceBinding2.superInterfaces()) == null || referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray == null) {
                referenceBindingArray = referenceBindingArray2;
                n2 = referenceBindingArray.length;
                continue;
            }
            int n3 = referenceBindingArray2.length;
            if (n2 + n3 >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
            }
            n = 0;
            while (n < n3) {
                block14: {
                    ReferenceBinding referenceBinding3 = referenceBindingArray2[n];
                    int n4 = 0;
                    while (n4 < n2) {
                        if (!TypeBinding.equalsEquals(referenceBinding3, referenceBindingArray[n4])) {
                            ++n4;
                            continue;
                        }
                        break block14;
                    }
                    referenceBindingArray[n2++] = referenceBinding3;
                }
                ++n;
            }
        } while (bl && (referenceBinding2 = referenceBinding2.superclass()) != null);
        int n5 = 0;
        while (n5 < n2) {
            referenceBinding2 = referenceBindingArray[n5];
            if (referenceBinding2.isEquivalentTo(referenceBinding)) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray4 = referenceBinding2.superInterfaces();
            if (referenceBindingArray4 != null && referenceBindingArray4 != Binding.NO_SUPERINTERFACES) {
                n = referenceBindingArray4.length;
                if (n2 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray5 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                    System.arraycopy(referenceBindingArray5, 0, referenceBindingArray, 0, n2);
                }
                int n6 = 0;
                while (n6 < n) {
                    block15: {
                        ReferenceBinding referenceBinding4 = referenceBindingArray4[n6];
                        int n7 = 0;
                        while (n7 < n2) {
                            if (!TypeBinding.equalsEquals(referenceBinding4, referenceBindingArray[n7])) {
                                ++n7;
                                continue;
                            }
                            break block15;
                        }
                        referenceBindingArray[n2++] = referenceBinding4;
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        return false;
    }

    boolean implementsMethod(MethodBinding methodBinding) {
        char[] cArray = methodBinding.selector;
        ReferenceBinding referenceBinding = this;
        while (referenceBinding != null) {
            MethodBinding[] methodBindingArray = referenceBinding.methods();
            long l = ReferenceBinding.binarySearch(cArray, methodBindingArray);
            if (l >= 0L) {
                int n = (int)l;
                int n2 = (int)(l >> 32);
                int n3 = n;
                while (n3 <= n2) {
                    if (methodBindingArray[n3].areParametersEqual(methodBinding)) {
                        return true;
                    }
                    ++n3;
                }
            }
            referenceBinding = referenceBinding.superclass();
        }
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isAnnotationType() {
        return (this.modifiers & 0x2000) != 0;
    }

    public final boolean isBinaryBinding() {
        return (this.tagBits & 0x40L) != 0L;
    }

    public boolean isClass() {
        return (this.modifiers & 0x6200) == 0;
    }

    public boolean isProperType(boolean bl) {
        ReferenceBinding referenceBinding = this.enclosingType();
        if (referenceBinding != null && !referenceBinding.isProperType(bl)) {
            return false;
        }
        return super.isProperType(bl);
    }

    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (ReferenceBinding.equalsEquals(typeBinding, this)) {
            return true;
        }
        if (typeBinding.id == 1) {
            return true;
        }
        if (this.compatibleCache == null) {
            this.compatibleCache = new SimpleLookupTable(3);
            Object var3_3 = null;
        } else {
            Object object = this.compatibleCache.get(typeBinding);
            if (object != null) {
                return object == Boolean.TRUE;
            }
        }
        this.compatibleCache.put(typeBinding, Boolean.FALSE);
        if (this.isCompatibleWith0(typeBinding, scope)) {
            this.compatibleCache.put(typeBinding, Boolean.TRUE);
            return true;
        }
        if (scope == null && this instanceof TypeVariableBinding && ((TypeVariableBinding)this).firstBound instanceof ParameterizedTypeBinding) {
            this.compatibleCache.put(typeBinding, null);
        }
        return false;
    }

    private boolean isCompatibleWith0(TypeBinding typeBinding, Scope scope) {
        if (TypeBinding.equalsEquals(typeBinding, this)) {
            return true;
        }
        if (typeBinding.id == 1) {
            return true;
        }
        if (this.isEquivalentTo(typeBinding)) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return false;
            }
            case 4100: {
                Object object;
                Object object2;
                if (typeBinding.isCapture()) {
                    object2 = (CaptureBinding)typeBinding;
                    object = ((CaptureBinding)object2).lowerBound;
                    if (object != null) {
                        if (((TypeBinding)object).isArrayType()) {
                            return false;
                        }
                        return this.isCompatibleWith((TypeBinding)object);
                    }
                }
                if (typeBinding instanceof InferenceVariable && scope != null && (object2 = scope.methodScope()) != null && (object = ((MethodScope)object2).referenceContext) instanceof LambdaExpression && ((LambdaExpression)object).inferenceContext != null) {
                    return true;
                }
            }
            case 4: 
            case 260: 
            case 1028: 
            case 2052: {
                Object object;
                switch (this.kind()) {
                    case 260: 
                    case 1028: 
                    case 2052: {
                        if (!TypeBinding.equalsEquals(this.erasure(), typeBinding.erasure())) break;
                        return false;
                    }
                }
                Object object2 = (ReferenceBinding)typeBinding;
                if (((ReferenceBinding)object2).isInterface()) {
                    if (this.implementsInterface((ReferenceBinding)object2, true)) {
                        return true;
                    }
                    if (this instanceof TypeVariableBinding && scope != null) {
                        object = (TypeVariableBinding)this;
                        if (((TypeVariableBinding)object).firstBound instanceof ParameterizedTypeBinding) {
                            TypeBinding typeBinding2 = ((TypeVariableBinding)object).firstBound.capture(scope, -1, -1);
                            return typeBinding2.isCompatibleWith((TypeBinding)object2);
                        }
                    }
                }
                if (this.isInterface()) {
                    return false;
                }
                return ((ReferenceBinding)object2).isSuperclassOf(this);
            }
        }
        return false;
    }

    public boolean isSubtypeOf(TypeBinding typeBinding) {
        if (this.isSubTypeOfRTL(typeBinding)) {
            return true;
        }
        TypeBinding typeBinding2 = this.findSuperTypeOriginatingFrom(typeBinding);
        if (typeBinding2 == null) {
            return false;
        }
        if (TypeBinding.equalsEquals(typeBinding2, typeBinding)) {
            return true;
        }
        if (typeBinding.isRawType() && TypeBinding.equalsEquals(typeBinding2.erasure(), typeBinding.erasure())) {
            return true;
        }
        TypeBinding[] typeBindingArray = typeBinding.typeArguments();
        TypeBinding[] typeBindingArray2 = typeBinding2.typeArguments();
        if (typeBindingArray2 == null || typeBindingArray == null) {
            return false;
        }
        if (typeBindingArray.length != typeBindingArray2.length) {
            return false;
        }
        int n = 0;
        while (n < typeBindingArray.length) {
            if (!typeBindingArray2[n].isTypeArgumentContainedBy(typeBindingArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean isSubTypeOfRTL(TypeBinding typeBinding) {
        ReferenceBinding[] referenceBindingArray;
        if (TypeBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        if (typeBinding instanceof CaptureBinding) {
            TypeBinding typeBinding2 = ((CaptureBinding)typeBinding).lowerBound;
            return typeBinding2 != null && this.isSubtypeOf(typeBinding2);
        }
        if (typeBinding instanceof ReferenceBinding && (referenceBindingArray = ((ReferenceBinding)typeBinding).getIntersectingTypes()) != null) {
            int n = 0;
            while (n < referenceBindingArray.length) {
                if (!this.isSubtypeOf(referenceBindingArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public final boolean isDefault() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isHierarchyBeingConnected() {
        return (this.tagBits & 0x200L) == 0L && (this.tagBits & 0x100L) != 0L;
    }

    public boolean isHierarchyBeingActivelyConnected() {
        return (this.tagBits & 0x200L) == 0L && (this.tagBits & 0x100L) != 0L && (this.tagBits & 0x80000L) == 0L;
    }

    public boolean isHierarchyConnected() {
        return true;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isFunctionalInterface(Scope scope) {
        MethodBinding methodBinding;
        return this.isInterface() && (methodBinding = this.getSingleAbstractMethod(scope, true)) != null && methodBinding.isValidBinding();
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isOrEnclosedByPrivateType() {
        if (this.isLocalType()) {
            return true;
        }
        ReferenceBinding referenceBinding = this;
        while (referenceBinding != null) {
            if ((referenceBinding.modifiers & 2) != 0) {
                return true;
            }
            referenceBinding = referenceBinding.enclosingType();
        }
        return false;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 0x208) != 0 || (this.tagBits & 4L) == 0L;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public boolean isSuperclassOf(ReferenceBinding referenceBinding) {
        while ((referenceBinding = referenceBinding.superclass()) != null) {
            if (!referenceBinding.isEquivalentTo(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isThrowable() {
        ReferenceBinding referenceBinding = this;
        do {
            switch (referenceBinding.id) {
                case 19: 
                case 21: 
                case 24: 
                case 25: {
                    return true;
                }
            }
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    public boolean isUncheckedException(boolean bl) {
        switch (this.id) {
            case 19: 
            case 24: {
                return true;
            }
            case 21: 
            case 25: {
                return bl;
            }
        }
        ReferenceBinding referenceBinding = this;
        while ((referenceBinding = referenceBinding.superclass()) != null) {
            switch (referenceBinding.id) {
                case 19: 
                case 24: {
                    return true;
                }
                case 21: 
                case 25: {
                    return false;
                }
            }
        }
        return false;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0 || this.getPackage().isViewedAsDeprecated();
    }

    public ReferenceBinding[] memberTypes() {
        return Binding.NO_MEMBER_TYPES;
    }

    public MethodBinding[] methods() {
        return Binding.NO_METHODS;
    }

    public final ReferenceBinding outermostEnclosingType() {
        ReferenceBinding referenceBinding;
        ReferenceBinding referenceBinding2 = this;
        do {
            referenceBinding = referenceBinding2;
        } while ((referenceBinding2 = referenceBinding2.enclosingType()) != null);
        return referenceBinding;
    }

    public char[] qualifiedSourceName() {
        if (this.isMemberType()) {
            return CharOperation.concat(this.enclosingType().qualifiedSourceName(), this.sourceName(), '.');
        }
        return this.sourceName();
    }

    public char[] readableName() {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : CharOperation.concatWith(this.compoundName, '.');
        TypeVariableBinding[] typeVariableBindingArray = this.typeVariables();
        if (typeVariableBindingArray != Binding.NO_TYPE_VARIABLES) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(cArray).append('<');
            int n = 0;
            int n2 = typeVariableBindingArray.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeVariableBindingArray[n].readableName());
                ++n;
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
        }
        return cArray;
    }

    protected void appendNullAnnotation(StringBuffer stringBuffer, CompilerOptions compilerOptions) {
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
            if (compilerOptions.usesNullTypeAnnotations()) {
                AnnotationBinding[] annotationBindingArray = this.typeAnnotations;
                int n = this.typeAnnotations.length;
                int n2 = 0;
                while (n2 < n) {
                    AnnotationBinding annotationBinding = annotationBindingArray[n2];
                    ReferenceBinding referenceBinding = annotationBinding.getAnnotationType();
                    if (referenceBinding.id == 66 || annotationBinding.type.id == 65) {
                        stringBuffer.append('@').append(((Binding)referenceBinding).shortReadableName()).append(' ');
                    }
                    ++n2;
                }
            } else {
                char[][] cArray;
                if ((this.tagBits & 0x100000000000000L) != 0L) {
                    cArray = compilerOptions.nonNullAnnotationName;
                    stringBuffer.append('@').append(cArray[cArray.length - 1]).append(' ');
                }
                if ((this.tagBits & 0x80000000000000L) != 0L) {
                    cArray = compilerOptions.nullableAnnotationName;
                    stringBuffer.append('@').append(cArray[cArray.length - 1]).append(' ');
                }
            }
        }
    }

    public AnnotationHolder retrieveAnnotationHolder(Binding binding, boolean bl) {
        SimpleLookupTable simpleLookupTable = this.storedAnnotations(bl);
        return simpleLookupTable == null ? null : (AnnotationHolder)simpleLookupTable.get(binding);
    }

    AnnotationBinding[] retrieveAnnotations(Binding binding) {
        AnnotationHolder annotationHolder = this.retrieveAnnotationHolder(binding, true);
        return annotationHolder == null ? Binding.NO_ANNOTATIONS : annotationHolder.getAnnotations();
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray) {
        this.storeAnnotations(this, annotationBindingArray);
    }

    public void setContainerAnnotationType(ReferenceBinding referenceBinding) {
    }

    public void tagAsHavingDefectiveContainerType() {
    }

    public char[] nullAnnotatedReadableName(CompilerOptions compilerOptions, boolean bl) {
        if (bl) {
            return this.nullAnnotatedShortReadableName(compilerOptions);
        }
        return this.nullAnnotatedReadableName(compilerOptions);
    }

    char[] nullAnnotatedReadableName(CompilerOptions compilerOptions) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(this.enclosingType().nullAnnotatedReadableName(compilerOptions, false));
            stringBuffer.append('.');
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            stringBuffer.append(this.sourceName);
        } else if (this.compoundName != null) {
            n = this.compoundName.length;
            int n2 = 0;
            while (n2 < n - 1) {
                stringBuffer.append(this.compoundName[n2]);
                stringBuffer.append('.');
                ++n2;
            }
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            stringBuffer.append(this.compoundName[n2]);
        } else {
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            if (this.sourceName != null) {
                stringBuffer.append(this.sourceName);
            } else {
                stringBuffer.append(this.readableName());
            }
        }
        TypeBinding[] typeBindingArray = this.typeArguments();
        if (typeBindingArray != null && typeBindingArray.length > 0) {
            stringBuffer.append('<');
            n = 0;
            int n3 = typeBindingArray.length;
            while (n < n3) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeBindingArray[n].nullAnnotatedReadableName(compilerOptions, false));
                ++n;
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    char[] nullAnnotatedShortReadableName(CompilerOptions compilerOptions) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType()) {
            stringBuffer.append(this.enclosingType().nullAnnotatedReadableName(compilerOptions, true));
            stringBuffer.append('.');
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            stringBuffer.append(this.sourceName);
        } else {
            this.appendNullAnnotation(stringBuffer, compilerOptions);
            if (this.sourceName != null) {
                stringBuffer.append(this.sourceName);
            } else {
                stringBuffer.append(this.shortReadableName());
            }
        }
        TypeBinding[] typeBindingArray = this.typeArguments();
        if (typeBindingArray != null && typeBindingArray.length > 0) {
            stringBuffer.append('<');
            n = 0;
            int n2 = typeBindingArray.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeBindingArray[n].nullAnnotatedReadableName(compilerOptions, true));
                ++n;
            }
            stringBuffer.append('>');
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public char[] shortReadableName() {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.sourceName;
        TypeVariableBinding[] typeVariableBindingArray = this.typeVariables();
        if (typeVariableBindingArray != Binding.NO_TYPE_VARIABLES) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(cArray).append('<');
            int n = 0;
            int n2 = typeVariableBindingArray.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeVariableBindingArray[n].shortReadableName());
                ++n;
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
        }
        return cArray;
    }

    public char[] signature() {
        if (this.signature != null) {
            return this.signature;
        }
        this.signature = CharOperation.concat('L', this.constantPoolName(), ';');
        return this.signature;
    }

    public char[] sourceName() {
        return this.sourceName;
    }

    void storeAnnotationHolder(Binding binding, AnnotationHolder annotationHolder) {
        if (annotationHolder == null) {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(false);
            if (simpleLookupTable != null) {
                simpleLookupTable.removeKey(binding);
            }
        } else {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(true);
            if (simpleLookupTable != null) {
                simpleLookupTable.put(binding, annotationHolder);
            }
        }
    }

    void storeAnnotations(Binding binding, AnnotationBinding[] annotationBindingArray) {
        AnnotationHolder annotationHolder = null;
        if (annotationBindingArray == null || annotationBindingArray.length == 0) {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(false);
            if (simpleLookupTable != null) {
                annotationHolder = (AnnotationHolder)simpleLookupTable.get(binding);
            }
            if (annotationHolder == null) {
                return;
            }
        } else {
            SimpleLookupTable simpleLookupTable = this.storedAnnotations(true);
            if (simpleLookupTable == null) {
                return;
            }
            annotationHolder = (AnnotationHolder)simpleLookupTable.get(binding);
            if (annotationHolder == null) {
                annotationHolder = new AnnotationHolder();
            }
        }
        this.storeAnnotationHolder(binding, annotationHolder.setAnnotations(annotationBindingArray));
    }

    SimpleLookupTable storedAnnotations(boolean bl) {
        return null;
    }

    public ReferenceBinding superclass() {
        return null;
    }

    public ReferenceBinding[] superInterfaces() {
        return Binding.NO_SUPERINTERFACES;
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (this.isStatic()) {
            return null;
        }
        ReferenceBinding referenceBinding = this.enclosingType();
        if (referenceBinding == null) {
            return null;
        }
        return new ReferenceBinding[]{referenceBinding};
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods();
    }

    public FieldBinding[] unResolvedFields() {
        return Binding.NO_FIELDS;
    }

    protected int applyCloseableClassWhitelists() {
        int n;
        switch (this.compoundName.length) {
            case 3: {
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0]) || !CharOperation.equals(TypeConstants.IO, this.compoundName[1])) break;
                char[] cArray = this.compoundName[2];
                n = TypeConstants.JAVA_IO_WRAPPER_CLOSEABLES.length;
                int n2 = 0;
                while (n2 < n) {
                    if (CharOperation.equals(cArray, TypeConstants.JAVA_IO_WRAPPER_CLOSEABLES[n2])) {
                        return 4;
                    }
                    ++n2;
                }
                n = TypeConstants.JAVA_IO_RESOURCE_FREE_CLOSEABLES.length;
                n2 = 0;
                while (n2 < n) {
                    if (CharOperation.equals(cArray, TypeConstants.JAVA_IO_RESOURCE_FREE_CLOSEABLES[n2])) {
                        return 8;
                    }
                    ++n2;
                }
                break;
            }
            case 4: {
                if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0]) || !CharOperation.equals(TypeConstants.UTIL, this.compoundName[1]) || !CharOperation.equals(TypeConstants.ZIP, this.compoundName[2])) break;
                char[] cArray = this.compoundName[3];
                n = TypeConstants.JAVA_UTIL_ZIP_WRAPPER_CLOSEABLES.length;
                int n2 = 0;
                while (n2 < n) {
                    if (CharOperation.equals(cArray, TypeConstants.JAVA_UTIL_ZIP_WRAPPER_CLOSEABLES[n2])) {
                        return 4;
                    }
                    ++n2;
                }
                break;
            }
        }
        int n3 = TypeConstants.OTHER_WRAPPER_CLOSEABLES.length;
        n = 0;
        while (n < n3) {
            if (CharOperation.equals(this.compoundName, TypeConstants.OTHER_WRAPPER_CLOSEABLES[n])) {
                return 4;
            }
            ++n;
        }
        return 0;
    }

    protected int applyCloseableInterfaceWhitelists() {
        switch (this.compoundName.length) {
            case 4: {
                if (!CharOperation.equals(this.compoundName, TypeConstants.RESOURCE_FREE_CLOSEABLE_STREAM)) break;
                return 8;
            }
        }
        return 0;
    }

    private MethodBinding[] getInterfaceAbstractContracts(Scope scope) throws InvalidInputException {
        int n;
        Object object;
        if (!this.isInterface() || !this.isValidBinding()) {
            throw new InvalidInputException("Not a functional interface");
        }
        MethodBinding[] methodBindingArray = this.methods();
        MethodBinding[] methodBindingArray2 = new MethodBinding[]{};
        int n2 = 0;
        int n3 = 0;
        ReferenceBinding[] referenceBindingArray = this.superInterfaces();
        int n4 = 0;
        int n5 = referenceBindingArray.length;
        while (n4 < n5) {
            object = referenceBindingArray[n4].getInterfaceAbstractContracts(scope);
            int n6 = n = object == null ? 0 : ((MethodBinding[])object).length;
            if (n != 0) {
                if (n3 < n2 + n) {
                    MethodBinding[] methodBindingArray3 = methodBindingArray2;
                    n3 = n2 + n;
                    methodBindingArray2 = new MethodBinding[n3];
                    System.arraycopy(methodBindingArray3, 0, methodBindingArray2, 0, n2);
                }
                System.arraycopy(object, 0, methodBindingArray2, n2, n);
                n2 += n;
            }
            ++n4;
        }
        n4 = 0;
        n5 = methodBindingArray == null ? 0 : methodBindingArray.length;
        while (n4 < n5) {
            object = methodBindingArray[n4];
            if (object != null && !((MethodBinding)object).isStatic() && !((MethodBinding)object).redeclaresPublicObjectMethod(scope)) {
                if (!((Binding)object).isValidBinding()) {
                    throw new InvalidInputException("Not a functional interface");
                }
                n = 0;
                while (n < n2) {
                    if (methodBindingArray2[n] != null && MethodVerifier.doesMethodOverride((MethodBinding)object, methodBindingArray2[n], scope.environment()) && n < --n2) {
                        System.arraycopy(methodBindingArray2, n + 1, methodBindingArray2, n, n2 - n);
                    }
                    ++n;
                }
                if (!((MethodBinding)object).isDefaultMethod()) {
                    if (n2 == n3) {
                        MethodBinding[] methodBindingArray4 = methodBindingArray2;
                        methodBindingArray2 = new MethodBinding[n3 += 16];
                        System.arraycopy(methodBindingArray4, 0, methodBindingArray2, 0, n2);
                    }
                    methodBindingArray2[n2++] = object;
                }
            }
            ++n4;
        }
        if (n2 < n3) {
            MethodBinding[] methodBindingArray5 = methodBindingArray2;
            methodBindingArray2 = new MethodBinding[n2];
            System.arraycopy(methodBindingArray5, 0, methodBindingArray2, 0, n2);
        }
        return methodBindingArray2;
    }

    /*
     * Unable to fully structure code
     */
    public MethodBinding getSingleAbstractMethod(Scope var1_1, boolean var2_2) {
        v0 = var3_3 = var2_2 != false ? 0 : 1;
        if (this.singleAbstractMethod != null) {
            if (this.singleAbstractMethod[var3_3] != null) {
                return this.singleAbstractMethod[var3_3];
            }
        } else {
            this.singleAbstractMethod = new MethodBinding[2];
        }
        if (this.compoundName != null) {
            var1_1.compilationUnitScope().recordQualifiedReference(this.compoundName);
        }
        var4_4 = null;
        try {
            var4_4 = this.getInterfaceAbstractContracts(var1_1);
            if (var4_4 == null || var4_4.length == 0) {
                this.singleAbstractMethod[var3_3] = ReferenceBinding.samProblemBinding;
                return this.singleAbstractMethod[var3_3];
            }
            var5_5 = 0;
            var6_7 = null;
            var7_9 = 0;
            var8_10 = var4_4.length;
            while (var7_9 < var8_10) {
                var9_11 = var4_4[var7_9];
                if (var9_11 != null) {
                    if (var6_7 == null) {
                        var6_7 = var9_11.selector;
                        var5_5 = var9_11.parameters == null ? 0 : var9_11.parameters.length;
                    } else {
                        v1 = var10_13 = var9_11.parameters == null ? 0 : var9_11.parameters.length;
                        if (var10_13 != var5_5 || !CharOperation.equals(var9_11.selector, var6_7)) {
                            this.singleAbstractMethod[var3_3] = ReferenceBinding.samProblemBinding;
                            return this.singleAbstractMethod[var3_3];
                        }
                    }
                }
                ++var7_9;
            }
        }
        catch (InvalidInputException v2) {
            this.singleAbstractMethod[var3_3] = ReferenceBinding.samProblemBinding;
            return this.singleAbstractMethod[var3_3];
        }
        if (var4_4.length == 1) {
            this.singleAbstractMethod[var3_3] = var4_4[0];
            return this.singleAbstractMethod[var3_3];
        }
        var5_6 = var1_1.environment();
        var6_8 = false;
        var7_9 = var4_4.length;
        var8_10 = (int)var5_6.globalOptions.isAnnotationBasedNullAnalysisEnabled;
        var9_12 = var7_9 - 1;
        while (var9_12 >= 0) {
            block36: {
                var10_14 = var4_4[var9_12];
                var11_15 = null;
                if (var10_14.typeVariables != Binding.NO_TYPE_VARIABLES) {
                    var6_8 = true;
                }
                var12_16 = var10_14.returnType;
                var13_17 = var10_14.parameters;
                var14_18 = 0;
                while (var14_18 < var7_9) {
                    if (var9_12 != var14_18) {
                        var11_15 = var4_4[var14_18];
                        if (var11_15.typeVariables != Binding.NO_TYPE_VARIABLES) {
                            var6_8 = true;
                        }
                        if (var6_8 && (var11_15 = MethodVerifier.computeSubstituteMethod(var11_15, var10_14, var5_6)) == null || !MethodVerifier.isSubstituteParameterSubsignature(var10_14, var11_15, var5_6) || !MethodVerifier.areReturnTypesCompatible(var10_14, var11_15, var5_6)) break block36;
                        if (var8_10 != 0) {
                            var12_16 = NullAnnotationMatching.strongerType(var12_16, var11_15.returnType, var5_6);
                            var13_17 = NullAnnotationMatching.weakerTypes(var13_17, var11_15.parameters, var5_6);
                        }
                    }
                    ++var14_18;
                }
                var14_19 = new ReferenceBinding[]{};
                var15_20 = 0;
                var16_21 = 0;
                var17_22 = var10_14;
                var18_23 = var17_22.typeVariables == Binding.NO_TYPE_VARIABLES && var6_8 != false;
                var19_24 = var17_22.typeVariables != Binding.NO_TYPE_VARIABLES;
                var20_25 = var17_22.typeVariables.length;
                var9_12 = 0;
                block5: while (var9_12 < var7_9) {
                    var10_14 = var4_4[var9_12];
                    var21_26 = var10_14.thrownExceptions;
                    v3 = var22_27 = var21_26 == null ? 0 : var21_26.length;
                    if (var22_27 == 0) break;
                    if (var19_24 && var10_14 != var17_22) {
                        v4 = var21_26;
                        var21_26 = new ReferenceBinding[var22_27];
                        System.arraycopy(v4, 0, var21_26, 0, var22_27);
                        var23_28 = 0;
                        while (var23_28 < var20_25) {
                            if (var21_26[var23_28] instanceof TypeVariableBinding) {
                                var21_26[var23_28] = var17_22.typeVariables[var23_28];
                            }
                            ++var23_28;
                        }
                    }
                    var23_28 = 0;
                    while (var23_28 < var22_27) {
                        block37: {
                            var24_29 = var21_26[var23_28];
                            if (var18_23) {
                                var24_29 = (ReferenceBinding)var24_29.erasure();
                            }
                            var25_30 = 0;
                            block8: while (var25_30 < var7_9) {
                                if (var9_12 == var25_30) ** GOTO lbl116
                                var11_15 = var4_4[var25_30];
                                var26_31 = var11_15.thrownExceptions;
                                v5 = var27_32 = var26_31 == null ? 0 : var26_31.length;
                                if (var27_32 == 0) break block5;
                                if (var19_24 && var11_15 != var17_22) {
                                    v6 = var26_31;
                                    var26_31 = new ReferenceBinding[var27_32];
                                    System.arraycopy(v6, 0, var26_31, 0, var27_32);
                                    var28_33 = 0;
                                    while (var28_33 < var20_25) {
                                        if (var26_31[var28_33] instanceof TypeVariableBinding) {
                                            var26_31[var28_33] = var17_22.typeVariables[var28_33];
                                        }
                                        ++var28_33;
                                    }
                                }
                                var28_33 = 0;
                                while (var28_33 < var27_32) {
                                    var29_34 = var26_31[var28_33];
                                    if (var18_23) {
                                        var29_34 = (ReferenceBinding)var29_34.erasure();
                                    }
                                    if (!var24_29.isCompatibleWith(var29_34)) {
                                        ++var28_33;
                                        continue;
                                    }
lbl116:
                                    // 3 sources

                                    ++var25_30;
                                    continue block8;
                                }
                                break block37;
                            }
                            if (var15_20 == var16_21) {
                                v7 = var14_19;
                                var14_19 = new ReferenceBinding[var16_21 += 16];
                                System.arraycopy(v7, 0, var14_19, 0, var15_20);
                            }
                            var14_19[var15_20++] = var24_29;
                        }
                        ++var23_28;
                    }
                    ++var9_12;
                }
                if (var15_20 != var16_21) {
                    v8 = var14_19;
                    var14_19 = new ReferenceBinding[var15_20];
                    System.arraycopy(v8, 0, var14_19, 0, var15_20);
                }
                this.singleAbstractMethod[var3_3] = new MethodBinding(var17_22.modifiers | 4096, var17_22.selector, var12_16, var13_17, var14_19, var17_22.declaringClass);
                this.singleAbstractMethod[var3_3].typeVariables = var17_22.typeVariables;
                return this.singleAbstractMethod[var3_3];
            }
            --var9_12;
        }
        this.singleAbstractMethod[var3_3] = ReferenceBinding.samProblemBinding;
        return this.singleAbstractMethod[var3_3];
    }

    public static boolean isConsistentIntersection(TypeBinding[] typeBindingArray) {
        TypeBinding[] typeBindingArray2 = new TypeBinding[typeBindingArray.length];
        int n = 0;
        while (n < typeBindingArray2.length) {
            TypeBinding typeBinding = typeBindingArray[n];
            typeBindingArray2[n] = typeBinding.isClass() || typeBinding.isArrayType() ? typeBinding : typeBinding.superclass();
            ++n;
        }
        TypeBinding typeBinding = typeBindingArray2[0];
        int n2 = 1;
        while (n2 < typeBindingArray2.length) {
            TypeBinding typeBinding2 = typeBindingArray2[n2];
            if (!typeBinding2.isTypeVariable() && !typeBinding2.isWildcard() && typeBinding2.isProperType(true) && !typeBinding.isSubtypeOf(typeBinding2)) {
                if (typeBinding2.isSubtypeOf(typeBinding)) {
                    typeBinding = typeBinding2;
                } else {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }
}

