/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class NestedTypeBinding
extends SourceTypeBinding {
    public SourceTypeBinding enclosingType;
    public SyntheticArgumentBinding[] enclosingInstances;
    private ReferenceBinding[] enclosingTypes = Binding.UNINITIALIZED_REFERENCE_TYPES;
    public SyntheticArgumentBinding[] outerLocalVariables;
    private int outerLocalVariablesSlotSize = -1;

    public NestedTypeBinding(char[][] cArray, ClassScope classScope, SourceTypeBinding sourceTypeBinding) {
        super(cArray, sourceTypeBinding.fPackage, classScope);
        this.tagBits |= 0x804L;
        this.enclosingType = sourceTypeBinding;
    }

    public NestedTypeBinding(NestedTypeBinding nestedTypeBinding) {
        super(nestedTypeBinding);
        this.enclosingType = nestedTypeBinding.enclosingType;
        this.enclosingInstances = nestedTypeBinding.enclosingInstances;
        this.enclosingTypes = nestedTypeBinding.enclosingTypes;
        this.outerLocalVariables = nestedTypeBinding.outerLocalVariables;
        this.outerLocalVariablesSlotSize = nestedTypeBinding.outerLocalVariablesSlotSize;
    }

    public SyntheticArgumentBinding addSyntheticArgument(LocalVariableBinding localVariableBinding) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        SyntheticArgumentBinding syntheticArgumentBinding = null;
        if (this.outerLocalVariables == null) {
            syntheticArgumentBinding = new SyntheticArgumentBinding(localVariableBinding);
            this.outerLocalVariables = new SyntheticArgumentBinding[]{syntheticArgumentBinding};
        } else {
            int n;
            int n2 = n = this.outerLocalVariables.length;
            int n3 = n;
            while (--n3 >= 0) {
                if (this.outerLocalVariables[n3].actualOuterLocalVariable == localVariableBinding) {
                    return this.outerLocalVariables[n3];
                }
                if (this.outerLocalVariables[n3].id <= localVariableBinding.id) continue;
                n2 = n3;
            }
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = new SyntheticArgumentBinding[n + 1];
            System.arraycopy(this.outerLocalVariables, 0, syntheticArgumentBindingArray, 0, n2);
            syntheticArgumentBindingArray[n2] = syntheticArgumentBinding = new SyntheticArgumentBinding(localVariableBinding);
            System.arraycopy(this.outerLocalVariables, n2, syntheticArgumentBindingArray, n2 + 1, n - n2);
            this.outerLocalVariables = syntheticArgumentBindingArray;
        }
        if (this.scope.referenceCompilationUnit().isPropagatingInnerClassEmulation) {
            this.updateInnerEmulationDependents();
        }
        return syntheticArgumentBinding;
    }

    public SyntheticArgumentBinding addSyntheticArgument(ReferenceBinding referenceBinding) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        SyntheticArgumentBinding syntheticArgumentBinding = null;
        if (this.enclosingInstances == null) {
            syntheticArgumentBinding = new SyntheticArgumentBinding(referenceBinding);
            this.enclosingInstances = new SyntheticArgumentBinding[]{syntheticArgumentBinding};
        } else {
            int n;
            int n2 = n = this.enclosingInstances.length;
            if (TypeBinding.equalsEquals(this.enclosingType(), referenceBinding)) {
                n2 = 0;
            }
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = new SyntheticArgumentBinding[n + 1];
            System.arraycopy(this.enclosingInstances, 0, syntheticArgumentBindingArray, n2 == 0 ? 1 : 0, n);
            syntheticArgumentBindingArray[n2] = syntheticArgumentBinding = new SyntheticArgumentBinding(referenceBinding);
            this.enclosingInstances = syntheticArgumentBindingArray;
        }
        if (this.scope.referenceCompilationUnit().isPropagatingInnerClassEmulation) {
            this.updateInnerEmulationDependents();
        }
        return syntheticArgumentBinding;
    }

    public SyntheticArgumentBinding addSyntheticArgumentAndField(LocalVariableBinding localVariableBinding) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        SyntheticArgumentBinding syntheticArgumentBinding = this.addSyntheticArgument(localVariableBinding);
        if (syntheticArgumentBinding == null) {
            return null;
        }
        if (syntheticArgumentBinding.matchingField == null) {
            syntheticArgumentBinding.matchingField = this.addSyntheticFieldForInnerclass(localVariableBinding);
        }
        return syntheticArgumentBinding;
    }

    public SyntheticArgumentBinding addSyntheticArgumentAndField(ReferenceBinding referenceBinding) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        SyntheticArgumentBinding syntheticArgumentBinding = this.addSyntheticArgument(referenceBinding);
        if (syntheticArgumentBinding == null) {
            return null;
        }
        if (syntheticArgumentBinding.matchingField == null) {
            syntheticArgumentBinding.matchingField = this.addSyntheticFieldForInnerclass(referenceBinding);
        }
        return syntheticArgumentBinding;
    }

    protected void checkRedundantNullnessDefaultRecurse(ASTNode aSTNode, Annotation[] annotationArray, long l, boolean bl) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        ReferenceBinding referenceBinding = this.enclosingType;
        do {
            if (referenceBinding.checkRedundantNullnessDefaultOne(aSTNode, annotationArray, l, bl)) continue;
            return;
        } while ((referenceBinding = referenceBinding.enclosingType()) instanceof SourceTypeBinding);
        super.checkRedundantNullnessDefaultRecurse(aSTNode, annotationArray, l, bl);
    }

    public ReferenceBinding enclosingType() {
        return this.enclosingType;
    }

    public int getEnclosingInstancesSlotSize() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        return this.enclosingInstances == null ? 0 : this.enclosingInstances.length;
    }

    public int getOuterLocalVariablesSlotSize() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.outerLocalVariablesSlotSize < 0) {
            this.outerLocalVariablesSlotSize = 0;
            int n = this.outerLocalVariables == null ? 0 : this.outerLocalVariables.length;
            int n2 = 0;
            while (n2 < n) {
                SyntheticArgumentBinding syntheticArgumentBinding = this.outerLocalVariables[n2];
                switch (syntheticArgumentBinding.type.id) {
                    case 7: 
                    case 8: {
                        this.outerLocalVariablesSlotSize += 2;
                        break;
                    }
                    default: {
                        ++this.outerLocalVariablesSlotSize;
                    }
                }
                ++n2;
            }
        }
        return this.outerLocalVariablesSlotSize;
    }

    public SyntheticArgumentBinding getSyntheticArgument(LocalVariableBinding localVariableBinding) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.outerLocalVariables == null) {
            return null;
        }
        int n = this.outerLocalVariables.length;
        while (--n >= 0) {
            if (this.outerLocalVariables[n].actualOuterLocalVariable != localVariableBinding) continue;
            return this.outerLocalVariables[n];
        }
        return null;
    }

    public SyntheticArgumentBinding getSyntheticArgument(ReferenceBinding referenceBinding, boolean bl, boolean bl2) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.enclosingInstances == null) {
            return null;
        }
        if (bl2 && this.enclosingInstances.length > 0 && TypeBinding.equalsEquals(this.enclosingInstances[0].type, referenceBinding) && this.enclosingInstances[0].actualOuterLocalVariable == null) {
            return this.enclosingInstances[0];
        }
        int n = this.enclosingInstances.length;
        while (--n >= 0) {
            if (!TypeBinding.equalsEquals(this.enclosingInstances[n].type, referenceBinding) || this.enclosingInstances[n].actualOuterLocalVariable != null) continue;
            return this.enclosingInstances[n];
        }
        if (!bl) {
            n = this.enclosingInstances.length;
            while (--n >= 0) {
                if (this.enclosingInstances[n].actualOuterLocalVariable != null || this.enclosingInstances[n].type.findSuperTypeOriginatingFrom(referenceBinding) == null) continue;
                return this.enclosingInstances[n];
            }
        }
        return null;
    }

    public SyntheticArgumentBinding[] syntheticEnclosingInstances() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        return this.enclosingInstances;
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.enclosingTypes == UNINITIALIZED_REFERENCE_TYPES) {
            if (this.enclosingInstances == null) {
                this.enclosingTypes = null;
            } else {
                int n = this.enclosingInstances.length;
                this.enclosingTypes = new ReferenceBinding[n];
                int n2 = 0;
                while (n2 < n) {
                    this.enclosingTypes[n2] = (ReferenceBinding)this.enclosingInstances[n2].type;
                    ++n2;
                }
            }
        }
        return this.enclosingTypes;
    }

    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        return this.outerLocalVariables;
    }

    public void updateInnerEmulationDependents() {
    }
}

