/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.Sorting;

class MethodVerifier15
extends MethodVerifier {
    MethodVerifier15(LookupEnvironment lookupEnvironment) {
        super(lookupEnvironment);
    }

    protected boolean canOverridingMethodDifferInErasure(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.areParameterErasuresEqual(methodBinding2)) {
            return false;
        }
        return !methodBinding.declaringClass.isRawType();
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && (this.type.superclass().isAbstract() || this.type.superclass().isParameterizedType())) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    boolean canSkipInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding2 == null || TypeBinding.equalsEquals(methodBinding.declaringClass, methodBinding2.declaringClass) && !methodBinding.declaringClass.isParameterizedType();
    }

    void checkConcreteInheritedMethod(MethodBinding methodBinding, MethodBinding[] methodBindingArray) {
        super.checkConcreteInheritedMethod(methodBinding, methodBindingArray);
        boolean bl = this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled;
        AbstractMethodDeclaration abstractMethodDeclaration = null;
        if (bl && this.type.equals(methodBinding.declaringClass)) {
            abstractMethodDeclaration = methodBinding.sourceMethod();
        }
        boolean bl2 = this.environment.usesNullTypeAnnotations();
        boolean bl3 = bl && methodBinding.hasNonNullDefaultFor(16, bl2);
        boolean bl4 = bl && methodBinding.hasNonNullDefaultFor(8, bl2);
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            MethodBinding methodBinding2 = methodBindingArray[n];
            if (methodBinding.isVarargs() != methodBinding2.isVarargs()) {
                this.problemReporter().varargsConflict(methodBinding, methodBinding2, this.type);
            }
            MethodBinding methodBinding3 = methodBinding2.original();
            if (TypeBinding.notEquals(methodBinding3.returnType, methodBinding.returnType) && !this.isAcceptableReturnTypeOverride(methodBinding, methodBinding2)) {
                this.problemReporter().unsafeReturnTypeOverride(methodBinding, methodBinding3, this.type);
            }
            if (methodBinding3.declaringClass.isInterface() && (TypeBinding.equalsEquals(methodBinding.declaringClass, this.type.superclass) && this.type.superclass.isParameterizedType() && !this.areMethodsCompatible(methodBinding, methodBinding3) || this.type.superclass.erasure().findSuperTypeOriginatingFrom(methodBinding3.declaringClass) == null)) {
                this.type.addSyntheticBridgeMethod(methodBinding3, methodBinding.original());
            }
            if (bl && !methodBinding.isStatic() && !methodBinding2.isStatic()) {
                this.checkNullSpecInheritance(methodBinding, abstractMethodDeclaration, bl3, bl4, true, methodBinding2, methodBindingArray, this.type.scope, null);
            }
            ++n;
        }
    }

    void checkForBridgeMethod(MethodBinding methodBinding, MethodBinding methodBinding2, MethodBinding[] methodBindingArray) {
        SyntheticMethodBinding syntheticMethodBinding;
        if (methodBinding.isVarargs() != methodBinding2.isVarargs()) {
            this.problemReporter(methodBinding).varargsConflict(methodBinding, methodBinding2, this.type);
        }
        MethodBinding methodBinding3 = methodBinding2.original();
        if (TypeBinding.notEquals(methodBinding3.returnType, methodBinding.returnType) && !this.isAcceptableReturnTypeOverride(methodBinding, methodBinding2)) {
            this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding3, this.type);
        }
        if ((syntheticMethodBinding = this.type.addSyntheticBridgeMethod(methodBinding3, methodBinding.original())) != null) {
            int n = 0;
            int n2 = methodBindingArray == null ? 0 : methodBindingArray.length;
            while (n < n2) {
                if (methodBindingArray[n] != null && this.detectInheritedNameClash(methodBinding3, methodBindingArray[n].original())) {
                    return;
                }
                ++n;
            }
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.currentMethods.get(syntheticMethodBinding.selector);
            n2 = methodBindingArray2.length - 1;
            while (n2 >= 0) {
                MethodBinding methodBinding4 = methodBindingArray2[n2];
                if (methodBinding4.areParameterErasuresEqual(syntheticMethodBinding) && TypeBinding.equalsEquals(methodBinding4.returnType.erasure(), syntheticMethodBinding.returnType.erasure())) {
                    this.problemReporter(methodBinding4).methodNameClash(methodBinding4, methodBinding2.declaringClass.isRawType() ? methodBinding2 : methodBinding2.original(), 1);
                    return;
                }
                --n2;
            }
        }
    }

    void checkForNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding2.isStatic() || methodBinding.isStatic()) {
            MethodBinding methodBinding3 = methodBinding2.original();
            if (this.type.scope.compilerOptions().complianceLevel >= 0x330000L && methodBinding.areParameterErasuresEqual(methodBinding3)) {
                this.problemReporter(methodBinding).methodNameClashHidden(methodBinding, methodBinding2.declaringClass.isRawType() ? methodBinding2 : methodBinding3);
            }
            return;
        }
        if (!this.detectNameClash(methodBinding, methodBinding2, false)) {
            int n;
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            int n2 = typeBindingArray.length;
            TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
            if (n2 != typeBindingArray2.length) {
                return;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (TypeBinding.notEquals(typeBindingArray[n3], typeBindingArray2[n3]) && (typeBindingArray[n3].isBaseType() != typeBindingArray2[n3].isBaseType() || !typeBindingArray2[n3].isCompatibleWith(typeBindingArray[n3]))) {
                    return;
                }
                ++n3;
            }
            ReferenceBinding[] referenceBindingArray = null;
            int n4 = 0;
            ReferenceBinding referenceBinding = methodBinding2.declaringClass;
            ReferenceBinding[] referenceBindingArray2 = referenceBinding.superInterfaces();
            if (referenceBindingArray2 != Binding.NO_SUPERINTERFACES) {
                n4 = referenceBindingArray2.length;
                referenceBindingArray = referenceBindingArray2;
            }
            referenceBinding = referenceBinding.superclass();
            while (referenceBinding != null && referenceBinding.isValidBinding()) {
                Binding binding;
                MethodBinding[] methodBindingArray = referenceBinding.getMethods(methodBinding.selector);
                int n5 = 0;
                n = methodBindingArray.length;
                while (n5 < n) {
                    binding = this.computeSubstituteMethod(methodBindingArray[n5], methodBinding);
                    if (binding != null && !this.isSubstituteParameterSubsignature(methodBinding, (MethodBinding)binding) && this.detectNameClash(methodBinding, (MethodBinding)binding, true)) {
                        return;
                    }
                    ++n5;
                }
                referenceBindingArray2 = referenceBinding.superInterfaces();
                if (referenceBindingArray2 != Binding.NO_SUPERINTERFACES) {
                    if (referenceBindingArray == null) {
                        referenceBindingArray = referenceBindingArray2;
                        n4 = referenceBindingArray.length;
                    } else {
                        n5 = referenceBindingArray2.length;
                        if (n4 + n5 >= referenceBindingArray.length) {
                            ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                            referenceBindingArray = new ReferenceBinding[n4 + n5 + 5];
                            System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n4);
                        }
                        n = 0;
                        while (n < n5) {
                            block26: {
                                binding = referenceBindingArray2[n];
                                int n6 = 0;
                                while (n6 < n4) {
                                    if (!TypeBinding.equalsEquals((TypeBinding)binding, referenceBindingArray[n6])) {
                                        ++n6;
                                        continue;
                                    }
                                    break block26;
                                }
                                referenceBindingArray[n4++] = binding;
                            }
                            ++n;
                        }
                    }
                }
                referenceBinding = referenceBinding.superclass();
            }
            int n7 = 0;
            while (n7 < n4) {
                referenceBinding = referenceBindingArray[n7];
                if (referenceBinding.isValidBinding()) {
                    MethodBinding[] methodBindingArray = referenceBinding.getMethods(methodBinding.selector);
                    n = 0;
                    int n8 = methodBindingArray.length;
                    while (n < n8) {
                        MethodBinding methodBinding4 = this.computeSubstituteMethod(methodBindingArray[n], methodBinding);
                        if (methodBinding4 != null && !this.isSubstituteParameterSubsignature(methodBinding, methodBinding4) && this.detectNameClash(methodBinding, methodBinding4, true)) {
                            return;
                        }
                        ++n;
                    }
                    referenceBindingArray2 = referenceBinding.superInterfaces();
                    if (referenceBindingArray2 != Binding.NO_SUPERINTERFACES) {
                        n = referenceBindingArray2.length;
                        if (n4 + n >= referenceBindingArray.length) {
                            ReferenceBinding[] referenceBindingArray4 = referenceBindingArray;
                            referenceBindingArray = new ReferenceBinding[n4 + n + 5];
                            System.arraycopy(referenceBindingArray4, 0, referenceBindingArray, 0, n4);
                        }
                        n8 = 0;
                        while (n8 < n) {
                            block27: {
                                ReferenceBinding referenceBinding2 = referenceBindingArray2[n8];
                                int n9 = 0;
                                while (n9 < n4) {
                                    if (!TypeBinding.equalsEquals(referenceBinding2, referenceBindingArray[n9])) {
                                        ++n9;
                                        continue;
                                    }
                                    break block27;
                                }
                                referenceBindingArray[n4++] = referenceBinding2;
                            }
                            ++n8;
                        }
                    }
                }
                ++n7;
            }
        }
    }

    void checkInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.isStatic()) {
            return;
        }
        if (this.environment.globalOptions.complianceLevel < 0x330000L && methodBinding.declaringClass.isInterface()) {
            return;
        }
        this.detectInheritedNameClash(methodBinding.original(), methodBinding2.original());
    }

    void checkInheritedMethods(MethodBinding[] methodBindingArray, int n, boolean[] blArray, boolean[] blArray2) {
        boolean bl = true;
        MethodBinding methodBinding = null;
        MethodBinding methodBinding2 = null;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            if (!methodBindingArray[n2].declaringClass.isInterface() && TypeBinding.notEquals(methodBindingArray[n2].declaringClass, this.type) && methodBindingArray[n2].isAbstract()) {
                methodBinding2 = methodBindingArray[n2];
                break;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            block12: {
                block14: {
                    block13: {
                        if (!blArray2[n2] || methodBindingArray[n2].isAbstract()) break block12;
                        if (!methodBindingArray[n2].isDefaultMethod() || methodBinding2 == null || !MethodVerifier15.areParametersEqual(methodBinding2, methodBindingArray[n2]) || methodBinding != null) break block13;
                        bl2 = true;
                        break block12;
                    }
                    bl2 = false;
                    if (methodBinding == null) break block14;
                    if (blArray[n2] && this.areMethodsCompatible(methodBinding, methodBindingArray[n2]) || TypeBinding.equalsEquals(methodBinding.declaringClass, methodBindingArray[n2].declaringClass) && methodBinding.typeVariables.length != methodBindingArray[n2].typeVariables.length && (methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && methodBinding.original() == methodBindingArray[n2] || methodBindingArray[n2].typeVariables == Binding.NO_TYPE_VARIABLES && methodBindingArray[n2].original() == methodBinding)) break block12;
                    this.problemReporter().duplicateInheritedMethods(this.type, methodBinding, methodBindingArray[n2], this.environment.globalOptions.sourceLevel >= 0x340000L);
                    bl = false;
                }
                methodBinding = methodBindingArray[n2];
            }
            ++n2;
        }
        if (bl) {
            if (bl2) {
                if (!this.type.isAbstract()) {
                    this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding2);
                    return;
                }
            } else if (methodBinding != null && methodBinding.isDefaultMethod() && this.environment.globalOptions.complianceLevel >= 0x340000L && !this.checkInheritedDefaultMethods(methodBindingArray, n)) {
                return;
            }
            super.checkInheritedMethods(methodBindingArray, n, blArray, blArray2);
        }
    }

    boolean checkInheritedDefaultMethods(MethodBinding[] methodBindingArray, int n) {
        if (n < 2) {
            return true;
        }
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (methodBindingArray[n2].isDefaultMethod()) {
                int n3 = 0;
                while (n3 < n) {
                    if (n3 != n2 && this.isMethodSubsignature(methodBindingArray[n2], methodBindingArray[n3])) {
                        if (this.doesMethodOverride(methodBindingArray[n2], methodBindingArray[n3]) || this.doesMethodOverride(methodBindingArray[n3], methodBindingArray[n2])) break;
                        this.problemReporter().inheritedDefaultMethodConflictsWithOtherInherited(this.type, methodBindingArray[n2], methodBindingArray[n3]);
                        bl = false;
                        break;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return bl;
    }

    boolean checkInheritedReturnTypes(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.areReturnTypesCompatible(methodBinding, methodBinding2)) {
            return true;
        }
        if (this.isUnsafeReturnTypeOverride(methodBinding, methodBinding2)) {
            if (!methodBinding.declaringClass.implementsInterface(methodBinding2.declaringClass, false)) {
                this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding2, this.type);
            }
            return true;
        }
        return false;
    }

    void checkAgainstInheritedMethods(MethodBinding methodBinding, MethodBinding[] methodBindingArray, int n, MethodBinding[] methodBindingArray2) {
        super.checkAgainstInheritedMethods(methodBinding, methodBindingArray, n, methodBindingArray2);
        CompilerOptions compilerOptions = this.environment.globalOptions;
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled && (methodBinding.tagBits & 0x1000L) == 0L) {
            AbstractMethodDeclaration abstractMethodDeclaration = null;
            if (this.type.equals(methodBinding.declaringClass)) {
                abstractMethodDeclaration = methodBinding.sourceMethod();
            }
            boolean bl = this.environment.usesNullTypeAnnotations();
            boolean bl2 = methodBinding.hasNonNullDefaultFor(16, bl);
            boolean bl3 = methodBinding.hasNonNullDefaultFor(8, bl);
            int n2 = n;
            while (--n2 >= 0) {
                if (methodBinding.isStatic() || methodBindingArray[n2].isStatic()) continue;
                this.checkNullSpecInheritance(methodBinding, abstractMethodDeclaration, bl2, bl3, true, methodBindingArray[n2], methodBindingArray, this.type.scope, null);
            }
        }
    }

    void checkNullSpecInheritance(MethodBinding methodBinding, AbstractMethodDeclaration abstractMethodDeclaration, boolean bl, boolean bl2, boolean bl3, MethodBinding methodBinding2, MethodBinding[] methodBindingArray, Scope scope, ImplicitNullAnnotationVerifier.InheritedNonNullnessInfo[] inheritedNonNullnessInfoArray) {
        if (!(bl || bl2 || (bl3 &= !methodBinding.isConstructor()) || this.environment.globalOptions.inheritNullAnnotations)) {
            methodBinding.tagBits |= 0x1000L;
            return;
        }
        if (TypeBinding.notEquals(methodBinding.declaringClass, this.type) && (methodBinding.tagBits & 0x1000L) == 0L) {
            this.buddyImplicitNullAnnotationsVerifier.checkImplicitNullAnnotations(methodBinding, abstractMethodDeclaration, bl3, scope);
        }
        super.checkNullSpecInheritance(methodBinding, abstractMethodDeclaration, bl, bl2, bl3, methodBinding2, methodBindingArray, scope, inheritedNonNullnessInfoArray);
    }

    void reportRawReferences() {
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        if (compilerOptions.sourceLevel < 0x310000L || compilerOptions.reportUnavoidableGenericTypeProblems) {
            return;
        }
        Object[] objectArray = this.currentMethods.valueTable;
        int n = objectArray.length;
        while (--n >= 0) {
            if (objectArray[n] == null) continue;
            MethodBinding[] methodBindingArray = (MethodBinding[])objectArray[n];
            int n2 = 0;
            int n3 = methodBindingArray.length;
            while (n2 < n3) {
                MethodBinding methodBinding = methodBindingArray[n2];
                if ((methodBinding.modifiers & 0x30000000) == 0) {
                    AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
                    if (abstractMethodDeclaration == null) {
                        return;
                    }
                    TypeBinding[] typeBindingArray = methodBinding.parameters;
                    Argument[] argumentArray = abstractMethodDeclaration.arguments;
                    int n4 = 0;
                    int n5 = methodBinding.parameters.length;
                    while (n4 < n5) {
                        TypeBinding typeBinding = typeBindingArray[n4];
                        Argument argument = argumentArray[n4];
                        if (typeBinding.leafComponentType().isRawType() && compilerOptions.getSeverity(0x20010000) != 256 && (argument.type.bits & 0x40000000) == 0) {
                            abstractMethodDeclaration.scope.problemReporter().rawTypeReference(argument.type, typeBinding);
                        }
                        ++n4;
                    }
                    if (!abstractMethodDeclaration.isConstructor() && abstractMethodDeclaration instanceof MethodDeclaration) {
                        TypeReference typeReference = ((MethodDeclaration)abstractMethodDeclaration).returnType;
                        TypeBinding typeBinding = methodBinding.returnType;
                        if (typeReference != null && typeBinding.leafComponentType().isRawType() && compilerOptions.getSeverity(0x20010000) != 256 && (typeReference.bits & 0x40000000) == 0) {
                            abstractMethodDeclaration.scope.problemReporter().rawTypeReference(typeReference, typeBinding);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public void reportRawReferences(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeBinding typeBinding;
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        if (compilerOptions.sourceLevel < 0x310000L || compilerOptions.reportUnavoidableGenericTypeProblems) {
            return;
        }
        AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
        if (abstractMethodDeclaration == null) {
            return;
        }
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        Argument[] argumentArray = abstractMethodDeclaration.arguments;
        int n = 0;
        int n2 = methodBinding.parameters.length;
        while (n < n2) {
            typeBinding = typeBindingArray[n];
            TypeBinding typeBinding2 = typeBindingArray2[n];
            Argument argument = argumentArray[n];
            if (typeBinding.leafComponentType().isRawType()) {
                if (typeBinding2.leafComponentType().isRawType()) {
                    argument.binding.tagBits |= 0x200L;
                } else if (compilerOptions.getSeverity(0x20010000) != 256 && (argument.type.bits & 0x40000000) == 0) {
                    abstractMethodDeclaration.scope.problemReporter().rawTypeReference(argument.type, typeBinding);
                }
            }
            ++n;
        }
        TypeReference typeReference = null;
        if (!abstractMethodDeclaration.isConstructor() && abstractMethodDeclaration instanceof MethodDeclaration && (typeReference = ((MethodDeclaration)abstractMethodDeclaration).returnType) != null) {
            TypeBinding typeBinding3 = methodBinding2.returnType;
            typeBinding = methodBinding.returnType;
            if (typeBinding.leafComponentType().isRawType() && !typeBinding3.leafComponentType().isRawType() && (typeReference.bits & 0x40000000) == 0 && compilerOptions.getSeverity(0x20010000) != 256) {
                abstractMethodDeclaration.scope.problemReporter().rawTypeReference(typeReference, typeBinding);
            }
        }
    }

    void checkMethods() {
        boolean bl = this.mustImplementAbstractMethods();
        boolean bl2 = bl && this.canSkipInheritedMethods();
        boolean bl3 = this.type.isOrEnclosedByPrivateType();
        char[][] cArray = this.inheritedMethods.keyTable;
        int n = cArray.length;
        while (--n >= 0) {
            Object object;
            MethodBinding methodBinding;
            int n2;
            Object object2;
            int n3;
            int n4;
            if (cArray[n] == null) continue;
            MethodBinding[] methodBindingArray = (MethodBinding[])this.currentMethods.get(cArray[n]);
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.inheritedMethods.valueTable[n];
            methodBindingArray2 = Sorting.concreteFirst(methodBindingArray2, methodBindingArray2.length);
            if (methodBindingArray == null && !bl3) {
                n4 = methodBindingArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    methodBindingArray2[n3].original().modifiers |= 0x8000000;
                    ++n3;
                }
            }
            if (methodBindingArray == null && this.type.isPublic()) {
                n4 = methodBindingArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    object2 = methodBindingArray2[n3];
                    if (((MethodBinding)object2).isPublic() && !((MethodBinding)object2).declaringClass.isInterface() && !((MethodBinding)object2).declaringClass.isPublic()) {
                        this.type.addSyntheticBridgeMethod(((MethodBinding)object2).original());
                    }
                    ++n3;
                }
            }
            if (methodBindingArray == null && bl2) continue;
            if (methodBindingArray2.length == 1 && methodBindingArray == null) {
                if (!bl || !methodBindingArray2[0].isAbstract()) continue;
                this.checkAbstractMethod(methodBindingArray2[0]);
                continue;
            }
            n4 = -1;
            n3 = methodBindingArray2.length;
            object2 = new MethodBinding[n3];
            MethodBinding[] methodBindingArray3 = new MethodBinding[n3];
            boolean[] blArray = new boolean[n3];
            boolean[] blArray2 = new boolean[n3];
            boolean[] blArray3 = new boolean[n3];
            Arrays.fill(blArray3, true);
            if (methodBindingArray != null) {
                n2 = 0;
                int n5 = methodBindingArray.length;
                while (n2 < n5) {
                    methodBinding = methodBindingArray[n2];
                    MethodBinding[] methodBindingArray4 = null;
                    int n6 = 0;
                    while (n6 < n3) {
                        object = this.computeSubstituteMethod(methodBindingArray2[n6], methodBinding);
                        if (object != null) {
                            if (methodBindingArray3[n6] == null && this.isSubstituteParameterSubsignature(methodBinding, (MethodBinding)object)) {
                                blArray2[n6] = blArray[n6] = MethodVerifier15.couldMethodOverride(methodBinding, (MethodBinding)object);
                                object2[++n4] = object;
                                methodBindingArray3[n6] = methodBinding;
                            } else {
                                this.checkForNameClash(methodBinding, (MethodBinding)object);
                                if (n3 > 1) {
                                    if (methodBindingArray4 == null) {
                                        methodBindingArray4 = new MethodBinding[n3];
                                    }
                                    methodBindingArray4[n6] = object;
                                }
                            }
                        }
                        ++n6;
                    }
                    if (n4 >= 0) {
                        this.checkAgainstInheritedMethods(methodBinding, (MethodBinding[])object2, n4 + 1, methodBindingArray4);
                        while (n4 >= 0) {
                            object2[n4--] = null;
                        }
                    }
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < n3) {
                MethodBinding methodBinding2 = methodBindingArray3[n2];
                if (methodBinding2 == null && methodBindingArray != null && this.type.isPublic() && (methodBinding = methodBindingArray2[n2]).isPublic() && !methodBinding.declaringClass.isInterface() && !methodBinding.declaringClass.isPublic()) {
                    this.type.addSyntheticBridgeMethod(methodBinding.original());
                }
                if (!bl3 && methodBinding2 == null && methodBindingArray != null) {
                    methodBindingArray2[n2].original().modifiers |= 0x8000000;
                }
                methodBinding = methodBindingArray2[n2];
                int n7 = n2 + 1;
                while (n7 < n3) {
                    MethodBinding methodBinding3 = methodBindingArray2[n7];
                    if (methodBinding2 == methodBindingArray3[n7] && methodBinding2 != null || this.canSkipInheritedMethods(methodBinding, methodBinding3) || !TypeBinding.notEquals(methodBinding.declaringClass, methodBinding3.declaringClass) || this.isSkippableOrOverridden(methodBinding, methodBinding3, blArray, blArray2, blArray3, n7) || this.isSkippableOrOverridden(methodBinding3, methodBinding, blArray, blArray2, blArray3, n2)) {
                        // empty if block
                    }
                    ++n7;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n3) {
                MethodBinding methodBinding4 = methodBindingArray3[n2];
                if (!blArray[n2]) {
                    methodBinding = methodBindingArray2[n2];
                    if (methodBinding4 == null) {
                        object2[++n4] = methodBinding;
                    }
                    int n8 = n2 + 1;
                    while (n8 < n3) {
                        if (methodBindingArray3[n8] == null) {
                            MethodBinding methodBinding5 = methodBindingArray2[n8];
                            if (!(methodBinding4 == methodBindingArray3[n8] && methodBinding4 != null || this.canSkipInheritedMethods(methodBinding, methodBinding5))) {
                                object = this.findReplacedMethod(methodBinding, methodBinding5);
                                if (object != null) {
                                    object2[++n4] = object;
                                    blArray[n8] = true;
                                } else {
                                    object = this.findReplacedMethod(methodBinding5, methodBinding);
                                    if (object != null) {
                                        object2[++n4] = object;
                                        blArray[n8] = true;
                                    } else if (methodBinding4 == null) {
                                        this.checkInheritedMethods(methodBinding, methodBinding5);
                                    }
                                }
                            }
                        }
                        ++n8;
                    }
                    if (n4 != -1) {
                        if (n4 > 0) {
                            boolean[] blArray4;
                            n8 = n4 + 1;
                            if (n8 != n3) {
                                blArray4 = new boolean[n8];
                                object = new boolean[n8];
                                int n9 = 0;
                                while (n9 < n8) {
                                    int n10 = 0;
                                    while (n10 < n3) {
                                        if (object2[n9] == methodBindingArray2[n10]) {
                                            blArray4[n9] = blArray2[n10];
                                            object[n9] = blArray3[n10];
                                            break;
                                        }
                                        ++n10;
                                    }
                                    ++n9;
                                }
                            } else {
                                blArray4 = blArray2;
                                object = blArray3;
                            }
                            this.checkInheritedMethods((MethodBinding[])object2, n8, blArray4, (boolean[])object);
                        } else if (bl && ((MethodBinding)object2[0]).isAbstract() && methodBinding4 == null) {
                            this.checkAbstractMethod((MethodBinding)object2[0]);
                        }
                        while (n4 >= 0) {
                            object2[n4--] = null;
                        }
                    }
                }
                ++n2;
            }
        }
    }

    boolean isSkippableOrOverridden(MethodBinding methodBinding, MethodBinding methodBinding2, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, int n) {
        boolean bl = methodBinding.declaringClass.isInterface();
        boolean bl2 = methodBinding2.declaringClass.isInterface();
        if (!bl && bl2) {
            if (!methodBinding.isAbstract() && this.isParameterSubsignature(methodBinding, methodBinding2)) {
                blArray3[n] = false;
                return true;
            }
            if (this.isInterfaceMethodImplemented(methodBinding2, methodBinding, methodBinding2.declaringClass)) {
                blArray[n] = true;
                blArray2[n] = true;
                return true;
            }
        } else if (bl == bl2 && methodBinding.declaringClass.isCompatibleWith(methodBinding2.declaringClass) && this.isMethodSubsignature(methodBinding, methodBinding2)) {
            blArray[n] = true;
            blArray2[n] = true;
            return true;
        }
        return false;
    }

    MethodBinding findReplacedMethod(MethodBinding methodBinding, MethodBinding methodBinding2) {
        MethodBinding methodBinding3 = this.computeSubstituteMethod(methodBinding2, methodBinding);
        if (methodBinding3 != null && (!methodBinding.isAbstract() || methodBinding2.isAbstract() || methodBinding2.isDefaultMethod() && methodBinding.declaringClass.isClass()) && this.isSubstituteParameterSubsignature(methodBinding, methodBinding3)) {
            return methodBinding3;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    void checkTypeVariableMethods(TypeParameter var1_1) {
        var2_2 = this.inheritedMethods.keyTable;
        var3_3 = var2_2.length;
        block0: while (--var3_3 >= 0) {
            if (var2_2[var3_3] == null || (var4_4 = (MethodBinding[])this.inheritedMethods.valueTable[var3_3]).length == 1) continue;
            var5_5 = -1;
            var6_6 = new MethodBinding[var4_4.length];
            var7_7 = 0;
            var8_8 = var4_4.length;
            ** GOTO lbl49
            {
                var6_6[var5_5--] = null;
                do {
                    if (var5_5 >= 0) continue block1;
                    var9_9 = var4_4[var7_7];
                    if (var9_9 != null) {
                        var6_6[++var5_5] = var9_9;
                        var10_10 = var7_7 + 1;
                        while (var10_10 < var8_8) {
                            var11_12 = var4_4[var10_10];
                            if (!this.canSkipInheritedMethods(var9_9, var11_12) && (var11_12 = this.computeSubstituteMethod(var11_12, var9_9)) != null && this.isSubstituteParameterSubsignature(var9_9, var11_12)) {
                                var6_6[++var5_5] = var11_12;
                                var4_4[var10_10] = null;
                            }
                            ++var10_10;
                        }
                    }
                    if (var5_5 > 0) {
                        var10_11 = var6_6[0];
                        var11_13 = var5_5 + 1;
                        while (--var11_13 > 0) {
                            var12_14 = var6_6[var11_13];
                            var13_15 = null;
                            var14_16 = null;
                            if (var10_11.declaringClass.isInterface()) {
                                var13_15 = var10_11;
                            } else if (var10_11.declaringClass.isClass()) {
                                var14_16 = var10_11;
                            }
                            if (var12_14.declaringClass.isInterface()) {
                                var13_15 = var12_14;
                            } else if (var12_14.declaringClass.isClass()) {
                                var14_16 = var12_14;
                            }
                            if (var13_15 != null && var14_16 != null && !this.isAsVisible(var14_16, var13_15)) {
                                this.problemReporter().inheritedMethodReducesVisibility(var1_1, var14_16, new MethodBinding[]{var13_15});
                            }
                            if (!this.areReturnTypesCompatible(var10_11, var12_14) && (!var10_11.declaringClass.isInterface() || !var12_14.declaringClass.isInterface() || !this.areReturnTypesCompatible(var12_14, var10_11))) break;
                        }
                        if (var11_13 > 0) {
                            this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(var1_1, var6_6, var5_5 + 1);
                            continue block0;
                        }
                    }
                    ++var7_7;
lbl49:
                    // 2 sources

                } while (var7_7 < var8_8);
            }
        }
    }

    boolean detectInheritedNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (!methodBinding.areParameterErasuresEqual(methodBinding2)) {
            return false;
        }
        if (TypeBinding.notEquals(methodBinding.returnType.erasure(), methodBinding2.returnType.erasure())) {
            return false;
        }
        if (TypeBinding.notEquals(methodBinding.declaringClass.erasure(), methodBinding2.declaringClass.erasure())) {
            if (methodBinding.declaringClass.findSuperTypeOriginatingFrom(methodBinding2.declaringClass) != null) {
                return false;
            }
            if (methodBinding2.declaringClass.findSuperTypeOriginatingFrom(methodBinding.declaringClass) != null) {
                return false;
            }
        }
        this.problemReporter().inheritedMethodsHaveNameClash(this.type, methodBinding, methodBinding2);
        return true;
    }

    boolean detectNameClash(MethodBinding methodBinding, MethodBinding methodBinding2, boolean bl) {
        MethodBinding[] methodBindingArray;
        MethodBinding methodBinding3 = methodBinding2;
        MethodBinding methodBinding4 = methodBinding3.original();
        if (!methodBinding.areParameterErasuresEqual(methodBinding4)) {
            return false;
        }
        int n = 1;
        if (this.environment.globalOptions.complianceLevel == 0x320000L && TypeBinding.notEquals(methodBinding.returnType.erasure(), methodBinding4.returnType.erasure())) {
            n = 0;
        }
        if (!bl && (methodBindingArray = (MethodBinding[])this.currentMethods.get(methodBinding2.selector)).length > 1) {
            int n2 = 0;
            int n3 = methodBindingArray.length;
            while (n2 < n3) {
                MethodBinding methodBinding5 = methodBindingArray[n2];
                if (methodBinding5 != methodBinding && this.doesMethodOverride(methodBinding5, methodBinding2)) {
                    methodBinding3 = methodBinding5;
                    break;
                }
                ++n2;
            }
        }
        if (!methodBinding.areParameterErasuresEqual(methodBinding4 = methodBinding3.original())) {
            return false;
        }
        methodBinding4 = methodBinding2.original();
        this.problemReporter(methodBinding).methodNameClash(methodBinding, methodBinding2.declaringClass.isRawType() ? methodBinding2 : methodBinding4, n);
        return n != 0;
    }

    boolean doTypeVariablesClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES && !(methodBinding2 instanceof ParameterizedGenericMethodBinding);
    }

    SimpleSet findSuperinterfaceCollisions(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        int n;
        ReferenceBinding referenceBinding2;
        int n2;
        int n3;
        ReferenceBinding[] referenceBindingArray2 = null;
        int n4 = 0;
        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
        if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
            n4 = referenceBindingArray3.length;
            referenceBindingArray2 = referenceBindingArray3;
        }
        boolean bl = this.type.isHierarchyInconsistent();
        ReferenceBinding referenceBinding3 = referenceBinding;
        while (referenceBinding3 != null && referenceBinding3.isValidBinding()) {
            bl |= referenceBinding3.isHierarchyInconsistent();
            referenceBindingArray3 = referenceBinding3.superInterfaces();
            if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
                if (referenceBindingArray2 == null) {
                    referenceBindingArray2 = referenceBindingArray3;
                    n4 = referenceBindingArray2.length;
                } else {
                    n3 = referenceBindingArray3.length;
                    if (n4 + n3 >= referenceBindingArray2.length) {
                        ReferenceBinding[] referenceBindingArray4 = referenceBindingArray2;
                        referenceBindingArray2 = new ReferenceBinding[n4 + n3 + 5];
                        System.arraycopy(referenceBindingArray4, 0, referenceBindingArray2, 0, n4);
                    }
                    n2 = 0;
                    while (n2 < n3) {
                        block22: {
                            referenceBinding2 = referenceBindingArray3[n2];
                            int n5 = 0;
                            while (n5 < n4) {
                                if (!TypeBinding.equalsEquals(referenceBinding2, referenceBindingArray2[n5])) {
                                    ++n5;
                                    continue;
                                }
                                break block22;
                            }
                            referenceBindingArray2[n4++] = referenceBinding2;
                        }
                        ++n2;
                    }
                }
            }
            referenceBinding3 = referenceBinding3.superclass();
        }
        n3 = 0;
        while (n3 < n4) {
            referenceBinding3 = referenceBindingArray2[n3];
            if (referenceBinding3.isValidBinding()) {
                bl |= referenceBinding3.isHierarchyInconsistent();
                referenceBindingArray3 = referenceBinding3.superInterfaces();
                if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
                    n2 = referenceBindingArray3.length;
                    if (n4 + n2 >= referenceBindingArray2.length) {
                        ReferenceBinding[] referenceBindingArray5 = referenceBindingArray2;
                        referenceBindingArray2 = new ReferenceBinding[n4 + n2 + 5];
                        System.arraycopy(referenceBindingArray5, 0, referenceBindingArray2, 0, n4);
                    }
                    int n6 = 0;
                    while (n6 < n2) {
                        block23: {
                            ReferenceBinding referenceBinding4 = referenceBindingArray3[n6];
                            n = 0;
                            while (n < n4) {
                                if (!TypeBinding.equalsEquals(referenceBinding4, referenceBindingArray2[n])) {
                                    ++n;
                                    continue;
                                }
                                break block23;
                            }
                            referenceBindingArray2[n4++] = referenceBinding4;
                        }
                        ++n6;
                    }
                }
            }
            ++n3;
        }
        if (!bl) {
            return null;
        }
        SimpleSet simpleSet = null;
        n2 = 0;
        while (n2 < n4) {
            referenceBinding2 = referenceBindingArray2[n2];
            if (referenceBinding2.isValidBinding()) {
                TypeBinding typeBinding = referenceBinding2.erasure();
                n = n2 + 1;
                while (n < n4) {
                    ReferenceBinding referenceBinding5 = referenceBindingArray2[n];
                    if (referenceBinding5.isValidBinding() && TypeBinding.equalsEquals(referenceBinding5.erasure(), typeBinding)) {
                        if (simpleSet == null) {
                            simpleSet = new SimpleSet(n4);
                        }
                        simpleSet.add(referenceBindingArray2[n2]);
                        simpleSet.add(referenceBindingArray2[n]);
                    }
                    ++n;
                }
            }
            ++n2;
        }
        return simpleSet;
    }

    boolean isAcceptableReturnTypeOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding2.declaringClass.isRawType()) {
            return true;
        }
        MethodBinding methodBinding3 = methodBinding2.original();
        TypeBinding typeBinding = methodBinding3.returnType.leafComponentType();
        if (typeBinding.isParameterizedTypeWithActualArguments()) {
            return !methodBinding.returnType.leafComponentType().isRawType();
        }
        TypeBinding typeBinding2 = methodBinding.returnType.leafComponentType();
        switch (typeBinding2.kind()) {
            case 4100: {
                if (!TypeBinding.equalsEquals(typeBinding2, methodBinding2.returnType.leafComponentType())) break;
                return true;
            }
        }
        return !typeBinding.isTypeVariable() || ((TypeVariableBinding)typeBinding).declaringElement != methodBinding3;
    }

    boolean isInterfaceMethodImplemented(MethodBinding methodBinding, MethodBinding methodBinding2, ReferenceBinding referenceBinding) {
        if (methodBinding.original() != methodBinding && methodBinding2.declaringClass.isInterface()) {
            return false;
        }
        if ((methodBinding = this.computeSubstituteMethod(methodBinding, methodBinding2)) == null || TypeBinding.notEquals(methodBinding.returnType, methodBinding2.returnType)) {
            return false;
        }
        if (!this.doesMethodOverride(methodBinding2, methodBinding)) {
            return false;
        }
        return TypeBinding.notEquals(this.type, methodBinding2.declaringClass) && !methodBinding2.declaringClass.isInterface();
    }

    public boolean isMethodSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        MethodBinding methodBinding3;
        if (!CharOperation.equals(methodBinding.selector, methodBinding2.selector)) {
            return false;
        }
        if (methodBinding.declaringClass.isParameterizedType()) {
            methodBinding = methodBinding.original();
        }
        return this.isParameterSubsignature(methodBinding, (methodBinding3 = methodBinding.findOriginalInheritedMethod(methodBinding2)) == null ? methodBinding2 : methodBinding3);
    }

    boolean isUnsafeReturnTypeOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (TypeBinding.equalsEquals(methodBinding.returnType, methodBinding2.returnType.erasure())) {
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
            int n = 0;
            int n2 = typeBindingArray.length;
            while (n < n2) {
                if (!MethodVerifier15.areTypesEqual(typeBindingArray[n], typeBindingArray2[n])) {
                    return true;
                }
                ++n;
            }
        }
        return methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && methodBinding2.original().typeVariables != Binding.NO_TYPE_VARIABLES && methodBinding.returnType.erasure().findSuperTypeOriginatingFrom(methodBinding2.returnType.erasure()) != null;
    }

    boolean reportIncompatibleReturnTypeError(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.isUnsafeReturnTypeOverride(methodBinding, methodBinding2)) {
            this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding2, this.type);
            return false;
        }
        return super.reportIncompatibleReturnTypeError(methodBinding, methodBinding2);
    }

    void verify() {
        if (this.type.isAnnotationType()) {
            this.type.detectAnnotationCycle();
        }
        super.verify();
        this.reportRawReferences();
        int n = this.type.typeVariables.length;
        while (--n >= 0) {
            TypeVariableBinding typeVariableBinding = this.type.typeVariables[n];
            if (typeVariableBinding.superInterfaces == Binding.NO_SUPERINTERFACES || typeVariableBinding.superInterfaces.length == 1 && typeVariableBinding.superclass.id == 1) continue;
            this.currentMethods = new HashtableOfObject(0);
            ReferenceBinding referenceBinding = typeVariableBinding.superclass();
            if (referenceBinding.kind() == 4100) {
                referenceBinding = (ReferenceBinding)referenceBinding.erasure();
            }
            ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces();
            ReferenceBinding[] referenceBindingArray2 = new ReferenceBinding[referenceBindingArray.length];
            int n2 = referenceBindingArray.length;
            while (--n2 >= 0) {
                ReferenceBinding referenceBinding2 = referenceBindingArray2[n2] = referenceBindingArray[n2].kind() == 4100 ? (ReferenceBinding)referenceBindingArray[n2].erasure() : referenceBindingArray[n2];
            }
            this.computeInheritedMethods(referenceBinding, referenceBindingArray2);
            this.checkTypeVariableMethods(this.type.scope.referenceContext.typeParameters[n]);
        }
    }
}

