/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class BlockScope
extends Scope {
    public LocalVariableBinding[] locals;
    public int localIndex;
    public int startIndex;
    public int offset;
    public int maxOffset;
    public BlockScope[] shiftScopes;
    public Scope[] subscopes = new Scope[1];
    public int subscopeCount = 0;
    public CaseStatement enclosingCase;
    public static final VariableBinding[] EmulationPathToImplicitThis = new VariableBinding[0];
    public static final VariableBinding[] NoEnclosingInstanceInConstructorCall = new VariableBinding[0];
    public static final VariableBinding[] NoEnclosingInstanceInStaticContext = new VariableBinding[0];
    public boolean insideTypeAnnotation = false;
    private List trackingVariables;
    public FlowInfo finallyInfo;

    public BlockScope(BlockScope blockScope) {
        this(blockScope, true);
    }

    public BlockScope(BlockScope blockScope, boolean bl) {
        this(1, blockScope);
        this.locals = new LocalVariableBinding[5];
        if (bl) {
            blockScope.addSubscope(this);
        }
        this.startIndex = blockScope.localIndex;
    }

    public BlockScope(BlockScope blockScope, int n) {
        this(1, blockScope);
        this.locals = new LocalVariableBinding[n];
        blockScope.addSubscope(this);
        this.startIndex = blockScope.localIndex;
    }

    protected BlockScope(int n, Scope scope) {
        super(n, scope);
    }

    public final void addAnonymousType(TypeDeclaration typeDeclaration, ReferenceBinding referenceBinding) {
        ClassScope classScope = new ClassScope(this, typeDeclaration);
        classScope.buildAnonymousTypeBinding(this.enclosingSourceType(), referenceBinding);
        MethodScope methodScope = this.methodScope();
        while (methodScope != null && methodScope.referenceContext instanceof LambdaExpression) {
            LambdaExpression lambdaExpression = (LambdaExpression)methodScope.referenceContext;
            if (!lambdaExpression.scope.isStatic && !lambdaExpression.scope.isConstructorCall) {
                lambdaExpression.shouldCaptureInstance = true;
            }
            methodScope = methodScope.enclosingMethodScope();
        }
    }

    public final void addLocalType(TypeDeclaration typeDeclaration) {
        ClassScope classScope = new ClassScope(this, typeDeclaration);
        this.addSubscope(classScope);
        classScope.buildLocalTypeBinding(this.enclosingSourceType());
        MethodScope methodScope = this.methodScope();
        while (methodScope != null && methodScope.referenceContext instanceof LambdaExpression) {
            LambdaExpression lambdaExpression = (LambdaExpression)methodScope.referenceContext;
            if (!lambdaExpression.scope.isStatic && !lambdaExpression.scope.isConstructorCall) {
                lambdaExpression.shouldCaptureInstance = true;
            }
            methodScope = methodScope.enclosingMethodScope();
        }
    }

    public final void addLocalVariable(LocalVariableBinding localVariableBinding) {
        this.checkAndSetModifiersForVariable(localVariableBinding);
        if (this.localIndex == this.locals.length) {
            this.locals = new LocalVariableBinding[this.localIndex * 2];
            System.arraycopy(this.locals, 0, this.locals, 0, this.localIndex);
        }
        this.locals[this.localIndex++] = localVariableBinding;
        localVariableBinding.declaringScope = this;
        localVariableBinding.id = this.outerMostMethodScope().analysisIndex++;
    }

    public void addSubscope(Scope scope) {
        if (this.subscopeCount == this.subscopes.length) {
            this.subscopes = new Scope[this.subscopeCount * 2];
            System.arraycopy(this.subscopes, 0, this.subscopes, 0, this.subscopeCount);
        }
        this.subscopes[this.subscopeCount++] = scope;
    }

    public final boolean allowBlankFinalFieldAssignment(FieldBinding fieldBinding) {
        if (TypeBinding.notEquals(this.enclosingReceiverType(), fieldBinding.declaringClass)) {
            return false;
        }
        MethodScope methodScope = this.methodScope();
        if (methodScope.isStatic != fieldBinding.isStatic()) {
            return false;
        }
        if (methodScope.isLambdaScope()) {
            return false;
        }
        return methodScope.isInsideInitializer() || ((AbstractMethodDeclaration)methodScope.referenceContext).isInitializationMethod();
    }

    String basicToString(int n) {
        String string = "\n";
        int n2 = n;
        while (--n2 >= 0) {
            string = String.valueOf(string) + "\t";
        }
        String string2 = String.valueOf(string) + "--- Block Scope ---";
        string = String.valueOf(string) + "\t";
        string2 = String.valueOf(string2) + string + "locals:";
        int n3 = 0;
        while (n3 < this.localIndex) {
            string2 = String.valueOf(string2) + string + "\t" + this.locals[n3].toString();
            ++n3;
        }
        string2 = String.valueOf(string2) + string + "startIndex = " + this.startIndex;
        return string2;
    }

    private void checkAndSetModifiersForVariable(LocalVariableBinding localVariableBinding) {
        int n;
        int n2;
        int n3 = localVariableBinding.modifiers;
        if ((n3 & 0x400000) != 0 && localVariableBinding.declaration != null) {
            this.problemReporter().duplicateModifierForVariable(localVariableBinding.declaration, this instanceof MethodScope);
        }
        if (((n2 = n3 & 0xFFFF) & (n = -17)) != 0 && localVariableBinding.declaration != null) {
            this.problemReporter().illegalModifierForVariable(localVariableBinding.declaration, this instanceof MethodScope);
        }
        localVariableBinding.modifiers = n3;
    }

    void computeLocalVariablePositions(int n, int n2, CodeStream codeStream) {
        this.offset = n2;
        this.maxOffset = n2;
        int n3 = this.localIndex;
        boolean bl = n < n3;
        int n4 = 0;
        int n5 = this.subscopeCount;
        boolean bl2 = n5 > 0;
        while (bl || bl2) {
            int n6;
            Object object;
            if (bl2 && (!bl || this.subscopes[n4].startIndex() <= n)) {
                if (this.subscopes[n4] instanceof BlockScope) {
                    object = (BlockScope)this.subscopes[n4];
                    n6 = ((BlockScope)object).shiftScopes == null ? this.offset : ((BlockScope)object).maxShiftedOffset();
                    ((BlockScope)object).computeLocalVariablePositions(0, n6, codeStream);
                    if (((BlockScope)object).maxOffset > this.maxOffset) {
                        this.maxOffset = ((BlockScope)object).maxOffset;
                    }
                }
                bl2 = ++n4 < n5;
                continue;
            }
            object = this.locals[n];
            int n7 = n6 = ((LocalVariableBinding)object).useFlag > 0 && ((VariableBinding)object).constant() == Constant.NotAConstant ? 1 : 0;
            if (((LocalVariableBinding)object).useFlag == 0 && ((LocalVariableBinding)object).declaration != null && (((LocalVariableBinding)object).declaration.bits & 0x40000000) != 0) {
                if (((LocalVariableBinding)object).isCatchParameter()) {
                    this.problemReporter().unusedExceptionParameter(((LocalVariableBinding)object).declaration);
                } else {
                    this.problemReporter().unusedLocalVariable(((LocalVariableBinding)object).declaration);
                }
            }
            if (n6 == 0 && ((LocalVariableBinding)object).declaration != null && this.compilerOptions().preserveAllLocalVariables) {
                n6 = 1;
                if (((LocalVariableBinding)object).useFlag == 0) {
                    ((LocalVariableBinding)object).useFlag = 1;
                }
            }
            if (n6 != 0) {
                if (((LocalVariableBinding)object).declaration != null) {
                    codeStream.record((LocalVariableBinding)object);
                }
                ((LocalVariableBinding)object).resolvedPosition = this.offset++;
                if (TypeBinding.equalsEquals(((LocalVariableBinding)object).type, TypeBinding.LONG) || TypeBinding.equalsEquals(((LocalVariableBinding)object).type, TypeBinding.DOUBLE)) {
                    this.offset += 2;
                }
                if (this.offset > 65535) {
                    this.problemReporter().noMoreAvailableSpaceForLocal((LocalVariableBinding)object, ((LocalVariableBinding)object).declaration == null ? (ASTNode)((Object)this.methodScope().referenceContext) : ((LocalVariableBinding)object).declaration);
                }
            } else {
                ((LocalVariableBinding)object).resolvedPosition = -1;
            }
            boolean bl3 = bl = ++n < n3;
        }
        if (this.offset > this.maxOffset) {
            this.maxOffset = this.offset;
        }
    }

    public void emulateOuterAccess(LocalVariableBinding localVariableBinding) {
        Object object;
        BlockScope blockScope = localVariableBinding.declaringScope;
        if (blockScope == null) {
            return;
        }
        int n = 0;
        Scope scope = this;
        while (blockScope != scope) {
            switch (scope.kind) {
                case 3: {
                    ++n;
                    break;
                }
                case 2: {
                    if (!scope.isLambdaScope()) break;
                    object = (LambdaExpression)scope.referenceContext();
                    ((LambdaExpression)object).addSyntheticArgument(localVariableBinding);
                }
            }
            scope = scope.parent;
        }
        if (n == 0) {
            return;
        }
        object = this.methodScope();
        if (blockScope.methodScope() != object) {
            NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)this.enclosingSourceType();
            if (!nestedTypeBinding.isLocalType()) {
                return;
            }
            if (!((MethodScope)object).isInsideInitializerOrConstructor()) {
                nestedTypeBinding.addSyntheticArgumentAndField(localVariableBinding);
            } else {
                nestedTypeBinding.addSyntheticArgument(localVariableBinding);
            }
        }
    }

    public final ReferenceBinding findLocalType(char[] cArray) {
        long l = this.compilerOptions().complianceLevel;
        int n = this.subscopeCount - 1;
        while (n >= 0) {
            if (this.subscopes[n] instanceof ClassScope) {
                LocalTypeBinding localTypeBinding = (LocalTypeBinding)((ClassScope)this.subscopes[n]).referenceContext.binding;
                if ((l < 0x300000L || localTypeBinding.enclosingCase == null || this.isInsideCase(localTypeBinding.enclosingCase)) && CharOperation.equals(localTypeBinding.sourceName(), cArray)) {
                    return localTypeBinding;
                }
            }
            --n;
        }
        return null;
    }

    public LocalDeclaration[] findLocalVariableDeclarations(int n) {
        int n2 = 0;
        int n3 = this.localIndex;
        boolean bl = n3 > 0;
        LocalDeclaration[] localDeclarationArray = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.subscopeCount;
        boolean bl2 = n6 > 0;
        while (bl || bl2) {
            LocalDeclaration localDeclaration;
            Object object;
            if (bl2 && (!bl || this.subscopes[n5].startIndex() <= n2)) {
                object = this.subscopes[n5];
                if (((Scope)object).kind == 1 && (localDeclarationArray = ((BlockScope)object).findLocalVariableDeclarations(n)) != null) {
                    return localDeclarationArray;
                }
                bl2 = ++n5 < n6;
                continue;
            }
            object = this.locals[n2];
            if (object != null && (localDeclaration = ((LocalVariableBinding)object).declaration) != null) {
                if (localDeclaration.declarationSourceStart <= n) {
                    if (n <= localDeclaration.declarationSourceEnd) {
                        if (localDeclarationArray == null) {
                            localDeclarationArray = new LocalDeclaration[n3];
                        }
                        localDeclarationArray[n4++] = localDeclaration;
                    }
                } else {
                    return localDeclarationArray;
                }
            }
            boolean bl3 = bl = ++n2 < n3;
            if (bl || localDeclarationArray == null) continue;
            return localDeclarationArray;
        }
        return null;
    }

    public LocalVariableBinding findVariable(char[] cArray) {
        int n = cArray.length;
        int n2 = this.localIndex - 1;
        while (n2 >= 0) {
            LocalVariableBinding localVariableBinding = this.locals[n2];
            char[] cArray2 = localVariableBinding.name;
            if (localVariableBinding.name.length == n && CharOperation.equals(cArray2, cArray)) {
                return localVariableBinding;
            }
            --n2;
        }
        return null;
    }

    public Binding getBinding(char[][] cArray, int n, InvocationSite invocationSite, boolean bl) {
        Object object;
        Object object2;
        Binding binding;
        int n2;
        int n3;
        Binding binding2;
        block22: {
            binding2 = this.getBinding(cArray[0], n | 4 | 0x10, invocationSite, bl);
            invocationSite.setFieldIndex(1);
            if (binding2 instanceof VariableBinding) {
                return binding2;
            }
            CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
            compilationUnitScope.recordQualifiedReference(cArray);
            if (!binding2.isValidBinding()) {
                return binding2;
            }
            n3 = cArray.length;
            n2 = 1;
            if (binding2 instanceof PackageBinding) {
                binding = (PackageBinding)binding2;
                while (n2 < n3) {
                    compilationUnitScope.recordReference(((PackageBinding)binding).compoundName, cArray[n2]);
                    binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray[n2++]);
                    invocationSite.setFieldIndex(n2);
                    if (binding2 == null) {
                        if (n2 == n3) {
                            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
                        }
                        return new ProblemBinding(CharOperation.subarray(cArray, 0, n2), 1);
                    }
                    if (binding2 instanceof ReferenceBinding) {
                        if (!binding2.isValidBinding()) {
                            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)((ReferenceBinding)binding2).closestMatch(), binding2.problemId());
                        }
                        if (!((ReferenceBinding)binding2).canBeSeenBy(this)) {
                            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding2, 2);
                        }
                        break block22;
                    }
                    binding = (PackageBinding)binding2;
                }
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
            }
        }
        binding = (ReferenceBinding)binding2;
        binding2 = this.environment().convertToRawType((TypeBinding)binding, false);
        if (invocationSite instanceof ASTNode && ((ASTNode)(object2 = (ASTNode)((Object)invocationSite))).isTypeUseDeprecated((TypeBinding)binding, this)) {
            this.problemReporter().deprecatedType((TypeBinding)binding, (ASTNode)object2);
        }
        object2 = null;
        while (n2 < n3) {
            ASTNode aSTNode;
            binding = (ReferenceBinding)binding2;
            object = cArray[n2++];
            invocationSite.setFieldIndex(n2);
            invocationSite.setActualReceiverType((ReferenceBinding)binding);
            if ((n & 1) != 0 && (binding2 = this.findField((TypeBinding)binding, (char[])object, invocationSite, true)) != null) {
                if (binding2.isValidBinding()) break;
                object2 = new ProblemFieldBinding(((ProblemFieldBinding)binding2).closestMatch, ((ProblemFieldBinding)binding2).declaringClass, CharOperation.concatWith(CharOperation.subarray(cArray, 0, n2), '.'), binding2.problemId());
                if (binding2.problemId() != 2) {
                    return object2;
                }
            }
            if ((binding2 = this.findMemberType((char[])object, (ReferenceBinding)binding)) == null) {
                if (object2 != null) {
                    return object2;
                }
                if ((n & 1) != 0) {
                    return new ProblemFieldBinding(null, (ReferenceBinding)binding, (char[])object, 1);
                }
                if ((n & 3) != 0) {
                    return new ProblemBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 1);
                }
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 1);
            }
            if (!binding2.isValidBinding()) {
                if (object2 != null) {
                    return object2;
                }
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)((ReferenceBinding)binding2).closestMatch(), binding2.problemId());
            }
            if (!(invocationSite instanceof ASTNode) || !(aSTNode = (ASTNode)((Object)invocationSite)).isTypeUseDeprecated((TypeBinding)(binding = (ReferenceBinding)binding2), this)) continue;
            this.problemReporter().deprecatedType((TypeBinding)binding, aSTNode);
        }
        if ((n & 1) != 0 && binding2 instanceof FieldBinding) {
            object = (FieldBinding)binding2;
            if (!((FieldBinding)object).isStatic()) {
                return new ProblemFieldBinding((FieldBinding)object, ((FieldBinding)object).declaringClass, CharOperation.concatWith(CharOperation.subarray(cArray, 0, n2), '.'), 7);
            }
            return binding2;
        }
        if ((n & 4) != 0 && binding2 instanceof ReferenceBinding) {
            return binding2;
        }
        return new ProblemBinding(CharOperation.subarray(cArray, 0, n2), 1);
    }

    public final Binding getBinding(char[][] cArray, InvocationSite invocationSite) {
        TypeBinding typeBinding;
        Object object;
        Binding binding;
        Binding binding2;
        int n;
        int n2;
        block17: {
            block16: {
                n2 = 0;
                n = cArray.length;
                if (!(binding2 = this.getBinding(cArray[n2++], 23, invocationSite, true)).isValidBinding()) {
                    return binding2;
                }
                if (binding2 instanceof PackageBinding) {
                    while (n2 < n) {
                        binding = (PackageBinding)binding2;
                        if ((binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray[n2++])) == null) {
                            if (n2 == n) {
                                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
                            }
                            return new ProblemBinding(CharOperation.subarray(cArray, 0, n2), 1);
                        }
                        if (!(binding2 instanceof ReferenceBinding)) continue;
                        if (!binding2.isValidBinding()) {
                            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)((ReferenceBinding)binding2).closestMatch(), binding2.problemId());
                        }
                        if (!((ReferenceBinding)binding2).canBeSeenBy(this)) {
                            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding2, 2);
                        }
                        break block16;
                    }
                    return binding2;
                }
            }
            if (binding2 instanceof ReferenceBinding) {
                while (n2 < n) {
                    binding = (ReferenceBinding)binding2;
                    object = cArray[n2++];
                    typeBinding = ((TypeBinding)binding).capture(this, invocationSite.sourceStart(), invocationSite.sourceEnd());
                    binding2 = this.findField(typeBinding, (char[])object, invocationSite, true);
                    if (binding2 != null) {
                        if (!binding2.isValidBinding()) {
                            return new ProblemFieldBinding((FieldBinding)binding2, ((FieldBinding)binding2).declaringClass, CharOperation.concatWith(CharOperation.subarray(cArray, 0, n2), '.'), binding2.problemId());
                        }
                        if (!((FieldBinding)binding2).isStatic()) {
                            return new ProblemFieldBinding((FieldBinding)binding2, ((FieldBinding)binding2).declaringClass, CharOperation.concatWith(CharOperation.subarray(cArray, 0, n2), '.'), 7);
                        }
                        break block17;
                    }
                    binding2 = this.findMemberType((char[])object, (ReferenceBinding)binding);
                    if (binding2 == null) {
                        return new ProblemBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 1);
                    }
                    if (binding2.isValidBinding()) continue;
                    return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)((ReferenceBinding)binding2).closestMatch(), binding2.problemId());
                }
                return binding2;
            }
        }
        binding = (VariableBinding)binding2;
        while (n2 < n) {
            object = ((VariableBinding)binding).type;
            if (object == null) {
                return new ProblemFieldBinding(null, null, CharOperation.concatWith(CharOperation.subarray(cArray, 0, n2), '.'), 1);
            }
            typeBinding = ((TypeBinding)object).capture(this, invocationSite.sourceStart(), invocationSite.sourceEnd());
            binding = this.findField(typeBinding, cArray[n2++], invocationSite, true);
            if (binding == null) {
                return new ProblemFieldBinding(null, typeBinding instanceof ReferenceBinding ? (ReferenceBinding)typeBinding : null, CharOperation.concatWith(CharOperation.subarray(cArray, 0, n2), '.'), 1);
            }
            if (binding.isValidBinding()) continue;
            return binding;
        }
        return binding;
    }

    public VariableBinding[] getEmulationPath(LocalVariableBinding localVariableBinding) {
        Object object;
        SyntheticArgumentBinding syntheticArgumentBinding;
        MethodScope methodScope = this.methodScope();
        SourceTypeBinding sourceTypeBinding = methodScope.enclosingSourceType();
        BlockScope blockScope = localVariableBinding.declaringScope;
        if (blockScope == null || methodScope == blockScope.methodScope()) {
            return new VariableBinding[]{localVariableBinding};
        }
        if (methodScope.isLambdaScope() && (syntheticArgumentBinding = ((LambdaExpression)(object = (LambdaExpression)methodScope.referenceContext)).getSyntheticArgument(localVariableBinding)) != null) {
            return new VariableBinding[]{syntheticArgumentBinding};
        }
        if (methodScope.isInsideInitializerOrConstructor() && sourceTypeBinding.isNestedType() && (object = ((NestedTypeBinding)sourceTypeBinding).getSyntheticArgument(localVariableBinding)) != null) {
            return new VariableBinding[]{object};
        }
        if (!methodScope.isStatic && (object = sourceTypeBinding.getSyntheticField(localVariableBinding)) != null) {
            return new VariableBinding[]{object};
        }
        return null;
    }

    public Object[] getEmulationPath(ReferenceBinding referenceBinding, boolean bl, boolean bl2) {
        FieldBinding fieldBinding;
        Object[] objectArray;
        Binding binding;
        Binding binding2;
        MethodScope methodScope = this.methodScope();
        SourceTypeBinding sourceTypeBinding = methodScope.enclosingSourceType();
        if (!methodScope.isStatic && !methodScope.isConstructorCall && (TypeBinding.equalsEquals(sourceTypeBinding, referenceBinding) || !bl && sourceTypeBinding.findSuperTypeOriginatingFrom(referenceBinding) != null)) {
            return EmulationPathToImplicitThis;
        }
        if (!sourceTypeBinding.isNestedType() || sourceTypeBinding.isStatic()) {
            if (methodScope.isConstructorCall) {
                return NoEnclosingInstanceInConstructorCall;
            }
            if (methodScope.isStatic) {
                return NoEnclosingInstanceInStaticContext;
            }
            return null;
        }
        boolean bl3 = methodScope.isInsideInitializerOrConstructor();
        if (bl3 && (binding2 = ((NestedTypeBinding)sourceTypeBinding).getSyntheticArgument(referenceBinding, bl, methodScope.isConstructorCall)) != null) {
            boolean bl4;
            boolean bl5 = bl4 = sourceTypeBinding.isAnonymousType() && sourceTypeBinding.scope.referenceContext.allocation.enclosingInstance != null;
            if (bl2 && methodScope.isConstructorCall && !bl4 && (TypeBinding.equalsEquals(sourceTypeBinding, referenceBinding) || !bl && sourceTypeBinding.findSuperTypeOriginatingFrom(referenceBinding) != null)) {
                return NoEnclosingInstanceInConstructorCall;
            }
            return new Object[]{binding2};
        }
        if (methodScope.isStatic) {
            return NoEnclosingInstanceInStaticContext;
        }
        if (sourceTypeBinding.isAnonymousType() && ((TypeBinding)(binding2 = sourceTypeBinding.enclosingType())).isNestedType() && (binding = (objectArray = (Object[])binding2).getSyntheticArgument(objectArray.enclosingType(), bl, methodScope.isConstructorCall)) != null && (fieldBinding = sourceTypeBinding.getSyntheticField((LocalVariableBinding)binding)) != null && (TypeBinding.equalsEquals(fieldBinding.type, referenceBinding) || !bl && ((ReferenceBinding)fieldBinding.type).findSuperTypeOriginatingFrom(referenceBinding) != null)) {
            return new Object[]{fieldBinding};
        }
        binding2 = sourceTypeBinding.getSyntheticField(referenceBinding, bl);
        if (binding2 != null) {
            if (methodScope.isConstructorCall) {
                return NoEnclosingInstanceInConstructorCall;
            }
            return new Object[]{binding2};
        }
        objectArray = new Object[2];
        binding = sourceTypeBinding.enclosingType();
        if (bl3) {
            objectArray[0] = ((NestedTypeBinding)sourceTypeBinding).getSyntheticArgument((ReferenceBinding)binding, bl, methodScope.isConstructorCall);
        } else {
            if (methodScope.isConstructorCall) {
                return NoEnclosingInstanceInConstructorCall;
            }
            objectArray[0] = sourceTypeBinding.getSyntheticField((ReferenceBinding)binding, bl);
        }
        if (objectArray[0] != null) {
            ReferenceBinding referenceBinding2;
            int n = 1;
            while ((referenceBinding2 = ((TypeBinding)binding).enclosingType()) != null) {
                if (TypeBinding.equalsEquals((TypeBinding)binding, referenceBinding) || !bl && ((TypeBinding)binding).findSuperTypeOriginatingFrom(referenceBinding) != null) break;
                if (methodScope != null) {
                    if ((methodScope = methodScope.enclosingMethodScope()) != null && methodScope.isConstructorCall) {
                        return NoEnclosingInstanceInConstructorCall;
                    }
                    if (methodScope != null && methodScope.isStatic) {
                        return NoEnclosingInstanceInStaticContext;
                    }
                }
                if ((binding2 = ((NestedTypeBinding)binding).getSyntheticField(referenceBinding2, bl)) == null) break;
                if (n == objectArray.length) {
                    Object[] objectArray2 = objectArray;
                    objectArray = new Object[n + 1];
                    System.arraycopy(objectArray2, 0, objectArray, 0, n);
                }
                objectArray[n++] = ((SourceTypeBinding)((FieldBinding)binding2).declaringClass).addSyntheticMethod((FieldBinding)binding2, true, false);
                binding = referenceBinding2;
            }
            if (TypeBinding.equalsEquals((TypeBinding)binding, referenceBinding) || !bl && ((TypeBinding)binding).findSuperTypeOriginatingFrom(referenceBinding) != null) {
                return objectArray;
            }
        }
        return null;
    }

    public final boolean isDuplicateLocalVariable(char[] cArray) {
        BlockScope blockScope = this;
        while (true) {
            int n = 0;
            while (n < this.localIndex) {
                if (CharOperation.equals(cArray, blockScope.locals[n].name)) {
                    return true;
                }
                ++n;
            }
            if (blockScope.kind != 1) {
                return false;
            }
            blockScope = (BlockScope)blockScope.parent;
        }
    }

    public int maxShiftedOffset() {
        int n = -1;
        if (this.shiftScopes != null) {
            int n2 = 0;
            int n3 = this.shiftScopes.length;
            while (n2 < n3) {
                int n4;
                if (this.shiftScopes[n2] != null && (n4 = this.shiftScopes[n2].maxOffset) > n) {
                    n = n4;
                }
                ++n2;
            }
        }
        return n;
    }

    public final boolean needBlankFinalFieldInitializationCheck(FieldBinding fieldBinding) {
        boolean bl = fieldBinding.isStatic();
        ReferenceBinding referenceBinding = fieldBinding.declaringClass;
        MethodScope methodScope = this.namedMethodScope();
        while (methodScope != null) {
            if (methodScope.isStatic != bl) {
                return false;
            }
            if (!methodScope.isInsideInitializer() && !((AbstractMethodDeclaration)methodScope.referenceContext).isInitializationMethod()) {
                return false;
            }
            ReferenceBinding referenceBinding2 = methodScope.enclosingReceiverType();
            if (TypeBinding.equalsEquals(referenceBinding2, referenceBinding)) {
                return true;
            }
            if (!referenceBinding2.erasure().isAnonymousType()) {
                return false;
            }
            methodScope = methodScope.enclosingMethodScope().namedMethodScope();
        }
        return false;
    }

    public ProblemReporter problemReporter() {
        return this.methodScope().problemReporter();
    }

    public void propagateInnerEmulation(ReferenceBinding referenceBinding, boolean bl) {
        SyntheticArgumentBinding[] syntheticArgumentBindingArray = referenceBinding.syntheticOuterLocalVariables();
        if (syntheticArgumentBindingArray != null) {
            int n = 0;
            int n2 = syntheticArgumentBindingArray.length;
            while (n < n2) {
                SyntheticArgumentBinding syntheticArgumentBinding = syntheticArgumentBindingArray[n];
                if (!bl || !TypeBinding.equalsEquals(syntheticArgumentBinding.type, referenceBinding.enclosingType())) {
                    this.emulateOuterAccess(syntheticArgumentBinding.actualOuterLocalVariable);
                }
                ++n;
            }
        }
    }

    public TypeDeclaration referenceType() {
        return this.methodScope().referenceType();
    }

    public int scopeIndex() {
        if (this instanceof MethodScope) {
            return -1;
        }
        BlockScope blockScope = (BlockScope)this.parent;
        Scope[] scopeArray = blockScope.subscopes;
        int n = 0;
        int n2 = blockScope.subscopeCount;
        while (n < n2) {
            if (scopeArray[n] == this) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int startIndex() {
        return this.startIndex;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        String string = this.basicToString(n);
        int n2 = 0;
        while (n2 < this.subscopeCount) {
            if (this.subscopes[n2] instanceof BlockScope) {
                string = String.valueOf(string) + ((BlockScope)this.subscopes[n2]).toString(n + 1) + "\n";
            }
            ++n2;
        }
        return string;
    }

    public int registerTrackingVariable(FakedTrackingVariable fakedTrackingVariable) {
        if (this.trackingVariables == null) {
            this.trackingVariables = new ArrayList(3);
        }
        this.trackingVariables.add(fakedTrackingVariable);
        MethodScope methodScope = this.outerMostMethodScope();
        return methodScope.analysisIndex++;
    }

    public void removeTrackingVar(FakedTrackingVariable fakedTrackingVariable) {
        if (fakedTrackingVariable.innerTracker != null) {
            fakedTrackingVariable.innerTracker.withdraw();
            fakedTrackingVariable.innerTracker = null;
        }
        if (this.trackingVariables != null && this.trackingVariables.remove(fakedTrackingVariable)) {
            return;
        }
        if (this.parent instanceof BlockScope) {
            ((BlockScope)this.parent).removeTrackingVar(fakedTrackingVariable);
        }
    }

    public void pruneWrapperTrackingVar(FakedTrackingVariable fakedTrackingVariable) {
        this.trackingVariables.remove(fakedTrackingVariable);
    }

    public void checkUnclosedCloseables(FlowInfo flowInfo, FlowContext flowContext, ASTNode aSTNode, BlockScope blockScope) {
        if (!this.compilerOptions().analyseResourceLeaks) {
            return;
        }
        if (this.trackingVariables == null) {
            if (aSTNode != null && this.parent instanceof BlockScope) {
                ((BlockScope)this.parent).checkUnclosedCloseables(flowInfo, flowContext, aSTNode, blockScope);
            }
            return;
        }
        if (aSTNode != null && flowInfo.reachMode() != 0) {
            return;
        }
        FakedTrackingVariable fakedTrackingVariable = aSTNode instanceof ReturnStatement ? FakedTrackingVariable.getCloseTrackingVariable(((ReturnStatement)aSTNode).expression, flowInfo, flowContext) : null;
        FakedTrackingVariable.IteratorForReporting iteratorForReporting = new FakedTrackingVariable.IteratorForReporting(this.trackingVariables, this, aSTNode != null);
        while (iteratorForReporting.hasNext()) {
            FakedTrackingVariable fakedTrackingVariable2 = (FakedTrackingVariable)iteratorForReporting.next();
            if (fakedTrackingVariable != null && fakedTrackingVariable2.isResourceBeingReturned(fakedTrackingVariable) || aSTNode != null && fakedTrackingVariable2.hasDefinitelyNoResource(flowInfo) || aSTNode != null && flowContext != null && flowContext.recordExitAgainstResource(this, flowInfo, fakedTrackingVariable2, aSTNode)) continue;
            int n = fakedTrackingVariable2.findMostSpecificStatus(flowInfo, this, blockScope);
            if (n == 2) {
                this.reportResourceLeak(fakedTrackingVariable2, aSTNode, n);
                continue;
            }
            if (aSTNode == null && fakedTrackingVariable2.reportRecordedErrors(this, n, flowInfo.reachMode() != 0)) continue;
            if (n == 16) {
                this.reportResourceLeak(fakedTrackingVariable2, aSTNode, n);
                continue;
            }
            if (n != 4 || this.environment().globalOptions.complianceLevel < 0x330000L) continue;
            fakedTrackingVariable2.reportExplicitClosing(this.problemReporter());
        }
        if (aSTNode == null) {
            int n = 0;
            while (n < this.localIndex) {
                this.locals[n].closeTracker = null;
                ++n;
            }
            this.trackingVariables = null;
        }
    }

    private void reportResourceLeak(FakedTrackingVariable fakedTrackingVariable, ASTNode aSTNode, int n) {
        if (aSTNode != null) {
            fakedTrackingVariable.recordErrorLocation(aSTNode, n);
        } else {
            fakedTrackingVariable.reportError(this.problemReporter(), null, n);
        }
    }

    public void correlateTrackingVarsIfElse(FlowInfo flowInfo, FlowInfo flowInfo2) {
        block6: {
            if (this.trackingVariables == null) break block6;
            int n = this.trackingVariables.size();
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    FakedTrackingVariable fakedTrackingVariable;
                    block9: {
                        block8: {
                            fakedTrackingVariable = (FakedTrackingVariable)this.trackingVariables.get(n2);
                            if (fakedTrackingVariable.originalBinding == null) break block7;
                            if (!flowInfo.isDefinitelyNonNull(fakedTrackingVariable.binding) || !flowInfo2.isDefinitelyNull(fakedTrackingVariable.originalBinding)) break block8;
                            flowInfo2.markAsDefinitelyNonNull(fakedTrackingVariable.binding);
                            break block7;
                        }
                        if (!flowInfo2.isDefinitelyNonNull(fakedTrackingVariable.binding) || !flowInfo.isDefinitelyNull(fakedTrackingVariable.originalBinding)) break block9;
                        flowInfo.markAsDefinitelyNonNull(fakedTrackingVariable.binding);
                        break block7;
                    }
                    if (flowInfo == FlowInfo.DEAD_END || flowInfo2 == FlowInfo.DEAD_END) break block7;
                    int n3 = n2 + 1;
                    while (n3 < n) {
                        block10: {
                            int n4;
                            FakedTrackingVariable fakedTrackingVariable2;
                            block12: {
                                boolean bl;
                                boolean bl2;
                                boolean bl3;
                                boolean bl4;
                                block11: {
                                    fakedTrackingVariable2 = (FakedTrackingVariable)this.trackingVariables.get(n3);
                                    if (fakedTrackingVariable.originalBinding != fakedTrackingVariable2.originalBinding) break block10;
                                    bl4 = flowInfo.hasNullInfoFor(fakedTrackingVariable.binding);
                                    bl3 = flowInfo2.hasNullInfoFor(fakedTrackingVariable.binding);
                                    bl2 = flowInfo.hasNullInfoFor(fakedTrackingVariable2.binding);
                                    bl = flowInfo2.hasNullInfoFor(fakedTrackingVariable2.binding);
                                    if (bl4 || !bl3 || !bl2 || bl) break block11;
                                    n4 = FlowInfo.mergeNullStatus(flowInfo.nullStatus(fakedTrackingVariable2.binding), flowInfo2.nullStatus(fakedTrackingVariable.binding));
                                    break block12;
                                }
                                if (!bl4 || bl3 || bl2 || !bl) break block10;
                                n4 = FlowInfo.mergeNullStatus(flowInfo.nullStatus(fakedTrackingVariable.binding), flowInfo2.nullStatus(fakedTrackingVariable2.binding));
                            }
                            flowInfo.markNullStatus(fakedTrackingVariable.binding, n4);
                            flowInfo2.markNullStatus(fakedTrackingVariable.binding, n4);
                            fakedTrackingVariable.originalBinding.closeTracker = fakedTrackingVariable;
                            flowInfo.markNullStatus(fakedTrackingVariable2.binding, 4);
                            flowInfo2.markNullStatus(fakedTrackingVariable2.binding, 4);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        if (this.parent instanceof BlockScope) {
            ((BlockScope)this.parent).correlateTrackingVarsIfElse(flowInfo, flowInfo2);
        }
    }

    public void checkAppropriateMethodAgainstSupers(char[] cArray, MethodBinding methodBinding, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        ReferenceBinding[] referenceBindingArray;
        ReferenceBinding referenceBinding = this.enclosingReceiverType();
        MethodBinding methodBinding2 = this.getMethod(referenceBinding.superclass(), cArray, typeBindingArray, invocationSite);
        if (this.checkAppropriate(methodBinding, methodBinding2, invocationSite) && (referenceBindingArray = referenceBinding.superInterfaces()) != null) {
            int n = 0;
            while (n < referenceBindingArray.length) {
                methodBinding2 = this.getMethod(referenceBindingArray[n], cArray, typeBindingArray, invocationSite);
                if (!this.checkAppropriate(methodBinding, methodBinding2, invocationSite)) break;
                ++n;
            }
        }
    }

    private boolean checkAppropriate(MethodBinding methodBinding, MethodBinding methodBinding2, InvocationSite invocationSite) {
        if (methodBinding2 == null || !methodBinding2.isValidBinding() || methodBinding2 == methodBinding) {
            return true;
        }
        if (MethodVerifier.doesMethodOverride(methodBinding2, methodBinding, this.environment())) {
            this.problemReporter().illegalSuperCallBypassingOverride(invocationSite, methodBinding, methodBinding2.declaringClass);
            return false;
        }
        return true;
    }

    public boolean hasDefaultNullnessFor(int n) {
        return this.parent.hasDefaultNullnessFor(n);
    }
}

