/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LabelFlowContext;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LoopingFlowContext
extends SwitchFlowContext {
    public BranchLabel continueLabel;
    public UnconditionalFlowInfo initsOnContinue = FlowInfo.DEAD_END;
    private UnconditionalFlowInfo upstreamNullFlowInfo;
    private LoopingFlowContext[] innerFlowContexts = null;
    private UnconditionalFlowInfo[] innerFlowInfos = null;
    private int innerFlowContextsCount = 0;
    private LabelFlowContext[] breakTargetContexts = null;
    private int breakTargetsCount = 0;
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount = 0;
    LocalVariableBinding[] nullLocals;
    ASTNode[] nullReferences;
    int[] nullCheckTypes;
    UnconditionalFlowInfo[] nullInfos;
    int nullCount;
    private ArrayList escapingExceptionCatchSites = null;
    Scope associatedScope;

    public LoopingFlowContext(FlowContext flowContext, FlowInfo flowInfo, ASTNode aSTNode, BranchLabel branchLabel, BranchLabel branchLabel2, Scope scope, boolean bl) {
        super(flowContext, aSTNode, branchLabel, bl);
        this.tagBits |= 2;
        this.continueLabel = branchLabel2;
        this.associatedScope = scope;
        this.upstreamNullFlowInfo = flowInfo.unconditionalCopy();
    }

    public void complainOnDeferredFinalChecks(BlockScope blockScope, FlowInfo flowInfo) {
        int n = 0;
        while (n < this.assignCount) {
            VariableBinding variableBinding = this.finalVariables[n];
            if (variableBinding != null) {
                boolean bl = false;
                if (variableBinding instanceof FieldBinding) {
                    if (flowInfo.isPotentiallyAssigned((FieldBinding)variableBinding)) {
                        bl = true;
                        blockScope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)variableBinding, this.finalAssignments[n]);
                    }
                } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)variableBinding)) {
                    variableBinding.tagBits &= 0xFFFFFFFFFFFFF7FFL;
                    if (variableBinding.isFinal()) {
                        bl = true;
                        blockScope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)variableBinding, this.finalAssignments[n]);
                    }
                }
                if (bl) {
                    FlowContext flowContext = this.getLocalParent();
                    while (flowContext != null) {
                        flowContext.removeFinalAssignmentIfAny(this.finalAssignments[n]);
                        flowContext = flowContext.getLocalParent();
                    }
                }
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void complainOnDeferredNullChecks(BlockScope var1_1, FlowInfo var2_2) {
        block60: {
            block59: {
                var3_3 = 0;
                while (var3_3 < this.innerFlowContextsCount) {
                    this.upstreamNullFlowInfo.addPotentialNullInfoFrom(this.innerFlowContexts[var3_3].upstreamNullFlowInfo).addPotentialNullInfoFrom(this.innerFlowInfos[var3_3]);
                    ++var3_3;
                }
                this.innerFlowContextsCount = 0;
                var3_4 = this.upstreamNullFlowInfo.copy();
                var4_5 = this.upstreamNullFlowInfo.addPotentialNullInfoFrom(var2_2.unconditionalInitsWithoutSideEffect());
                if ((this.tagBits & 1) == 0) break block59;
                var5_6 = 0;
                while (var5_6 < this.nullCount) {
                    var6_7 = this.nullLocals[var5_6];
                    var7_8 = this.nullReferences[var5_6];
                    var8_9 = this.nullInfos[var5_6] != null ? var4_5.copy().addNullInfoFrom(this.nullInfos[var5_6]) : var4_5;
                    block0 : switch (this.nullCheckTypes[var5_6] & -61441) {
                        case 258: 
                        case 514: {
                            if (var8_9.isDefinitelyNonNull((LocalVariableBinding)var6_7)) {
                                this.nullReferences[var5_6] = null;
                                if ((this.nullCheckTypes[var5_6] & -61441) == 514) {
                                    if ((this.nullCheckTypes[var5_6] & 4096) != 0) break;
                                    var1_1.problemReporter().localVariableRedundantCheckOnNonNull((LocalVariableBinding)var6_7, (ASTNode)var7_8);
                                    break;
                                }
                                var1_1.problemReporter().localVariableNonNullComparedToNull((LocalVariableBinding)var6_7, (ASTNode)var7_8);
                                break;
                            }
                            ** GOTO lbl107
                        }
                        case 256: 
                        case 512: {
                            if (var8_9.isDefinitelyNonNull((LocalVariableBinding)var6_7)) {
                                this.nullReferences[var5_6] = null;
                                if ((this.nullCheckTypes[var5_6] & -61441) == 512) {
                                    if ((this.nullCheckTypes[var5_6] & 4096) != 0) break;
                                    var1_1.problemReporter().localVariableRedundantCheckOnNonNull((LocalVariableBinding)var6_7, (ASTNode)var7_8);
                                    break;
                                }
                                var1_1.problemReporter().localVariableNonNullComparedToNull((LocalVariableBinding)var6_7, (ASTNode)var7_8);
                                break;
                            }
                            if (var8_9.isDefinitelyNull((LocalVariableBinding)var6_7)) {
                                this.nullReferences[var5_6] = null;
                                if ((this.nullCheckTypes[var5_6] & -61441) == 256) {
                                    if ((this.nullCheckTypes[var5_6] & 4096) != 0) break;
                                    var1_1.problemReporter().localVariableRedundantCheckOnNull((LocalVariableBinding)var6_7, (ASTNode)var7_8);
                                    break;
                                }
                                var1_1.problemReporter().localVariableNullComparedToNonNull((LocalVariableBinding)var6_7, (ASTNode)var7_8);
                                break;
                            }
                            ** GOTO lbl107
                        }
                        case 257: 
                        case 513: 
                        case 769: 
                        case 1025: {
                            var9_10 = (Expression)var7_8;
                            if (!var8_9.isDefinitelyNull((LocalVariableBinding)var6_7)) ** GOTO lbl70
                            this.nullReferences[var5_6] = null;
                            switch (this.nullCheckTypes[var5_6] & -61696) {
                                case 256: {
                                    if ((this.nullCheckTypes[var5_6] & 255 & -61441) == 1 && (var9_10.implicitConversion & 1024) != 0) {
                                        var1_1.problemReporter().localVariableNullReference((LocalVariableBinding)var6_7, var9_10);
                                        break block0;
                                    }
                                    if ((this.nullCheckTypes[var5_6] & 4096) != 0) break block0;
                                    var1_1.problemReporter().localVariableRedundantCheckOnNull((LocalVariableBinding)var6_7, var9_10);
                                    break block0;
                                }
                                case 512: {
                                    if ((this.nullCheckTypes[var5_6] & 255 & -61441) == 1 && (var9_10.implicitConversion & 1024) != 0) {
                                        var1_1.problemReporter().localVariableNullReference((LocalVariableBinding)var6_7, var9_10);
                                        break block0;
                                    }
                                    var1_1.problemReporter().localVariableNullComparedToNonNull((LocalVariableBinding)var6_7, var9_10);
                                    break block0;
                                }
                                case 768: {
                                    var1_1.problemReporter().localVariableRedundantNullAssignment((LocalVariableBinding)var6_7, var9_10);
                                    break block0;
                                }
                                case 1024: {
                                    var1_1.problemReporter().localVariableNullInstanceof((LocalVariableBinding)var6_7, var9_10);
                                    break block0;
                                }
                            }
                            ** GOTO lbl107
lbl70:
                            // 1 sources

                            if (!var8_9.isPotentiallyNull((LocalVariableBinding)var6_7)) ** GOTO lbl107
                            switch (this.nullCheckTypes[var5_6] & -61696) {
                                case 256: {
                                    this.nullReferences[var5_6] = null;
                                    if ((this.nullCheckTypes[var5_6] & 255 & -61441) == 1 && (var9_10.implicitConversion & 1024) != 0) {
                                        var1_1.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)var6_7, var9_10);
                                        break block0;
                                    }
                                    ** GOTO lbl107
                                }
                                case 512: {
                                    this.nullReferences[var5_6] = null;
                                    if ((this.nullCheckTypes[var5_6] & 255 & -61441) == 1 && (var9_10.implicitConversion & 1024) != 0) {
                                        var1_1.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)var6_7, var9_10);
                                        break block0;
                                    }
                                    ** GOTO lbl107
                                }
                            }
                            ** GOTO lbl107
                        }
                        case 3: {
                            if (var8_9.isDefinitelyNull((LocalVariableBinding)var6_7)) {
                                this.nullReferences[var5_6] = null;
                                var1_1.problemReporter().localVariableNullReference((LocalVariableBinding)var6_7, (ASTNode)var7_8);
                                break;
                            }
                            ** GOTO lbl107
                        }
                        case 128: {
                            var10_11 = var8_9.nullStatus((LocalVariableBinding)var6_7);
                            if (var10_11 == 4) break;
                            this.parent.recordNullityMismatch(var1_1, (Expression)var7_8, this.providedExpectedTypes[var5_6][0], this.providedExpectedTypes[var5_6][1], var8_9, var10_11, null);
                            break;
                        }
                        case 2048: {
                            var11_12 = var6_7.closeTracker;
                            if (var11_12 == null) ** GOTO lbl107
                            if (var11_12.hasDefinitelyNoResource(var8_9) || var11_12.isClosedInFinallyOfEnclosing(var1_1)) break;
                            if (this.parent.recordExitAgainstResource(var1_1, var8_9, (FakedTrackingVariable)var11_12, (ASTNode)var7_8)) {
                                this.nullReferences[var5_6] = null;
                                break;
                            }
                            ** GOTO lbl107
                        }
                        case 16: {
                            this.checkUnboxing(var1_1, (Expression)var7_8, var8_9);
                            break;
                        }
lbl107:
                        // 11 sources

                        default: {
                            if (this.nullCheckTypes[var5_6] == 3 && var3_4.isDefinitelyNonNull((LocalVariableBinding)var6_7)) break;
                            this.parent.recordUsingNullReference(var1_1, (LocalVariableBinding)var6_7, (ASTNode)var7_8, this.nullCheckTypes[var5_6], var8_9);
                        }
                    }
                    ++var5_6;
                }
                break block60;
            }
            var5_6 = 0;
            while (var5_6 < this.nullCount) {
                var6_7 = this.nullReferences[var5_6];
                var7_8 = this.nullLocals[var5_6];
                var8_9 = this.nullInfos[var5_6] != null ? var4_5.copy().addNullInfoFrom(this.nullInfos[var5_6]) : var4_5;
                block19 : switch (this.nullCheckTypes[var5_6] & -61441) {
                    case 256: 
                    case 512: {
                        if (var8_9.isDefinitelyNonNull((LocalVariableBinding)var7_8)) {
                            this.nullReferences[var5_6] = null;
                            if ((this.nullCheckTypes[var5_6] & -61441) == 512) {
                                if ((this.nullCheckTypes[var5_6] & 4096) != 0) break;
                                var1_1.problemReporter().localVariableRedundantCheckOnNonNull((LocalVariableBinding)var7_8, (ASTNode)var6_7);
                                break;
                            }
                            var1_1.problemReporter().localVariableNonNullComparedToNull((LocalVariableBinding)var7_8, (ASTNode)var6_7);
                            break;
                        }
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        var9_10 = (Expression)var6_7;
                        if (var8_9.isDefinitelyNull((LocalVariableBinding)var7_8)) {
                            this.nullReferences[var5_6] = null;
                            switch (this.nullCheckTypes[var5_6] & -61696) {
                                case 256: {
                                    if ((this.nullCheckTypes[var5_6] & 255 & -61441) == 1 && (var9_10.implicitConversion & 1024) != 0) {
                                        var1_1.problemReporter().localVariableNullReference((LocalVariableBinding)var7_8, var9_10);
                                        break block19;
                                    }
                                    if ((this.nullCheckTypes[var5_6] & 4096) != 0) break block19;
                                    var1_1.problemReporter().localVariableRedundantCheckOnNull((LocalVariableBinding)var7_8, var9_10);
                                    break block19;
                                }
                                case 512: {
                                    if ((this.nullCheckTypes[var5_6] & 255 & -61441) == 1 && (var9_10.implicitConversion & 1024) != 0) {
                                        var1_1.problemReporter().localVariableNullReference((LocalVariableBinding)var7_8, var9_10);
                                        break block19;
                                    }
                                    var1_1.problemReporter().localVariableNullComparedToNonNull((LocalVariableBinding)var7_8, var9_10);
                                    break block19;
                                }
                                case 768: {
                                    var1_1.problemReporter().localVariableRedundantNullAssignment((LocalVariableBinding)var7_8, var9_10);
                                    break block19;
                                }
                                case 1024: {
                                    var1_1.problemReporter().localVariableNullInstanceof((LocalVariableBinding)var7_8, var9_10);
                                    break block19;
                                }
                            }
                            break;
                        }
                        if (!var8_9.isPotentiallyNull((LocalVariableBinding)var7_8)) break;
                        switch (this.nullCheckTypes[var5_6] & -61696) {
                            case 256: {
                                this.nullReferences[var5_6] = null;
                                if ((this.nullCheckTypes[var5_6] & 255 & -61441) != 1 || (var9_10.implicitConversion & 1024) == 0) break block19;
                                var1_1.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)var7_8, var9_10);
                                break block19;
                            }
                            case 512: {
                                this.nullReferences[var5_6] = null;
                                if ((this.nullCheckTypes[var5_6] & 255 & -61441) != 1 || (var9_10.implicitConversion & 1024) == 0) break block19;
                                var1_1.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)var7_8, var9_10);
                                break block19;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (var8_9.isDefinitelyNull((LocalVariableBinding)var7_8)) {
                            this.nullReferences[var5_6] = null;
                            var1_1.problemReporter().localVariableNullReference((LocalVariableBinding)var7_8, (ASTNode)var6_7);
                            break;
                        }
                        if (!var8_9.isPotentiallyNull((LocalVariableBinding)var7_8)) break;
                        this.nullReferences[var5_6] = null;
                        var1_1.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)var7_8, (ASTNode)var6_7);
                        break;
                    }
                    case 128: {
                        var10_11 = var8_9.nullStatus((LocalVariableBinding)var7_8);
                        if (var10_11 == 4) break;
                        var11_12 = var1_1.environment().getNonNullAnnotationName();
                        var1_1.problemReporter().nullityMismatch((Expression)var6_7, this.providedExpectedTypes[var5_6][0], this.providedExpectedTypes[var5_6][1], var10_11, (char[][])var11_12);
                        break;
                    }
                    case 2048: {
                        var10_11 = var8_9.nullStatus((LocalVariableBinding)var7_8);
                        if (var10_11 == 4 || (var11_12 = var7_8.closeTracker) == null || var11_12.hasDefinitelyNoResource(var8_9) || var11_12.isClosedInFinallyOfEnclosing(var1_1)) break;
                        var10_11 = var11_12.findMostSpecificStatus(var8_9, var1_1, null);
                        var11_12.recordErrorLocation(this.nullReferences[var5_6], var10_11);
                        var11_12.reportRecordedErrors(var1_1, var10_11, var8_9.reachMode() != 0);
                        this.nullReferences[var5_6] = null;
                        break;
                    }
                    case 16: {
                        this.checkUnboxing(var1_1, (Expression)var6_7, var8_9);
                    }
                }
                ++var5_6;
            }
        }
        this.initsOnBreak.addPotentialNullInfoFrom(var4_5);
        var5_6 = 0;
        while (var5_6 < this.breakTargetsCount) {
            this.breakTargetContexts[var5_6].initsOnBreak.addPotentialNullInfoFrom(var4_5);
            ++var5_6;
        }
    }

    public BranchLabel continueLabel() {
        return this.continueLabel;
    }

    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Looping flow context");
        stringBuffer.append("[initsOnBreak - ").append(this.initsOnBreak.toString()).append(']');
        stringBuffer.append("[initsOnContinue - ").append(this.initsOnContinue.toString()).append(']');
        stringBuffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        stringBuffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return stringBuffer.toString();
    }

    public boolean isContinuable() {
        return true;
    }

    public boolean isContinuedTo() {
        return this.initsOnContinue != FlowInfo.DEAD_END;
    }

    public void recordBreakTo(FlowContext flowContext) {
        if (flowContext instanceof LabelFlowContext) {
            int n;
            if ((n = this.breakTargetsCount++) == 0) {
                this.breakTargetContexts = new LabelFlowContext[2];
            } else if (n == this.breakTargetContexts.length) {
                this.breakTargetContexts = new LabelFlowContext[n + 2];
                System.arraycopy(this.breakTargetContexts, 0, this.breakTargetContexts, 0, n);
            }
            this.breakTargetContexts[n] = (LabelFlowContext)flowContext;
        }
    }

    public void recordContinueFrom(FlowContext flowContext, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.initsOnContinue = (this.initsOnContinue.tagBits & 1) == 0 ? this.initsOnContinue.mergedWith(flowInfo.unconditionalInitsWithoutSideEffect()) : flowInfo.unconditionalCopy();
            FlowContext flowContext2 = flowContext;
            while (flowContext2 != this && !(flowContext2 instanceof LoopingFlowContext)) {
                flowContext2 = flowContext2.parent;
            }
            if (flowContext2 == this) {
                this.upstreamNullFlowInfo.addPotentialNullInfoFrom(flowInfo.unconditionalInitsWithoutSideEffect());
            } else {
                int n = 0;
                if (this.innerFlowContexts == null) {
                    this.innerFlowContexts = new LoopingFlowContext[5];
                    this.innerFlowInfos = new UnconditionalFlowInfo[5];
                } else {
                    n = this.innerFlowContexts.length;
                    if (this.innerFlowContextsCount == n - 1) {
                        this.innerFlowContexts = new LoopingFlowContext[n + 5];
                        System.arraycopy(this.innerFlowContexts, 0, this.innerFlowContexts, 0, n);
                        this.innerFlowInfos = new UnconditionalFlowInfo[n + 5];
                        System.arraycopy(this.innerFlowInfos, 0, this.innerFlowInfos, 0, n);
                    }
                }
                this.innerFlowContexts[this.innerFlowContextsCount] = (LoopingFlowContext)flowContext2;
                this.innerFlowInfos[this.innerFlowContextsCount++] = flowInfo.unconditionalInitsWithoutSideEffect();
            }
        }
    }

    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        if (variableBinding instanceof LocalVariableBinding) {
            Scope scope = ((LocalVariableBinding)variableBinding).declaringScope;
            while ((scope = scope.parent) != null) {
                if (scope != this.associatedScope) continue;
                return false;
            }
        }
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = reference;
        this.finalVariables[this.assignCount++] = variableBinding;
        return true;
    }

    protected void recordNullReference(LocalVariableBinding localVariableBinding, ASTNode aSTNode, int n, FlowInfo flowInfo) {
        if (this.nullCount == 0) {
            this.nullLocals = new LocalVariableBinding[5];
            this.nullReferences = new ASTNode[5];
            this.nullCheckTypes = new int[5];
            this.nullInfos = new UnconditionalFlowInfo[5];
        } else if (this.nullCount == this.nullLocals.length) {
            this.nullLocals = new LocalVariableBinding[this.nullCount * 2];
            System.arraycopy(this.nullLocals, 0, this.nullLocals, 0, this.nullCount);
            this.nullReferences = new ASTNode[this.nullCount * 2];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullCheckTypes = new int[this.nullCount * 2];
            System.arraycopy(this.nullCheckTypes, 0, this.nullCheckTypes, 0, this.nullCount);
            this.nullInfos = new UnconditionalFlowInfo[this.nullCount * 2];
            System.arraycopy(this.nullInfos, 0, this.nullInfos, 0, this.nullCount);
        }
        this.nullLocals[this.nullCount] = localVariableBinding;
        this.nullReferences[this.nullCount] = aSTNode;
        this.nullCheckTypes[this.nullCount] = n;
        this.nullInfos[this.nullCount++] = flowInfo != null ? flowInfo.unconditionalCopy() : null;
    }

    public void recordUnboxing(Scope scope, Expression expression, int n, FlowInfo flowInfo) {
        if (n == 2) {
            super.recordUnboxing(scope, expression, n, flowInfo);
        } else {
            this.recordNullReference(null, expression, 16, flowInfo);
        }
    }

    public boolean recordExitAgainstResource(BlockScope blockScope, FlowInfo flowInfo, FakedTrackingVariable fakedTrackingVariable, ASTNode aSTNode) {
        LocalVariableBinding localVariableBinding = fakedTrackingVariable.binding;
        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
            return false;
        }
        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
            blockScope.problemReporter().unclosedCloseable(fakedTrackingVariable, aSTNode);
            return true;
        }
        if (flowInfo.isPotentiallyNull(localVariableBinding)) {
            blockScope.problemReporter().potentiallyUnclosedCloseable(fakedTrackingVariable, aSTNode);
            return true;
        }
        this.recordNullReference(fakedTrackingVariable.binding, aSTNode, 2048, flowInfo);
        return true;
    }

    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, ASTNode aSTNode, int n, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 3) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) {
            return;
        }
        int n2 = (n |= this.tagBits & 0x1000) & 0xFFFF0FFF;
        switch (n2) {
            case 256: 
            case 512: {
                Expression expression = (Expression)aSTNode;
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    if (n2 == 512) {
                        if ((this.tagBits & 0x1000) == 0) {
                            scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, expression);
                        }
                        flowInfo.initsWhenFalse().setReachMode(2);
                    } else {
                        scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, expression);
                        flowInfo.initsWhenTrue().setReachMode(2);
                    }
                } else if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    if (n2 == 256) {
                        if ((this.tagBits & 0x1000) == 0) {
                            scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                        }
                        flowInfo.initsWhenFalse().setReachMode(2);
                    } else {
                        scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                        flowInfo.initsWhenTrue().setReachMode(2);
                    }
                } else if (this.upstreamNullFlowInfo.isDefinitelyNonNull(localVariableBinding) && !flowInfo.isPotentiallyNull(localVariableBinding) && !flowInfo.isPotentiallyUnknown(localVariableBinding)) {
                    this.recordNullReference(localVariableBinding, expression, n, flowInfo);
                    flowInfo.markAsDefinitelyNonNull(localVariableBinding);
                } else {
                    if (flowInfo.cannotBeDefinitelyNullOrNonNull(localVariableBinding)) {
                        return;
                    }
                    if (flowInfo.isPotentiallyNonNull(localVariableBinding)) {
                        this.recordNullReference(localVariableBinding, expression, 2 | n & 0xFFFFFF00, flowInfo);
                    } else if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                        this.recordNullReference(localVariableBinding, expression, 1 | n & 0xFFFFFF00, flowInfo);
                    } else {
                        this.recordNullReference(localVariableBinding, expression, n, flowInfo);
                    }
                }
                return;
            }
            case 257: 
            case 513: 
            case 769: 
            case 1025: {
                Expression expression = (Expression)aSTNode;
                if (flowInfo.isPotentiallyNonNull(localVariableBinding) || flowInfo.isPotentiallyUnknown(localVariableBinding) || flowInfo.isProtectedNonNull(localVariableBinding)) {
                    return;
                }
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    switch (n2 & 0xFFFF0F00) {
                        case 256: {
                            if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                return;
                            }
                            if ((this.tagBits & 0x1000) == 0) {
                                scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                            }
                            flowInfo.initsWhenFalse().setReachMode(2);
                            return;
                        }
                        case 512: {
                            if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                return;
                            }
                            scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                            flowInfo.initsWhenTrue().setReachMode(2);
                            return;
                        }
                        case 768: {
                            scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                            return;
                        }
                        case 1024: {
                            scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                            return;
                        }
                    }
                } else if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                    switch (n2 & 0xFFFF0F00) {
                        case 256: {
                            if ((n2 & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                            return;
                        }
                        case 512: {
                            if ((n2 & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                            return;
                        }
                    }
                }
                this.recordNullReference(localVariableBinding, expression, n, flowInfo);
                return;
            }
            case 3: {
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    return;
                }
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableNullReference(localVariableBinding, aSTNode);
                    return;
                }
                if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                    scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, aSTNode);
                    return;
                }
                this.recordNullReference(localVariableBinding, aSTNode, n, flowInfo);
                return;
            }
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
        int n = 0;
        while (n < this.assignCount) {
            if (this.finalAssignments[n] == reference) {
                this.finalAssignments[n] = null;
                this.finalVariables[n] = null;
                return;
            }
            ++n;
        }
    }

    public void simulateThrowAfterLoopBack(FlowInfo flowInfo) {
        if (this.escapingExceptionCatchSites != null) {
            int n = 0;
            int n2 = this.escapingExceptionCatchSites.size();
            while (n < n2) {
                ((EscapingExceptionCatchSite)this.escapingExceptionCatchSites.get(n)).simulateThrowAfterLoopBack(flowInfo);
                ++n;
            }
            this.escapingExceptionCatchSites = null;
        }
    }

    public void recordCatchContextOfEscapingException(ExceptionHandlingFlowContext exceptionHandlingFlowContext, ReferenceBinding referenceBinding, FlowInfo flowInfo) {
        if (this.escapingExceptionCatchSites == null) {
            this.escapingExceptionCatchSites = new ArrayList(5);
        }
        this.escapingExceptionCatchSites.add(new EscapingExceptionCatchSite(exceptionHandlingFlowContext, referenceBinding, flowInfo));
    }

    public boolean hasEscapingExceptions() {
        return this.escapingExceptionCatchSites != null;
    }

    protected boolean internalRecordNullityMismatch(Expression expression, TypeBinding typeBinding, FlowInfo flowInfo, int n, TypeBinding typeBinding2, int n2) {
        this.recordProvidedExpectedTypes(typeBinding, typeBinding2, this.nullCount);
        this.recordNullReference(expression.localVariableBinding(), expression, n2, flowInfo);
        return true;
    }

    private static class EscapingExceptionCatchSite {
        final ReferenceBinding caughtException;
        final ExceptionHandlingFlowContext catchingContext;
        final FlowInfo exceptionInfo;

        public EscapingExceptionCatchSite(ExceptionHandlingFlowContext exceptionHandlingFlowContext, ReferenceBinding referenceBinding, FlowInfo flowInfo) {
            this.catchingContext = exceptionHandlingFlowContext;
            this.caughtException = referenceBinding;
            this.exceptionInfo = flowInfo;
        }

        void simulateThrowAfterLoopBack(FlowInfo flowInfo) {
            this.catchingContext.recordHandlingException(this.caughtException, flowInfo.unconditionalCopy().addNullInfoFrom(this.exceptionInfo).unconditionalInits(), null, null, null, true);
        }
    }
}

