/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import org.eclipse.jdt.core.compiler.CharOperation;

public class CharArrayCache {
    public char[][] keyTable;
    public int[] valueTable;
    int elementSize = 0;
    int threshold;

    public CharArrayCache() {
        this(9);
    }

    public CharArrayCache(int n) {
        this.threshold = n * 2 / 3;
        this.keyTable = new char[n][];
        this.valueTable = new int[n];
    }

    public void clear() {
        int n = this.keyTable.length;
        while (--n >= 0) {
            this.keyTable[n] = null;
            this.valueTable[n] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(char[] cArray) {
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        while (this.keyTable[n2] != null) {
            if (CharOperation.equals(this.keyTable[n2], cArray)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public int get(char[] cArray) {
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        while (this.keyTable[n2] != null) {
            if (CharOperation.equals(this.keyTable[n2], cArray)) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return -1;
    }

    public int putIfAbsent(char[] cArray, int n) {
        int n2 = this.keyTable.length;
        int n3 = CharOperation.hashCode(cArray) % n2;
        while (this.keyTable[n3] != null) {
            if (CharOperation.equals(this.keyTable[n3], cArray)) {
                return this.valueTable[n3];
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        this.keyTable[n3] = cArray;
        this.valueTable[n3] = n;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return -n;
    }

    private int put(char[] cArray, int n) {
        int n2 = this.keyTable.length;
        int n3 = CharOperation.hashCode(cArray) % n2;
        while (this.keyTable[n3] != null) {
            if (CharOperation.equals(this.keyTable[n3], cArray)) {
                this.valueTable[n3] = n;
                return this.valueTable[n3];
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        this.keyTable[n3] = cArray;
        this.valueTable[n3] = n;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return n;
    }

    private void rehash() {
        CharArrayCache charArrayCache = new CharArrayCache(this.keyTable.length * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            if (this.keyTable[n] == null) continue;
            charArrayCache.put(this.keyTable[n], this.valueTable[n]);
        }
        this.keyTable = charArrayCache.keyTable;
        this.valueTable = charArrayCache.valueTable;
        this.threshold = charArrayCache.threshold;
    }

    public void remove(char[] cArray) {
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        while (this.keyTable[n2] != null) {
            if (CharOperation.equals(this.keyTable[n2], cArray)) {
                this.valueTable[n2] = 0;
                this.keyTable[n2] = null;
                return;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
    }

    public char[] returnKeyFor(int n) {
        int n2 = this.keyTable.length;
        while (n2-- > 0) {
            if (this.valueTable[n2] != n) continue;
            return this.keyTable[n2];
        }
        return null;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 < n) {
            if (this.keyTable[n2] != null) {
                stringBuffer.append(this.keyTable[n2]).append("->").append(this.valueTable[n2]);
            }
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

