/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.AnnotationMethodInfo;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationProvider;
import org.eclipse.jdt.internal.compiler.classfmt.FieldInfo;
import org.eclipse.jdt.internal.compiler.classfmt.InnerClassInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.classfmt.TypeAnnotationInfo;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.env.ITypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClassFileReader
extends ClassFileStruct
implements IBinaryType {
    private int accessFlags;
    private char[] classFileName;
    private char[] className;
    private int classNameIndex;
    private int constantPoolCount;
    private AnnotationInfo[] annotations;
    private TypeAnnotationInfo[] typeAnnotations;
    private FieldInfo[] fields;
    private int fieldsCount;
    private InnerClassInfo innerInfo;
    private int innerInfoIndex;
    private InnerClassInfo[] innerInfos;
    private char[][] interfaceNames;
    private int interfacesCount;
    private MethodInfo[] methods;
    private int methodsCount;
    private char[] signature;
    private char[] sourceName;
    private char[] sourceFileName;
    private char[] superclassName;
    private long tagBits;
    private long version;
    private char[] enclosingTypeName;
    private char[][][] missingTypeNames;
    private int enclosingNameAndTypeIndex;
    private char[] enclosingMethod;
    private ExternalAnnotationProvider annotationProvider;

    private static String printTypeModifiers(int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        if ((n & 1) != 0) {
            printWriter.print("public ");
        }
        if ((n & 2) != 0) {
            printWriter.print("private ");
        }
        if ((n & 0x10) != 0) {
            printWriter.print("final ");
        }
        if ((n & 0x20) != 0) {
            printWriter.print("super ");
        }
        if ((n & 0x200) != 0) {
            printWriter.print("interface ");
        }
        if ((n & 0x400) != 0) {
            printWriter.print("abstract ");
        }
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }

    public static ClassFileReader read(File file) throws ClassFormatException, IOException {
        return ClassFileReader.read(file, false);
    }

    public static ClassFileReader read(File file, boolean bl) throws ClassFormatException, IOException {
        byte[] byArray = Util.getFileByteContent(file);
        ClassFileReader classFileReader = new ClassFileReader(byArray, file.getAbsolutePath().toCharArray());
        if (bl) {
            classFileReader.initialize();
        }
        return classFileReader;
    }

    public static ClassFileReader read(InputStream inputStream, String string) throws ClassFormatException, IOException {
        return ClassFileReader.read(inputStream, string, false);
    }

    public static ClassFileReader read(InputStream inputStream, String string, boolean bl) throws ClassFormatException, IOException {
        byte[] byArray = Util.getInputStreamAsByteArray(inputStream, -1);
        ClassFileReader classFileReader = new ClassFileReader(byArray, string.toCharArray());
        if (bl) {
            classFileReader.initialize();
        }
        return classFileReader;
    }

    public static ClassFileReader read(ZipFile zipFile, String string) throws ClassFormatException, IOException {
        return ClassFileReader.read(zipFile, string, false);
    }

    public static ClassFileReader read(ZipFile zipFile, String string, boolean bl) throws ClassFormatException, IOException {
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        byte[] byArray = Util.getZipEntryByteContent(zipEntry, zipFile);
        ClassFileReader classFileReader = new ClassFileReader(byArray, string.toCharArray());
        if (bl) {
            classFileReader.initialize();
        }
        return classFileReader;
    }

    public static ClassFileReader read(String string) throws ClassFormatException, IOException {
        return ClassFileReader.read(string, false);
    }

    public static ClassFileReader read(String string, boolean bl) throws ClassFormatException, IOException {
        return ClassFileReader.read(new File(string), bl);
    }

    public ClassFileReader(byte[] byArray, char[] cArray) throws ClassFormatException {
        this(byArray, cArray, false);
    }

    public ClassFileReader(byte[] byArray, char[] cArray, boolean bl) throws ClassFormatException {
        super(byArray, null, 0);
        this.classFileName = cArray;
        int n = 10;
        try {
            int n2;
            int n3;
            this.version = ((long)this.u2At(6) << 16) + (long)this.u2At(4);
            this.constantPoolCount = this.u2At(8);
            this.constantPoolOffsets = new int[this.constantPoolCount];
            int n4 = 1;
            while (n4 < this.constantPoolCount) {
                n3 = this.u1At(n);
                switch (n3) {
                    case 1: {
                        this.constantPoolOffsets[n4] = n;
                        n += this.u2At(n + 1);
                        n += 3;
                        break;
                    }
                    case 3: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        break;
                    }
                    case 4: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        break;
                    }
                    case 5: {
                        this.constantPoolOffsets[n4] = n;
                        n += 9;
                        ++n4;
                        break;
                    }
                    case 6: {
                        this.constantPoolOffsets[n4] = n;
                        n += 9;
                        ++n4;
                        break;
                    }
                    case 7: {
                        this.constantPoolOffsets[n4] = n;
                        n += 3;
                        break;
                    }
                    case 8: {
                        this.constantPoolOffsets[n4] = n;
                        n += 3;
                        break;
                    }
                    case 9: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        break;
                    }
                    case 10: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        break;
                    }
                    case 11: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        break;
                    }
                    case 12: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                        break;
                    }
                    case 15: {
                        this.constantPoolOffsets[n4] = n;
                        n += 4;
                        break;
                    }
                    case 16: {
                        this.constantPoolOffsets[n4] = n;
                        n += 3;
                        break;
                    }
                    case 18: {
                        this.constantPoolOffsets[n4] = n;
                        n += 5;
                    }
                }
                ++n4;
            }
            this.accessFlags = this.u2At(n);
            this.classNameIndex = this.u2At(n += 2);
            this.className = this.getConstantClassNameAt(this.classNameIndex);
            n4 = this.u2At(n += 2);
            n += 2;
            if (n4 != 0) {
                this.superclassName = this.getConstantClassNameAt(n4);
            }
            this.interfacesCount = this.u2At(n);
            n += 2;
            if (this.interfacesCount != 0) {
                this.interfaceNames = new char[this.interfacesCount][];
                n3 = 0;
                while (n3 < this.interfacesCount) {
                    this.interfaceNames[n3] = this.getConstantClassNameAt(this.u2At(n));
                    n += 2;
                    ++n3;
                }
            }
            this.fieldsCount = this.u2At(n);
            n += 2;
            if (this.fieldsCount != 0) {
                this.fields = new FieldInfo[this.fieldsCount];
                n2 = 0;
                while (n2 < this.fieldsCount) {
                    FieldInfo fieldInfo;
                    this.fields[n2] = fieldInfo = FieldInfo.createField(this.reference, this.constantPoolOffsets, n);
                    n += fieldInfo.sizeInBytes();
                    ++n2;
                }
            }
            this.methodsCount = this.u2At(n);
            n += 2;
            if (this.methodsCount != 0) {
                this.methods = new MethodInfo[this.methodsCount];
                boolean bl2 = (this.accessFlags & 0x2000) != 0;
                n2 = 0;
                while (n2 < this.methodsCount) {
                    this.methods[n2] = bl2 ? AnnotationMethodInfo.createAnnotationMethod(this.reference, this.constantPoolOffsets, n) : MethodInfo.createMethod(this.reference, this.constantPoolOffsets, n);
                    n += this.methods[n2].sizeInBytes();
                    ++n2;
                }
            }
            int n5 = this.u2At(n);
            n += 2;
            n2 = 0;
            while (n2 < n5) {
                int n6 = this.constantPoolOffsets[this.u2At(n)];
                char[] cArray2 = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                if (cArray2.length == 0) {
                    n = (int)((long)n + (6L + this.u4At(n + 2)));
                } else {
                    switch (cArray2[0]) {
                        case 'E': {
                            if (!CharOperation.equals(cArray2, AttributeNamesConstants.EnclosingMethodName)) break;
                            n6 = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[this.u2At(n + 6)] + 1)];
                            this.enclosingTypeName = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                            this.enclosingNameAndTypeIndex = this.u2At(n + 8);
                            break;
                        }
                        case 'D': {
                            if (!CharOperation.equals(cArray2, AttributeNamesConstants.DeprecatedName)) break;
                            this.accessFlags |= 0x100000;
                            break;
                        }
                        case 'I': {
                            int n7;
                            int n8;
                            if (CharOperation.equals(cArray2, AttributeNamesConstants.InnerClassName)) {
                                char[] cArray3;
                                n8 = n + 6;
                                n7 = this.u2At(n8);
                                if (n7 == 0) break;
                                n8 += 2;
                                this.innerInfos = new InnerClassInfo[n7];
                                int n9 = 0;
                                while (n9 < n7) {
                                    this.innerInfos[n9] = new InnerClassInfo(this.reference, this.constantPoolOffsets, n8);
                                    if (this.classNameIndex == this.innerInfos[n9].innerClassNameIndex) {
                                        this.innerInfo = this.innerInfos[n9];
                                        this.innerInfoIndex = n9;
                                    }
                                    n8 += 8;
                                    ++n9;
                                }
                                if (this.innerInfo == null || (cArray3 = this.innerInfo.getEnclosingTypeName()) == null) break;
                                this.enclosingTypeName = cArray3;
                                break;
                            }
                            if (!CharOperation.equals(cArray2, AttributeNamesConstants.InconsistentHierarchy)) break;
                            this.tagBits |= 0x20000L;
                            break;
                        }
                        case 'S': {
                            if (cArray2.length <= 2) break;
                            switch (cArray2[1]) {
                                case 'o': {
                                    if (!CharOperation.equals(cArray2, AttributeNamesConstants.SourceName)) break;
                                    n6 = this.constantPoolOffsets[this.u2At(n + 6)];
                                    this.sourceFileName = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                                    break;
                                }
                                case 'y': {
                                    if (!CharOperation.equals(cArray2, AttributeNamesConstants.SyntheticName)) break;
                                    this.accessFlags |= 0x1000;
                                    break;
                                }
                                case 'i': {
                                    if (!CharOperation.equals(cArray2, AttributeNamesConstants.SignatureName)) break;
                                    n6 = this.constantPoolOffsets[this.u2At(n + 6)];
                                    this.signature = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                                }
                            }
                            break;
                        }
                        case 'R': {
                            if (CharOperation.equals(cArray2, AttributeNamesConstants.RuntimeVisibleAnnotationsName)) {
                                this.decodeAnnotations(n, true);
                                break;
                            }
                            if (CharOperation.equals(cArray2, AttributeNamesConstants.RuntimeInvisibleAnnotationsName)) {
                                this.decodeAnnotations(n, false);
                                break;
                            }
                            if (CharOperation.equals(cArray2, AttributeNamesConstants.RuntimeVisibleTypeAnnotationsName)) {
                                this.decodeTypeAnnotations(n, true);
                                break;
                            }
                            if (!CharOperation.equals(cArray2, AttributeNamesConstants.RuntimeInvisibleTypeAnnotationsName)) break;
                            this.decodeTypeAnnotations(n, false);
                            break;
                        }
                        case 'M': {
                            int n7;
                            int n8;
                            if (!CharOperation.equals(cArray2, AttributeNamesConstants.MissingTypesName) || (n7 = this.u2At(n8 = n + 6)) == 0) break;
                            this.missingTypeNames = new char[n7][][];
                            n8 += 2;
                            int n10 = 0;
                            while (n10 < n7) {
                                n6 = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[this.u2At(n8)] + 1)];
                                char[] cArray4 = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                                this.missingTypeNames[n10] = CharOperation.splitOn('/', cArray4);
                                n8 += 2;
                                ++n10;
                            }
                            break;
                        }
                    }
                    n = (int)((long)n + (6L + this.u4At(n + 2)));
                }
                ++n2;
            }
            if (bl) {
                this.initialize();
            }
        }
        catch (ClassFormatException classFormatException) {
            throw classFormatException;
        }
        catch (Exception exception) {
            throw new ClassFormatException(21, n);
        }
    }

    public ZipFile setExternalAnnotationProvider(String string, String string2, ZipFile zipFile, ZipFileProducer zipFileProducer) throws IOException {
        Object object;
        String string3 = String.valueOf(string2) + ".eea";
        if (zipFile == null) {
            object = new File(string);
            if (((File)object).isDirectory()) {
                try {
                    String string4 = String.valueOf(((File)object).getAbsolutePath()) + '/' + string3;
                    this.annotationProvider = new ExternalAnnotationProvider(new FileInputStream(string4), String.valueOf(this.getName()));
                }
                catch (FileNotFoundException fileNotFoundException) {}
                return null;
            }
            if (!((File)object).exists()) {
                return null;
            }
            ZipFile zipFile2 = zipFile = zipFileProducer != null ? zipFileProducer.produce() : new ZipFile((File)object);
        }
        if ((object = zipFile.getEntry(string3)) != null) {
            this.annotationProvider = new ExternalAnnotationProvider(zipFile.getInputStream((ZipEntry)object), String.valueOf(this.getName()));
        }
        return zipFile;
    }

    public boolean hasAnnotationProvider() {
        return this.annotationProvider != null;
    }

    public ITypeAnnotationWalker enrichWithExternalAnnotationsFor(ITypeAnnotationWalker iTypeAnnotationWalker, Object object, LookupEnvironment lookupEnvironment) {
        if (iTypeAnnotationWalker == ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER && this.annotationProvider != null) {
            if (object == null) {
                return this.annotationProvider.forTypeHeader(lookupEnvironment);
            }
            if (object instanceof IBinaryField) {
                IBinaryField iBinaryField = (IBinaryField)object;
                char[] cArray = iBinaryField.getGenericSignature();
                if (cArray == null) {
                    cArray = iBinaryField.getTypeName();
                }
                return this.annotationProvider.forField(iBinaryField.getName(), cArray, lookupEnvironment);
            }
            if (object instanceof IBinaryMethod) {
                IBinaryMethod iBinaryMethod = (IBinaryMethod)object;
                char[] cArray = iBinaryMethod.getGenericSignature();
                if (cArray == null) {
                    cArray = iBinaryMethod.getMethodDescriptor();
                }
                return this.annotationProvider.forMethod(iBinaryMethod.isConstructor() ? TypeConstants.INIT : iBinaryMethod.getSelector(), cArray, lookupEnvironment);
            }
        }
        return iTypeAnnotationWalker;
    }

    public int accessFlags() {
        return this.accessFlags;
    }

    private void decodeAnnotations(int n, boolean bl) {
        int n2 = this.u2At(n + 6);
        if (n2 > 0) {
            AnnotationInfo[] annotationInfoArray;
            int n3 = n + 8;
            AnnotationInfo[] annotationInfoArray2 = null;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                annotationInfoArray = new AnnotationInfo(this.reference, this.constantPoolOffsets, n3, bl, false);
                n3 += annotationInfoArray.readOffset;
                long l = annotationInfoArray.standardAnnotationTagBits;
                if (l != 0L) {
                    this.tagBits |= l;
                } else {
                    if (annotationInfoArray2 == null) {
                        annotationInfoArray2 = new AnnotationInfo[n2 - n5];
                    }
                    annotationInfoArray2[n4++] = annotationInfoArray;
                }
                ++n5;
            }
            if (annotationInfoArray2 == null) {
                return;
            }
            if (this.annotations == null) {
                if (n4 != annotationInfoArray2.length) {
                    AnnotationInfo[] annotationInfoArray3 = annotationInfoArray2;
                    annotationInfoArray2 = new AnnotationInfo[n4];
                    System.arraycopy(annotationInfoArray3, 0, annotationInfoArray2, 0, n4);
                }
                this.annotations = annotationInfoArray2;
            } else {
                n5 = this.annotations.length;
                annotationInfoArray = new AnnotationInfo[n5 + n4];
                System.arraycopy(this.annotations, 0, annotationInfoArray, 0, n5);
                System.arraycopy(annotationInfoArray2, 0, annotationInfoArray, n5, n4);
                this.annotations = annotationInfoArray;
            }
        }
    }

    private void decodeTypeAnnotations(int n, boolean bl) {
        int n2 = this.u2At(n + 6);
        if (n2 > 0) {
            TypeAnnotationInfo[] typeAnnotationInfoArray;
            int n3 = n + 8;
            TypeAnnotationInfo[] typeAnnotationInfoArray2 = null;
            typeAnnotationInfoArray2 = new TypeAnnotationInfo[n2];
            int n4 = 0;
            while (n4 < n2) {
                typeAnnotationInfoArray = new TypeAnnotationInfo(this.reference, this.constantPoolOffsets, n3, bl, false);
                n3 += typeAnnotationInfoArray.readOffset;
                typeAnnotationInfoArray2[n4] = typeAnnotationInfoArray;
                ++n4;
            }
            if (this.typeAnnotations == null) {
                this.typeAnnotations = typeAnnotationInfoArray2;
            } else {
                n4 = this.typeAnnotations.length;
                typeAnnotationInfoArray = new TypeAnnotationInfo[n4 + n2];
                System.arraycopy(this.typeAnnotations, 0, typeAnnotationInfoArray, 0, n4);
                System.arraycopy(typeAnnotationInfoArray2, 0, typeAnnotationInfoArray, n4, n2);
                this.typeAnnotations = typeAnnotationInfoArray;
            }
        }
    }

    public IBinaryAnnotation[] getAnnotations() {
        return this.annotations;
    }

    public IBinaryTypeAnnotation[] getTypeAnnotations() {
        return this.typeAnnotations;
    }

    private char[] getConstantClassNameAt(int n) {
        int n2 = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[n] + 1)];
        return this.utf8At(n2 + 3, this.u2At(n2 + 1));
    }

    public int[] getConstantPoolOffsets() {
        return this.constantPoolOffsets;
    }

    public char[] getEnclosingMethod() {
        if (this.enclosingNameAndTypeIndex <= 0) {
            return null;
        }
        if (this.enclosingMethod == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.constantPoolOffsets[this.enclosingNameAndTypeIndex];
            int n2 = this.constantPoolOffsets[this.u2At(n + 1)];
            stringBuffer.append(this.utf8At(n2 + 3, this.u2At(n2 + 1)));
            n2 = this.constantPoolOffsets[this.u2At(n + 3)];
            stringBuffer.append(this.utf8At(n2 + 3, this.u2At(n2 + 1)));
            this.enclosingMethod = String.valueOf(stringBuffer).toCharArray();
        }
        return this.enclosingMethod;
    }

    public char[] getEnclosingTypeName() {
        return this.enclosingTypeName;
    }

    public IBinaryField[] getFields() {
        return this.fields;
    }

    public char[] getFileName() {
        return this.classFileName;
    }

    public char[] getGenericSignature() {
        return this.signature;
    }

    public char[] getInnerSourceName() {
        if (this.innerInfo != null) {
            return this.innerInfo.getSourceName();
        }
        return null;
    }

    public char[][] getInterfaceNames() {
        return this.interfaceNames;
    }

    public IBinaryNestedType[] getMemberTypes() {
        int n;
        if (this.innerInfos == null) {
            return null;
        }
        int n2 = this.innerInfos.length;
        int n3 = n = this.innerInfo != null ? this.innerInfoIndex + 1 : 0;
        if (n2 != n) {
            IBinaryNestedType[] iBinaryNestedTypeArray = new IBinaryNestedType[n2 - this.innerInfoIndex];
            int n4 = 0;
            int n5 = n;
            while (n5 < n2) {
                InnerClassInfo innerClassInfo = this.innerInfos[n5];
                int n6 = innerClassInfo.outerClassNameIndex;
                int n7 = innerClassInfo.innerNameIndex;
                if (n6 != 0 && n7 != 0 && n6 == this.classNameIndex && innerClassInfo.getSourceName().length != 0) {
                    iBinaryNestedTypeArray[n4++] = innerClassInfo;
                }
                ++n5;
            }
            if (n4 == 0) {
                return null;
            }
            if (n4 != iBinaryNestedTypeArray.length) {
                IBinaryNestedType[] iBinaryNestedTypeArray2 = iBinaryNestedTypeArray;
                iBinaryNestedTypeArray = new IBinaryNestedType[n4];
                System.arraycopy(iBinaryNestedTypeArray2, 0, iBinaryNestedTypeArray, 0, n4);
            }
            return iBinaryNestedTypeArray;
        }
        return null;
    }

    public IBinaryMethod[] getMethods() {
        return this.methods;
    }

    public char[][][] getMissingTypeNames() {
        return this.missingTypeNames;
    }

    public int getModifiers() {
        int n = this.innerInfo != null ? this.innerInfo.getModifiers() | this.accessFlags & 0x100000 | this.accessFlags & 0x1000 : this.accessFlags;
        return n;
    }

    public char[] getName() {
        return this.className;
    }

    public char[] getSourceName() {
        if (this.sourceName != null) {
            return this.sourceName;
        }
        char[] cArray = this.getInnerSourceName();
        if (cArray == null) {
            cArray = this.getName();
            int n = this.isAnonymous() ? CharOperation.indexOf('$', cArray, CharOperation.lastIndexOf('/', cArray) + 1) + 1 : CharOperation.lastIndexOf('/', cArray) + 1;
            if (n > 0) {
                char[] cArray2 = new char[cArray.length - n];
                System.arraycopy(cArray, n, cArray2, 0, cArray2.length);
                cArray = cArray2;
            }
        }
        this.sourceName = cArray;
        return cArray;
    }

    public char[] getSuperclassName() {
        return this.superclassName;
    }

    public long getTagBits() {
        return this.tagBits;
    }

    public long getVersion() {
        return this.version;
    }

    /*
     * Unable to fully structure code
     */
    private boolean hasNonSyntheticFieldChanges(FieldInfo[] var1_1, FieldInfo[] var2_2) {
        var3_3 = var1_1 == null ? 0 : var1_1.length;
        var4_4 = var2_2 == null ? 0 : var2_2.length;
        var5_5 = 0;
        var6_6 = 0;
        ** GOTO lbl13
        block0: while (++var5_5 < var3_3) {
            while (!var1_1[var5_5].isSynthetic()) {
                while (var2_2[var6_6].isSynthetic()) {
                    if (++var6_6 >= var4_4) break block0;
                }
                if (this.hasStructuralFieldChanges(var1_1[var5_5++], var2_2[var6_6++])) {
                    return true;
                }
lbl13:
                // 3 sources

                if (var5_5 < var3_3 && var6_6 < var4_4) continue;
            }
        }
        while (var5_5 < var3_3) {
            if (var1_1[var5_5++].isSynthetic()) continue;
            return true;
        }
        while (var6_6 < var4_4) {
            if (var2_2[var6_6++].isSynthetic()) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean hasNonSyntheticMethodChanges(MethodInfo[] var1_1, MethodInfo[] var2_2) {
        var3_3 = var1_1 == null ? 0 : var1_1.length;
        var4_4 = var2_2 == null ? 0 : var2_2.length;
        var5_5 = 0;
        var6_6 = 0;
        ** GOTO lbl13
        block0: while (++var5_5 < var3_3) {
            while (!(var7_7 = var1_1[var5_5]).isSynthetic() && !var7_7.isClinit()) {
                while ((var7_7 = var2_2[var6_6]).isSynthetic() || var7_7.isClinit()) {
                    if (++var6_6 >= var4_4) break block0;
                }
                if (this.hasStructuralMethodChanges(var1_1[var5_5++], var2_2[var6_6++])) {
                    return true;
                }
lbl13:
                // 3 sources

                if (var5_5 < var3_3 && var6_6 < var4_4) continue;
            }
        }
        while (var5_5 < var3_3) {
            if ((var7_7 = var1_1[var5_5++]).isSynthetic() || var7_7.isClinit()) continue;
            return true;
        }
        while (var6_6 < var4_4) {
            if ((var7_7 = var2_2[var6_6++]).isSynthetic() || var7_7.isClinit()) continue;
            return true;
        }
        return false;
    }

    public boolean hasStructuralChanges(byte[] byArray) {
        return this.hasStructuralChanges(byArray, true, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasStructuralChanges(byte[] byArray, boolean bl, boolean bl2) {
        try {
            int n;
            Object[] objectArray;
            int n2;
            Object[] objectArray2;
            int n3;
            int n4;
            IBinaryNestedType[] iBinaryNestedTypeArray;
            IBinaryNestedType[] iBinaryNestedTypeArray2;
            int n5;
            ClassFileReader classFileReader = new ClassFileReader(byArray, this.classFileName);
            if (this.getModifiers() != classFileReader.getModifiers()) {
                return true;
            }
            long l = 27162300892971008L;
            if ((this.getTagBits() & l) != (classFileReader.getTagBits() & l)) {
                return true;
            }
            if (this.hasStructuralAnnotationChanges(this.getAnnotations(), classFileReader.getAnnotations())) {
                return true;
            }
            if (!CharOperation.equals(this.getGenericSignature(), classFileReader.getGenericSignature())) {
                return true;
            }
            if (!CharOperation.equals(this.getSuperclassName(), classFileReader.getSuperclassName())) {
                return true;
            }
            char[][] cArray = classFileReader.getInterfaceNames();
            if (this.interfaceNames != cArray) {
                int n6;
                int n7 = n6 = cArray == null ? 0 : cArray.length;
                if (n6 != this.interfacesCount) {
                    return true;
                }
                int n8 = 0;
                n5 = this.interfacesCount;
                while (n8 < n5) {
                    if (!CharOperation.equals(this.interfaceNames[n8], cArray[n8])) {
                        return true;
                    }
                    ++n8;
                }
            }
            if ((iBinaryNestedTypeArray2 = this.getMemberTypes()) != (iBinaryNestedTypeArray = classFileReader.getMemberTypes())) {
                n5 = iBinaryNestedTypeArray2 == null ? 0 : iBinaryNestedTypeArray2.length;
                int n9 = n4 = iBinaryNestedTypeArray == null ? 0 : iBinaryNestedTypeArray.length;
                if (n5 != n4) {
                    return true;
                }
                n3 = 0;
                while (n3 < n5) {
                    if (!CharOperation.equals(iBinaryNestedTypeArray2[n3].getName(), iBinaryNestedTypeArray[n3].getName())) return true;
                    if (iBinaryNestedTypeArray2[n3].getModifiers() != iBinaryNestedTypeArray[n3].getModifiers()) {
                        return true;
                    }
                    ++n3;
                }
            }
            n4 = (objectArray2 = (FieldInfo[])classFileReader.getFields()) == null ? 0 : objectArray2.length;
            n3 = 1;
            if (this.fieldsCount == n4) {
                n2 = 0;
                while (n2 < this.fieldsCount && !this.hasStructuralFieldChanges(this.fields[n2], objectArray2[n2])) {
                    ++n2;
                }
                n3 = n2 != this.fieldsCount ? 1 : 0;
                if (n3 != 0 && !bl && !bl2) {
                    return true;
                }
            }
            if (n3 != 0) {
                if (this.fieldsCount != n4 && !bl2) {
                    return true;
                }
                if (bl) {
                    if (this.fieldsCount != 0) {
                        Arrays.sort(this.fields);
                    }
                    if (n4 != 0) {
                        Arrays.sort(objectArray2);
                    }
                }
                if (bl2) {
                    if (this.hasNonSyntheticFieldChanges(this.fields, (FieldInfo[])objectArray2)) {
                        return true;
                    }
                } else {
                    n2 = 0;
                    while (n2 < this.fieldsCount) {
                        if (this.hasStructuralFieldChanges(this.fields[n2], (FieldInfo)objectArray2[n2])) {
                            return true;
                        }
                        ++n2;
                    }
                }
            }
            int n10 = (objectArray = (MethodInfo[])classFileReader.getMethods()) == null ? 0 : objectArray.length;
            boolean bl3 = true;
            if (this.methodsCount == n10) {
                n = 0;
                while (n < this.methodsCount && !this.hasStructuralMethodChanges(this.methods[n], objectArray[n])) {
                    ++n;
                }
                bl3 = n != this.methodsCount;
                if (bl3 && !bl && !bl2) {
                    return true;
                }
            }
            if (bl3) {
                if (this.methodsCount != n10 && !bl2) {
                    return true;
                }
                if (bl) {
                    if (this.methodsCount != 0) {
                        Arrays.sort(this.methods);
                    }
                    if (n10 != 0) {
                        Arrays.sort(objectArray);
                    }
                }
                if (bl2) {
                    if (this.hasNonSyntheticMethodChanges(this.methods, (MethodInfo[])objectArray)) {
                        return true;
                    }
                } else {
                    n = 0;
                    while (n < this.methodsCount) {
                        if (this.hasStructuralMethodChanges(this.methods[n], (MethodInfo)objectArray[n])) {
                            return true;
                        }
                        ++n;
                    }
                }
            }
            char[][][] cArray2 = this.getMissingTypeNames();
            char[][][] cArray3 = classFileReader.getMissingTypeNames();
            if (cArray2 == null) {
                if (cArray3 == null) return false;
                return true;
            }
            if (cArray3 == null) {
                return true;
            }
            int n11 = cArray2.length;
            if (n11 != cArray3.length) {
                return true;
            }
            int n12 = 0;
            while (true) {
                if (n12 >= n11) {
                    return false;
                }
                if (!CharOperation.equals(cArray2[n12], cArray3[n12])) {
                    return true;
                }
                ++n12;
            }
        }
        catch (ClassFormatException classFormatException) {
            return true;
        }
    }

    private boolean hasStructuralAnnotationChanges(IBinaryAnnotation[] iBinaryAnnotationArray, IBinaryAnnotation[] iBinaryAnnotationArray2) {
        int n;
        if (iBinaryAnnotationArray == iBinaryAnnotationArray2) {
            return false;
        }
        int n2 = iBinaryAnnotationArray == null ? 0 : iBinaryAnnotationArray.length;
        int n3 = n = iBinaryAnnotationArray2 == null ? 0 : iBinaryAnnotationArray2.length;
        if (n2 != n) {
            return true;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            if (!CharOperation.equals(iBinaryAnnotationArray[n4].getTypeName(), iBinaryAnnotationArray2[n4].getTypeName())) {
                return true;
            }
            IBinaryElementValuePair[] iBinaryElementValuePairArray = iBinaryAnnotationArray[n4].getElementValuePairs();
            IBinaryElementValuePair[] iBinaryElementValuePairArray2 = iBinaryAnnotationArray2[n4].getElementValuePairs();
            int n6 = iBinaryElementValuePairArray == null ? 0 : iBinaryElementValuePairArray.length;
            int n7 = n5 = iBinaryElementValuePairArray2 == null ? 0 : iBinaryElementValuePairArray2.length;
            if (n6 != n5) {
                return true;
            }
            int n8 = 0;
            while (n8 < n6) {
                if (!CharOperation.equals(iBinaryElementValuePairArray[n8].getName(), iBinaryElementValuePairArray2[n8].getName())) {
                    return true;
                }
                Object object = iBinaryElementValuePairArray[n8].getValue();
                Object object2 = iBinaryElementValuePairArray2[n8].getValue();
                if (object instanceof Object[]) {
                    Object[] objectArray = (Object[])object;
                    if (object2 instanceof Object[]) {
                        int n9 = objectArray.length;
                        Object[] objectArray2 = (Object[])object2;
                        if (n9 != objectArray2.length) {
                            return true;
                        }
                        int n10 = 0;
                        while (n10 < n9) {
                            if (!objectArray[n10].equals(objectArray2[n10])) {
                                return true;
                            }
                            ++n10;
                        }
                        return false;
                    }
                    return true;
                }
                if (!object.equals(object2)) {
                    return true;
                }
                ++n8;
            }
            ++n4;
        }
        return false;
    }

    private boolean hasStructuralFieldChanges(FieldInfo fieldInfo, FieldInfo fieldInfo2) {
        if (!CharOperation.equals(fieldInfo.getGenericSignature(), fieldInfo2.getGenericSignature())) {
            return true;
        }
        if (fieldInfo.getModifiers() != fieldInfo2.getModifiers()) {
            return true;
        }
        if ((fieldInfo.getTagBits() & 0x400000000000L) != (fieldInfo2.getTagBits() & 0x400000000000L)) {
            return true;
        }
        if (this.hasStructuralAnnotationChanges(fieldInfo.getAnnotations(), fieldInfo2.getAnnotations())) {
            return true;
        }
        if (!CharOperation.equals(fieldInfo.getName(), fieldInfo2.getName())) {
            return true;
        }
        if (!CharOperation.equals(fieldInfo.getTypeName(), fieldInfo2.getTypeName())) {
            return true;
        }
        if (fieldInfo.hasConstant() != fieldInfo2.hasConstant()) {
            return true;
        }
        if (fieldInfo.hasConstant()) {
            Constant constant = fieldInfo.getConstant();
            Constant constant2 = fieldInfo2.getConstant();
            if (constant.typeID() != constant2.typeID()) {
                return true;
            }
            if (!constant.getClass().equals(constant2.getClass())) {
                return true;
            }
            switch (constant.typeID()) {
                case 10: {
                    return constant.intValue() != constant2.intValue();
                }
                case 3: {
                    return constant.byteValue() != constant2.byteValue();
                }
                case 4: {
                    return constant.shortValue() != constant2.shortValue();
                }
                case 2: {
                    return constant.charValue() != constant2.charValue();
                }
                case 7: {
                    return constant.longValue() != constant2.longValue();
                }
                case 9: {
                    return constant.floatValue() != constant2.floatValue();
                }
                case 8: {
                    return constant.doubleValue() != constant2.doubleValue();
                }
                case 5: {
                    return constant.booleanValue() ^ constant2.booleanValue();
                }
                case 11: {
                    return !constant.stringValue().equals(constant2.stringValue());
                }
            }
        }
        return false;
    }

    private boolean hasStructuralMethodChanges(MethodInfo methodInfo, MethodInfo methodInfo2) {
        char[][] cArray;
        int n;
        if (!CharOperation.equals(methodInfo.getGenericSignature(), methodInfo2.getGenericSignature())) {
            return true;
        }
        if (methodInfo.getModifiers() != methodInfo2.getModifiers()) {
            return true;
        }
        if ((methodInfo.getTagBits() & 0x400000000000L) != (methodInfo2.getTagBits() & 0x400000000000L)) {
            return true;
        }
        if (this.hasStructuralAnnotationChanges(methodInfo.getAnnotations(), methodInfo2.getAnnotations())) {
            return true;
        }
        int n2 = methodInfo.getAnnotatedParametersCount();
        if (n2 != (n = methodInfo2.getAnnotatedParametersCount())) {
            return true;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.hasStructuralAnnotationChanges(methodInfo.getParameterAnnotations(n3), methodInfo2.getParameterAnnotations(n3))) {
                return true;
            }
            ++n3;
        }
        if (!CharOperation.equals(methodInfo.getSelector(), methodInfo2.getSelector())) {
            return true;
        }
        if (!CharOperation.equals(methodInfo.getMethodDescriptor(), methodInfo2.getMethodDescriptor())) {
            return true;
        }
        if (!CharOperation.equals(methodInfo.getGenericSignature(), methodInfo2.getGenericSignature())) {
            return true;
        }
        char[][] cArray2 = methodInfo.getExceptionTypeNames();
        if (cArray2 != (cArray = methodInfo2.getExceptionTypeNames())) {
            int n4;
            int n5 = cArray2 == null ? 0 : cArray2.length;
            int n6 = n4 = cArray == null ? 0 : cArray.length;
            if (n5 != n4) {
                return true;
            }
            int n7 = 0;
            while (n7 < n5) {
                if (!CharOperation.equals(cArray2[n7], cArray[n7])) {
                    return true;
                }
                ++n7;
            }
        }
        return false;
    }

    private void initialize() throws ClassFormatException {
        try {
            int n = 0;
            int n2 = this.fieldsCount;
            while (n < n2) {
                this.fields[n].initialize();
                ++n;
            }
            n = 0;
            n2 = this.methodsCount;
            while (n < n2) {
                this.methods[n].initialize();
                ++n;
            }
            if (this.innerInfos != null) {
                n = 0;
                n2 = this.innerInfos.length;
                while (n < n2) {
                    this.innerInfos[n].initialize();
                    ++n;
                }
            }
            if (this.annotations != null) {
                n = 0;
                n2 = this.annotations.length;
                while (n < n2) {
                    this.annotations[n].initialize();
                    ++n;
                }
            }
            this.getEnclosingMethod();
            this.reset();
        }
        catch (RuntimeException runtimeException) {
            ClassFormatException classFormatException = new ClassFormatException(runtimeException, this.classFileName);
            throw classFormatException;
        }
    }

    public boolean isAnonymous() {
        if (this.innerInfo == null) {
            return false;
        }
        char[] cArray = this.innerInfo.getSourceName();
        return cArray == null || cArray.length == 0;
    }

    public boolean isBinaryType() {
        return true;
    }

    public boolean isLocal() {
        if (this.innerInfo == null) {
            return false;
        }
        if (this.innerInfo.getEnclosingTypeName() != null) {
            return false;
        }
        char[] cArray = this.innerInfo.getSourceName();
        return cArray != null && cArray.length > 0;
    }

    public boolean isMember() {
        if (this.innerInfo == null) {
            return false;
        }
        if (this.innerInfo.getEnclosingTypeName() == null) {
            return false;
        }
        char[] cArray = this.innerInfo.getSourceName();
        return cArray != null && cArray.length > 0;
    }

    public boolean isNestedType() {
        return this.innerInfo != null;
    }

    public char[] sourceFileName() {
        return this.sourceFileName;
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println(String.valueOf(this.getClass().getName()) + "{");
        printWriter.println(" this.className: " + new String(this.getName()));
        printWriter.println(" this.superclassName: " + (this.getSuperclassName() == null ? "null" : new String(this.getSuperclassName())));
        printWriter.println(" access_flags: " + ClassFileReader.printTypeModifiers(this.accessFlags()) + "(" + this.accessFlags() + ")");
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }

    public static interface ZipFileProducer {
        public ZipFile produce() throws IOException;
    }
}

