/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathDirectory
extends ClasspathLocation {
    private Hashtable directoryCache;
    private String[] missingPackageHolder = new String[1];
    private int mode;
    private String encoding;
    private Hashtable<String, Hashtable<String, String>> packageSecondaryTypes = null;

    ClasspathDirectory(File file, String string, int n, AccessRuleSet accessRuleSet, String string2) {
        super(accessRuleSet, string2);
        this.mode = n;
        try {
            this.path = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.path = file.getAbsolutePath();
        }
        if (!this.path.endsWith(File.separator)) {
            this.path = String.valueOf(this.path) + File.separator;
        }
        this.directoryCache = new Hashtable(11);
        this.encoding = string;
    }

    String[] directoryList(String string) {
        String[] stringArray = (String[])this.directoryCache.get(string);
        if (stringArray == this.missingPackageHolder) {
            return null;
        }
        if (stringArray != null) {
            return stringArray;
        }
        File file = new File(String.valueOf(this.path) + string);
        if (file.isDirectory()) {
            String string2;
            String string3;
            int n = string.length();
            int n2 = string.lastIndexOf(File.separatorChar);
            while (--n > n2 && !ScannerHelper.isUpperCase(string.charAt(n))) {
            }
            if (n <= n2 || !(n2 != -1 ? !this.doesFileExist(string3 = string.substring(n2 + 1), string2 = string.substring(0, n2)) : !this.doesFileExist(string, Util.EMPTY_STRING))) {
                stringArray = file.list();
                if (stringArray == null) {
                    stringArray = CharOperation.NO_STRINGS;
                }
                this.directoryCache.put(string, stringArray);
                return stringArray;
            }
        }
        this.directoryCache.put(string, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String string, String string2) {
        String[] stringArray = this.directoryList(string2);
        if (stringArray == null) {
            return false;
        }
        int n = stringArray.length;
        while (--n >= 0) {
            if (!string.equals(stringArray[n])) continue;
            return true;
        }
        return false;
    }

    @Override
    public List fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter classpathSectionProblemReporter) {
        return null;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2) {
        return this.findClass(cArray, string, string2, false);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, boolean bl) {
        String string3;
        Object object;
        boolean bl2;
        if (!this.isPackage(string)) {
            return null;
        }
        String string4 = new String(cArray);
        boolean bl3 = (this.mode & 2) != 0 && this.doesFileExist(String.valueOf(string4) + ".class", string);
        boolean bl4 = bl2 = (this.mode & 1) != 0 && this.doesFileExist(String.valueOf(string4) + ".java", string);
        if (bl2 && !bl) {
            object = String.valueOf(this.path) + string2.substring(0, string2.length() - 6) + ".java";
            if (!bl3) {
                return new NameEnvironmentAnswer(new CompilationUnit(null, (String)object, this.encoding, this.destinationPath), this.fetchAccessRestriction(string2));
            }
            string3 = String.valueOf(this.path) + string2;
            long l = new File(string3).lastModified();
            long l2 = new File((String)object).lastModified();
            if (l2 > l) {
                return new NameEnvironmentAnswer(new CompilationUnit(null, (String)object, this.encoding, this.destinationPath), this.fetchAccessRestriction(string2));
            }
        }
        if (bl3) {
            try {
                object = ClassFileReader.read(String.valueOf(this.path) + string2);
                String string5 = string3 = string.length() > 0 ? String.valueOf(string.replace(File.separatorChar, '/')) + "/" + string4 : string4;
                if (!CharOperation.equals(((ClassFileReader)object).getName(), string3.toCharArray())) {
                    object = null;
                }
                if (object != null) {
                    return new NameEnvironmentAnswer((IBinaryType)object, this.fetchAccessRestriction(string2));
                }
            }
            catch (IOException iOException) {
            }
            catch (ClassFormatException classFormatException) {}
        }
        return null;
    }

    public NameEnvironmentAnswer findSecondaryInClass(char[] cArray, String string, String string2) {
        boolean bl = this.isPackage(string) && (this.mode & 1) != 0 && this.doesFileExist(String.valueOf(new String(cArray)) + ".java", string);
        return bl ? null : this.findSourceSecondaryType(cArray, string, string2);
    }

    @Override
    public boolean hasAnnotationFileFor(String string) {
        int n = string.lastIndexOf(47);
        if (n != -1 && n + 1 < string.length()) {
            String string2 = String.valueOf(string.substring(n + 1)) + '.' + "eea";
            return this.doesFileExist(string2, string.substring(0, n));
        }
        return false;
    }

    private Hashtable<String, String> getPackageTypes(char[] cArray, String string) {
        File[] fileArray;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = (String[])this.directoryCache.get(string);
        if (stringArray == this.missingPackageHolder || stringArray == null) {
            return hashtable;
        }
        File file = new File(String.valueOf(this.path) + string);
        File[] fileArray2 = fileArray = file.isDirectory() ? file.listFiles() : null;
        if (fileArray == null) {
            return hashtable;
        }
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            String string2;
            File file2 = fileArray[n];
            if (!file2.isDirectory() && (string2 = file2.getAbsolutePath()) != null) {
                TypeDeclaration[] typeDeclarationArray;
                CompilationUnit compilationUnit = new CompilationUnit(null, string2, this.encoding, this.destinationPath);
                CompilationResult compilationResult = new CompilationResult(compilationUnit.getContents(), 1, 1, 10);
                ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(), new DefaultProblemFactory());
                Parser parser = new Parser(problemReporter, false);
                CompilationUnitDeclaration compilationUnitDeclaration = parser.parse(compilationUnit, compilationResult);
                TypeDeclaration[] typeDeclarationArray2 = typeDeclarationArray = compilationUnitDeclaration != null ? compilationUnitDeclaration.types : null;
                if (typeDeclarationArray != null) {
                    int n3 = 0;
                    int n4 = typeDeclarationArray.length;
                    while (n3 < n4) {
                        char[] cArray2;
                        TypeDeclaration typeDeclaration = typeDeclarationArray[n3];
                        char[] cArray3 = cArray2 = typeDeclaration.isSecondary() ? typeDeclaration.name : null;
                        if (cArray2 != null) {
                            hashtable.put(new String(cArray2), string2);
                        }
                        ++n3;
                    }
                }
            }
            ++n;
        }
        return hashtable;
    }

    private NameEnvironmentAnswer findSourceSecondaryType(char[] cArray, String string, String string2) {
        String string3;
        Hashtable<String, String> hashtable;
        if (this.packageSecondaryTypes == null) {
            this.packageSecondaryTypes = new Hashtable();
        }
        if ((hashtable = this.packageSecondaryTypes.get(string)) == null) {
            hashtable = this.getPackageTypes(cArray, string);
            this.packageSecondaryTypes.put(string, hashtable);
        }
        return (string3 = hashtable.get(new String(cArray))) != null ? new NameEnvironmentAnswer(new CompilationUnit(null, string3, this.encoding, this.destinationPath), this.fetchAccessRestriction(string2)) : null;
    }

    @Override
    public char[][][] findTypeNames(String string) {
        int n;
        if (!this.isPackage(string)) {
            return null;
        }
        File file = new File(String.valueOf(this.path) + string);
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                String string2 = string.toLowerCase();
                return string2.endsWith(".class") || string2.endsWith(".java");
            }
        });
        if (stringArray == null || (n = stringArray.length) == 0) {
            return null;
        }
        char[][][] cArrayArray = new char[n][][];
        char[][] cArray = CharOperation.splitOn(File.separatorChar, string.toCharArray());
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            int n3 = string2.indexOf(46);
            cArrayArray[n2] = CharOperation.arrayConcat(cArray, string2.substring(0, n3).toCharArray());
            ++n2;
        }
        return cArrayArray;
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public boolean isPackage(String string) {
        return this.directoryList(string) != null;
    }

    @Override
    public void reset() {
        this.directoryCache = new Hashtable(11);
    }

    public String toString() {
        return "ClasspathDirectory " + this.path;
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            this.normalizedPath = this.path.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(this.normalizedPath, '\\', '/');
            }
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int getMode() {
        return this.mode;
    }
}

