/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class QualifiedTypeReference
extends TypeReference {
    public char[][] tokens;
    public long[] sourcePositions;

    public QualifiedTypeReference(char[][] cArray, long[] lArray) {
        this.tokens = cArray;
        this.sourcePositions = lArray;
        this.sourceStart = (int)(this.sourcePositions[0] >>> 32);
        this.sourceEnd = (int)(this.sourcePositions[this.sourcePositions.length - 1] & 0xFFFFFFFFL);
    }

    public TypeReference augmentTypeWithAdditionalDimensions(int n, Annotation[][] annotationArray, boolean bl) {
        int n2 = this.dimensions() + n;
        Annotation[][] annotationArray2 = this.getMergedAnnotationsOnDimensions(n, annotationArray);
        ArrayQualifiedTypeReference arrayQualifiedTypeReference = new ArrayQualifiedTypeReference(this.tokens, n2, annotationArray2, this.sourcePositions);
        arrayQualifiedTypeReference.annotations = this.annotations;
        arrayQualifiedTypeReference.bits |= this.bits & 0x100000;
        if (!bl) {
            arrayQualifiedTypeReference.extendedDimensions = n;
        }
        return arrayQualifiedTypeReference;
    }

    protected TypeBinding findNextTypeBinding(int n, Scope scope, PackageBinding packageBinding) {
        LookupEnvironment lookupEnvironment = scope.environment();
        try {
            lookupEnvironment.missingClassFileLocation = this;
            if (this.resolvedType == null) {
                this.resolvedType = scope.getType(this.tokens[n], packageBinding);
            } else {
                this.resolvedType = scope.getMemberType(this.tokens[n], (ReferenceBinding)this.resolvedType);
                if (!this.resolvedType.isValidBinding()) {
                    this.resolvedType = new ProblemReferenceBinding(CharOperation.subarray(this.tokens, 0, n + 1), (ReferenceBinding)this.resolvedType.closestMatch(), this.resolvedType.problemId());
                }
            }
            TypeBinding typeBinding = this.resolvedType;
            return typeBinding;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(this, scope.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    public char[] getLastToken() {
        return this.tokens[this.tokens.length - 1];
    }

    protected void rejectAnnotationsOnPackageQualifiers(Scope scope, PackageBinding packageBinding) {
        if (packageBinding == null || this.annotations == null) {
            return;
        }
        int n = packageBinding.compoundName.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] annotationArray = this.annotations[n2];
            if (annotationArray != null && annotationArray.length > 0) {
                scope.problemReporter().misplacedTypeAnnotations(annotationArray[0], annotationArray[annotationArray.length - 1]);
                this.annotations[n2] = null;
            }
            ++n2;
        }
    }

    protected static void rejectAnnotationsOnStaticMemberQualififer(Scope scope, ReferenceBinding referenceBinding, Annotation[] annotationArray) {
        if (referenceBinding.isMemberType() && referenceBinding.isStatic() && annotationArray != null && annotationArray.length > 0) {
            scope.problemReporter().illegalTypeAnnotationsInStaticMemberAccess(annotationArray[0], annotationArray[annotationArray.length - 1]);
        }
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        Binding binding = scope.getPackage(this.tokens);
        if (binding != null && !binding.isValidBinding()) {
            if (binding instanceof ProblemReferenceBinding && binding.problemId() == 1) {
                ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)binding;
                Binding binding2 = scope.getTypeOrPackage(this.tokens);
                return new ProblemReferenceBinding(problemReferenceBinding.compoundName, binding2 instanceof PackageBinding ? null : scope.environment().createMissingType(null, this.tokens), 1);
            }
            return (ReferenceBinding)binding;
        }
        PackageBinding packageBinding = binding == null ? null : (PackageBinding)binding;
        this.rejectAnnotationsOnPackageQualifiers(scope, packageBinding);
        boolean bl = scope.kind == 3;
        ReferenceBinding referenceBinding = null;
        int n = packageBinding == null ? 0 : packageBinding.compoundName.length;
        int n2 = this.tokens.length;
        int n3 = n2 - 1;
        while (n < n2) {
            this.findNextTypeBinding(n, scope, packageBinding);
            if (!this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            if (n == 0 && this.resolvedType.isTypeVariable() && ((TypeVariableBinding)this.resolvedType).firstBound == null) {
                scope.problemReporter().illegalAccessFromTypeVariable((TypeVariableBinding)this.resolvedType, this);
                return null;
            }
            if (n <= n3 && this.isTypeUseDeprecated(this.resolvedType, scope)) {
                this.reportDeprecatedType(this.resolvedType, scope, n);
            }
            if (bl && ((ClassScope)scope).detectHierarchyCycle(this.resolvedType, this)) {
                return null;
            }
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.resolvedType;
            if (referenceBinding != null) {
                boolean bl2;
                ReferenceBinding referenceBinding3;
                if (this.annotations != null) {
                    QualifiedTypeReference.rejectAnnotationsOnStaticMemberQualififer(scope, referenceBinding2, this.annotations[n - 1]);
                }
                if ((referenceBinding3 = referenceBinding2.enclosingType()) != null && TypeBinding.notEquals(referenceBinding3.erasure(), referenceBinding.erasure())) {
                    referenceBinding = referenceBinding3;
                }
                referenceBinding = referenceBinding2.isGenericType() ? scope.environment().createRawType(referenceBinding2, referenceBinding) : ((bl2 = referenceBinding.isRawType()) && !referenceBinding2.isStatic() ? scope.environment().createRawType((ReferenceBinding)referenceBinding2.erasure(), referenceBinding) : ((bl2 || referenceBinding.isParameterizedType()) && TypeBinding.equalsEquals(referenceBinding.erasure(), referenceBinding2.enclosingType().erasure()) ? scope.environment().createParameterizedType((ReferenceBinding)referenceBinding2.erasure(), null, referenceBinding) : referenceBinding2));
            } else {
                referenceBinding = referenceBinding2.isGenericType() ? (ReferenceBinding)scope.environment().convertToRawType(referenceBinding2, false) : referenceBinding2;
            }
            this.recordResolution(scope.environment(), referenceBinding);
            ++n;
        }
        this.resolvedType = referenceBinding;
        return this.resolvedType;
    }

    void recordResolution(LookupEnvironment lookupEnvironment, TypeBinding typeBinding) {
        if (typeBinding != null && typeBinding.isValidBinding()) {
            int n = 0;
            while (n < lookupEnvironment.resolutionListeners.length) {
                lookupEnvironment.resolutionListeners[n].recordResolution(this, typeBinding);
                ++n;
            }
        }
    }

    public char[][] getTypeName() {
        return this.tokens;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2 = 0;
        while (n2 < this.tokens.length) {
            if (n2 > 0) {
                stringBuffer.append('.');
            }
            if (this.annotations != null && this.annotations[n2] != null) {
                QualifiedTypeReference.printAnnotations(this.annotations[n2], stringBuffer);
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.tokens[n2]);
            ++n2;
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.annotations != null) {
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.annotations[n2] == null ? 0 : this.annotations[n2].length;
                int n4 = 0;
                while (n4 < n3) {
                    this.annotations[n2][n4].traverse(aSTVisitor, blockScope);
                    ++n4;
                }
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope) && this.annotations != null) {
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.annotations[n2] == null ? 0 : this.annotations[n2].length;
                int n4 = 0;
                while (n4 < n3) {
                    this.annotations[n2][n4].traverse(aSTVisitor, classScope);
                    ++n4;
                }
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    public int getAnnotatableLevels() {
        return this.tokens.length;
    }
}

