/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedSingleTypeReference
extends ArrayTypeReference {
    public static final TypeBinding[] DIAMOND_TYPE_ARGUMENTS = new TypeBinding[0];
    public TypeReference[] typeArguments;

    public ParameterizedSingleTypeReference(char[] cArray, TypeReference[] typeReferenceArray, int n, long l) {
        super(cArray, n, l);
        this.originalSourceEnd = this.sourceEnd;
        this.typeArguments = typeReferenceArray;
        int n2 = 0;
        int n3 = typeReferenceArray.length;
        while (n2 < n3) {
            if ((typeReferenceArray[n2].bits & 0x100000) != 0) {
                this.bits |= 0x100000;
                break;
            }
            ++n2;
        }
    }

    public ParameterizedSingleTypeReference(char[] cArray, TypeReference[] typeReferenceArray, int n, Annotation[][] annotationArray, long l) {
        this(cArray, typeReferenceArray, n, l);
        this.setAnnotationsOnDimensions(annotationArray);
        if (annotationArray != null) {
            this.bits |= 0x100000;
        }
    }

    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        if (this.resolvedType.leafComponentType() instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.resolvedType.leafComponentType();
            ReferenceBinding referenceBinding = parameterizedTypeBinding.genericType();
            TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
            TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
            if (typeBindingArray != null && typeVariableBindingArray != null) {
                parameterizedTypeBinding.boundCheck(scope, this.typeArguments);
            }
        }
        this.checkNullConstraints(scope, this.typeArguments);
    }

    public TypeReference augmentTypeWithAdditionalDimensions(int n, Annotation[][] annotationArray, boolean bl) {
        int n2 = this.dimensions() + n;
        Annotation[][] annotationArray2 = this.getMergedAnnotationsOnDimensions(n, annotationArray);
        ParameterizedSingleTypeReference parameterizedSingleTypeReference = new ParameterizedSingleTypeReference(this.token, this.typeArguments, n2, annotationArray2, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
        parameterizedSingleTypeReference.annotations = this.annotations;
        parameterizedSingleTypeReference.bits |= this.bits & 0x100000;
        if (!bl) {
            parameterizedSingleTypeReference.extendedDimensions = n;
        }
        return parameterizedSingleTypeReference;
    }

    public char[][] getParameterizedTypeName() {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(this.token).append('<');
        int n = 0;
        int n2 = this.typeArguments.length;
        while (n < n2) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(CharOperation.concatWith(this.typeArguments[n].getParameterizedTypeName(), '.'));
            ++n;
        }
        stringBuffer.append('>');
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        int n3 = this.dimensions;
        if (n3 > 0) {
            char[] cArray2 = new char[n3 * 2];
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n4 * 2;
                cArray2[n5] = 91;
                cArray2[n5 + 1] = 93;
                ++n4;
            }
            cArray = CharOperation.concat(cArray, cArray2);
        }
        return new char[][]{cArray};
    }

    public TypeReference[][] getTypeArguments() {
        return new TypeReference[][]{this.typeArguments};
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    public boolean isParameterizedTypeReference() {
        return true;
    }

    public boolean hasNullTypeAnnotation(TypeReference.AnnotationPosition annotationPosition) {
        if (super.hasNullTypeAnnotation(annotationPosition)) {
            return true;
        }
        if (annotationPosition == TypeReference.AnnotationPosition.ANY) {
            if (this.resolvedType != null && !this.resolvedType.hasNullTypeAnnotations()) {
                return false;
            }
            if (this.typeArguments != null) {
                int n = 0;
                while (n < this.typeArguments.length) {
                    if (this.typeArguments[n].hasNullTypeAnnotation(annotationPosition)) {
                        return true;
                    }
                    ++n;
                }
            }
        }
        return false;
    }

    private TypeBinding internalResolveType(Scope scope, ReferenceBinding referenceBinding, boolean bl, int n) {
        this.constant = Constant.NotAConstant;
        if ((this.bits & 0x40000) != 0 && this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    TypeBinding typeBinding = this.resolvedType.closestMatch();
                    return typeBinding;
                }
            }
            return null;
        }
        this.bits |= 0x40000;
        TypeBinding typeBinding = this.internalResolveLeafType(scope, referenceBinding, bl);
        if (typeBinding == null) {
            this.resolvedType = this.createArrayType(scope, this.resolvedType);
            this.resolveAnnotations(scope, 0);
            if (bl) {
                this.checkNullConstraints(scope, this.typeArguments);
            }
            return null;
        }
        typeBinding = this.createArrayType(scope, typeBinding);
        if (!this.resolvedType.isValidBinding() && this.resolvedType.dimensions() == typeBinding.dimensions()) {
            this.resolveAnnotations(scope, 0);
            if (bl) {
                this.checkNullConstraints(scope, this.typeArguments);
            }
            return typeBinding;
        }
        this.resolvedType = typeBinding;
        this.resolveAnnotations(scope, n);
        if (bl) {
            this.checkNullConstraints(scope, this.typeArguments);
        }
        return this.resolvedType;
    }

    private TypeBinding internalResolveLeafType(Scope scope, ReferenceBinding typeBinding, boolean bl) {
        TypeVariableBinding[] typeVariableBindingArray;
        Object object;
        TypeBinding typeBinding2;
        ReferenceBinding referenceBinding;
        if (typeBinding == null) {
            this.resolvedType = scope.getType(this.token);
            if (this.resolvedType.isValidBinding()) {
                referenceBinding = (ReferenceBinding)this.resolvedType;
            } else {
                this.reportInvalidType(scope);
                switch (this.resolvedType.problemId()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        typeBinding2 = this.resolvedType.closestMatch();
                        if (typeBinding2 instanceof ReferenceBinding) {
                            referenceBinding = (ReferenceBinding)typeBinding2;
                            break;
                        }
                    }
                    default: {
                        boolean bl2 = scope.kind == 3;
                        int n = this.typeArguments.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TypeReference typeReference = this.typeArguments[n2];
                            if (bl2) {
                                typeReference.resolveType((ClassScope)scope);
                            } else {
                                typeReference.resolveType((BlockScope)scope, bl);
                            }
                            ++n2;
                        }
                        return null;
                    }
                }
            }
            typeBinding = referenceBinding.enclosingType();
            if (typeBinding != null) {
                typeBinding = referenceBinding.isStatic() ? (ReferenceBinding)scope.environment().convertToRawType(typeBinding, false) : scope.environment().convertToParameterizedType((ReferenceBinding)typeBinding);
                referenceBinding = scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)typeBinding);
            }
        } else {
            referenceBinding = scope.getMemberType(this.token, (ReferenceBinding)typeBinding);
            this.resolvedType = referenceBinding;
            if (!this.resolvedType.isValidBinding()) {
                scope.problemReporter().invalidEnclosingType(this, referenceBinding, (ReferenceBinding)typeBinding);
                return null;
            }
            if (this.isTypeUseDeprecated(referenceBinding, scope)) {
                scope.problemReporter().deprecatedType(referenceBinding, this);
            }
            if ((typeBinding2 = referenceBinding.enclosingType()) != null && TypeBinding.notEquals(typeBinding2.erasure(), typeBinding.erasure())) {
                typeBinding = typeBinding2;
            }
        }
        boolean bl3 = scope.kind == 3;
        TypeReference typeReference = null;
        if (bl3) {
            typeReference = ((ClassScope)scope).superTypeReference;
            ((ClassScope)scope).superTypeReference = null;
        }
        boolean bl4 = (this.bits & 0x80000) != 0;
        int n = this.typeArguments.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        boolean bl5 = false;
        ReferenceBinding referenceBinding2 = (ReferenceBinding)referenceBinding.original();
        int n3 = 0;
        while (n3 < n) {
            object = this.typeArguments[n3];
            TypeBinding typeBinding3 = bl3 ? ((TypeReference)object).resolveTypeArgument((ClassScope)scope, referenceBinding2, n3) : ((TypeReference)object).resolveTypeArgument((BlockScope)scope, referenceBinding2, n3);
            this.bits |= ((TypeReference)object).bits & 0x100000;
            if (typeBinding3 == null) {
                bl5 = true;
            } else {
                typeBindingArray[n3] = typeBinding3;
            }
            ++n3;
        }
        if (bl5) {
            return null;
        }
        if (bl3) {
            ((ClassScope)scope).superTypeReference = typeReference;
            if (((ClassScope)scope).detectHierarchyCycle(referenceBinding2, this)) {
                return null;
            }
        }
        if ((typeVariableBindingArray = referenceBinding2.typeVariables()) == Binding.NO_TYPE_VARIABLES) {
            boolean bl6;
            boolean bl7 = bl6 = scope.compilerOptions().originalSourceLevel >= 0x310000L;
            if ((referenceBinding2.tagBits & 0x80L) == 0L && bl6) {
                this.resolvedType = referenceBinding;
                scope.problemReporter().nonGenericTypeCannotBeParameterized(0, this, referenceBinding, typeBindingArray);
                return null;
            }
            if (!bl6) {
                if (!this.resolvedType.isValidBinding()) {
                    return referenceBinding;
                }
                this.resolvedType = referenceBinding;
                return this.resolvedType;
            }
        } else if (n != typeVariableBindingArray.length) {
            if (!bl4) {
                scope.problemReporter().incorrectArityForParameterizedType(this, referenceBinding, typeBindingArray);
                return null;
            }
        } else if (!referenceBinding.isStatic() && (object = referenceBinding.enclosingType()) != null && ((TypeBinding)object).isRawType()) {
            scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType(referenceBinding2, (ReferenceBinding)object), typeBindingArray);
            return null;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = scope.environment().createParameterizedType(referenceBinding2, typeBindingArray, (ReferenceBinding)typeBinding);
        if (!bl4) {
            if (bl) {
                parameterizedTypeBinding.boundCheck(scope, this.typeArguments);
            } else {
                scope.deferBoundCheck(this);
            }
        } else {
            parameterizedTypeBinding.arguments = DIAMOND_TYPE_ARGUMENTS;
        }
        if (this.isTypeUseDeprecated(parameterizedTypeBinding, scope)) {
            this.reportDeprecatedType(parameterizedTypeBinding, scope);
        }
        if (!this.resolvedType.isValidBinding()) {
            return parameterizedTypeBinding;
        }
        this.resolvedType = parameterizedTypeBinding;
        return this.resolvedType;
    }

    private TypeBinding createArrayType(Scope scope, TypeBinding typeBinding) {
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            return scope.createArrayType(typeBinding, this.dimensions);
        }
        return typeBinding;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.annotations != null && this.annotations[0] != null) {
            ParameterizedSingleTypeReference.printAnnotations(this.annotations[0], stringBuffer);
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.token);
        stringBuffer.append("<");
        int n3 = this.typeArguments.length;
        if (n3 > 0) {
            int n4 = n3 - 1;
            n2 = 0;
            while (n2 < n4) {
                this.typeArguments[n2].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n2;
            }
            this.typeArguments[n4].print(0, stringBuffer);
        }
        stringBuffer.append(">");
        Annotation[][] annotationArray = this.getAnnotationsOnDimensions();
        if ((this.bits & 0x4000) != 0) {
            n2 = 0;
            while (n2 < this.dimensions - 1) {
                if (annotationArray != null && annotationArray[n2] != null) {
                    stringBuffer.append(" ");
                    ParameterizedSingleTypeReference.printAnnotations(annotationArray[n2], stringBuffer);
                    stringBuffer.append(" ");
                }
                stringBuffer.append("[]");
                ++n2;
            }
            if (annotationArray != null && annotationArray[this.dimensions - 1] != null) {
                stringBuffer.append(" ");
                ParameterizedSingleTypeReference.printAnnotations(annotationArray[this.dimensions - 1], stringBuffer);
                stringBuffer.append(" ");
            }
            stringBuffer.append("...");
        } else {
            n2 = 0;
            while (n2 < this.dimensions) {
                if (annotationArray != null && annotationArray[n2] != null) {
                    stringBuffer.append(" ");
                    ParameterizedSingleTypeReference.printAnnotations(annotationArray[n2], stringBuffer);
                    stringBuffer.append(" ");
                }
                stringBuffer.append("[]");
                ++n2;
            }
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl, int n) {
        return this.internalResolveType(blockScope, null, bl, n);
    }

    public TypeBinding resolveType(ClassScope classScope, int n) {
        return this.internalResolveType(classScope, null, false, n);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope blockScope, ReferenceBinding referenceBinding) {
        return this.internalResolveType(blockScope, referenceBinding, true, 0);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            Annotation[][] annotationArray;
            if (this.annotations != null) {
                annotationArray = this.annotations[0];
                n2 = 0;
                n = annotationArray == null ? 0 : annotationArray.length;
                while (n2 < n) {
                    annotationArray[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if ((annotationArray = this.getAnnotationsOnDimensions(true)) != null) {
                n2 = 0;
                n = annotationArray.length;
                while (n2 < n) {
                    Annotation[] annotationArray2 = annotationArray[n2];
                    if (annotationArray2 != null) {
                        int n3 = 0;
                        int n4 = annotationArray2.length;
                        while (n3 < n4) {
                            Annotation annotation = annotationArray2[n3];
                            annotation.traverse(aSTVisitor, blockScope);
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            n2 = 0;
            n = this.typeArguments.length;
            while (n2 < n) {
                this.typeArguments[n2].traverse(aSTVisitor, blockScope);
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            Annotation[][] annotationArray;
            if (this.annotations != null) {
                annotationArray = this.annotations[0];
                n2 = 0;
                n = annotationArray == null ? 0 : annotationArray.length;
                while (n2 < n) {
                    annotationArray[n2].traverse(aSTVisitor, classScope);
                    ++n2;
                }
            }
            if ((annotationArray = this.getAnnotationsOnDimensions(true)) != null) {
                n2 = 0;
                n = annotationArray.length;
                while (n2 < n) {
                    Annotation[] annotationArray2 = annotationArray[n2];
                    int n3 = 0;
                    int n4 = annotationArray2.length;
                    while (n3 < n4) {
                        Annotation annotation = annotationArray2[n3];
                        annotation.traverse(aSTVisitor, classScope);
                        ++n3;
                    }
                    ++n2;
                }
            }
            n2 = 0;
            n = this.typeArguments.length;
            while (n2 < n) {
                this.typeArguments[n2].traverse(aSTVisitor, classScope);
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

