/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBindingVisitor;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class NullAnnotationMatching {
    public static final NullAnnotationMatching NULL_ANNOTATIONS_OK = new NullAnnotationMatching(0, 1, null);
    public static final NullAnnotationMatching NULL_ANNOTATIONS_OK_NONNULL = new NullAnnotationMatching(0, 4, null);
    public static final NullAnnotationMatching NULL_ANNOTATIONS_UNCHECKED = new NullAnnotationMatching(1, 1, null);
    public static final NullAnnotationMatching NULL_ANNOTATIONS_MISMATCH = new NullAnnotationMatching(2, 1, null);
    public final int severity;
    public final TypeBinding superTypeHint;
    public final int nullStatus;

    public NullAnnotationMatching(int n, int n2, TypeBinding typeBinding) {
        this.severity = n;
        this.superTypeHint = typeBinding;
        this.nullStatus = n2;
    }

    public boolean isAnyMismatch() {
        return this.severity != 0;
    }

    public boolean isUnchecked() {
        return this.severity == 1;
    }

    public boolean isDefiniteMismatch() {
        return this.severity == 2;
    }

    public boolean isPotentiallyNullMismatch() {
        return !this.isDefiniteMismatch() && this.nullStatus != -1 && (this.nullStatus & 0x10) != 0;
    }

    public String superTypeHintName(CompilerOptions compilerOptions, boolean bl) {
        return String.valueOf(this.superTypeHint.nullAnnotatedReadableName(compilerOptions, bl));
    }

    public static int checkAssignment(BlockScope blockScope, FlowContext flowContext, VariableBinding variableBinding, FlowInfo flowInfo, int n, Expression expression, TypeBinding typeBinding) {
        long l = 0L;
        boolean bl = false;
        if (!blockScope.environment().usesNullTypeAnnotations()) {
            l = variableBinding.tagBits & 0x180000000000000L;
        } else {
            if (expression instanceof ConditionalExpression && expression.isPolyExpression()) {
                int n2;
                ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
                int n3 = NullAnnotationMatching.checkAssignment(blockScope, flowContext, variableBinding, flowInfo, conditionalExpression.ifTrueNullStatus, conditionalExpression.valueIfTrue, conditionalExpression.valueIfTrue.resolvedType);
                if (n3 == (n2 = NullAnnotationMatching.checkAssignment(blockScope, flowContext, variableBinding, flowInfo, conditionalExpression.ifFalseNullStatus, conditionalExpression.valueIfFalse, conditionalExpression.valueIfFalse.resolvedType))) {
                    return n3;
                }
                return n;
            }
            l = variableBinding.type.tagBits & 0x180000000000000L;
            NullAnnotationMatching nullAnnotationMatching = NullAnnotationMatching.analyse(variableBinding.type, typeBinding, n);
            if (nullAnnotationMatching.isAnyMismatch()) {
                flowContext.recordNullityMismatch(blockScope, expression, typeBinding, variableBinding.type, flowInfo, n, nullAnnotationMatching);
                bl = true;
            } else if (nullAnnotationMatching.nullStatus != 1) {
                return nullAnnotationMatching.nullStatus;
            }
        }
        if (l == 0x100000000000000L && n != 4) {
            if (!bl) {
                flowContext.recordNullityMismatch(blockScope, expression, typeBinding, variableBinding.type, flowInfo, n, null);
            }
            return 4;
        }
        if (l == 0x80000000000000L && n == 1) {
            return 16;
        }
        return n;
    }

    public static NullAnnotationMatching analyse(TypeBinding typeBinding, TypeBinding typeBinding2, int n) {
        return NullAnnotationMatching.analyse(typeBinding, typeBinding2, null, n, CheckMode.COMPATIBLE);
    }

    public static NullAnnotationMatching analyse(TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3, int n, CheckMode checkMode) {
        if (!typeBinding.enterRecursiveFunction()) {
            return NULL_ANNOTATIONS_OK;
        }
        try {
            Object object;
            Object object2;
            int n2 = 0;
            TypeBinding typeBinding4 = null;
            NullAnnotationMatching nullAnnotationMatching = NULL_ANNOTATIONS_OK;
            if (NullAnnotationMatching.areSameTypes(typeBinding, typeBinding2, typeBinding3)) {
                if ((typeBinding.tagBits & 0x100000000000000L) != 0L) {
                    NullAnnotationMatching nullAnnotationMatching2 = NULL_ANNOTATIONS_OK_NONNULL;
                    return nullAnnotationMatching2;
                }
                NullAnnotationMatching nullAnnotationMatching3 = nullAnnotationMatching;
                return nullAnnotationMatching3;
            }
            if (checkMode == CheckMode.BOUND_CHECK && typeBinding instanceof TypeVariableBinding) {
                Object object3;
                object2 = typeBinding.superclass();
                if (object2 != null && ((TypeBinding)object2).hasNullTypeAnnotations()) {
                    object3 = NullAnnotationMatching.analyse((TypeBinding)object2, typeBinding2, null, n, checkMode);
                    if ((n2 = Math.max(n2, object3.severity)) == 2) {
                        NullAnnotationMatching nullAnnotationMatching4 = new NullAnnotationMatching(n2, n, typeBinding4);
                        return nullAnnotationMatching4;
                    }
                }
                if ((object3 = typeBinding.superInterfaces()) != null) {
                    int n3 = 0;
                    while (n3 < ((ReferenceBinding[])object3).length) {
                        if (object3[n3].hasNullTypeAnnotations()) {
                            object = NullAnnotationMatching.analyse(object3[n3], typeBinding2, null, n, checkMode);
                            if ((n2 = Math.max(n2, ((NullAnnotationMatching)object).severity)) == 2) {
                                NullAnnotationMatching nullAnnotationMatching5 = new NullAnnotationMatching(n2, n, typeBinding4);
                                return nullAnnotationMatching5;
                            }
                        }
                        ++n3;
                    }
                }
            }
            if (typeBinding instanceof ArrayBinding) {
                object2 = ((ArrayBinding)typeBinding).nullTagBitsPerDimension;
                if (object2 != null) {
                    int n4 = typeBinding.dimensions();
                    if (typeBinding.dimensions() == typeBinding2.dimensions()) {
                        long[] lArray = ((ArrayBinding)typeBinding2).nullTagBitsPerDimension;
                        if (lArray == null) {
                            lArray = new long[n4 + 1];
                        }
                        int n5 = n;
                        int n6 = 0;
                        while (n6 <= n4) {
                            long l = NullAnnotationMatching.validNullTagBits((long)object2[n6]);
                            long l2 = NullAnnotationMatching.validNullTagBits(lArray[n6]);
                            if (n6 > 0) {
                                n5 = -1;
                            }
                            if ((n2 = Math.max(n2, NullAnnotationMatching.computeNullProblemSeverity(l, l2, n5, checkMode == CheckMode.OVERRIDE && n == -1))) == 2) {
                                NullAnnotationMatching nullAnnotationMatching6 = NULL_ANNOTATIONS_MISMATCH;
                                return nullAnnotationMatching6;
                            }
                            if (n2 == 0) {
                                n = -1;
                            }
                            ++n6;
                        }
                    } else if (typeBinding2.id == 12 && n4 > 0 && object2[0] == 0x100000000000000L) {
                        NullAnnotationMatching nullAnnotationMatching7 = NULL_ANNOTATIONS_MISMATCH;
                        return nullAnnotationMatching7;
                    }
                }
            } else if (typeBinding.hasNullTypeAnnotations() || typeBinding2.hasNullTypeAnnotations() || typeBinding.isTypeVariable()) {
                long l;
                int n7;
                long l3 = NullAnnotationMatching.requiredNullTagBits(typeBinding, checkMode);
                if ((l3 != 0x80000000000000L || n == -1) && (n2 = Math.max(n2, n7 = NullAnnotationMatching.computeNullProblemSeverity(l3, l = NullAnnotationMatching.providedNullTagBits(typeBinding2), n, checkMode == CheckMode.OVERRIDE && n == -1))) == 0 && (l & 0x100000000000000L) != 0L) {
                    nullAnnotationMatching = NULL_ANNOTATIONS_OK_NONNULL;
                }
                if (n2 < 2) {
                    ReferenceBinding referenceBinding;
                    TypeBinding[] typeBindingArray;
                    TypeBinding typeBinding5 = typeBinding2.findSuperTypeOriginatingFrom(typeBinding);
                    Object object4 = object = typeBinding3 != null ? typeBinding3.findSuperTypeOriginatingFrom(typeBinding) : null;
                    if (typeBinding5 != typeBinding2) {
                        typeBinding4 = typeBinding5;
                    }
                    if (typeBinding.isParameterizedType() && typeBinding5 instanceof ParameterizedTypeBinding) {
                        TypeBinding[] typeBindingArray2 = ((ParameterizedTypeBinding)typeBinding).arguments;
                        typeBindingArray = ((ParameterizedTypeBinding)typeBinding5).arguments;
                        Object object5 = referenceBinding = object instanceof ParameterizedTypeBinding ? ((ParameterizedTypeBinding)object).arguments : null;
                        if (typeBindingArray2 != null && typeBindingArray != null && typeBindingArray2.length == typeBindingArray.length) {
                            int n8 = 0;
                            while (n8 < typeBindingArray2.length) {
                                ReferenceBinding referenceBinding2 = referenceBinding != null ? referenceBinding[n8] : null;
                                NullAnnotationMatching nullAnnotationMatching8 = NullAnnotationMatching.analyse(typeBindingArray2[n8], typeBindingArray[n8], referenceBinding2, -1, checkMode);
                                if ((n2 = Math.max(n2, nullAnnotationMatching8.severity)) == 2) {
                                    NullAnnotationMatching nullAnnotationMatching9 = new NullAnnotationMatching(n2, n, typeBinding4);
                                    return nullAnnotationMatching9;
                                }
                                ++n8;
                            }
                        }
                    }
                    ReferenceBinding referenceBinding3 = typeBinding.enclosingType();
                    typeBindingArray = typeBinding2.enclosingType();
                    if (referenceBinding3 != null && typeBindingArray != null) {
                        referenceBinding = typeBinding3 != null ? typeBinding3.enclosingType() : null;
                        NullAnnotationMatching nullAnnotationMatching10 = NullAnnotationMatching.analyse(referenceBinding3, (TypeBinding)typeBindingArray, referenceBinding, -1, checkMode);
                        n2 = Math.max(n2, nullAnnotationMatching10.severity);
                    }
                }
            }
            if (n2 == 0) {
                NullAnnotationMatching nullAnnotationMatching11 = nullAnnotationMatching;
                return nullAnnotationMatching11;
            }
            NullAnnotationMatching nullAnnotationMatching12 = new NullAnnotationMatching(n2, n, typeBinding4);
            return nullAnnotationMatching12;
        }
        finally {
            typeBinding.exitRecursiveFunction();
        }
    }

    protected static boolean areSameTypes(TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3) {
        if (typeBinding == typeBinding2) {
            return true;
        }
        if (typeBinding.isParameterizedType() || typeBinding.isArrayType()) {
            return false;
        }
        if (TypeBinding.notEquals(typeBinding, typeBinding2)) {
            if (typeBinding instanceof CaptureBinding) {
                TypeBinding typeBinding4 = ((CaptureBinding)typeBinding).lowerBound;
                if (typeBinding4 != null && NullAnnotationMatching.areSameTypes(typeBinding4, typeBinding2, typeBinding3)) {
                    return true;
                }
            } else {
                TypeBinding typeBinding5;
                if (typeBinding.kind() == 4100 && typeBinding == typeBinding3) {
                    return true;
                }
                if (typeBinding2 instanceof CaptureBinding && (typeBinding5 = ((CaptureBinding)typeBinding2).upperBound()) != null && NullAnnotationMatching.areSameTypes(typeBinding, typeBinding5, typeBinding3)) {
                    return true;
                }
            }
            return false;
        }
        return (typeBinding.tagBits & 0x180000000000000L) == (typeBinding2.tagBits & 0x180000000000000L);
    }

    static long requiredNullTagBits(TypeBinding typeBinding, CheckMode checkMode) {
        long l = typeBinding.tagBits & 0x180000000000000L;
        if (l != 0L) {
            return NullAnnotationMatching.validNullTagBits(l);
        }
        if (typeBinding.isWildcard()) {
            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
            if (wildcardBinding.boundKind == 0) {
                return 0L;
            }
            l = wildcardBinding.bound.tagBits & 0x180000000000000L;
            if (l == 0L) {
                return 0L;
            }
            switch (wildcardBinding.boundKind) {
                case 1: {
                    if (l == 0x100000000000000L) {
                        return 0x100000000000000L;
                    }
                    return 0x180000000000000L;
                }
                case 2: {
                    if (l == 0x80000000000000L) {
                        return 0x80000000000000L;
                    }
                    return 0x180000000000000L;
                }
            }
            return 0L;
        }
        if (typeBinding.isTypeVariable()) {
            TypeBinding typeBinding2;
            if (typeBinding.isCapture() && (typeBinding2 = ((CaptureBinding)typeBinding).lowerBound) != null && (l = typeBinding2.tagBits & 0x180000000000000L) == 0x80000000000000L) {
                return 0x80000000000000L;
            }
            if (checkMode != CheckMode.BOUND_CHECK) {
                return 0x100000000000000L;
            }
        }
        return 0L;
    }

    static long providedNullTagBits(TypeBinding typeBinding) {
        long l = typeBinding.tagBits & 0x180000000000000L;
        if (l != 0L) {
            return NullAnnotationMatching.validNullTagBits(l);
        }
        if (typeBinding.isWildcard()) {
            WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
            if (wildcardBinding.boundKind == 0) {
                return 0L;
            }
            l = wildcardBinding.bound.tagBits & 0x180000000000000L;
            if (l == 0L) {
                return 0L;
            }
            switch (wildcardBinding.boundKind) {
                case 1: {
                    if (l == 0x100000000000000L) {
                        return 0x100000000000000L;
                    }
                    return 0x180000000000000L;
                }
                case 2: {
                    if (l == 0x80000000000000L) {
                        return 0x80000000000000L;
                    }
                    return 0x180000000000000L;
                }
            }
            return 0L;
        }
        if (typeBinding.isTypeVariable()) {
            TypeBinding typeBinding2;
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBinding;
            boolean bl = false;
            if (typeVariableBinding.isCapture() && (typeBinding2 = ((CaptureBinding)typeVariableBinding).lowerBound) != null) {
                l = typeBinding2.tagBits & 0x180000000000000L;
                if (l == 0x80000000000000L) {
                    return 0x80000000000000L;
                }
                bl |= l != 0L;
            }
            if (typeVariableBinding.firstBound != null) {
                long l2 = typeVariableBinding.firstBound.tagBits & 0x180000000000000L;
                if (l2 == 0x100000000000000L) {
                    return 0x100000000000000L;
                }
                bl |= l2 != 0L;
            }
            if (bl) {
                return 0x180000000000000L;
            }
        }
        return 0L;
    }

    public static long validNullTagBits(long l) {
        return (l &= 0x180000000000000L) == 0x180000000000000L ? 0L : l;
    }

    public static TypeBinding moreDangerousType(TypeBinding typeBinding, TypeBinding typeBinding2) {
        long l;
        if (typeBinding == null) {
            return null;
        }
        long l2 = NullAnnotationMatching.validNullTagBits(typeBinding.tagBits);
        if (l2 != (l = NullAnnotationMatching.validNullTagBits(typeBinding2.tagBits))) {
            if (l2 == 0x80000000000000L) {
                return typeBinding;
            }
            if (l == 0x80000000000000L) {
                return typeBinding2;
            }
            if (l2 == 0L) {
                return typeBinding;
            }
            return typeBinding2;
        }
        if (typeBinding != typeBinding2 && NullAnnotationMatching.analyse(typeBinding, typeBinding2, -1).isAnyMismatch()) {
            return typeBinding2;
        }
        return typeBinding;
    }

    private static int computeNullProblemSeverity(long l, long l2, int n, boolean bl) {
        if ((l != 0L || bl) && l != l2) {
            if (l == 0x100000000000000L && n == 4) {
                return 0;
            }
            if (l == 0x180000000000000L) {
                return 0;
            }
            if (n != -1 && !bl && l == 0x80000000000000L) {
                return 0;
            }
            if (l2 != 0L) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static MethodBinding checkForContradictions(MethodBinding methodBinding, Object object, Scope scope) {
        int n = 0;
        int n2 = 0;
        if (object instanceof InvocationSite) {
            n = ((InvocationSite)object).sourceStart();
            n2 = ((InvocationSite)object).sourceEnd();
        } else if (object instanceof ASTNode) {
            n = ((ASTNode)object).sourceStart;
            n2 = ((ASTNode)object).sourceEnd;
        }
        SearchContradictions searchContradictions = new SearchContradictions();
        TypeBindingVisitor.visit((TypeBindingVisitor)searchContradictions, methodBinding.returnType);
        if (searchContradictions.typeWithContradiction != null) {
            if (scope == null) {
                return new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 25);
            }
            scope.problemReporter().contradictoryNullAnnotationsInferred(methodBinding, n, n2, object instanceof FunctionalExpression);
            return methodBinding;
        }
        Expression[] expressionArray = null;
        if (object instanceof Invocation) {
            expressionArray = ((Invocation)object).arguments();
        }
        int n3 = 0;
        while (n3 < methodBinding.parameters.length) {
            TypeBindingVisitor.visit((TypeBindingVisitor)searchContradictions, methodBinding.parameters[n3]);
            if (searchContradictions.typeWithContradiction != null) {
                if (scope == null) {
                    return new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 25);
                }
                if (expressionArray != null && n3 < expressionArray.length) {
                    scope.problemReporter().contradictoryNullAnnotationsInferred(methodBinding, expressionArray[n3]);
                } else {
                    scope.problemReporter().contradictoryNullAnnotationsInferred(methodBinding, n, n2, object instanceof FunctionalExpression);
                }
                return methodBinding;
            }
            ++n3;
        }
        return methodBinding;
    }

    public static boolean hasContradictions(TypeBinding typeBinding) {
        SearchContradictions searchContradictions = new SearchContradictions();
        TypeBindingVisitor.visit((TypeBindingVisitor)searchContradictions, typeBinding);
        return searchContradictions.typeWithContradiction != null;
    }

    public static TypeBinding strongerType(TypeBinding typeBinding, TypeBinding typeBinding2, LookupEnvironment lookupEnvironment) {
        if ((typeBinding.tagBits & 0x100000000000000L) != 0L) {
            return NullAnnotationMatching.mergeTypeAnnotations(typeBinding, typeBinding2, true, lookupEnvironment);
        }
        return NullAnnotationMatching.mergeTypeAnnotations(typeBinding2, typeBinding, true, lookupEnvironment);
    }

    public static TypeBinding[] weakerTypes(TypeBinding[] typeBindingArray, TypeBinding[] typeBindingArray2, LookupEnvironment lookupEnvironment) {
        TypeBinding[] typeBindingArray3 = new TypeBinding[typeBindingArray.length];
        int n = 0;
        while (n < typeBindingArray3.length) {
            long l = typeBindingArray[n].tagBits;
            long l2 = typeBindingArray2[n].tagBits;
            typeBindingArray3[n] = (l & 0x80000000000000L) != 0L ? NullAnnotationMatching.mergeTypeAnnotations(typeBindingArray[n], typeBindingArray2[n], true, lookupEnvironment) : ((l2 & 0x80000000000000L) != 0L ? NullAnnotationMatching.mergeTypeAnnotations(typeBindingArray2[n], typeBindingArray[n], true, lookupEnvironment) : ((l & 0x100000000000000L) == 0L ? NullAnnotationMatching.mergeTypeAnnotations(typeBindingArray[n], typeBindingArray2[n], true, lookupEnvironment) : NullAnnotationMatching.mergeTypeAnnotations(typeBindingArray2[n], typeBindingArray[n], true, lookupEnvironment)));
            ++n;
        }
        return typeBindingArray3;
    }

    private static TypeBinding mergeTypeAnnotations(TypeBinding typeBinding, TypeBinding typeBinding2, boolean bl, LookupEnvironment lookupEnvironment) {
        Object object;
        TypeBinding typeBinding3 = typeBinding;
        if (!bl && (object = typeBinding2.getTypeAnnotations()) != Binding.NO_ANNOTATIONS) {
            typeBinding3 = lookupEnvironment.createAnnotatedType(typeBinding, (AnnotationBinding[])object);
        }
        if (typeBinding3.isParameterizedType() && typeBinding2.isParameterizedType()) {
            object = (ParameterizedTypeBinding)typeBinding;
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding2;
            TypeBinding[] typeBindingArray = ((ParameterizedTypeBinding)object).arguments;
            TypeBinding[] typeBindingArray2 = parameterizedTypeBinding.arguments;
            TypeBinding[] typeBindingArray3 = new TypeBinding[typeBindingArray.length];
            int n = 0;
            while (n < typeBindingArray.length) {
                typeBindingArray3[n] = NullAnnotationMatching.mergeTypeAnnotations(typeBindingArray[n], typeBindingArray2[n], false, lookupEnvironment);
                ++n;
            }
            return lookupEnvironment.createParameterizedType(((ParameterizedTypeBinding)object).genericType(), typeBindingArray3, ((ParameterizedTypeBinding)object).enclosingType());
        }
        return typeBinding3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CheckMode {
        COMPATIBLE,
        OVERRIDE,
        BOUND_CHECK;

    }

    static class SearchContradictions
    extends TypeBindingVisitor {
        ReferenceBinding typeWithContradiction;

        SearchContradictions() {
        }

        public boolean visit(ReferenceBinding referenceBinding) {
            if ((referenceBinding.tagBits & 0x180000000000000L) == 0x180000000000000L) {
                this.typeWithContradiction = referenceBinding;
                return false;
            }
            return true;
        }

        public boolean visit(TypeVariableBinding typeVariableBinding) {
            if (!this.visit((ReferenceBinding)typeVariableBinding)) {
                return false;
            }
            long l = typeVariableBinding.tagBits & 0x180000000000000L;
            if (typeVariableBinding.firstBound != null) {
                l = typeVariableBinding.firstBound.tagBits & 0x180000000000000L;
            }
            TypeBinding[] typeBindingArray = typeVariableBinding.otherUpperBounds();
            int n = typeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding typeBinding = typeBindingArray[n2];
                l |= typeBinding.tagBits & 0x180000000000000L;
                ++n2;
            }
            if (l == 0x180000000000000L) {
                this.typeWithContradiction = typeVariableBinding;
                return false;
            }
            return true;
        }

        public boolean visit(RawTypeBinding rawTypeBinding) {
            return this.visit((ReferenceBinding)rawTypeBinding);
        }

        public boolean visit(WildcardBinding wildcardBinding) {
            long l = wildcardBinding.tagBits & 0x180000000000000L;
            switch (wildcardBinding.boundKind) {
                case 1: {
                    l |= wildcardBinding.bound.tagBits & 0x100000000000000L;
                    break;
                }
                case 2: {
                    l |= wildcardBinding.bound.tagBits & 0x80000000000000L;
                }
            }
            if (l == 0x180000000000000L) {
                this.typeWithContradiction = wildcardBinding;
                return false;
            }
            return true;
        }

        public boolean visit(ParameterizedTypeBinding parameterizedTypeBinding) {
            if (!this.visit((ReferenceBinding)parameterizedTypeBinding)) {
                return false;
            }
            return super.visit(parameterizedTypeBinding);
        }
    }
}

