/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.LongLiteralMinValue;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;

public class LongLiteral
extends NumberLiteral {
    private static final char[] HEXA_MIN_VALUE = "0x8000000000000000L".toCharArray();
    private static final char[] HEXA_MINUS_ONE_VALUE = "0xffffffffffffffffL".toCharArray();
    private static final char[] OCTAL_MIN_VALUE = "01000000000000000000000L".toCharArray();
    private static final char[] OCTAL_MINUS_ONE_VALUE = "01777777777777777777777L".toCharArray();
    private static final char[] DECIMAL_MIN_VALUE = "9223372036854775808L".toCharArray();
    private static final char[] DECIMAL_MAX_VALUE = "9223372036854775807L".toCharArray();
    private char[] reducedForm;

    public static LongLiteral buildLongLiteral(char[] cArray, int n, int n2) {
        char[] cArray2 = LongLiteral.removePrefixZerosAndUnderscores(cArray, true);
        switch (cArray2.length) {
            case 19: {
                if (!CharOperation.equals(cArray2, HEXA_MIN_VALUE)) break;
                return new LongLiteralMinValue(cArray, (char[])(cArray2 != cArray ? cArray2 : null), n, n2);
            }
            case 24: {
                if (!CharOperation.equals(cArray2, OCTAL_MIN_VALUE)) break;
                return new LongLiteralMinValue(cArray, (char[])(cArray2 != cArray ? cArray2 : null), n, n2);
            }
        }
        return new LongLiteral(cArray, (char[])(cArray2 != cArray ? cArray2 : null), n, n2);
    }

    LongLiteral(char[] cArray, char[] cArray2, int n, int n2) {
        super(cArray, n, n2);
        this.reducedForm = cArray2;
    }

    public LongLiteral convertToMinValue() {
        if ((this.bits & 0x1FE00000) >> 21 != 0) {
            return this;
        }
        char[] cArray = this.reducedForm != null ? this.reducedForm : this.source;
        switch (cArray.length) {
            case 20: {
                if (!CharOperation.equals(cArray, DECIMAL_MIN_VALUE, false)) break;
                return new LongLiteralMinValue(this.source, this.reducedForm, this.sourceStart, this.sourceEnd);
            }
        }
        return this;
    }

    public void computeConstant() {
        char[] cArray = this.reducedForm != null ? this.reducedForm : this.source;
        int n = cArray.length;
        int n2 = n - 1;
        int n3 = 10;
        int n4 = 0;
        if (cArray[0] == '0') {
            if (n2 == 1) {
                this.constant = LongConstant.fromValue(0L);
                return;
            }
            if (cArray[1] == 'x' || cArray[1] == 'X') {
                n3 = 16;
                n4 = 2;
            } else if (cArray[1] == 'b' || cArray[1] == 'B') {
                n3 = 2;
                n4 = 2;
            } else {
                n3 = 8;
                n4 = 1;
            }
        }
        switch (n3) {
            case 2: {
                if (n2 - 2 > 64) {
                    return;
                }
                this.computeValue(cArray, n2, n3, n4);
                break;
            }
            case 16: {
                if (n > 19) break;
                if (CharOperation.equals(cArray, HEXA_MINUS_ONE_VALUE)) {
                    this.constant = LongConstant.fromValue(-1L);
                    return;
                }
                this.computeValue(cArray, n2, n3, n4);
                break;
            }
            case 10: {
                if (n > DECIMAL_MAX_VALUE.length || n == DECIMAL_MAX_VALUE.length && CharOperation.compareTo(cArray, DECIMAL_MAX_VALUE, 0, n2) > 0) {
                    return;
                }
                this.computeValue(cArray, n2, n3, n4);
                break;
            }
            case 8: {
                if (n > 24) break;
                if (n == 24 && cArray[n4] > '1') {
                    return;
                }
                if (CharOperation.equals(cArray, OCTAL_MINUS_ONE_VALUE)) {
                    this.constant = LongConstant.fromValue(-1L);
                    return;
                }
                this.computeValue(cArray, n2, n3, n4);
            }
        }
    }

    private void computeValue(char[] cArray, int n, int n2, int n3) {
        long l = 0L;
        while (n3 < n) {
            int n4;
            if ((n4 = ScannerHelper.digit(cArray[n3++], n2)) < 0) {
                return;
            }
            l = l * (long)n2 + (long)n4;
        }
        this.constant = LongConstant.fromValue(l);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope blockScope) {
        return TypeBinding.LONG;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

