/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.IPolyExpression;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.ExceptionInferenceFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambdaExpression
extends FunctionalExpression
implements IPolyExpression,
ReferenceContext,
ProblemSeverities {
    public Argument[] arguments;
    private TypeBinding[] argumentTypes;
    public int arrowPosition;
    public Statement body;
    public boolean hasParentheses;
    public MethodScope scope;
    boolean voidCompatible = true;
    boolean valueCompatible = false;
    boolean returnsValue;
    public boolean isSerializable;
    private boolean requiresGenericSignature;
    boolean returnsVoid;
    public LambdaExpression original = this;
    public SyntheticArgumentBinding[] outerLocalVariables = NO_SYNTHETIC_ARGUMENTS;
    private int outerLocalVariablesSlotSize = 0;
    public boolean shouldCaptureInstance = false;
    private boolean assistNode = false;
    private boolean hasIgnoredMandatoryErrors = false;
    private ReferenceBinding classType;
    public int ordinal;
    private Set thrownExceptions;
    public char[] text;
    private static final SyntheticArgumentBinding[] NO_SYNTHETIC_ARGUMENTS = new SyntheticArgumentBinding[0];
    private static final Block NO_BODY = new Block(0);
    private HashMap<TypeBinding, LambdaExpression> copiesPerTargetType;
    protected Expression[] resultExpressions = NO_EXPRESSIONS;
    public InferenceContext18 inferenceContext;

    public LambdaExpression(CompilationResult compilationResult, boolean bl, boolean bl2) {
        super(compilationResult);
        this.assistNode = bl;
        this.requiresGenericSignature = bl2;
        this.setArguments(NO_ARGUMENTS);
        this.setBody(NO_BODY);
    }

    public LambdaExpression(CompilationResult compilationResult, boolean bl) {
        this(compilationResult, bl, false);
    }

    public void setArguments(Argument[] argumentArray) {
        this.arguments = argumentArray != null ? argumentArray : ASTNode.NO_ARGUMENTS;
        this.argumentTypes = new TypeBinding[argumentArray != null ? argumentArray.length : 0];
    }

    public Argument[] arguments() {
        return this.arguments;
    }

    public TypeBinding[] argumentTypes() {
        return this.argumentTypes;
    }

    public void setBody(Statement statement) {
        this.body = statement == null ? NO_BODY : statement;
    }

    public Statement body() {
        return this.body;
    }

    public Expression[] resultExpressions() {
        return this.resultExpressions;
    }

    public void setArrowPosition(int n) {
        this.arrowPosition = n;
    }

    public int arrowPosition() {
        return this.arrowPosition;
    }

    protected FunctionalExpression original() {
        return this.original;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        this.binding.modifiers = this.shouldCaptureInstance ? (this.binding.modifiers &= 0xFFFFFFF7) : (this.binding.modifiers |= 8);
        SourceTypeBinding sourceTypeBinding = blockScope.enclosingSourceType();
        boolean bl2 = !(this.binding instanceof SyntheticMethodBinding);
        this.binding = sourceTypeBinding.addSyntheticMethod(this);
        int n = codeStream.position;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if (this.shouldCaptureInstance) {
            codeStream.aload_0();
            stringBuffer.append(sourceTypeBinding.signature());
        }
        int n2 = 0;
        int n3 = this.outerLocalVariables == null ? 0 : this.outerLocalVariables.length;
        while (n2 < n3) {
            SyntheticArgumentBinding syntheticArgumentBinding = this.outerLocalVariables[n2];
            if (this.shouldCaptureInstance && bl2) {
                syntheticArgumentBinding.resolvedPosition = syntheticArgumentBinding.resolvedPosition + 1;
            }
            stringBuffer.append(syntheticArgumentBinding.type.signature());
            LocalVariableBinding localVariableBinding = syntheticArgumentBinding.actualOuterLocalVariable;
            Object[] objectArray = blockScope.getEmulationPath(localVariableBinding);
            codeStream.generateOuterAccess(objectArray, this, localVariableBinding, blockScope);
            ++n2;
        }
        stringBuffer.append(')');
        if (this.expectedType instanceof IntersectionTypeBinding18) {
            stringBuffer.append(((IntersectionTypeBinding18)this.expectedType).getSAMType(blockScope).signature());
        } else {
            stringBuffer.append(this.expectedType.signature());
        }
        n2 = codeStream.classFile.recordBootstrapMethod(this);
        codeStream.invokeDynamic(n2, (this.shouldCaptureInstance ? 1 : 0) + this.outerLocalVariablesSlotSize, 1, this.descriptor.selector, stringBuffer.toString().toCharArray());
        if (!bl) {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public boolean kosherDescriptor(Scope scope, MethodBinding methodBinding, boolean bl) {
        if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
            if (bl) {
                scope.problemReporter().lambdaExpressionCannotImplementGenericMethod(this, methodBinding);
            }
            return false;
        }
        return super.kosherDescriptor(scope, methodBinding, bl);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        ReferenceBinding[] referenceBindingArray;
        Argument argument;
        Argument argument2;
        Object object;
        int n;
        boolean bl;
        int n2;
        boolean bl2 = this.argumentsTypeElided();
        int n3 = n2 = this.arguments == null ? 0 : this.arguments.length;
        if (this.constant != Constant.NotAConstant) {
            this.constant = Constant.NotAConstant;
            this.enclosingScope = blockScope;
            if (this.original == this) {
                this.ordinal = this.recordFunctionalType(blockScope);
            }
            if (!bl2) {
                int n4 = 0;
                while (n4 < n2) {
                    this.argumentTypes[n4] = this.arguments[n4].type.resolveType(blockScope, true);
                    ++n4;
                }
            }
            if (this.expectedType == null && this.expressionContext == ExpressionContext.INVOCATION_CONTEXT) {
                return new PolyTypeBinding(this);
            }
        }
        MethodScope methodScope = blockScope.methodScope();
        this.scope = new MethodScope(blockScope, this, methodScope.isStatic, methodScope.lastVisibleFieldID);
        this.scope.isConstructorCall = methodScope.isConstructorCall;
        super.resolveType(blockScope);
        boolean bl3 = bl = this.descriptor != null;
        if (!bl || this.descriptor.typeVariables != Binding.NO_TYPE_VARIABLES) {
            this.resolvedType = null;
            return null;
        }
        this.binding = new MethodBinding(0x2001002, CharOperation.concat(TypeConstants.ANONYMOUS_METHOD, Integer.toString(this.ordinal).toCharArray()), bl ? this.descriptor.returnType : TypeBinding.VOID, Binding.NO_PARAMETERS, bl ? this.descriptor.thrownExceptions : Binding.NO_EXCEPTIONS, blockScope.enclosingSourceType());
        this.binding.typeVariables = Binding.NO_TYPE_VARIABLES;
        boolean bl4 = false;
        if (bl && (n = this.descriptor.parameters.length) != n2) {
            this.scope.problemReporter().lambdaSignatureMismatched(this);
            if (bl2 || this.original != this) {
                this.resolvedType = null;
                return null;
            }
            this.resolvedType = null;
            bl4 = true;
        }
        TypeBinding[] typeBindingArray = new TypeBinding[n2];
        AnnotationBinding[][] annotationBindingArrayArray = null;
        int n5 = 0;
        while (n5 < n2) {
            object = this.arguments[n5];
            if (((Argument)object).isVarArgs()) {
                if (n5 == n2 - 1) {
                    this.binding.modifiers |= 0x80;
                } else {
                    this.scope.problemReporter().illegalVarargInLambda((Argument)object);
                    bl4 = true;
                }
            }
            argument2 = bl && n5 < this.descriptor.parameters.length ? this.descriptor.parameters[n5] : null;
            Argument argument3 = argument = bl2 ? argument2 : this.argumentTypes[n5];
            if (argument == null) {
                bl4 = true;
            } else if (argument == TypeBinding.VOID) {
                this.scope.problemReporter().argumentTypeCannotBeVoid(this, (Argument)object);
                bl4 = true;
            } else {
                if (!((Binding)((Object)argument)).isValidBinding()) {
                    this.binding.tagBits |= 0x200L;
                }
                if ((((TypeBinding)((Object)argument)).tagBits & 0x80L) != 0L) {
                    this.binding.tagBits |= 0x80L;
                }
            }
            ++n5;
        }
        if (!bl2 && !bl4) {
            ReferenceBinding referenceBinding = null;
            object = null;
            if (this.expectedType instanceof IntersectionTypeBinding18) {
                object = (ReferenceBinding)((IntersectionTypeBinding18)this.expectedType).getSAMType(blockScope);
            } else if (this.expectedType instanceof ReferenceBinding) {
                object = (ReferenceBinding)this.expectedType;
            }
            if (object != null) {
                referenceBinding = this.findGroundTargetType(blockScope, (TypeBinding)object, bl2);
            }
            if (referenceBinding != null) {
                this.descriptor = referenceBinding.getSingleAbstractMethod(blockScope, true);
                if (!this.descriptor.isValidBinding()) {
                    this.reportSamProblem(blockScope, this.descriptor);
                } else {
                    if (referenceBinding != object && !referenceBinding.isCompatibleWith((TypeBinding)object, this.scope)) {
                        blockScope.problemReporter().typeMismatchError((TypeBinding)referenceBinding, this.expectedType, this, null);
                        this.resolvedType = null;
                        return null;
                    }
                    this.resolvedType = referenceBinding;
                }
            }
        }
        boolean bl5 = this.requiresGenericSignature || blockScope.compilerOptions().generateGenericSignatureForLambdaExpressions;
        int n6 = 0;
        while (n6 < n2) {
            argument = this.arguments[n6];
            referenceBindingArray = bl && n6 < this.descriptor.parameters.length ? this.descriptor.parameters[n6] : null;
            Argument argument4 = argument2 = bl2 ? referenceBindingArray : this.argumentTypes[n6];
            if (argument2 != null && argument2 != TypeBinding.VOID) {
                TypeBinding typeBinding;
                if (bl && referenceBindingArray != null && ((Binding)((Object)argument2)).isValidBinding() && TypeBinding.notEquals((TypeBinding)((Object)argument2), (TypeBinding)referenceBindingArray) && referenceBindingArray.isProperType(true)) {
                    this.scope.problemReporter().lambdaParameterTypeMismatched(argument, argument.type, (TypeBinding)referenceBindingArray);
                    this.resolvedType = null;
                }
                if (bl5 && (typeBinding = ((TypeBinding)((Object)argument2)).leafComponentType()) instanceof ReferenceBinding && (((ReferenceBinding)typeBinding).modifiers & 0x40000000) != 0) {
                    this.binding.modifiers |= 0x40000000;
                }
                typeBindingArray[n6] = argument.bind(this.scope, (TypeBinding)((Object)argument2), false);
                if (argument.annotations != null) {
                    this.binding.tagBits |= 0x400L;
                    if (annotationBindingArrayArray == null) {
                        annotationBindingArrayArray = new AnnotationBinding[n2][];
                        int n7 = 0;
                        while (n7 < n6) {
                            annotationBindingArrayArray[n7] = Binding.NO_ANNOTATIONS;
                            ++n7;
                        }
                    }
                    annotationBindingArrayArray[n6] = argument.binding.getAnnotations();
                } else if (annotationBindingArrayArray != null) {
                    annotationBindingArrayArray[n6] = Binding.NO_ANNOTATIONS;
                }
            }
            ++n6;
        }
        if (!bl4) {
            this.binding.parameters = typeBindingArray;
            if (annotationBindingArrayArray != null) {
                this.binding.setParameterAnnotations(annotationBindingArrayArray);
            }
        }
        if (!bl2 && this.binding.isVarargs() && !this.binding.parameters[this.binding.parameters.length - 1].isReifiable()) {
            this.scope.problemReporter().possibleHeapPollutionFromVararg(this.arguments[this.arguments.length - 1]);
        }
        ReferenceBinding[] referenceBindingArray2 = this.binding.thrownExceptions;
        int n8 = referenceBindingArray2.length;
        int n9 = 0;
        while (n9 < n8) {
            referenceBindingArray = referenceBindingArray2[n9];
            if ((referenceBindingArray.tagBits & 0x80L) != 0L) {
                this.binding.tagBits |= 0x80L;
            }
            if (bl5) {
                this.binding.modifiers |= referenceBindingArray.modifiers & 0x40000000;
            }
            ++n9;
        }
        TypeBinding typeBinding = this.binding.returnType;
        if (typeBinding != null) {
            if ((typeBinding.tagBits & 0x80L) != 0L) {
                this.binding.tagBits |= 0x80L;
            }
            if (bl5 && (referenceBindingArray = typeBinding.leafComponentType()) instanceof ReferenceBinding && (((ReferenceBinding)referenceBindingArray).modifiers & 0x40000000) != 0) {
                this.binding.modifiers |= 0x40000000;
            }
        }
        if (bl && !bl4 && blockScope.compilerOptions().isAnnotationBasedNullAnalysisEnabled) {
            if (!bl2) {
                AbstractMethodDeclaration.createArgumentBindings(this.arguments, this.binding, this.scope);
                this.mergeParameterNullAnnotations(blockScope);
            }
            this.binding.tagBits |= this.descriptor.tagBits & 0x180000000000000L;
        }
        this.binding.modifiers &= 0xFDFFFFFF;
        if (this.body instanceof Expression) {
            referenceBindingArray = (Expression)this.body;
            new ReturnStatement((Expression)referenceBindingArray, referenceBindingArray.sourceStart, referenceBindingArray.sourceEnd, true).resolve(this.scope);
        } else {
            this.body.resolve(this.scope);
            if (!this.returnsVoid && !this.returnsValue) {
                this.valueCompatible = this.body.doesNotCompleteNormally();
            }
        }
        if (this.expectedType instanceof IntersectionTypeBinding18) {
            referenceBindingArray = ((IntersectionTypeBinding18)this.expectedType).intersectingTypes;
            int n10 = 0;
            int n11 = referenceBindingArray.length;
            while (n10 < n11) {
                if (referenceBindingArray[n10].findSuperTypeOriginatingFrom(37, false) != null) {
                    this.isSerializable = true;
                    break;
                }
                ++n10;
            }
        } else if (this.expectedType != null && this.expectedType.findSuperTypeOriginatingFrom(37, false) != null) {
            this.isSerializable = true;
        }
        if ((this.binding.tagBits & 0x80L) != 0L) {
            this.scope.problemReporter().missingTypeInLambda(this, this.binding);
        }
        if (this.shouldCaptureInstance && this.scope.isConstructorCall) {
            this.scope.problemReporter().fieldsOrThisBeforeConstructorInvocation(this);
        }
        return bl4 ? (this.resolvedType = null) : this.resolvedType;
    }

    private ReferenceBinding findGroundTargetType(BlockScope blockScope, TypeBinding typeBinding, boolean bl) {
        if (typeBinding instanceof IntersectionTypeBinding18) {
            typeBinding = ((IntersectionTypeBinding18)typeBinding).getSAMType(blockScope);
        }
        if (typeBinding instanceof ReferenceBinding && typeBinding.isValidBinding()) {
            ParameterizedTypeBinding parameterizedTypeBinding = InferenceContext18.parameterizedWithWildcard(typeBinding);
            if (parameterizedTypeBinding != null) {
                if (!bl) {
                    return new InferenceContext18(blockScope).inferFunctionalInterfaceParameterization(this, blockScope, parameterizedTypeBinding);
                }
                return this.findGroundTargetTypeForElidedLambda(blockScope, parameterizedTypeBinding);
            }
            return (ReferenceBinding)typeBinding;
        }
        return null;
    }

    public ReferenceBinding findGroundTargetTypeForElidedLambda(BlockScope blockScope, ParameterizedTypeBinding parameterizedTypeBinding) {
        TypeBinding[] typeBindingArray = parameterizedTypeBinding.getNonWildcardParameterization(blockScope);
        if (typeBindingArray == null) {
            return null;
        }
        ReferenceBinding referenceBinding = parameterizedTypeBinding.genericType();
        return blockScope.environment().createParameterizedType(referenceBinding, typeBindingArray, parameterizedTypeBinding.enclosingType());
    }

    @Override
    public boolean argumentsTypeElided() {
        return this.arguments.length > 0 && this.arguments[0].hasElidedType();
    }

    private void analyzeExceptions() {
        try {
            ExceptionInferenceFlowContext exceptionInferenceFlowContext = new ExceptionInferenceFlowContext(null, this, Binding.NO_EXCEPTIONS, null, this.scope, FlowInfo.DEAD_END);
            this.body.analyseCode(this.scope, exceptionInferenceFlowContext, UnconditionalFlowInfo.fakeInitializedFlowInfo(this.scope.outerMostMethodScope().analysisIndex, this.scope.referenceType().maxFieldCount));
            this.thrownExceptions = exceptionInferenceFlowContext.extendedExceptions == null ? Collections.emptySet() : new HashSet(exceptionInferenceFlowContext.extendedExceptions);
        }
        catch (Exception exception) {}
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return flowInfo;
        }
        FlowInfo flowInfo2 = flowInfo.copy();
        ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(flowContext, this, this.binding.thrownExceptions, flowContext.getInitializationContext(), this.scope, FlowInfo.DEAD_END);
        MethodBinding methodBinding = this.argumentsTypeElided() ? this.descriptor : this.binding;
        AbstractMethodDeclaration.analyseArguments18(flowInfo2, this.arguments, methodBinding);
        if (this.arguments != null) {
            int n = 0;
            int n2 = this.arguments.length;
            while (n < n2) {
                this.bits |= this.arguments[n].bits & 0x100000;
                ++n;
            }
        }
        flowInfo2 = this.body.analyseCode(this.scope, exceptionHandlingFlowContext, flowInfo2);
        if (this.body instanceof Block) {
            TypeBinding typeBinding = this.expectedResultType();
            if (typeBinding == TypeBinding.VOID) {
                if ((flowInfo2.tagBits & 1) == 0 || ((Block)this.body).statements == null) {
                    this.bits |= 0x40;
                }
            } else if (flowInfo2 != FlowInfo.DEAD_END) {
                this.scope.problemReporter().shouldReturn(typeBinding, this);
            }
        } else if (blockScope.compilerOptions().isAnnotationBasedNullAnalysisEnabled && flowInfo2.reachMode() == 0) {
            Expression expression = (Expression)this.body;
            this.checkAgainstNullAnnotation(flowContext, expression, flowInfo, expression.nullStatus(flowInfo2, flowContext));
        }
        return flowInfo;
    }

    void validateNullAnnotations() {
        if (this.binding != null) {
            int n = this.binding.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                if (!this.scope.validateNullAnnotation(this.binding.returnType.tagBits, this.arguments[n2].type, this.arguments[n2].annotations)) {
                    this.binding.returnType = this.binding.returnType.withoutToplevelNullAnnotation();
                }
                ++n2;
            }
        }
    }

    private void mergeParameterNullAnnotations(BlockScope blockScope) {
        LookupEnvironment lookupEnvironment = blockScope.environment();
        TypeBinding[] typeBindingArray = this.binding.parameters;
        TypeBinding[] typeBindingArray2 = this.descriptor.parameters;
        int n = Math.min(typeBindingArray.length, typeBindingArray2.length);
        int n2 = 0;
        while (n2 < n) {
            Object object;
            long l = typeBindingArray[n2].tagBits & 0x180000000000000L;
            long l2 = typeBindingArray2[n2].tagBits & 0x180000000000000L;
            if (l == 0L) {
                if (l2 != 0L && !typeBindingArray[n2].isBaseType()) {
                    object = typeBindingArray2[n2].getTypeAnnotations();
                    int n3 = 0;
                    int n4 = ((AnnotationBinding[])object).length;
                    while (n3 < n4) {
                        AnnotationBinding annotationBinding = object[n3];
                        if (annotationBinding != null) {
                            switch (annotationBinding.getAnnotationType().id) {
                                case 65: 
                                case 66: {
                                    typeBindingArray[n2] = lookupEnvironment.createAnnotatedType(typeBindingArray[n2], new AnnotationBinding[]{annotationBinding});
                                }
                            }
                        }
                        ++n3;
                    }
                }
            } else if (l != l2 && l == 0x100000000000000L) {
                object = null;
                if (l2 == 0x80000000000000L) {
                    object = lookupEnvironment.getNullableAnnotationName();
                }
                blockScope.problemReporter().illegalRedefinitionToNonNullParameter(this.arguments[n2], this.descriptor.declaringClass, (char[][])object);
            }
            ++n2;
        }
    }

    void checkAgainstNullAnnotation(FlowContext flowContext, Expression expression, FlowInfo flowInfo, int n) {
        if (n != 4 && (this.descriptor.returnType.tagBits & 0x100000000000000L) != 0L) {
            flowContext.recordNullityMismatch(this.scope, expression, expression.resolvedType, this.descriptor.returnType, flowInfo, n, null);
        }
    }

    @Override
    public boolean isPertinentToApplicability(TypeBinding typeBinding, MethodBinding methodBinding) {
        if (typeBinding == null) {
            return true;
        }
        if (this.argumentsTypeElided()) {
            return false;
        }
        if (!super.isPertinentToApplicability(typeBinding, methodBinding)) {
            return false;
        }
        if (this.body instanceof Expression) {
            if (!((Expression)this.body).isPertinentToApplicability(typeBinding, methodBinding)) {
                return false;
            }
        } else {
            Expression[] expressionArray = this.resultExpressions;
            int n = 0;
            int n2 = expressionArray.length;
            while (n < n2) {
                if (!expressionArray[n].isPertinentToApplicability(typeBinding, methodBinding)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public boolean isVoidCompatible() {
        return this.voidCompatible;
    }

    public boolean isValueCompatible() {
        return this.valueCompatible;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return this.printExpression(n, stringBuffer, false);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer, boolean bl) {
        int n2 = (this.bits & 0x1FE00000) >> 21;
        String string = "";
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append('(');
            string = String.valueOf(string) + ')';
            ++n3;
        }
        stringBuffer.append('(');
        if (this.arguments != null) {
            n3 = 0;
            while (n3 < this.arguments.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n3].print(0, stringBuffer);
                ++n3;
            }
        }
        stringBuffer.append(") -> ");
        if (bl) {
            stringBuffer.append("{}");
        } else if (this.body != null) {
            this.body.print(this.body instanceof Block ? n : 0, stringBuffer);
        } else {
            stringBuffer.append("<@incubator>");
        }
        return stringBuffer.append(string);
    }

    public TypeBinding expectedResultType() {
        return this.descriptor != null && this.descriptor.isValidBinding() ? this.descriptor.returnType : null;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.arguments != null) {
                int n = this.arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    this.arguments[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
            if (this.body != null) {
                this.body.traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public MethodScope getScope() {
        return this.scope;
    }

    private boolean enclosingScopesHaveErrors() {
        Scope scope = this.enclosingScope;
        while (scope != null) {
            ReferenceContext referenceContext = scope.referenceContext();
            if (referenceContext != null && referenceContext.hasErrors()) {
                return true;
            }
            scope = scope.parent;
        }
        return false;
    }

    private void analyzeShape() {
        if (this.body instanceof Expression) {
            this.voidCompatible = this.assistNode ? true : ((Expression)this.body).statementExpression();
            this.valueCompatible = true;
        } else {
            if (this.assistNode) {
                this.voidCompatible = true;
                this.valueCompatible = true;
            }
            class ShapeComputer
            extends ASTVisitor {
                ShapeComputer() {
                }

                public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
                    return false;
                }

                public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
                    return false;
                }

                public boolean visit(LambdaExpression lambdaExpression, BlockScope blockScope) {
                    return false;
                }

                public boolean visit(ReturnStatement returnStatement, BlockScope blockScope) {
                    if (returnStatement.expression != null) {
                        LambdaExpression.this.valueCompatible = true;
                        LambdaExpression.this.voidCompatible = false;
                        LambdaExpression.this.returnsValue = true;
                    } else {
                        LambdaExpression.this.voidCompatible = true;
                        LambdaExpression.this.valueCompatible = false;
                        LambdaExpression.this.returnsVoid = true;
                    }
                    return false;
                }
            }
            this.body.traverse(new ShapeComputer(), null);
            if (!this.returnsValue && !this.returnsVoid) {
                this.valueCompatible = this.body.doesNotCompleteNormally();
            }
        }
    }

    @Override
    public boolean isPotentiallyCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (!super.isPertinentToApplicability(typeBinding, null)) {
            return true;
        }
        MethodBinding methodBinding = typeBinding.getSingleAbstractMethod(scope, true);
        if (methodBinding == null || !methodBinding.isValidBinding()) {
            return false;
        }
        if (methodBinding.parameters.length != this.arguments.length) {
            return false;
        }
        this.analyzeShape();
        return !(methodBinding.returnType.id == 6 ? !this.voidCompatible : !this.valueCompatible);
    }

    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (!super.isPertinentToApplicability(typeBinding, null)) {
            return true;
        }
        LambdaExpression lambdaExpression = null;
        try {
            lambdaExpression = this.cachedResolvedCopy(typeBinding, this.argumentsTypeElided(), false, null);
        }
        catch (CopyFailureException copyFailureException) {
            if (this.assistNode) {
                return true;
            }
            return !this.isPertinentToApplicability(typeBinding, null);
        }
        if (lambdaExpression == null) {
            return false;
        }
        typeBinding = this.findGroundTargetType(this.enclosingScope, typeBinding, this.argumentsTypeElided());
        MethodBinding methodBinding = typeBinding.getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding.returnType.id == 6 ? !lambdaExpression.voidCompatible : !lambdaExpression.valueCompatible) {
            return false;
        }
        if (!this.isPertinentToApplicability(typeBinding, null)) {
            return true;
        }
        Expression[] expressionArray = lambdaExpression.resultExpressions;
        int n = 0;
        int n2 = expressionArray.length;
        while (n < n2) {
            if (this.enclosingScope.parameterCompatibilityLevel(expressionArray[n].resolvedType, methodBinding.returnType) == -1 && !expressionArray[n].isConstantValueOfTypeAssignableToType(expressionArray[n].resolvedType, methodBinding.returnType) && (methodBinding.returnType.id != 6 || this.body instanceof Block)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private LambdaExpression cachedResolvedCopy(TypeBinding typeBinding, boolean bl, boolean bl2, InferenceContext18 inferenceContext18) {
        if ((typeBinding = this.findGroundTargetType(this.enclosingScope, typeBinding, this.argumentsTypeElided())) == null) {
            return null;
        }
        MethodBinding methodBinding = typeBinding.getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding == null || !methodBinding.isValidBinding()) {
            return null;
        }
        if (methodBinding.parameters.length != this.arguments.length) {
            return null;
        }
        LambdaExpression lambdaExpression = null;
        if (this.copiesPerTargetType != null && (lambdaExpression = this.copiesPerTargetType.get(typeBinding)) == null && bl && this.copiesPerTargetType.values().size() > 0) {
            lambdaExpression = this.copiesPerTargetType.values().iterator().next();
        }
        CompilerOptions compilerOptions = this.enclosingScope.compilerOptions();
        boolean bl3 = compilerOptions.isAnnotationBasedNullAnalysisEnabled;
        IErrorHandlingPolicy iErrorHandlingPolicy = this.enclosingScope.problemReporter().switchErrorHandlingPolicy(silentErrorHandlingPolicy);
        compilerOptions.isAnnotationBasedNullAnalysisEnabled = false;
        try {
            if (lambdaExpression == null) {
                lambdaExpression = this.copy();
                if (lambdaExpression == null) {
                    throw new CopyFailureException();
                }
                lambdaExpression.setExpressionContext(this.expressionContext);
                lambdaExpression.setExpectedType(typeBinding);
                lambdaExpression.inferenceContext = inferenceContext18;
                TypeBinding typeBinding2 = lambdaExpression.resolveType(this.enclosingScope);
                if (typeBinding2 == null || !typeBinding2.isValidBinding()) {
                    return null;
                }
                if (this.copiesPerTargetType == null) {
                    this.copiesPerTargetType = new HashMap();
                }
                this.copiesPerTargetType.put(typeBinding, lambdaExpression);
            }
            if (!bl2) {
                LambdaExpression lambdaExpression2 = lambdaExpression;
                return lambdaExpression2;
            }
            if (lambdaExpression.thrownExceptions == null && !lambdaExpression.hasIgnoredMandatoryErrors && !this.enclosingScopesHaveErrors()) {
                lambdaExpression.analyzeExceptions();
            }
            LambdaExpression lambdaExpression3 = lambdaExpression;
            return lambdaExpression3;
        }
        finally {
            compilerOptions.isAnnotationBasedNullAnalysisEnabled = bl3;
            this.enclosingScope.problemReporter().switchErrorHandlingPolicy(iErrorHandlingPolicy);
        }
    }

    @Override
    public LambdaExpression resolveExpressionExpecting(TypeBinding typeBinding, Scope scope, InferenceContext18 inferenceContext18) {
        LambdaExpression lambdaExpression = null;
        try {
            lambdaExpression = this.cachedResolvedCopy(typeBinding, false, true, inferenceContext18);
        }
        catch (CopyFailureException copyFailureException) {
            return null;
        }
        return lambdaExpression;
    }

    @Override
    public boolean sIsMoreSpecific(TypeBinding typeBinding, TypeBinding typeBinding2, Scope scope) {
        int n;
        int n2;
        if (super.sIsMoreSpecific(typeBinding, typeBinding2, scope)) {
            return true;
        }
        if (this.argumentsTypeElided() || typeBinding2.findSuperTypeOriginatingFrom(typeBinding) != null) {
            return false;
        }
        MethodBinding methodBinding = (typeBinding = typeBinding.capture(this.enclosingScope, this.sourceStart, this.sourceEnd)).getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding == null || !methodBinding.isValidBinding()) {
            return false;
        }
        TypeBinding typeBinding3 = methodBinding.returnType;
        MethodBinding methodBinding2 = typeBinding2.getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding2 == null || !methodBinding2.isValidBinding()) {
            return true;
        }
        TypeBinding typeBinding4 = methodBinding2.returnType;
        if (typeBinding4.id == 6) {
            return true;
        }
        if (typeBinding3.id == 6) {
            return false;
        }
        if (typeBinding3.isCompatibleWith(typeBinding4, scope)) {
            return true;
        }
        LambdaExpression lambdaExpression = this.cachedResolvedCopy(typeBinding, true, false, null);
        Expression[] expressionArray = lambdaExpression.resultExpressions;
        int n3 = n2 = expressionArray == null ? 0 : expressionArray.length;
        if (typeBinding3.isBaseType() && !typeBinding4.isBaseType()) {
            n = 0;
            while (n < n2) {
                if (expressionArray[n].isPolyExpression() || !expressionArray[n].resolvedType.isBaseType()) break;
                ++n;
            }
            if (n == n2) {
                return true;
            }
        }
        if (!typeBinding3.isBaseType() && typeBinding4.isBaseType()) {
            n = 0;
            while (n < n2) {
                if (expressionArray[n].resolvedType.isBaseType()) break;
                ++n;
            }
            if (n == n2) {
                return true;
            }
        }
        if (typeBinding3.isFunctionalInterface(this.enclosingScope) && typeBinding4.isFunctionalInterface(this.enclosingScope)) {
            n = 0;
            while (n < n2) {
                Expression expression = expressionArray[n];
                if (!expression.sIsMoreSpecific(typeBinding3, typeBinding4, scope)) break;
                ++n;
            }
            if (n == n2) {
                return true;
            }
        }
        return false;
    }

    LambdaExpression copy() {
        ICompilationUnit iCompilationUnit;
        char[] cArray;
        Parser parser = new Parser(this.enclosingScope.problemReporter(), false);
        LambdaExpression lambdaExpression = (LambdaExpression)parser.parseLambdaExpression(cArray = (iCompilationUnit = this.compilationResult.getCompilationUnit()) != null ? iCompilationUnit.getContents() : this.text, iCompilationUnit != null ? this.sourceStart : 0, this.sourceEnd - this.sourceStart + 1, this.enclosingScope.referenceCompilationUnit(), false);
        if (lambdaExpression != null) {
            lambdaExpression.original = this;
            lambdaExpression.assistNode = this.assistNode;
            lambdaExpression.enclosingScope = this.enclosingScope;
        }
        return lambdaExpression;
    }

    public void returnsExpression(Expression expression, TypeBinding typeBinding) {
        if (this.original == this) {
            return;
        }
        if (this.body instanceof Expression) {
            this.valueCompatible = typeBinding == null || typeBinding.id != 6;
            this.voidCompatible = this.assistNode ? true : ((Expression)this.body).statementExpression();
            this.resultExpressions = new Expression[]{expression};
            return;
        }
        if (expression != null) {
            this.returnsValue = true;
            this.voidCompatible = false;
            this.valueCompatible = !this.returnsVoid;
            Expression[] expressionArray = this.resultExpressions;
            int n = expressionArray.length;
            Expression[] expressionArray2 = expressionArray;
            expressionArray = new Expression[n + 1];
            System.arraycopy(expressionArray2, 0, expressionArray, 0, n);
            expressionArray[n] = expression;
            this.resultExpressions = expressionArray;
        } else {
            this.returnsVoid = true;
            this.valueCompatible = false;
            this.voidCompatible = !this.returnsValue;
        }
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    @Override
    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, categorizedProblem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
            }
            case 8: {
                throw new AbortType(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortMethod(this.compilationResult, categorizedProblem);
    }

    @Override
    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        return this.enclosingScope == null ? null : this.enclosingScope.compilationUnitScope().referenceContext;
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
        Scope scope = this.enclosingScope.parent;
        while (scope != null) {
            switch (scope.kind) {
                case 2: 
                case 3: {
                    scope.referenceContext().tagAsHavingErrors();
                    return;
                }
            }
            scope = scope.parent;
        }
    }

    @Override
    public void tagAsHavingIgnoredMandatoryErrors(int n) {
        switch (n) {
            case 16777362: 
            case 16777384: 
            case 16778098: {
                return;
            }
            case 99: 
            case 0x1000013: 
            case 16778111: 
            case 67108969: 
            case 0x4000303: 
            case 553648781: 
            case 553648783: 
            case 553648784: 
            case 553648785: 
            case 553648786: 
            case 553648787: 
            case 603979884: {
                return;
            }
        }
        this.hasIgnoredMandatoryErrors = true;
        MethodScope methodScope = this.scope == null ? null : this.scope.enclosingLambdaScope();
        while (methodScope != null) {
            LambdaExpression lambdaExpression = (LambdaExpression)methodScope.referenceContext;
            lambdaExpression.hasIgnoredMandatoryErrors = true;
            methodScope = methodScope.enclosingLambdaScope();
        }
    }

    public Set<TypeBinding> getThrownExceptions() {
        if (this.thrownExceptions == null) {
            return Collections.emptySet();
        }
        return this.thrownExceptions;
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int n = 0;
        classFile.codeStream.wideMode = false;
        boolean bl = false;
        do {
            try {
                n = classFile.contentsOffset;
                this.generateCode(classFile);
                bl = false;
            }
            catch (AbortMethod abortMethod) {
                if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetInWideMode();
                    bl = true;
                    continue;
                }
                if (abortMethod.compilationResult == CodeStream.RESTART_CODE_GEN_FOR_UNUSED_LOCALS_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetForCodeGenUnusedLocals();
                    bl = true;
                    continue;
                }
                throw new AbortType(this.compilationResult, abortMethod.problem);
            }
        } while (bl);
    }

    public void generateCode(ClassFile classFile) {
        LocalVariableBinding localVariableBinding;
        int n;
        int n2;
        classFile.generateMethodInfoHeader(this.binding);
        int n3 = classFile.contentsOffset;
        int n4 = classFile.generateMethodInfoAttributes(this.binding);
        int n5 = classFile.contentsOffset;
        classFile.generateCodeAttributeHeader();
        CodeStream codeStream = classFile.codeStream;
        codeStream.reset(this, classFile);
        this.scope.computeLocalVariablePositions(this.outerLocalVariablesSlotSize + (this.binding.isStatic() ? 0 : 1), codeStream);
        if (this.outerLocalVariables != null) {
            n2 = 0;
            n = this.outerLocalVariables.length;
            while (n2 < n) {
                localVariableBinding = this.outerLocalVariables[n2];
                codeStream.addVisibleLocalVariable(localVariableBinding);
                codeStream.record(localVariableBinding);
                localVariableBinding.recordInitializationStartPC(0);
                ++n2;
            }
        }
        if (this.arguments != null) {
            n2 = 0;
            n = this.arguments.length;
            while (n2 < n) {
                localVariableBinding = this.arguments[n2].binding;
                codeStream.addVisibleLocalVariable(localVariableBinding);
                localVariableBinding.recordInitializationStartPC(0);
                ++n2;
            }
        }
        if (this.body instanceof Block) {
            this.body.generateCode(this.scope, codeStream);
            if ((this.bits & 0x40) != 0) {
                codeStream.return_();
            }
        } else {
            Expression expression = (Expression)this.body;
            expression.generateCode(this.scope, codeStream, true);
            if (this.binding.returnType == TypeBinding.VOID) {
                codeStream.return_();
            } else {
                codeStream.generateReturnBytecode(expression);
            }
        }
        codeStream.exitUserScope(this.scope);
        codeStream.recordPositionsFrom(0, this.sourceEnd);
        try {
            classFile.completeCodeAttribute(n5);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
        }
        classFile.completeMethodInfo(this.binding, n3, ++n4);
    }

    public void addSyntheticArgument(LocalVariableBinding localVariableBinding) {
        if (this.original != this || this.binding == null) {
            return;
        }
        SyntheticArgumentBinding syntheticArgumentBinding = null;
        int n = this.outerLocalVariables.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.outerLocalVariables[n2].actualOuterLocalVariable == localVariableBinding) {
                return;
            }
            ++n2;
        }
        this.outerLocalVariables = new SyntheticArgumentBinding[n + 1];
        System.arraycopy(this.outerLocalVariables, 0, this.outerLocalVariables, 0, n);
        this.outerLocalVariables[n] = syntheticArgumentBinding = new SyntheticArgumentBinding(localVariableBinding);
        syntheticArgumentBinding.resolvedPosition = this.outerLocalVariablesSlotSize;
        syntheticArgumentBinding.declaringScope = this.scope;
        n2 = this.binding.parameters.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n2 + 1];
        typeBindingArray[n] = localVariableBinding.type;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            if (n3 == n) {
                ++n4;
            }
            typeBindingArray[n4] = this.binding.parameters[n3];
            ++n3;
            ++n4;
        }
        this.binding.parameters = typeBindingArray;
        switch (syntheticArgumentBinding.type.id) {
            case 7: 
            case 8: {
                this.outerLocalVariablesSlotSize += 2;
                break;
            }
            default: {
                ++this.outerLocalVariablesSlotSize;
            }
        }
    }

    public SyntheticArgumentBinding getSyntheticArgument(LocalVariableBinding localVariableBinding) {
        int n = 0;
        int n2 = this.outerLocalVariables == null ? 0 : this.outerLocalVariables.length;
        while (n < n2) {
            if (this.outerLocalVariables[n].actualOuterLocalVariable == localVariableBinding) {
                return this.outerLocalVariables[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public MethodBinding getMethodBinding() {
        if (this.actualMethodBinding == null) {
            if (this.binding != null) {
                TypeBinding[] typeBindingArray = null;
                if (this.binding instanceof SyntheticMethodBinding && this.outerLocalVariables.length > 0) {
                    typeBindingArray = new TypeBinding[this.binding.parameters.length - this.outerLocalVariables.length];
                    System.arraycopy(this.binding.parameters, this.outerLocalVariables.length, typeBindingArray, 0, typeBindingArray.length);
                } else {
                    typeBindingArray = this.binding.parameters;
                }
                this.actualMethodBinding = new MethodBinding(this.binding.modifiers, this.binding.selector, this.binding.returnType, typeBindingArray, this.binding.thrownExceptions, this.binding.declaringClass);
                this.actualMethodBinding.tagBits = this.binding.tagBits;
            } else {
                this.actualMethodBinding = new ProblemMethodBinding(CharOperation.NO_CHAR, null, 17);
            }
        }
        return this.actualMethodBinding;
    }

    @Override
    public int diagnosticsSourceEnd() {
        return this.body instanceof Block ? this.arrowPosition : this.sourceEnd;
    }

    public TypeBinding[] getMarkerInterfaces() {
        if (this.expectedType instanceof IntersectionTypeBinding18) {
            LinkedHashSet<ReferenceBinding> linkedHashSet = new LinkedHashSet<ReferenceBinding>();
            ReferenceBinding[] referenceBindingArray = ((IntersectionTypeBinding18)this.expectedType).intersectingTypes;
            int n = 0;
            int n2 = referenceBindingArray.length;
            while (n < n2) {
                ReferenceBinding referenceBinding = referenceBindingArray[n];
                MethodBinding methodBinding = ((TypeBinding)referenceBinding).getSingleAbstractMethod(this.scope, true);
                if (methodBinding instanceof ProblemMethodBinding && ((ProblemMethodBinding)methodBinding).problemId() == 17 && referenceBinding.id != 37) {
                    linkedHashSet.add(referenceBinding);
                }
                ++n;
            }
            if (linkedHashSet.size() > 0) {
                return linkedHashSet.toArray(new TypeBinding[linkedHashSet.size()]);
            }
        }
        return null;
    }

    public ReferenceBinding getTypeBinding() {
        if (this.classType != null || this.resolvedType == null) {
            return null;
        }
        class LambdaTypeBinding
        extends ReferenceBinding {
            LambdaTypeBinding() {
            }

            public MethodBinding[] methods() {
                return new MethodBinding[]{LambdaExpression.this.getMethodBinding()};
            }

            public char[] sourceName() {
                return TypeConstants.LAMBDA_TYPE;
            }

            public ReferenceBinding superclass() {
                return LambdaExpression.this.scope.getJavaLangObject();
            }

            public ReferenceBinding[] superInterfaces() {
                return new ReferenceBinding[]{(ReferenceBinding)LambdaExpression.this.resolvedType};
            }

            public char[] computeUniqueKey() {
                return LambdaExpression.this.descriptor.declaringClass.computeUniqueKey();
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer("()->{} implements ");
                stringBuffer.append(LambdaExpression.this.descriptor.declaringClass.sourceName());
                stringBuffer.append('.');
                stringBuffer.append(LambdaExpression.this.descriptor.toString());
                return stringBuffer.toString();
            }
        }
        this.classType = new LambdaTypeBinding();
        return this.classType;
    }

    class CopyFailureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CopyFailureException() {
        }
    }
}

