/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LabelFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class LabeledStatement
extends Statement {
    public Statement statement;
    public char[] label;
    public BranchLabel targetLabel;
    public int labelEnd;
    int mergedInitStateIndex = -1;

    public LabeledStatement(char[] cArray, Statement statement, long l, int n) {
        this.statement = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.label = cArray;
        this.sourceStart = (int)(l >>> 32);
        this.labelEnd = (int)l;
        this.sourceEnd = n;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statement == null) {
            return flowInfo;
        }
        this.targetLabel = new BranchLabel();
        LabelFlowContext labelFlowContext = new LabelFlowContext(flowContext, this, this.label, this.targetLabel, blockScope);
        FlowInfo flowInfo2 = this.statement.analyseCode(blockScope, labelFlowContext, flowInfo);
        boolean bl = (flowInfo2.tagBits & 3) != 0 && (labelFlowContext.initsOnBreak.tagBits & 3) == 0;
        UnconditionalFlowInfo unconditionalFlowInfo = flowInfo2.mergedWith(labelFlowContext.initsOnBreak);
        if (bl) {
            unconditionalFlowInfo.addInitializationsFrom(flowInfo.unconditionalFieldLessCopy()).addInitializationsFrom(labelFlowContext.initsOnBreak.unconditionalFieldLessCopy());
        }
        this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo);
        if ((this.bits & 0x40) == 0) {
            blockScope.problemReporter().unusedLabel(this);
        }
        return unconditionalFlowInfo;
    }

    public ASTNode concreteStatement() {
        return this.statement;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (this.targetLabel != null) {
            this.targetLabel.initialize(codeStream);
            if (this.statement != null) {
                this.statement.generateCode(blockScope, codeStream);
            }
            this.targetLabel.place();
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        LabeledStatement.printIndent(n, stringBuffer).append(this.label).append(": ");
        if (this.statement == null) {
            stringBuffer.append(';');
        } else {
            this.statement.printStatement(0, stringBuffer);
        }
        return stringBuffer;
    }

    public void resolve(BlockScope blockScope) {
        if (this.statement != null) {
            this.statement.resolve(blockScope);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.statement != null) {
            this.statement.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public boolean doesNotCompleteNormally() {
        if (this.statement.breaksOut(this.label)) {
            return false;
        }
        return this.statement.doesNotCompleteNormally();
    }

    public boolean completesByContinue() {
        return this.statement instanceof ContinueStatement;
    }
}

