/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class DoStatement
extends Statement {
    public Expression condition;
    public Statement action;
    private BranchLabel breakLabel;
    private BranchLabel continueLabel;
    int mergedInitStateIndex = -1;
    int preConditionInitStateIndex = -1;

    public DoStatement(Expression expression, Statement statement, int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.condition = expression;
        this.action = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo flowInfo2;
        this.breakLabel = new BranchLabel();
        this.continueLabel = new BranchLabel();
        LoopingFlowContext loopingFlowContext = new LoopingFlowContext(flowContext, flowInfo, this, this.breakLabel, this.continueLabel, blockScope, false);
        Constant constant = this.condition.constant;
        boolean bl = constant != Constant.NotAConstant && constant.booleanValue();
        constant = this.condition.optimizedBooleanConstant();
        boolean bl2 = constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl3 = constant != Constant.NotAConstant && !constant.booleanValue();
        int n = flowInfo.reachMode();
        FlowInfo flowInfo3 = flowInfo;
        UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.nullInfoLessUnconditionalCopy();
        if (this.action != null && !this.action.isEmptyBlock()) {
            unconditionalFlowInfo = this.action.analyseCode(blockScope, loopingFlowContext, unconditionalFlowInfo).unconditionalInits();
            if ((unconditionalFlowInfo.tagBits & loopingFlowContext.initsOnContinue.tagBits & 1) != 0) {
                this.continueLabel = null;
            }
            if ((this.condition.implicitConversion & 0x400) != 0) {
                flowInfo3 = flowInfo.unconditionalInits().addInitializationsFrom(unconditionalFlowInfo.mergedWith(loopingFlowContext.initsOnContinue));
            }
        }
        this.condition.checkNPEbyUnboxing(blockScope, flowContext, flowInfo3);
        unconditionalFlowInfo.setReachMode(n);
        LoopingFlowContext loopingFlowContext2 = new LoopingFlowContext(flowContext, flowInfo, this, null, null, blockScope, true);
        FlowInfo flowInfo4 = this.condition.analyseCode(blockScope, loopingFlowContext2, (this.action == null ? unconditionalFlowInfo : unconditionalFlowInfo.mergedWith(loopingFlowContext.initsOnContinue)).copy());
        this.preConditionInitStateIndex = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo.mergedWith(loopingFlowContext.initsOnContinue));
        if (!bl3 && this.continueLabel != null) {
            loopingFlowContext.complainOnDeferredFinalChecks(blockScope, flowInfo4);
            loopingFlowContext2.complainOnDeferredFinalChecks(blockScope, flowInfo4);
            loopingFlowContext.complainOnDeferredNullChecks(blockScope, flowInfo.unconditionalCopy().addPotentialNullInfoFrom(flowInfo4.initsWhenTrue().unconditionalInits()));
            loopingFlowContext2.complainOnDeferredNullChecks(blockScope, unconditionalFlowInfo.addPotentialNullInfoFrom(flowInfo4.initsWhenTrue().unconditionalInits()));
        }
        if (loopingFlowContext.hasEscapingExceptions()) {
            flowInfo2 = flowInfo.copy();
            flowInfo2 = flowInfo2.mergedWith(flowInfo2.unconditionalCopy().addNullInfoFrom(flowInfo4.initsWhenTrue()).unconditionalInits());
            loopingFlowContext.simulateThrowAfterLoopBack(flowInfo2);
        }
        flowInfo2 = FlowInfo.mergedOptimizedBranches((loopingFlowContext.initsOnBreak.tagBits & 3) != 0 ? loopingFlowContext.initsOnBreak : flowInfo.unconditionalCopy().addInitializationsFrom(loopingFlowContext.initsOnBreak), bl2, (flowInfo4.tagBits & 3) == 0 ? flowInfo.copy().addInitializationsFrom(flowInfo4.initsWhenFalse()) : flowInfo4, false, !bl);
        this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo2);
        return flowInfo2;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        boolean bl;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        BranchLabel branchLabel = new BranchLabel(codeStream);
        if (this.action != null) {
            branchLabel.tagBits |= 2;
        }
        branchLabel.place();
        this.breakLabel.initialize(codeStream);
        boolean bl2 = bl = this.continueLabel != null;
        if (bl) {
            this.continueLabel.initialize(codeStream);
        }
        if (this.action != null) {
            this.action.generateCode(blockScope, codeStream);
        }
        if (bl) {
            Constant constant;
            boolean bl3;
            this.continueLabel.place();
            if (this.preConditionInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preConditionInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.preConditionInitStateIndex);
            }
            boolean bl4 = bl3 = (constant = this.condition.optimizedBooleanConstant()) != Constant.NotAConstant && !constant.booleanValue();
            if (bl3) {
                this.condition.generateCode(blockScope, codeStream, false);
            } else {
                this.condition.generateOptimizedBoolean(blockScope, codeStream, branchLabel, null, true);
            }
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        if (this.breakLabel.forwardReferenceCount() > 0) {
            this.breakLabel.place();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        DoStatement.printIndent(n, stringBuffer).append("do");
        if (this.action == null) {
            stringBuffer.append(" ;\n");
        } else {
            stringBuffer.append('\n');
            this.action.printStatement(n + 1, stringBuffer).append('\n');
        }
        stringBuffer.append("while (");
        return this.condition.printExpression(0, stringBuffer).append(");");
    }

    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding = this.condition.resolveTypeExpecting(blockScope, TypeBinding.BOOLEAN);
        this.condition.computeConversion(blockScope, typeBinding, typeBinding);
        if (this.action != null) {
            this.action.resolve(blockScope);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.action != null) {
                this.action.traverse(aSTVisitor, blockScope);
            }
            this.condition.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public boolean doesNotCompleteNormally() {
        boolean bl;
        Constant constant = this.condition.constant;
        boolean bl2 = constant == null || constant != Constant.NotAConstant && constant.booleanValue();
        constant = this.condition.optimizedBooleanConstant();
        boolean bl3 = constant == null ? true : (bl = constant != Constant.NotAConstant && constant.booleanValue());
        if (bl2 || bl) {
            return this.action == null || !this.action.breaksOut(null);
        }
        if (this.action == null || this.action.breaksOut(null)) {
            return false;
        }
        return this.action.doesNotCompleteNormally() && !this.action.completesByContinue();
    }

    public boolean completesByContinue() {
        return this.action.continuesAtOuterLabel();
    }
}

