/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class AssertStatement
extends Statement {
    public Expression assertExpression;
    public Expression exceptionArgument;
    int preAssertInitStateIndex = -1;
    private FieldBinding assertionSyntheticFieldBinding;

    public AssertStatement(Expression expression, Expression expression2, int n) {
        this.assertExpression = expression2;
        this.exceptionArgument = expression;
        this.sourceStart = n;
        this.sourceEnd = expression.sourceEnd;
    }

    public AssertStatement(Expression expression, int n) {
        this.assertExpression = expression;
        this.sourceStart = n;
        this.sourceEnd = expression.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        Object object;
        this.preAssertInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
        Constant constant = this.assertExpression.optimizedBooleanConstant();
        this.assertExpression.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
        boolean bl = constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl2 = constant != Constant.NotAConstant && !constant.booleanValue();
        flowContext.tagBits |= 0x1000;
        FlowInfo flowInfo2 = this.assertExpression.analyseCode(blockScope, flowContext, flowInfo.copy());
        flowContext.extendTimeToLiveForNullCheckedField(1);
        flowContext.tagBits &= 0xFFFFEFFF;
        UnconditionalFlowInfo unconditionalFlowInfo = flowInfo2.initsWhenTrue().unconditionalInits();
        FlowInfo flowInfo3 = flowInfo2.initsWhenFalse();
        if (bl) {
            flowInfo3.setReachMode(1);
        }
        if (this.exceptionArgument != null) {
            object = this.exceptionArgument.analyseCode(blockScope, flowContext, flowInfo3.copy());
            if (bl) {
                blockScope.problemReporter().fakeReachable(this.exceptionArgument);
            } else {
                flowContext.checkExceptionHandlers(blockScope.getJavaLangAssertionError(), (ASTNode)this, (FlowInfo)object, blockScope);
            }
        }
        if (!bl) {
            this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        }
        flowContext.recordAbruptExit();
        if (bl2) {
            return flowInfo;
        }
        object = blockScope.compilerOptions();
        if (!((CompilerOptions)object).includeNullInfoFromAsserts) {
            return flowInfo.nullInfoLessUnconditionalCopy().mergedWith(flowInfo3.nullInfoLessUnconditionalCopy()).addNullInfoFrom(flowInfo);
        }
        return flowInfo.mergedWith(flowInfo3.nullInfoLessUnconditionalCopy()).addInitializationsFrom(unconditionalFlowInfo.discardInitializationInfo());
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (this.assertionSyntheticFieldBinding != null) {
            BranchLabel branchLabel = new BranchLabel(codeStream);
            codeStream.fieldAccess((byte)-78, this.assertionSyntheticFieldBinding, null);
            codeStream.ifne(branchLabel);
            BranchLabel branchLabel2 = new BranchLabel(codeStream);
            this.assertExpression.generateOptimizedBoolean(blockScope, codeStream, branchLabel2, null, true);
            codeStream.newJavaLangAssertionError();
            codeStream.dup();
            if (this.exceptionArgument != null) {
                this.exceptionArgument.generateCode(blockScope, codeStream, true);
                codeStream.invokeJavaLangAssertionErrorConstructor(this.exceptionArgument.implicitConversion & 0xF);
            } else {
                codeStream.invokeJavaLangAssertionErrorDefaultConstructor();
            }
            codeStream.athrow();
            if (this.preAssertInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preAssertInitStateIndex);
            }
            branchLabel2.place();
            branchLabel.place();
        } else if (this.preAssertInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preAssertInitStateIndex);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding;
        this.assertExpression.resolveTypeExpecting(blockScope, TypeBinding.BOOLEAN);
        if (this.exceptionArgument != null && (typeBinding = this.exceptionArgument.resolveType(blockScope)) != null) {
            int n = typeBinding.id;
            switch (n) {
                case 6: {
                    blockScope.problemReporter().illegalVoidExpression(this.exceptionArgument);
                }
                default: {
                    n = 1;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
            }
            this.exceptionArgument.implicitConversion = (n << 4) + n;
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.assertExpression.traverse(aSTVisitor, blockScope);
            if (this.exceptionArgument != null) {
                this.exceptionArgument.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            Object object;
            SourceTypeBinding sourceTypeBinding = blockScope.enclosingSourceType();
            while (sourceTypeBinding.isLocalType()) {
                object = sourceTypeBinding.enclosingType();
                if (object == null || ((ReferenceBinding)object).isInterface()) break;
                sourceTypeBinding = (SourceTypeBinding)object;
            }
            this.assertionSyntheticFieldBinding = sourceTypeBinding.addSyntheticFieldForAssert(blockScope);
            object = sourceTypeBinding.scope.referenceType();
            AbstractMethodDeclaration[] abstractMethodDeclarationArray = ((TypeDeclaration)object).methods;
            int n = 0;
            int n2 = abstractMethodDeclarationArray.length;
            while (n < n2) {
                AbstractMethodDeclaration abstractMethodDeclaration = abstractMethodDeclarationArray[n];
                if (abstractMethodDeclaration.isClinit()) {
                    ((Clinit)abstractMethodDeclaration).setAssertionSupport(this.assertionSyntheticFieldBinding, blockScope.compilerOptions().sourceLevel < 0x310000L);
                    break;
                }
                ++n;
            }
        }
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        AssertStatement.printIndent(n, stringBuffer);
        stringBuffer.append("assert ");
        this.assertExpression.printExpression(0, stringBuffer);
        if (this.exceptionArgument != null) {
            stringBuffer.append(": ");
            this.exceptionArgument.printExpression(0, stringBuffer);
        }
        return stringBuffer.append(';');
    }
}

