/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.torproject.descriptor.BandwidthHistory;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.ServerDescriptor;
import org.torproject.descriptor.impl.BandwidthHistoryImpl;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.ParseHelper;

public abstract class ServerDescriptorImpl
extends DescriptorImpl
implements ServerDescriptor {
    private static final Set<Key> atMostOnce = EnumSet.of(Key.IDENTITY_ED25519, new Key[]{Key.MASTER_KEY_ED25519, Key.PLATFORM, Key.PROTO, Key.FINGERPRINT, Key.HIBERNATING, Key.UPTIME, Key.CONTACT, Key.FAMILY, Key.READ_HISTORY, Key.WRITE_HISTORY, Key.EVENTDNS, Key.CACHES_EXTRA_INFO, Key.EXTRA_INFO_DIGEST, Key.HIDDEN_SERVICE_DIR, Key.PROTOCOLS, Key.ALLOW_SINGLE_HOP_EXITS, Key.ONION_KEY, Key.SIGNING_KEY, Key.IPV6_POLICY, Key.NTOR_ONION_KEY, Key.ONION_KEY_CROSSCERT, Key.NTOR_ONION_KEY_CROSSCERT, Key.TUNNELLED_DIR_SERVER, Key.ROUTER_SIG_ED25519, Key.ROUTER_SIGNATURE, Key.ROUTER_DIGEST_SHA256, Key.ROUTER_DIGEST});
    private static final Set<Key> exactlyOnce = EnumSet.of(Key.ROUTER, Key.BANDWIDTH, Key.PUBLISHED);
    private String nickname;
    private String address;
    private int orPort;
    private int socksPort;
    private int dirPort;
    private List<String> orAddresses = new ArrayList<String>();
    private int bandwidthRate;
    private int bandwidthBurst;
    private int bandwidthObserved;
    private String platform;
    private SortedMap<String, SortedSet<Long>> protocols;
    private long publishedMillis;
    private String fingerprint;
    private boolean hibernating;
    private Long uptime;
    private String onionKey;
    private String signingKey;
    private List<String> exitPolicyLines = new ArrayList<String>();
    private String routerSignature;
    private String contact;
    private String[] familyEntries;
    private BandwidthHistory readHistory;
    private BandwidthHistory writeHistory;
    private boolean usesEnhancedDnsLogic;
    private boolean cachesExtraInfo;
    private String extraInfoDigest;
    private String extraInfoDigestSha256;
    private boolean hiddenServiceDir;
    private Integer[] linkProtocolVersions;
    private Integer[] circuitProtocolVersions;
    private boolean allowSingleHopExits;
    private String ipv6DefaultPolicy;
    private String ipv6PortList;
    private String ntorOnionKey;
    private String identityEd25519;
    private String masterKeyEd25519;
    private String routerSignatureEd25519;
    private String onionKeyCrosscert;
    private String ntorOnionKeyCrosscert;
    private int ntorOnionKeyCrosscertSign = -1;
    private boolean tunnelledDirServer;

    protected ServerDescriptorImpl(byte[] descriptorBytes, int[] offsetAndLength, File descriptorFile) throws DescriptorParseException {
        super(descriptorBytes, offsetAndLength, descriptorFile, false);
        this.parseDescriptorBytes();
        this.checkExactlyOnceKeys(exactlyOnce);
        this.checkAtMostOnceKeys(atMostOnce);
        this.checkFirstKey(Key.ROUTER);
        if (this.getKeyCount(Key.ACCEPT) == 0 && this.getKeyCount(Key.REJECT) == 0) {
            throw new DescriptorParseException("Either keyword 'accept' or 'reject' must be contained at least once.");
        }
        this.clearParsedKeys();
    }

    private void parseDescriptorBytes() throws DescriptorParseException {
        Scanner scanner = this.newScanner().useDelimiter("\n");
        Key nextCrypto = Key.EMPTY;
        ArrayList<String> cryptoLines = null;
        block47: while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.startsWith("@")) continue;
            String lineNoOpt = line.startsWith(Key.OPT.keyword + " ") ? line.substring(Key.OPT.keyword.length() + 1) : line;
            String[] partsNoOpt = lineNoOpt.split("[ \t]+");
            Key key = Key.get(partsNoOpt[0]);
            switch (key) {
                case ROUTER: {
                    this.parseRouterLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case OR_ADDRESS: {
                    this.parseOrAddressLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case BANDWIDTH: {
                    this.parseBandwidthLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case PLATFORM: {
                    this.parsePlatformLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case PROTO: {
                    this.parseProtoLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case PUBLISHED: {
                    this.parsePublishedLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case FINGERPRINT: {
                    this.parseFingerprintLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case HIBERNATING: {
                    this.parseHibernatingLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case UPTIME: {
                    this.parseUptimeLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case ONION_KEY: {
                    this.parseOnionKeyLine(line, lineNoOpt, partsNoOpt);
                    nextCrypto = key;
                    continue block47;
                }
                case SIGNING_KEY: {
                    this.parseSigningKeyLine(line, lineNoOpt, partsNoOpt);
                    nextCrypto = key;
                    continue block47;
                }
                case ACCEPT: {
                    this.parseAcceptLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case REJECT: {
                    this.parseRejectLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case ROUTER_SIGNATURE: {
                    this.parseRouterSignatureLine(line, lineNoOpt, partsNoOpt);
                    nextCrypto = key;
                    continue block47;
                }
                case CONTACT: {
                    this.parseContactLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case FAMILY: {
                    this.parseFamilyLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case READ_HISTORY: {
                    this.parseReadHistoryLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case WRITE_HISTORY: {
                    this.parseWriteHistoryLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case EVENTDNS: {
                    this.parseEventdnsLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case CACHES_EXTRA_INFO: {
                    this.parseCachesExtraInfoLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case EXTRA_INFO_DIGEST: {
                    this.parseExtraInfoDigestLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case HIDDEN_SERVICE_DIR: {
                    this.parseHiddenServiceDirLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case PROTOCOLS: {
                    this.parseProtocolsLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case ALLOW_SINGLE_HOP_EXITS: {
                    this.parseAllowSingleHopExitsLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case DIRCACHEPORT: {
                    this.parseDircacheportLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case ROUTER_DIGEST: {
                    this.parseRouterDigestLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case ROUTER_DIGEST_SHA256: {
                    this.parseRouterDigestSha256Line(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case IPV6_POLICY: {
                    this.parseIpv6PolicyLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case NTOR_ONION_KEY: {
                    this.parseNtorOnionKeyLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case IDENTITY_ED25519: {
                    this.parseIdentityEd25519Line(line, lineNoOpt, partsNoOpt);
                    nextCrypto = key;
                    continue block47;
                }
                case MASTER_KEY_ED25519: {
                    this.parseMasterKeyEd25519Line(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case ROUTER_SIG_ED25519: {
                    this.parseRouterSigEd25519Line(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case ONION_KEY_CROSSCERT: {
                    this.parseOnionKeyCrosscert(line, lineNoOpt, partsNoOpt);
                    nextCrypto = key;
                    continue block47;
                }
                case NTOR_ONION_KEY_CROSSCERT: {
                    this.parseNtorOnionKeyCrosscert(line, lineNoOpt, partsNoOpt);
                    nextCrypto = key;
                    continue block47;
                }
                case TUNNELLED_DIR_SERVER: {
                    this.parseTunnelledDirServerLine(line, lineNoOpt, partsNoOpt);
                    continue block47;
                }
                case CRYPTO_BEGIN: {
                    cryptoLines = new ArrayList<String>();
                    cryptoLines.add(line);
                    continue block47;
                }
                case CRYPTO_END: {
                    cryptoLines.add(line);
                    StringBuilder sb = new StringBuilder();
                    for (String cryptoLine : cryptoLines) {
                        sb.append("\n").append(cryptoLine);
                    }
                    String cryptoString = sb.toString().substring(1);
                    switch (nextCrypto) {
                        case ONION_KEY: {
                            this.onionKey = cryptoString;
                            break;
                        }
                        case SIGNING_KEY: {
                            this.signingKey = cryptoString;
                            break;
                        }
                        case ROUTER_SIGNATURE: {
                            this.routerSignature = cryptoString;
                            break;
                        }
                        case IDENTITY_ED25519: {
                            this.identityEd25519 = cryptoString;
                            this.parseIdentityEd25519CryptoBlock(cryptoString);
                            break;
                        }
                        case ONION_KEY_CROSSCERT: {
                            this.onionKeyCrosscert = cryptoString;
                            break;
                        }
                        case NTOR_ONION_KEY_CROSSCERT: {
                            this.ntorOnionKeyCrosscert = cryptoString;
                            break;
                        }
                        default: {
                            if (this.unrecognizedLines == null) {
                                this.unrecognizedLines = new ArrayList();
                            }
                            this.unrecognizedLines.addAll(cryptoLines);
                        }
                    }
                    cryptoLines = null;
                    nextCrypto = Key.EMPTY;
                    continue block47;
                }
            }
            if (cryptoLines != null) {
                cryptoLines.add(line);
                continue;
            }
            ParseHelper.parseKeyword(line, partsNoOpt[0]);
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseRouterLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 6) {
            throw new DescriptorParseException("Illegal line '" + line + "' in server descriptor.");
        }
        this.nickname = ParseHelper.parseNickname(line, partsNoOpt[1]);
        this.address = ParseHelper.parseIpv4Address(line, partsNoOpt[2]);
        this.orPort = ParseHelper.parsePort(line, partsNoOpt[3]);
        this.socksPort = ParseHelper.parsePort(line, partsNoOpt[4]);
        this.dirPort = ParseHelper.parsePort(line, partsNoOpt[5]);
    }

    private void parseOrAddressLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 2) {
            throw new DescriptorParseException("Wrong number of values in line '" + line + "'.");
        }
        this.orAddresses.add(partsNoOpt[1]);
    }

    private void parseBandwidthLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length < 3 || partsNoOpt.length > 4) {
            throw new DescriptorParseException("Wrong number of values in line '" + line + "'.");
        }
        boolean isValid = false;
        try {
            this.bandwidthRate = Integer.parseInt(partsNoOpt[1]);
            this.bandwidthBurst = Integer.parseInt(partsNoOpt[2]);
            if (partsNoOpt.length == 4) {
                this.bandwidthObserved = Integer.parseInt(partsNoOpt[3]);
            }
            if (this.bandwidthRate >= 0 && this.bandwidthBurst >= 0 && this.bandwidthObserved >= 0) {
                isValid = true;
            }
            if (partsNoOpt.length < 4) {
                this.bandwidthObserved = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!isValid) {
            throw new DescriptorParseException("Illegal values in line '" + line + "'.");
        }
    }

    private void parsePlatformLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        this.platform = lineNoOpt.length() > Key.PLATFORM.keyword.length() + 1 ? lineNoOpt.substring(Key.PLATFORM.keyword.length() + 1) : "";
    }

    private void parseProtoLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        this.protocols = ParseHelper.parseProtocolVersions(line, lineNoOpt, partsNoOpt);
    }

    private void parsePublishedLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, partsNoOpt, 1, 2);
    }

    private void parseFingerprintLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (lineNoOpt.length() != Key.FINGERPRINT.keyword.length() + 50) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.fingerprint = ParseHelper.parseTwentyByteHexString(line, lineNoOpt.substring(Key.FINGERPRINT.keyword.length() + 1).replaceAll(" ", ""));
    }

    private void parseHibernatingLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.hibernating = ParseHelper.parseBoolean(partsNoOpt[1], line);
    }

    private void parseUptimeLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 2) {
            throw new DescriptorParseException("Wrong number of values in line '" + line + "'.");
        }
        boolean isValid = false;
        try {
            this.uptime = Long.parseLong(partsNoOpt[1]);
            isValid = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!isValid) {
            throw new DescriptorParseException("Illegal value in line '" + line + "'.");
        }
    }

    private void parseOnionKeyLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (!lineNoOpt.equals(Key.ONION_KEY.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseSigningKeyLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (!lineNoOpt.equals(Key.SIGNING_KEY.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseAcceptLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        this.parseExitPolicyLine(line, lineNoOpt, partsNoOpt);
    }

    private void parseRejectLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        this.parseExitPolicyLine(line, lineNoOpt, partsNoOpt);
    }

    private void parseExitPolicyLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        ParseHelper.parseExitPattern(line, partsNoOpt[1]);
        this.exitPolicyLines.add(lineNoOpt);
    }

    private void parseRouterSignatureLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (!lineNoOpt.equals(Key.ROUTER_SIGNATURE.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseContactLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        this.contact = lineNoOpt.length() > Key.CONTACT.keyword.length() + 1 ? lineNoOpt.substring(Key.CONTACT.keyword.length() + 1) : "";
    }

    private void parseFamilyLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        String[] familyEntries = new String[partsNoOpt.length - 1];
        for (int i = 1; i < partsNoOpt.length; ++i) {
            if (partsNoOpt[i].startsWith("$")) {
                if (partsNoOpt[i].contains("=") ^ partsNoOpt[i].contains("~")) {
                    String separator = partsNoOpt[i].contains("=") ? "=" : "~";
                    String fingerprint = ParseHelper.parseTwentyByteHexString(line, partsNoOpt[i].substring(1, partsNoOpt[i].indexOf(separator)));
                    String nickname = ParseHelper.parseNickname(line, partsNoOpt[i].substring(partsNoOpt[i].indexOf(separator) + 1));
                    familyEntries[i - 1] = "$" + fingerprint + separator + nickname;
                    continue;
                }
                familyEntries[i - 1] = "$" + ParseHelper.parseTwentyByteHexString(line, partsNoOpt[i].substring(1));
                continue;
            }
            familyEntries[i - 1] = ParseHelper.parseNickname(line, partsNoOpt[i]);
        }
        this.familyEntries = familyEntries;
    }

    private void parseReadHistoryLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        this.readHistory = new BandwidthHistoryImpl(line, lineNoOpt, partsNoOpt);
    }

    private void parseWriteHistoryLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        this.writeHistory = new BandwidthHistoryImpl(line, lineNoOpt, partsNoOpt);
    }

    private void parseEventdnsLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.usesEnhancedDnsLogic = ParseHelper.parseBoolean(partsNoOpt[1], line);
    }

    private void parseCachesExtraInfoLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (!lineNoOpt.equals(Key.CACHES_EXTRA_INFO.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.cachesExtraInfo = true;
    }

    private void parseExtraInfoDigestLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length < 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.extraInfoDigest = ParseHelper.parseTwentyByteHexString(line, partsNoOpt[1]);
        if (partsNoOpt.length >= 3) {
            ParseHelper.verifyThirtyTwoByteBase64String(line, partsNoOpt[2]);
            this.extraInfoDigestSha256 = partsNoOpt[2];
        }
    }

    private void parseHiddenServiceDirLine(String line, String lineNoOpt, String[] partsNoOpt) {
        this.hiddenServiceDir = true;
    }

    private void parseProtocolsLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        int linkIndex = -1;
        int circuitIndex = -1;
        block10: for (int i = 1; i < partsNoOpt.length; ++i) {
            switch (partsNoOpt[i]) {
                case "Link": {
                    linkIndex = i;
                    continue block10;
                }
                case "Circuit": {
                    circuitIndex = i;
                    continue block10;
                }
            }
        }
        if (linkIndex < 0 || circuitIndex < 0 || circuitIndex < linkIndex) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        try {
            Integer[] linkProtocolVersions = new Integer[circuitIndex - linkIndex - 1];
            int i = linkIndex + 1;
            int j = 0;
            while (i < circuitIndex) {
                linkProtocolVersions[j] = Integer.parseInt(partsNoOpt[i]);
                ++i;
                ++j;
            }
            Integer[] circuitProtocolVersions = new Integer[partsNoOpt.length - circuitIndex - 1];
            int i2 = circuitIndex + 1;
            int j2 = 0;
            while (i2 < partsNoOpt.length) {
                circuitProtocolVersions[j2] = Integer.parseInt(partsNoOpt[i2]);
                ++i2;
                ++j2;
            }
            this.linkProtocolVersions = linkProtocolVersions;
            this.circuitProtocolVersions = circuitProtocolVersions;
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseAllowSingleHopExitsLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (!lineNoOpt.equals(Key.ALLOW_SINGLE_HOP_EXITS.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.allowSingleHopExits = true;
    }

    private void parseDircacheportLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        if (this.dirPort != 0) {
            throw new DescriptorParseException("At most one of dircacheport and the directory port in the router line may be non-zero.");
        }
        this.dirPort = ParseHelper.parsePort(line, partsNoOpt[1]);
    }

    private void parseRouterDigestLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.setDigestSha1Hex(ParseHelper.parseTwentyByteHexString(line, partsNoOpt[1]));
    }

    private void parseIpv6PolicyLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        boolean isValid = true;
        if (partsNoOpt.length != 3) {
            isValid = false;
        } else {
            block0 : switch (Key.get(partsNoOpt[1])) {
                case ACCEPT: 
                case REJECT: {
                    this.ipv6DefaultPolicy = partsNoOpt[1];
                    this.ipv6PortList = partsNoOpt[2];
                    String[] ports = partsNoOpt[2].split(",", -1);
                    for (int i = 0; i < ports.length; ++i) {
                        if (ports[i].length() >= 1) continue;
                        isValid = false;
                        break block0;
                    }
                    break;
                }
                default: {
                    isValid = false;
                }
            }
        }
        if (!isValid) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseNtorOnionKeyLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.ntorOnionKey = partsNoOpt[1].replaceAll("=", "");
    }

    private void parseIdentityEd25519Line(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 1) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseOnionKeyCrosscert(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 1) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseNtorOnionKeyCrosscert(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        try {
            this.ntorOnionKeyCrosscertSign = Integer.parseInt(partsNoOpt[1]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseTunnelledDirServerLine(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (!lineNoOpt.equals(Key.TUNNELLED_DIR_SERVER.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.tunnelledDirServer = true;
    }

    private void parseIdentityEd25519CryptoBlock(String cryptoString) throws DescriptorParseException {
        String masterKeyEd25519FromIdentityEd25519 = ParseHelper.parseMasterKeyEd25519FromIdentityEd25519CryptoBlock(cryptoString);
        if (this.masterKeyEd25519 != null && !this.masterKeyEd25519.equals(masterKeyEd25519FromIdentityEd25519)) {
            throw new DescriptorParseException("Mismatch between identity-ed25519 and master-key-ed25519.");
        }
        this.masterKeyEd25519 = masterKeyEd25519FromIdentityEd25519;
    }

    private void parseMasterKeyEd25519Line(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        String masterKeyEd25519FromMasterKeyEd25519Line = partsNoOpt[1];
        if (this.masterKeyEd25519 != null && !this.masterKeyEd25519.equals(masterKeyEd25519FromMasterKeyEd25519Line)) {
            throw new DescriptorParseException("Mismatch between identity-ed25519 and master-key-ed25519.");
        }
        this.masterKeyEd25519 = masterKeyEd25519FromMasterKeyEd25519Line;
    }

    private void parseRouterSigEd25519Line(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.routerSignatureEd25519 = partsNoOpt[1];
    }

    private void parseRouterDigestSha256Line(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        ParseHelper.verifyThirtyTwoByteBase64String(line, partsNoOpt[1]);
        this.setDigestSha256Base64(partsNoOpt[1]);
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public int getOrPort() {
        return this.orPort;
    }

    @Override
    public int getSocksPort() {
        return this.socksPort;
    }

    @Override
    public int getDirPort() {
        return this.dirPort;
    }

    @Override
    public List<String> getOrAddresses() {
        return new ArrayList<String>(this.orAddresses);
    }

    @Override
    public int getBandwidthRate() {
        return this.bandwidthRate;
    }

    @Override
    public int getBandwidthBurst() {
        return this.bandwidthBurst;
    }

    @Override
    public int getBandwidthObserved() {
        return this.bandwidthObserved;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getProtocols() {
        return this.protocols;
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public boolean isHibernating() {
        return this.hibernating;
    }

    @Override
    public Long getUptime() {
        return this.uptime;
    }

    @Override
    public String getOnionKey() {
        return this.onionKey;
    }

    @Override
    public String getSigningKey() {
        return this.signingKey;
    }

    @Override
    public List<String> getExitPolicyLines() {
        return new ArrayList<String>(this.exitPolicyLines);
    }

    @Override
    public String getRouterSignature() {
        return this.routerSignature;
    }

    @Override
    public String getContact() {
        return this.contact;
    }

    @Override
    public List<String> getFamilyEntries() {
        return this.familyEntries == null ? null : Arrays.asList(this.familyEntries);
    }

    @Override
    public BandwidthHistory getReadHistory() {
        return this.readHistory;
    }

    @Override
    public BandwidthHistory getWriteHistory() {
        return this.writeHistory;
    }

    @Override
    public boolean getUsesEnhancedDnsLogic() {
        return this.usesEnhancedDnsLogic;
    }

    @Override
    public boolean getCachesExtraInfo() {
        return this.cachesExtraInfo;
    }

    @Override
    public String getExtraInfoDigestSha1Hex() {
        return this.extraInfoDigest;
    }

    @Override
    public String getExtraInfoDigestSha256Base64() {
        return this.extraInfoDigestSha256;
    }

    @Override
    public boolean isHiddenServiceDir() {
        return this.hiddenServiceDir;
    }

    @Override
    public List<Integer> getHiddenServiceDirVersions() {
        return this.hiddenServiceDir ? null : Collections.singletonList(2);
    }

    @Override
    public List<Integer> getLinkProtocolVersions() {
        return this.linkProtocolVersions == null ? null : Arrays.asList(this.linkProtocolVersions);
    }

    @Override
    public List<Integer> getCircuitProtocolVersions() {
        return this.circuitProtocolVersions == null ? null : Arrays.asList(this.circuitProtocolVersions);
    }

    @Override
    public boolean getAllowSingleHopExits() {
        return this.allowSingleHopExits;
    }

    @Override
    public String getIpv6DefaultPolicy() {
        return this.ipv6DefaultPolicy;
    }

    @Override
    public String getIpv6PortList() {
        return this.ipv6PortList;
    }

    @Override
    public String getNtorOnionKey() {
        return this.ntorOnionKey;
    }

    @Override
    public String getIdentityEd25519() {
        return this.identityEd25519;
    }

    @Override
    public String getMasterKeyEd25519() {
        return this.masterKeyEd25519;
    }

    @Override
    public String getRouterSignatureEd25519() {
        return this.routerSignatureEd25519;
    }

    @Override
    public String getOnionKeyCrosscert() {
        return this.onionKeyCrosscert;
    }

    @Override
    public String getNtorOnionKeyCrosscert() {
        return this.ntorOnionKeyCrosscert;
    }

    @Override
    public int getNtorOnionKeyCrosscertSign() {
        return this.ntorOnionKeyCrosscertSign;
    }

    @Override
    public boolean getTunnelledDirServer() {
        return this.tunnelledDirServer;
    }
}

