/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.NetworkStatusEntryImpl;
import org.torproject.descriptor.impl.NetworkStatusImpl;
import org.torproject.descriptor.impl.ParseHelper;

public class RelayNetworkStatusConsensusImpl
extends NetworkStatusImpl
implements RelayNetworkStatusConsensus {
    private boolean microdescConsensus = false;
    private int networkStatusVersion;
    private String consensusFlavor;
    private int consensusMethod;
    private long validAfterMillis;
    private long freshUntilMillis;
    private long validUntilMillis;
    private long voteSeconds;
    private long distSeconds;
    private String[] recommendedClientVersions;
    private String[] recommendedServerVersions;
    private SortedMap<String, SortedSet<Long>> recommendedClientProtocols;
    private SortedMap<String, SortedSet<Long>> recommendedRelayProtocols;
    private SortedMap<String, SortedSet<Long>> requiredClientProtocols;
    private SortedMap<String, SortedSet<Long>> requiredRelayProtocols;
    private List<String> packageLines;
    private String[] knownFlags;
    private SortedMap<String, Integer> consensusParams;
    private int sharedRandPreviousNumReveals = -1;
    private String sharedRandPreviousValue = null;
    private int sharedRandCurrentNumReveals = -1;
    private String sharedRandCurrentValue = null;
    private SortedMap<String, Integer> bandwidthWeights;

    protected RelayNetworkStatusConsensusImpl(byte[] consensusBytes, int[] offsetAndLimit, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        super(consensusBytes, offsetAndLimit, failUnrecognizedDescriptorLines, true, false);
        EnumSet<Key[]> exactlyOnceKeys = EnumSet.of(Key.VOTE_STATUS, new Key[]{Key.CONSENSUS_METHOD, Key.VALID_AFTER, Key.FRESH_UNTIL, Key.VALID_UNTIL, Key.VOTING_DELAY, Key.KNOWN_FLAGS});
        this.checkExactlyOnceKeys(exactlyOnceKeys);
        EnumSet<Key[]> atMostOnceKeys = EnumSet.of(Key.CLIENT_VERSIONS, new Key[]{Key.SERVER_VERSIONS, Key.RECOMMENDED_CLIENT_PROTOCOLS, Key.RECOMMENDED_RELAY_PROTOCOLS, Key.REQUIRED_CLIENT_PROTOCOLS, Key.REQUIRED_RELAY_PROTOCOLS, Key.PARAMS, Key.SHARED_RAND_PREVIOUS_VALUE, Key.SHARED_RAND_CURRENT_VALUE, Key.DIRECTORY_FOOTER, Key.BANDWIDTH_WEIGHTS});
        this.checkAtMostOnceKeys(atMostOnceKeys);
        this.checkFirstKey(Key.NETWORK_STATUS_VERSION);
        this.clearParsedKeys();
        this.calculateDigestSha1Hex(Key.NETWORK_STATUS_VERSION.keyword + " ", "\n" + Key.DIRECTORY_SIGNATURE.keyword + " ");
    }

    @Override
    protected void parseHeader(int offset, int length) throws DescriptorParseException {
        Scanner scanner = this.newScanner(offset, length).useDelimiter("\n");
        block20: while (scanner.hasNext()) {
            String line = scanner.next();
            String[] parts = line.split("[ \t]+");
            Key key = Key.get(parts[0]);
            switch (key) {
                case NETWORK_STATUS_VERSION: {
                    this.parseNetworkStatusVersionLine(line, parts);
                    continue block20;
                }
                case VOTE_STATUS: {
                    this.parseVoteStatusLine(line, parts);
                    continue block20;
                }
                case CONSENSUS_METHOD: {
                    this.parseConsensusMethodLine(line, parts);
                    continue block20;
                }
                case VALID_AFTER: {
                    this.parseValidAfterLine(line, parts);
                    continue block20;
                }
                case FRESH_UNTIL: {
                    this.parseFreshUntilLine(line, parts);
                    continue block20;
                }
                case VALID_UNTIL: {
                    this.parseValidUntilLine(line, parts);
                    continue block20;
                }
                case VOTING_DELAY: {
                    this.parseVotingDelayLine(line, parts);
                    continue block20;
                }
                case CLIENT_VERSIONS: {
                    this.parseClientVersionsLine(line, parts);
                    continue block20;
                }
                case SERVER_VERSIONS: {
                    this.parseServerVersionsLine(line, parts);
                    continue block20;
                }
                case RECOMMENDED_CLIENT_PROTOCOLS: {
                    this.parseRecommendedClientProtocolsLine(line, parts);
                    continue block20;
                }
                case RECOMMENDED_RELAY_PROTOCOLS: {
                    this.parseRecommendedRelayProtocolsLine(line, parts);
                    continue block20;
                }
                case REQUIRED_CLIENT_PROTOCOLS: {
                    this.parseRequiredClientProtocolsLine(line, parts);
                    continue block20;
                }
                case REQUIRED_RELAY_PROTOCOLS: {
                    this.parseRequiredRelayProtocolsLine(line, parts);
                    continue block20;
                }
                case PACKAGE: {
                    this.parsePackageLine(line, parts);
                    continue block20;
                }
                case KNOWN_FLAGS: {
                    this.parseKnownFlagsLine(line, parts);
                    continue block20;
                }
                case PARAMS: {
                    this.parseParamsLine(line, parts);
                    continue block20;
                }
                case SHARED_RAND_PREVIOUS_VALUE: {
                    this.parseSharedRandPreviousValueLine(line, parts);
                    continue block20;
                }
                case SHARED_RAND_CURRENT_VALUE: {
                    this.parseSharedRandCurrentValueLine(line, parts);
                    continue block20;
                }
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in consensus.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    @Override
    protected void parseStatusEntry(int offset, int length) throws DescriptorParseException {
        NetworkStatusEntryImpl statusEntry = new NetworkStatusEntryImpl(this, offset, length, this.microdescConsensus, this.failUnrecognizedDescriptorLines);
        this.statusEntries.put(statusEntry.getFingerprint(), statusEntry);
        List<String> unrecognizedStatusEntryLines = statusEntry.getAndClearUnrecognizedLines();
        if (unrecognizedStatusEntryLines != null) {
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.addAll(unrecognizedStatusEntryLines);
        }
    }

    @Override
    protected void parseFooter(int offset, int length) throws DescriptorParseException {
        Scanner scanner = this.newScanner(offset, length).useDelimiter("\n");
        block4: while (scanner.hasNext()) {
            String line = scanner.next();
            String[] parts = line.split("[ \t]+");
            Key key = Key.get(parts[0]);
            switch (key) {
                case DIRECTORY_FOOTER: {
                    continue block4;
                }
                case BANDWIDTH_WEIGHTS: {
                    this.parseBandwidthWeightsLine(line, parts);
                    continue block4;
                }
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in consensus.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseNetworkStatusVersionLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.startsWith(Key.NETWORK_STATUS_VERSION.keyword + " " + "3")) {
            throw new DescriptorParseException("Illegal network status version number in line '" + line + "'.");
        }
        this.networkStatusVersion = 3;
        if (parts.length == 3) {
            this.consensusFlavor = parts[2];
            if (this.consensusFlavor.equals("microdesc")) {
                this.microdescConsensus = true;
            }
        } else if (parts.length != 2) {
            throw new DescriptorParseException("Illegal network status version line '" + line + "'.");
        }
    }

    private void parseVoteStatusLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2 || !parts[1].equals("consensus")) {
            throw new DescriptorParseException("Line '" + line + "' indicates that this is not a consensus.");
        }
    }

    private void parseConsensusMethodLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in consensus.");
        }
        try {
            this.consensusMethod = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal consensus method number in line '" + line + "'.");
        }
        if (this.consensusMethod < 1) {
            throw new DescriptorParseException("Illegal consensus method number in line '" + line + "'.");
        }
    }

    private void parseValidAfterLine(String line, String[] parts) throws DescriptorParseException {
        this.validAfterMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseFreshUntilLine(String line, String[] parts) throws DescriptorParseException {
        this.freshUntilMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseValidUntilLine(String line, String[] parts) throws DescriptorParseException {
        this.validUntilMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseVotingDelayLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Wrong number of values in line '" + line + "'.");
        }
        try {
            this.voteSeconds = Long.parseLong(parts[1]);
            this.distSeconds = Long.parseLong(parts[2]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal values in line '" + line + "'.");
        }
    }

    private void parseClientVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedClientVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parseServerVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedServerVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parseRecommendedClientProtocolsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedClientProtocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parseRecommendedRelayProtocolsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedRelayProtocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parseRequiredClientProtocolsLine(String line, String[] parts) throws DescriptorParseException {
        this.requiredClientProtocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parseRequiredRelayProtocolsLine(String line, String[] parts) throws DescriptorParseException {
        this.requiredRelayProtocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parsePackageLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 5) {
            throw new DescriptorParseException("Wrong number of values in line '" + line + "'.");
        }
        if (this.packageLines == null) {
            this.packageLines = new ArrayList<String>();
        }
        this.packageLines.add(line.substring(Key.PACKAGE.keyword.length() + 1));
    }

    private void parseKnownFlagsLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("No known flags in line '" + line + "'.");
        }
        String[] knownFlags = new String[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            knownFlags[i - 1] = parts[i];
        }
        this.knownFlags = knownFlags;
    }

    private void parseParamsLine(String line, String[] parts) throws DescriptorParseException {
        this.consensusParams = ParseHelper.parseKeyValueIntegerPairs(line, parts, 1);
    }

    private void parseSharedRandPreviousValueLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        try {
            this.sharedRandPreviousNumReveals = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        this.sharedRandPreviousValue = parts[2];
    }

    private void parseSharedRandCurrentValueLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        try {
            this.sharedRandCurrentNumReveals = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        this.sharedRandCurrentValue = parts[2];
    }

    private void parseBandwidthWeightsLine(String line, String[] parts) throws DescriptorParseException {
        this.bandwidthWeights = ParseHelper.parseKeyValueIntegerPairs(line, parts, 1);
    }

    @Override
    public String getConsensusDigest() {
        return this.getDigestSha1Hex();
    }

    @Override
    public int getNetworkStatusVersion() {
        return this.networkStatusVersion;
    }

    @Override
    public String getConsensusFlavor() {
        return this.consensusFlavor;
    }

    @Override
    public int getConsensusMethod() {
        return this.consensusMethod;
    }

    @Override
    public long getValidAfterMillis() {
        return this.validAfterMillis;
    }

    @Override
    public long getFreshUntilMillis() {
        return this.freshUntilMillis;
    }

    @Override
    public long getValidUntilMillis() {
        return this.validUntilMillis;
    }

    @Override
    public long getVoteSeconds() {
        return this.voteSeconds;
    }

    @Override
    public long getDistSeconds() {
        return this.distSeconds;
    }

    @Override
    public List<String> getRecommendedClientVersions() {
        return this.recommendedClientVersions == null ? null : Arrays.asList(this.recommendedClientVersions);
    }

    @Override
    public List<String> getRecommendedServerVersions() {
        return this.recommendedServerVersions == null ? null : Arrays.asList(this.recommendedServerVersions);
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getRecommendedClientProtocols() {
        return this.recommendedClientProtocols;
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getRecommendedRelayProtocols() {
        return this.recommendedRelayProtocols;
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getRequiredClientProtocols() {
        return this.requiredClientProtocols;
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getRequiredRelayProtocols() {
        return this.requiredRelayProtocols;
    }

    @Override
    public List<String> getPackageLines() {
        return this.packageLines == null ? null : new ArrayList<String>(this.packageLines);
    }

    @Override
    public SortedSet<String> getKnownFlags() {
        return new TreeSet<String>(Arrays.asList(this.knownFlags));
    }

    @Override
    public SortedMap<String, Integer> getConsensusParams() {
        return this.consensusParams == null ? null : new TreeMap<String, Integer>(this.consensusParams);
    }

    @Override
    public int getSharedRandPreviousNumReveals() {
        return this.sharedRandPreviousNumReveals;
    }

    @Override
    public String getSharedRandPreviousValue() {
        return this.sharedRandPreviousValue;
    }

    @Override
    public int getSharedRandCurrentNumReveals() {
        return this.sharedRandCurrentNumReveals;
    }

    @Override
    public String getSharedRandCurrentValue() {
        return this.sharedRandCurrentValue;
    }

    @Override
    public SortedMap<String, Integer> getBandwidthWeights() {
        return this.bandwidthWeights == null ? null : new TreeMap<String, Integer>(this.bandwidthWeights);
    }
}

