/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.DataOutputStream;
import java.io.IOException;
import org.tukaani.xz.FinishableOutputStream;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.lz.LZEncoder;
import org.tukaani.xz.lzma.LZMAEncoder;
import org.tukaani.xz.rangecoder.RangeEncoder;

class LZMA2OutputStream
extends FinishableOutputStream {
    static final int COMPRESSED_SIZE_MAX = 65536;
    private FinishableOutputStream out;
    private final DataOutputStream outData;
    private final LZEncoder lz;
    private final RangeEncoder rc;
    private final LZMAEncoder lzma;
    private final int props;
    private boolean dictResetNeeded = true;
    private boolean stateResetNeeded = true;
    private boolean propsNeeded = true;
    private int pendingSize = 0;
    private boolean finished = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];
    static final /* synthetic */ boolean $assertionsDisabled;

    private static int getExtraSizeBefore(int dictSize) {
        return 65536 > dictSize ? 65536 - dictSize : 0;
    }

    static int getMemoryUsage(LZMA2Options options) {
        int dictSize = options.getDictSize();
        int extraSizeBefore = LZMA2OutputStream.getExtraSizeBefore(dictSize);
        return 70 + LZMAEncoder.getMemoryUsage(options.getMode(), dictSize, extraSizeBefore, options.getMatchFinder());
    }

    LZMA2OutputStream(FinishableOutputStream out, LZMA2Options options) {
        if (out == null) {
            throw new NullPointerException();
        }
        this.out = out;
        this.outData = new DataOutputStream(out);
        this.rc = new RangeEncoder(65536);
        int dictSize = options.getDictSize();
        int extraSizeBefore = LZMA2OutputStream.getExtraSizeBefore(dictSize);
        this.lzma = LZMAEncoder.getInstance(this.rc, options.getLc(), options.getLp(), options.getPb(), options.getMode(), dictSize, extraSizeBefore, options.getNiceLen(), options.getMatchFinder(), options.getDepthLimit());
        this.lz = this.lzma.getLZEncoder();
        byte[] presetDict = options.getPresetDict();
        if (presetDict != null && presetDict.length > 0) {
            this.lz.setPresetDict(dictSize, presetDict);
            this.dictResetNeeded = false;
        }
        this.props = (options.getPb() * 5 + options.getLp()) * 9 + options.getLc();
    }

    public void write(int b) throws IOException {
        this.tempBuf[0] = (byte)b;
        this.write(this.tempBuf, 0, 1);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            while (len > 0) {
                int used = this.lz.fillWindow(buf, off, len);
                off += used;
                len -= used;
                this.pendingSize += used;
                if (!this.lzma.encodeForLZMA2()) continue;
                this.writeChunk();
            }
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
    }

    private void writeChunk() throws IOException {
        int compressedSize = this.rc.finish();
        int uncompressedSize = this.lzma.getUncompressedSize();
        if (!$assertionsDisabled && compressedSize <= 0) {
            throw new AssertionError(compressedSize);
        }
        if (!$assertionsDisabled && uncompressedSize <= 0) {
            throw new AssertionError(uncompressedSize);
        }
        if (compressedSize + 2 < uncompressedSize) {
            this.writeLZMA(uncompressedSize, compressedSize);
        } else {
            this.lzma.reset();
            uncompressedSize = this.lzma.getUncompressedSize();
            if (!$assertionsDisabled && uncompressedSize <= 0) {
                throw new AssertionError(uncompressedSize);
            }
            this.writeUncompressed(uncompressedSize);
        }
        this.pendingSize -= uncompressedSize;
        this.lzma.resetUncompressedSize();
        this.rc.reset();
    }

    private void writeLZMA(int uncompressedSize, int compressedSize) throws IOException {
        int control = this.propsNeeded ? (this.dictResetNeeded ? 224 : 192) : (this.stateResetNeeded ? 160 : 128);
        this.outData.writeByte(control |= uncompressedSize - 1 >>> 16);
        this.outData.writeShort(uncompressedSize - 1);
        this.outData.writeShort(compressedSize - 1);
        if (this.propsNeeded) {
            this.outData.writeByte(this.props);
        }
        this.rc.write(this.out);
        this.propsNeeded = false;
        this.stateResetNeeded = false;
        this.dictResetNeeded = false;
    }

    private void writeUncompressed(int uncompressedSize) throws IOException {
        while (uncompressedSize > 0) {
            int chunkSize = Math.min(uncompressedSize, 65536);
            this.outData.writeByte(this.dictResetNeeded ? 1 : 2);
            this.outData.writeShort(chunkSize - 1);
            this.lz.copyUncompressed(this.out, uncompressedSize, chunkSize);
            uncompressedSize -= chunkSize;
            this.dictResetNeeded = false;
        }
        this.stateResetNeeded = true;
    }

    private void writeEndMarker() throws IOException {
        if (!$assertionsDisabled && this.finished) {
            throw new AssertionError();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        this.lz.setFinishing();
        try {
            while (this.pendingSize > 0) {
                this.lzma.encodeForLZMA2();
                this.writeChunk();
            }
            this.out.write(0);
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
        this.finished = true;
    }

    public void flush() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            this.lz.setFlushing();
            while (this.pendingSize > 0) {
                this.lzma.encodeForLZMA2();
                this.writeChunk();
            }
            this.out.flush();
        }
        catch (IOException e) {
            this.exception = e;
            throw e;
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.writeEndMarker();
            try {
                this.out.finish();
            }
            catch (IOException e) {
                this.exception = e;
                throw e;
            }
            this.finished = true;
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            block7: {
                if (!this.finished) {
                    try {
                        this.writeEndMarker();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    if (this.exception != null) break block7;
                    this.exception = e;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    static {
        $assertionsDisabled = !LZMA2OutputStream.class.desiredAssertionStatus();
    }
}

