/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument.pass3;

import java.util.Map;
import net.sourceforge.cobertura.instrument.TouchPointListener;
import net.sourceforge.cobertura.instrument.pass3.CodeProvider;
import net.sourceforge.cobertura.instrument.tp.ClassMap;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectCodeTouchPointListener
implements TouchPointListener {
    private static final Logger logger = LoggerFactory.getLogger(InjectCodeTouchPointListener.class);
    private final CodeProvider codeProvider;
    private final ClassMap classMap;
    private int lastJumpIdVariableIndex;

    public InjectCodeTouchPointListener(ClassMap classMap, CodeProvider codeProvider) {
        this.classMap = classMap;
        this.codeProvider = codeProvider;
    }

    @Override
    public void beforeJump(int eventId, Label label, int currentLine, MethodVisitor nextMethodVisitor) {
        Integer jumpTrueCounterId = this.classMap.getCounterIdForJumpTrue(eventId);
        if (jumpTrueCounterId != null) {
            this.codeProvider.generateCodeThatSetsJumpCounterIdVariable(nextMethodVisitor, jumpTrueCounterId, this.lastJumpIdVariableIndex);
        }
    }

    @Override
    public void afterJump(int eventId, Label label, int currentLine, MethodVisitor nextMethodVisitor) {
        logger.debug("After jump:" + currentLine + "(" + eventId + ") to :" + label);
        Integer jumpFalseCounterId = this.classMap.getCounterIdForJumpFalse(eventId);
        if (jumpFalseCounterId != null) {
            this.codeProvider.generateCodeThatIncrementsCoberturaCounter(nextMethodVisitor, jumpFalseCounterId, this.classMap.getClassName());
            this.codeProvider.generateCodeThatZeroJumpCounterIdVariable(nextMethodVisitor, this.lastJumpIdVariableIndex);
        }
    }

    @Override
    public void beforeSwitch(int eventId, Label def, Label[] labels, int currentLine, MethodVisitor mv, String conditionType) {
        Integer switchCounterId = this.classMap.getCounterIdForSwitch(eventId);
        if (switchCounterId != null) {
            this.codeProvider.generateCodeThatSetsJumpCounterIdVariable(mv, switchCounterId, this.lastJumpIdVariableIndex);
        }
    }

    @Override
    public void afterLabel(int eventId, Label label, int currentLine, MethodVisitor mv) {
        Map<Integer, Integer> branchTouchPoints;
        logger.debug("Looking for jumps going to event(" + eventId + "):" + label + " ");
        if (this.classMap.isJumpDestinationLabel(eventId)) {
            this.codeProvider.generateCodeThatIncrementsCoberturaCounterFromInternalVariable(mv, this.lastJumpIdVariableIndex, this.classMap.getClassName());
        }
        if ((branchTouchPoints = this.classMap.getBranchLabelDescriptorsForLabelEvent(eventId)) != null) {
            for (Map.Entry<Integer, Integer> entry : branchTouchPoints.entrySet()) {
                this.codeProvider.generateCodeThatIncrementsCoberturaCounterIfVariableEqualsAndCleanVariable(mv, entry.getKey(), entry.getValue(), this.lastJumpIdVariableIndex, this.classMap.getClassName());
            }
        }
        if (this.classMap.isJumpDestinationLabel(eventId)) {
            this.codeProvider.generateCodeThatZeroJumpCounterIdVariable(mv, this.lastJumpIdVariableIndex);
        }
    }

    @Override
    public void afterLineNumber(int eventId, Label label, int currentLine, MethodVisitor nextMethodVisitor, String methodName, String methodSignature) {
        Integer lineCounterId = this.classMap.getCounterIdForLineEventId(eventId);
        if (lineCounterId != null) {
            this.codeProvider.generateCodeThatIncrementsCoberturaCounter(nextMethodVisitor, lineCounterId, this.classMap.getClassName());
        }
    }

    @Override
    public void afterMethodStart(MethodVisitor nextMethodVisitor) {
        this.codeProvider.generateCodeThatZeroJumpCounterIdVariable(nextMethodVisitor, this.lastJumpIdVariableIndex);
    }

    @Override
    public void beforeLabel(int eventId, Label label, int currentLine, MethodVisitor mv) {
    }

    @Override
    public void ignoreLine(int eventId, int currentLine) {
    }

    public void setLastJumpIdVariableIndex(int lastJumpIdVariableIndex) {
        this.lastJumpIdVariableIndex = lastJumpIdVariableIndex;
    }
}

