/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.filters.IntFilter;
import com.puppycrawl.tools.checkstyle.filters.IntMatchFilter;
import com.puppycrawl.tools.checkstyle.filters.IntRangeFilter;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;

class CsvFilter
implements IntFilter {
    private final Set<IntFilter> filters = Sets.newHashSet();

    CsvFilter(String pattern) {
        StringTokenizer tokenizer = new StringTokenizer(pattern, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            int index = token.indexOf(45);
            if (index == -1) {
                int matchValue = Integer.parseInt(token);
                this.addFilter(new IntMatchFilter(matchValue));
                continue;
            }
            int lowerBound = Integer.parseInt(token.substring(0, index));
            int upperBound = Integer.parseInt(token.substring(index + 1));
            this.addFilter(new IntRangeFilter(lowerBound, upperBound));
        }
    }

    public final void addFilter(IntFilter filter) {
        this.filters.add(filter);
    }

    protected Set<IntFilter> getFilters() {
        return Collections.unmodifiableSet(this.filters);
    }

    @Override
    public boolean accept(int intValue) {
        for (IntFilter filter : this.getFilters()) {
            if (!filter.accept(intValue)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CsvFilter csvFilter = (CsvFilter)object;
        return Objects.equals(this.filters, csvFilter.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }
}

