/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PackageObjectFactory
implements ModuleFactory {
    private static final Log LOG = LogFactory.getLog(PackageObjectFactory.class);
    private static final String IGNORING_EXCEPTION_MESSAGE = "Keep looking, ignoring exception";
    private static final String UNABLE_TO_INSTANTIATE_EXCEPTION_MESSAGE = "PackageObjectFactory.unableToInstantiateExceptionMessage";
    private static final String STRING_SEPARATOR = ", ";
    private final Set<String> packages;
    private final ClassLoader moduleClassLoader;

    public PackageObjectFactory(Set<String> packageNames, ClassLoader moduleClassLoader) {
        if (moduleClassLoader == null) {
            throw new IllegalArgumentException("moduleClassLoader must not be null");
        }
        this.packages = Sets.newLinkedHashSet(packageNames);
        this.moduleClassLoader = moduleClassLoader;
    }

    @Override
    public Object createModule(String name) throws CheckstyleException {
        String nameCheck;
        Object instance = this.createObjectWithIgnoringProblems(name, this.getAllPossibleNames(name));
        if (instance == null && (instance = this.createObjectWithIgnoringProblems(nameCheck = name + "Check", this.getAllPossibleNames(nameCheck))) == null) {
            String attemptedNames = this.joinPackageNamesWithClassName(name) + STRING_SEPARATOR + nameCheck + STRING_SEPARATOR + this.joinPackageNamesWithClassName(nameCheck);
            LocalizedMessage exceptionMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", UNABLE_TO_INSTANTIATE_EXCEPTION_MESSAGE, new String[]{name, attemptedNames}, null, this.getClass(), null);
            throw new CheckstyleException(exceptionMessage.getMessage());
        }
        return instance;
    }

    private Object createObjectWithIgnoringProblems(String className, Set<String> secondAttempt) {
        Object instance = this.createObject(className);
        if (instance == null) {
            Iterator<String> ite = secondAttempt.iterator();
            while (instance == null && ite.hasNext()) {
                instance = this.createObject(ite.next());
            }
        }
        return instance;
    }

    private Set<String> getAllPossibleNames(String name) {
        HashSet<String> names = Sets.newHashSet();
        for (String packageName : this.packages) {
            names.add(packageName + name);
        }
        return names;
    }

    private String joinPackageNamesWithClassName(String className) {
        Joiner joiner = Joiner.on(className + STRING_SEPARATOR).skipNulls();
        return joiner.join(this.packages) + className;
    }

    private Object createObject(String className) {
        Object instance = null;
        try {
            Class<?> clazz = Class.forName(className, true, this.moduleClassLoader);
            Constructor<?> declaredConstructor = clazz.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            instance = declaredConstructor.newInstance(new Object[0]);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException exception) {
            LOG.debug(IGNORING_EXCEPTION_MESSAGE, exception);
        }
        return instance;
    }
}

