/* Copyright 2016 The Tor Project
 * See LICENSE for licensing information */

/**
 * Interfaces and essential classes for obtaining and processing Tor
 * descriptors.
 *
 * <p>This package contains all relevant interfaces and
 * classes that an application would need to use this library.
 * Applications are strongly discouraged from accessing types from the
 * implementation package ({@code org.torproject.descriptor.impl})
 * directly, because those may change without prior notice.</p>
 *
 * <p>Interfaces and classes in this package can be grouped into
 * general-purpose types to obtain and process any type of descriptor and
 * descriptors produced by different components of the Tor network:</p>
 *
 * <ol>
 * <li>General-purpose types comprise
 * {@link org.torproject.descriptor.DescriptorSourceFactory} which is the
 * main entry point into using this library.  This factory is used to
 * create the descriptor sources for obtaining remote descriptor data
 * ({@link org.torproject.descriptor.DescriptorDownloader} and
 * {@link org.torproject.descriptor.DescriptorCollector}) and descriptor
 * sources for processing local descriptor data
 * ({@link org.torproject.descriptor.DescriptorReader} and
 * {@link org.torproject.descriptor.DescriptorParser}).  General-purpose
 * types also include descriptor containers
 * ({@link org.torproject.descriptor.DescriptorRequest} and
 * {@link org.torproject.descriptor.DescriptorFile}) and the
 * superinterface for all provided descriptors
 * ({@link org.torproject.descriptor.Descriptor}).</li>
 *
 * <li>The first group of descriptors is published by relays and servers
 * in the Tor network.  These interfaces include server descriptors
 * ({@link org.torproject.descriptor.ServerDescriptor} with subinterfaces
 * {@link org.torproject.descriptor.RelayServerDescriptor} and
 * {@link org.torproject.descriptor.BridgeServerDescriptor}), extra-info
 * descriptors ({@link org.torproject.descriptor.ExtraInfoDescriptor} with
 * subinterfaces
 * {@link org.torproject.descriptor.RelayExtraInfoDescriptor} and
 * {@link org.torproject.descriptor.BridgeExtraInfoDescriptor}),
 * microdescriptors which are derived from server descriptors by the
 * directory authorities
 * ({@link org.torproject.descriptor.Microdescriptor}), and helper types
 * for parts of the aforementioned descriptors
 * ({@link org.torproject.descriptor.BandwidthHistory}).</li>
 *
 * <li>The second group of descriptors is generated by authoritative
 * directory servers that form an opinion about relays and bridges in the
 * Tor network.  These include descriptors specified in version 3 of the
 * directory protocol
 * ({@link org.torproject.descriptor.RelayNetworkStatusConsensus},
 * {@link org.torproject.descriptor.RelayNetworkStatusVote},
 * {@link org.torproject.descriptor.DirectoryKeyCertificate}, and helper
 * types for descriptor parts
 * {@link org.torproject.descriptor.DirSourceEntry},
 * {@link org.torproject.descriptor.NetworkStatusEntry}, and
 * {@link org.torproject.descriptor.DirectorySignature}), descriptors from
 * earlier directory protocol version 2
 * ({@link org.torproject.descriptor.RelayNetworkStatus}) and version 1
 * ({@link org.torproject.descriptor.RelayDirectory} and
 * {@link org.torproject.descriptor.RouterStatusEntry}), as well as
 * descriptors published by the bridge authority and sanitized by the
 * CollecTor service
 * ({@link org.torproject.descriptor.BridgeNetworkStatus}).</li>
 *
 * <li>The third group of descriptors is created by auxiliary services
 * connected to the Tor network rather than by the Tor software.  This
 * group comprises descriptors by the bridge distribution service BridgeDB
 * ({@link org.torproject.descriptor.BridgePoolAssignment}), the exit list
 * service TorDNSEL ({@link org.torproject.descriptor.ExitList}), and the
 * performance measurement service Torperf
 * ({@link org.torproject.descriptor.TorperfResult}).</li>
 * </ol>
 *
 * @since 1.0.0
 */
package org.torproject.descriptor;

