/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class BlockingIteratorImpl<T>
implements Iterator<T> {
    private Queue<T> queue = new LinkedList<T>();
    private int maxQueueSize = 100;
    private boolean outOfDescriptors = false;

    protected BlockingIteratorImpl() {
    }

    protected BlockingIteratorImpl(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    protected synchronized void add(T object) {
        if (this.outOfDescriptors) {
            throw new IllegalStateException("Internal error: Adding results to descriptor queue not allowed after sending end-of-stream object.");
        }
        while (this.queue.size() >= this.maxQueueSize) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.queue.offer(object);
        this.notifyAll();
    }

    protected synchronized void setOutOfDescriptors() {
        if (this.outOfDescriptors) {
            throw new IllegalStateException("Internal error: Sending end-of-stream object only permitted once.");
        }
        this.outOfDescriptors = true;
        this.notifyAll();
    }

    @Override
    public synchronized boolean hasNext() {
        while (!this.outOfDescriptors && this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.queue.peek() != null;
    }

    @Override
    public synchronized T next() {
        while (!this.outOfDescriptors && this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.queue.peek() == null) {
            throw new NoSuchElementException();
        }
        this.notifyAll();
        return this.queue.remove();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

