/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.WrapOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;

public class SeparatorWrapCheck
extends AbstractCheck {
    public static final String MSG_LINE_PREVIOUS = "line.previous";
    public static final String MSG_LINE_NEW = "line.new";
    private WrapOption option = WrapOption.EOL;

    public void setOption(String optionStr) {
        try {
            this.option = WrapOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + optionStr, iae);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{59, 74};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{59, 74, 45, 171, 170, 76, 77, 17, 48};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        String text = ast.getText();
        int colNo = ast.getColumnNo();
        int lineNo = ast.getLineNo();
        String currentLine = this.getLines()[lineNo - 1];
        String substringAfterToken = currentLine.substring(colNo + text.length()).trim();
        String substringBeforeToken = currentLine.substring(0, colNo).trim();
        if (this.option == WrapOption.EOL && substringBeforeToken.isEmpty()) {
            this.log(lineNo, colNo, MSG_LINE_PREVIOUS, text);
        } else if (this.option == WrapOption.NL && substringAfterToken.isEmpty()) {
            this.log(lineNo, colNo, MSG_LINE_NEW, text);
        }
    }
}

