/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.DatatypeConverter;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.RelayNetworkStatus;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.NetworkStatusImpl;
import org.torproject.descriptor.impl.ParseHelper;

public class RelayNetworkStatusImpl
extends NetworkStatusImpl
implements RelayNetworkStatus {
    private String statusDigest;
    private int networkStatusVersion;
    private String hostname;
    private String address;
    private int dirPort;
    private String fingerprint;
    private String contactLine;
    private String dirSigningKey;
    private String[] recommendedClientVersions;
    private String[] recommendedServerVersions;
    private long publishedMillis;
    private String[] dirOptions;
    private String nickname;
    private String directorySignature;

    protected static List<RelayNetworkStatus> parseStatuses(byte[] statusesBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        ArrayList<RelayNetworkStatus> parsedStatuses = new ArrayList<RelayNetworkStatus>();
        List<byte[]> splitStatusBytes = DescriptorImpl.splitRawDescriptorBytes(statusesBytes, "network-status-version 2");
        for (byte[] statusBytes : splitStatusBytes) {
            RelayNetworkStatusImpl parsedStatus = new RelayNetworkStatusImpl(statusBytes, failUnrecognizedDescriptorLines);
            parsedStatuses.add(parsedStatus);
        }
        return parsedStatuses;
    }

    protected RelayNetworkStatusImpl(byte[] statusBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        super(statusBytes, failUnrecognizedDescriptorLines, false, true);
        HashSet<String> exactlyOnceKeywords = new HashSet<String>(Arrays.asList("network-status-version,dir-source,fingerprint,contact,dir-signing-key,published".split(",")));
        this.checkExactlyOnceKeywords(exactlyOnceKeywords);
        HashSet<String> atMostOnceKeywords = new HashSet<String>(Arrays.asList("dir-options,client-versions,server-versions".split(",")));
        this.checkAtMostOnceKeywords(atMostOnceKeywords);
        this.checkFirstKeyword("network-status-version");
        this.clearParsedKeywords();
        this.calculateDigest();
    }

    private void calculateDigest() throws DescriptorParseException {
        try {
            String ascii = new String(this.getRawDescriptorBytes(), "US-ASCII");
            String startToken = "network-status-version ";
            String sigToken = "\ndirectory-signature ";
            if (!ascii.contains(sigToken)) {
                return;
            }
            int start = ascii.indexOf(startToken);
            int sig = ascii.indexOf(sigToken) + sigToken.length();
            sig = ascii.indexOf("\n", sig) + 1;
            if (start >= 0 && sig >= 0 && sig > start) {
                byte[] forDigest = new byte[sig - start];
                System.arraycopy(this.getRawDescriptorBytes(), start, forDigest, 0, sig - start);
                this.statusDigest = DatatypeConverter.printHexBinary((byte[])MessageDigest.getInstance("SHA-1").digest(forDigest)).toLowerCase();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (this.statusDigest == null) {
            throw new DescriptorParseException("Could not calculate status digest.");
        }
    }

    @Override
    protected void parseHeader(byte[] headerBytes) throws DescriptorParseException {
        Scanner scanner = new Scanner(new String(headerBytes)).useDelimiter("\n");
        String nextCrypto = "";
        StringBuilder crypto = null;
        block26: while (scanner.hasNext()) {
            String keyword;
            String line = scanner.next();
            if (line.isEmpty()) continue;
            String[] parts = line.split("[ \t]+");
            switch (keyword = parts[0]) {
                case "network-status-version": {
                    this.parseNetworkStatusVersionLine(line, parts);
                    continue block26;
                }
                case "dir-source": {
                    this.parseDirSourceLine(line, parts);
                    continue block26;
                }
                case "fingerprint": {
                    this.parseFingerprintLine(line, parts);
                    continue block26;
                }
                case "contact": {
                    this.parseContactLine(line, parts);
                    continue block26;
                }
                case "dir-signing-key": {
                    this.parseDirSigningKeyLine(line, parts);
                    nextCrypto = "dir-signing-key";
                    continue block26;
                }
                case "client-versions": {
                    this.parseClientVersionsLine(line, parts);
                    continue block26;
                }
                case "server-versions": {
                    this.parseServerVersionsLine(line, parts);
                    continue block26;
                }
                case "published": {
                    this.parsePublishedLine(line, parts);
                    continue block26;
                }
                case "dir-options": {
                    this.parseDirOptionsLine(line, parts);
                    continue block26;
                }
                case "-----BEGIN": {
                    crypto = new StringBuilder();
                    crypto.append(line).append("\n");
                    continue block26;
                }
                case "-----END": {
                    crypto.append(line).append("\n");
                    String cryptoString = crypto.toString();
                    crypto = null;
                    if (!nextCrypto.equals("dir-signing-key")) {
                        throw new DescriptorParseException("Unrecognized crypto block in v2 network status.");
                    }
                    this.dirSigningKey = cryptoString;
                    nextCrypto = "";
                    continue block26;
                }
            }
            if (crypto != null) {
                crypto.append(line).append("\n");
                continue;
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in v2 network status.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    @Override
    protected void parseFooter(byte[] footerBytes) throws DescriptorParseException {
        throw new DescriptorParseException("No directory footer expected in v2 network status.");
    }

    @Override
    protected void parseDirectorySignature(byte[] directorySignatureBytes) throws DescriptorParseException {
        Scanner scanner = new Scanner(new String(directorySignatureBytes)).useDelimiter("\n");
        String nextCrypto = "";
        StringBuilder crypto = null;
        block10: while (scanner.hasNext()) {
            String keyword;
            String line = scanner.next();
            String[] parts = line.split("[ \t]+");
            switch (keyword = parts[0]) {
                case "directory-signature": {
                    this.parseDirectorySignatureLine(line, parts);
                    nextCrypto = "directory-signature";
                    continue block10;
                }
                case "-----BEGIN": {
                    crypto = new StringBuilder();
                    crypto.append(line).append("\n");
                    continue block10;
                }
                case "-----END": {
                    crypto.append(line).append("\n");
                    String cryptoString = crypto.toString();
                    crypto = null;
                    if (!nextCrypto.equals("directory-signature")) {
                        throw new DescriptorParseException("Unrecognized crypto block in v2 network status.");
                    }
                    this.directorySignature = cryptoString;
                    nextCrypto = "";
                    continue block10;
                }
            }
            if (crypto != null) {
                crypto.append(line).append("\n");
                continue;
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in v2 network status.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseNetworkStatusVersionLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals("network-status-version 2")) {
            throw new DescriptorParseException("Illegal network status version number in line '" + line + "'.");
        }
        this.networkStatusVersion = 2;
    }

    private void parseDirSourceLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 4) {
            throw new DescriptorParseException("Illegal line '" + line + "' in v2 network status.");
        }
        if (parts[1].length() < 1) {
            throw new DescriptorParseException("Illegal hostname in '" + line + "'.");
        }
        this.address = ParseHelper.parseIpv4Address(line, parts[2]);
        this.dirPort = ParseHelper.parsePort(line, parts[3]);
    }

    private void parseFingerprintLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in v2 network status.");
        }
        this.fingerprint = ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    private void parseContactLine(String line, String[] parts) throws DescriptorParseException {
        this.contactLine = line.length() > "contact ".length() ? line.substring("contact ".length()) : "";
    }

    private void parseDirSigningKeyLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals("dir-signing-key")) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseClientVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedClientVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parseServerVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedServerVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parsePublishedLine(String line, String[] parts) throws DescriptorParseException {
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseDirOptionsLine(String line, String[] parts) throws DescriptorParseException {
        String[] dirOptions = new String[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            dirOptions[i - 1] = parts[i];
        }
        this.dirOptions = dirOptions;
    }

    private void parseDirectorySignatureLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.nickname = ParseHelper.parseNickname(line, parts[1]);
    }

    @Override
    public String getStatusDigest() {
        return this.statusDigest;
    }

    @Override
    public int getNetworkStatusVersion() {
        return this.networkStatusVersion;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public int getDirport() {
        return this.dirPort;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public String getContactLine() {
        return this.contactLine;
    }

    @Override
    public String getDirSigningKey() {
        return this.dirSigningKey;
    }

    @Override
    public List<String> getRecommendedClientVersions() {
        return this.recommendedClientVersions == null ? null : Arrays.asList(this.recommendedClientVersions);
    }

    @Override
    public List<String> getRecommendedServerVersions() {
        return this.recommendedServerVersions == null ? null : Arrays.asList(this.recommendedServerVersions);
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public SortedSet<String> getDirOptions() {
        return new TreeSet<String>(Arrays.asList(this.dirOptions));
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getDirectorySignature() {
        return this.directorySignature;
    }
}

