/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.SortedMap;
import java.util.TreeMap;
import org.torproject.descriptor.BandwidthHistory;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.impl.ParseHelper;

public class BandwidthHistoryImpl
implements BandwidthHistory {
    private String line;
    private long historyEndMillis;
    private long intervalLength;
    private long[] bandwidthValues;

    protected BandwidthHistoryImpl(String line, String lineNoOpt, String[] partsNoOpt) throws DescriptorParseException {
        boolean isValid = false;
        this.line = line;
        if (partsNoOpt.length == 5 || partsNoOpt.length == 6) {
            try {
                this.historyEndMillis = ParseHelper.parseTimestampAtIndex(line, partsNoOpt, 1, 2);
                if (partsNoOpt[3].startsWith("(") && partsNoOpt[4].startsWith("s)")) {
                    this.intervalLength = Long.parseLong(partsNoOpt[3].substring(1));
                    if (this.intervalLength <= 0L) {
                        throw new DescriptorParseException("Only positive interval lengths are allowed in line '" + line + "'.");
                    }
                    String[] values = null;
                    if (partsNoOpt.length == 5 && partsNoOpt[4].equals("s)")) {
                        isValid = true;
                    } else if (partsNoOpt.length == 6) {
                        values = partsNoOpt[5].split(",", -1);
                    } else if (partsNoOpt[4].length() > 2) {
                        values = partsNoOpt[4].substring(2).split(",", -1);
                    }
                    if (values != null) {
                        this.bandwidthValues = new long[values.length];
                        for (int i = values.length - 1; i >= 0; --i) {
                            long bandwidthValue = Long.parseLong(values[i]);
                            if (bandwidthValue < 0L) {
                                throw new DescriptorParseException("Negative bandwidth values are not allowed in line '" + line + "'.");
                            }
                            this.bandwidthValues[i] = bandwidthValue;
                        }
                        isValid = true;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!isValid) {
            throw new DescriptorParseException("Invalid bandwidth-history line '" + line + "'.");
        }
    }

    @Override
    public String getLine() {
        return this.line;
    }

    @Override
    public long getHistoryEndMillis() {
        return this.historyEndMillis;
    }

    @Override
    public long getIntervalLength() {
        return this.intervalLength;
    }

    @Override
    public SortedMap<Long, Long> getBandwidthValues() {
        TreeMap<Long, Long> result = new TreeMap<Long, Long>();
        if (this.bandwidthValues != null) {
            long endMillis = this.historyEndMillis;
            for (int i = this.bandwidthValues.length - 1; i >= 0; --i) {
                result.put(endMillis, this.bandwidthValues[i]);
                endMillis -= this.intervalLength * 1000L;
            }
        }
        return result;
    }
}

