/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorRequest;
import org.torproject.descriptor.DirSourceEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.impl.BlockingIteratorImpl;
import org.torproject.descriptor.impl.DescriptorRequestImpl;
import org.torproject.descriptor.impl.DirectoryDownloader;
import org.torproject.descriptor.impl.DownloadCoordinator;

public class DownloadCoordinatorImpl
implements DownloadCoordinator {
    private BlockingIteratorImpl<DescriptorRequest> descriptorQueue = new BlockingIteratorImpl();
    private SortedSet<String> runningDirectories;
    private SortedMap<String, DirectoryDownloader> directoryAuthorities;
    private SortedMap<String, DirectoryDownloader> directoryMirrors;
    private boolean downloadConsensusFromAllAuthorities;
    private boolean includeCurrentReferencedVotes;
    private long connectTimeoutMillis;
    private long readTimeoutMillis;
    private long globalTimeoutMillis;
    private boolean failUnrecognizedDescriptorLines;
    private Thread globalTimerThread;
    private boolean missingConsensus = false;
    private Set<String> requestingConsensuses = new HashSet<String>();
    private Set<String> requestedConsensuses = new HashSet<String>();
    private Set<String> missingVotes = new HashSet<String>();
    private Map<String, String> requestingVotes = new HashMap<String, String>();
    private Map<String, Set<String>> requestedVotes = new HashMap<String, Set<String>>();
    private boolean hasFinishedDownloading = false;

    protected Iterator<DescriptorRequest> getDescriptorQueue() {
        return this.descriptorQueue;
    }

    protected DownloadCoordinatorImpl(SortedMap<String, DirectoryDownloader> directoryAuthorities, SortedMap<String, DirectoryDownloader> directoryMirrors, boolean downloadConsensus, boolean downloadConsensusFromAllAuthorities, Set<String> downloadVotes, boolean includeCurrentReferencedVotes, long connectTimeoutMillis, long readTimeoutMillis, long globalTimeoutMillis, boolean failUnrecognizedDescriptorLines) {
        this.directoryAuthorities = directoryAuthorities;
        this.directoryMirrors = directoryMirrors;
        this.runningDirectories = new TreeSet<String>();
        this.runningDirectories.addAll(directoryAuthorities.keySet());
        this.runningDirectories.addAll(directoryMirrors.keySet());
        this.missingConsensus = downloadConsensus;
        this.downloadConsensusFromAllAuthorities = downloadConsensusFromAllAuthorities;
        this.missingVotes = downloadVotes;
        this.includeCurrentReferencedVotes = includeCurrentReferencedVotes;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.globalTimeoutMillis = globalTimeoutMillis;
        this.failUnrecognizedDescriptorLines = failUnrecognizedDescriptorLines;
        if (this.directoryMirrors.isEmpty() && this.directoryAuthorities.isEmpty()) {
            this.descriptorQueue.setOutOfDescriptors();
        } else {
            GlobalTimer globalTimer = new GlobalTimer(this.globalTimeoutMillis, this);
            this.globalTimerThread = new Thread(globalTimer);
            this.globalTimerThread.start();
            for (DirectoryDownloader directoryMirror : this.directoryMirrors.values()) {
                directoryMirror.setDownloadCoordinator(this);
                directoryMirror.setConnectTimeout(this.connectTimeoutMillis);
                directoryMirror.setReadTimeout(this.readTimeoutMillis);
                directoryMirror.setFailUnrecognizedDescriptorLines(this.failUnrecognizedDescriptorLines);
                new Thread(directoryMirror).start();
            }
            for (DirectoryDownloader directoryAuthority : this.directoryAuthorities.values()) {
                directoryAuthority.setDownloadCoordinator(this);
                directoryAuthority.setConnectTimeout(this.connectTimeoutMillis);
                directoryAuthority.setReadTimeout(this.readTimeoutMillis);
                directoryAuthority.setFailUnrecognizedDescriptorLines(this.failUnrecognizedDescriptorLines);
                new Thread(directoryAuthority).start();
            }
        }
    }

    @Override
    public synchronized DescriptorRequestImpl createRequest(String nickname) {
        while (!this.hasFinishedDownloading) {
            DescriptorRequestImpl request = new DescriptorRequestImpl();
            request.setDirectoryNickname(nickname);
            if ((this.missingConsensus || this.downloadConsensusFromAllAuthorities && this.directoryAuthorities.containsKey(nickname)) && !this.requestedConsensuses.contains(nickname)) {
                if (!this.downloadConsensusFromAllAuthorities) {
                    this.missingConsensus = false;
                }
                this.requestingConsensuses.add(nickname);
                this.requestedConsensuses.add(nickname);
                request.setRequestedResource("/tor/status-vote/current/consensus.z");
                request.setDescriptorType("consensus");
                return request;
            }
            if (!this.missingVotes.isEmpty() && this.directoryAuthorities.containsKey(nickname)) {
                String requestingVote = null;
                for (String missingVote : this.missingVotes) {
                    if (this.requestedVotes.containsKey(nickname) && this.requestedVotes.get(nickname).contains(missingVote)) continue;
                    requestingVote = missingVote;
                }
                if (requestingVote != null) {
                    this.requestingVotes.put(nickname, requestingVote);
                    if (!this.requestedVotes.containsKey(nickname)) {
                        this.requestedVotes.put(nickname, new HashSet());
                    }
                    this.requestedVotes.get(nickname).add(requestingVote);
                    this.missingVotes.remove(requestingVote);
                    request.setRequestedResource("/tor/status-vote/current/" + requestingVote + ".z");
                    request.setDescriptorType("vote");
                    return request;
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    @Override
    public synchronized void deliverResponse(DescriptorRequestImpl response) {
        String nickname = response.getDirectoryNickname();
        if (response.getException() != null) {
            this.runningDirectories.remove(nickname);
        }
        switch (response.getDescriptorType()) {
            case "consensus": {
                this.requestingConsensuses.remove(nickname);
                if (response.getResponseCode() == 200 && response.getDescriptors() != null) {
                    if (!this.includeCurrentReferencedVotes) break;
                    for (Descriptor parsedDescriptor : response.getDescriptors()) {
                        if (!(parsedDescriptor instanceof RelayNetworkStatusConsensus)) continue;
                        RelayNetworkStatusConsensus parsedConsensus = (RelayNetworkStatusConsensus)parsedDescriptor;
                        for (DirSourceEntry dirSource : parsedConsensus.getDirSourceEntries().values()) {
                            String identity = dirSource.getIdentity();
                            if (this.missingVotes.contains(identity)) continue;
                            boolean alreadyRequested = false;
                            for (Set<String> requestedBefore : this.requestedVotes.values()) {
                                if (!requestedBefore.contains(identity)) continue;
                                alreadyRequested = true;
                                break;
                            }
                            if (alreadyRequested) continue;
                            this.missingVotes.add(identity);
                        }
                    }
                    break;
                }
                this.missingConsensus = true;
                break;
            }
            case "vote": {
                String requestedVote = this.requestingVotes.remove(nickname);
                if (response.getResponseCode() == 200) break;
                this.missingVotes.add(requestedVote);
            }
        }
        if (response.getRequestEnd() != 0L) {
            this.descriptorQueue.add(response);
        }
        boolean doneDownloading = true;
        if (!(!this.missingConsensus && !this.downloadConsensusFromAllAuthorities || this.requestedConsensuses.containsAll(this.runningDirectories) && this.requestingConsensuses.isEmpty())) {
            doneDownloading = false;
        }
        if (!this.requestingVotes.isEmpty()) {
            doneDownloading = false;
        } else if (!this.missingVotes.isEmpty()) {
            if (!this.requestedVotes.keySet().containsAll(this.runningDirectories)) {
                doneDownloading = false;
            } else {
                for (String missingVote : this.missingVotes) {
                    for (String runningDirectory : this.runningDirectories) {
                        Set<String> reqVotes = this.requestedVotes.get(runningDirectory);
                        if (reqVotes.contains(missingVote)) continue;
                        doneDownloading = false;
                    }
                }
            }
        }
        if (doneDownloading) {
            this.hasFinishedDownloading = true;
            this.globalTimerThread.interrupt();
            this.descriptorQueue.setOutOfDescriptors();
        }
        this.notifyAll();
    }

    private synchronized void interruptAllDownloads() {
        this.hasFinishedDownloading = true;
        this.notifyAll();
    }

    private static class GlobalTimer
    implements Runnable {
        private long timeoutMillis;
        private DownloadCoordinatorImpl downloadCoordinator;

        private GlobalTimer(long timeoutMillis, DownloadCoordinatorImpl downloadCoordinator) {
            this.timeoutMillis = timeoutMillis;
            this.downloadCoordinator = downloadCoordinator;
        }

        @Override
        public void run() {
            long sleep;
            long started = System.currentTimeMillis();
            while ((sleep = started + this.timeoutMillis - System.currentTimeMillis()) > 0L) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            this.downloadCoordinator.interruptAllDownloads();
        }
    }
}

