/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import org.junit.Test;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.Microdescriptor;
import org.torproject.descriptor.impl.MicrodescriptorImpl;

public class MicrodescriptorImplTest {
    @Test
    public void testDefaults() throws DescriptorParseException {
        DescriptorBuilder.createWithDefaultLines();
    }

    @Test(expected=DescriptorParseException.class)
    public void testIdRsa1024TooShort() throws DescriptorParseException {
        DescriptorBuilder.createWithIdLine("id rsa1024 AAAA");
    }

    @Test(expected=DescriptorParseException.class)
    public void testIdRsa1024TooLong() throws DescriptorParseException {
        DescriptorBuilder.createWithIdLine("id ed25519 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
    }

    @Test(expected=DescriptorParseException.class)
    public void testIdRsa512() throws DescriptorParseException {
        DescriptorBuilder.createWithIdLine("id rsa512 bvegfGxp8k7T9QFpjPTrPaJTa/8");
    }

    @Test(expected=DescriptorParseException.class)
    public void testIdEd25519Duplicate() throws DescriptorParseException {
        DescriptorBuilder.createWithIdLine("id rsa1024 bvegfGxp8k7T9QFpjPTrPaJTa/8\nid rsa1024 bvegfGxp8k7T9QFpjPTrPaJTa/8");
    }

    private static class DescriptorBuilder {
        private String onionKeyLines = "onion-key\n-----BEGIN RSA PUBLIC KEY-----\nMIGJAoGBALNZ4pNsHHkl7a+kFWbBmPHNAepjjvuhjTr1TaMB3UKuCRaXJmS2QrCW\nkTmINqdQUccwb3ghb7EBZfDtCUvjcwMSEsRRTVIZqVQsYj6m3n1CegOc4oUutXaZ\nfkyty5XOgV4Qucx9wokzTMCHlO0V0x9y0FwFsK5Nb6ugqfQLLQ6XAgMBAAE=\n-----END RSA PUBLIC KEY-----";
        private String ntorOnionKeyLine = "ntor-onion-key PXLa7IGE+TzPDMsM5j9rFnDa37rd6kfZa5QuzqqJukw=";
        private String idLine = "id rsa1024 bvegfGxp8k7T9QFpjPTrPaJTa/8";

        private DescriptorBuilder() {
        }

        private static Microdescriptor createWithDefaultLines() throws DescriptorParseException {
            DescriptorBuilder db = new DescriptorBuilder();
            return new MicrodescriptorImpl(db.buildDescriptor(), true);
        }

        private static Microdescriptor createWithIdLine(String line) throws DescriptorParseException {
            DescriptorBuilder db = new DescriptorBuilder();
            db.idLine = line;
            return new MicrodescriptorImpl(db.buildDescriptor(), true);
        }

        private byte[] buildDescriptor() {
            StringBuilder sb = new StringBuilder();
            if (this.onionKeyLines != null) {
                sb.append(this.onionKeyLines).append("\n");
            }
            if (this.ntorOnionKeyLine != null) {
                sb.append(this.ntorOnionKeyLine).append("\n");
            }
            if (this.idLine != null) {
                sb.append(this.idLine).append("\n");
            }
            return sb.toString().getBytes();
        }
    }
}

