/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.impl.BridgeNetworkStatusImpl;

public class BridgeNetworkStatusTest {
    @Test
    public void testSampleStatus() throws DescriptorParseException {
        StatusBuilder sb = new StatusBuilder();
        BridgeNetworkStatusImpl status = new BridgeNetworkStatusImpl(sb.buildStatus(), sb.fileName, true);
        Assert.assertEquals((long)1448127576000L, (long)status.getPublishedMillis());
        Assert.assertEquals((long)3105080L, (long)status.getStableUptime());
        Assert.assertEquals((long)2450615L, (long)status.getStableMtbf());
        Assert.assertEquals((long)55000L, (long)status.getFastBandwidth());
        Assert.assertEquals((double)98.0, (double)status.getGuardWfu(), (double)0.001);
        Assert.assertEquals((long)691200L, (long)status.getGuardTk());
        Assert.assertEquals((long)337000L, (long)status.getGuardBandwidthIncludingExits());
        Assert.assertEquals((long)339000L, (long)status.getGuardBandwidthExcludingExits());
        Assert.assertEquals((long)1L, (long)status.getEnoughMtbfInfo());
        Assert.assertEquals((long)0L, (long)status.getIgnoringAdvertisedBws());
        Assert.assertEquals((long)264L, (long)((NetworkStatusEntry)status.getStatusEntries().get("001934C20E23E812C27592A5795B6636B7F32462")).getBandwidth());
        Assert.assertTrue((boolean)status.getUnrecognizedLines().isEmpty());
    }

    @Test
    public void testPublishedNoLine() throws DescriptorParseException {
        BridgeNetworkStatus status = StatusBuilder.createWithPublishedLine(null);
        Assert.assertEquals((long)1448127576000L, (long)status.getPublishedMillis());
    }

    @Test
    public void testFlagThresholdsNoLine() throws DescriptorParseException {
        BridgeNetworkStatus status = StatusBuilder.createWithFlagThresholdsLine(null);
        Assert.assertEquals((long)-1L, (long)status.getStableUptime());
        Assert.assertEquals((long)-1L, (long)status.getStableMtbf());
        Assert.assertEquals((long)-1L, (long)status.getFastBandwidth());
        Assert.assertEquals((double)-1.0, (double)status.getGuardWfu(), (double)0.001);
        Assert.assertEquals((long)-1L, (long)status.getGuardTk());
        Assert.assertEquals((long)-1L, (long)status.getGuardBandwidthIncludingExits());
        Assert.assertEquals((long)-1L, (long)status.getGuardBandwidthExcludingExits());
        Assert.assertEquals((long)-1L, (long)status.getEnoughMtbfInfo());
        Assert.assertEquals((long)-1L, (long)status.getIgnoringAdvertisedBws());
    }

    private static class StatusBuilder {
        private String fileName = "20151121-173936-4A0CCD2DDC7995083D73F5D667100C8A5831F16D";
        private String publishedLine = "published 2015-11-21 17:39:36";
        private String flagThresholdsLine = "flag-thresholds stable-uptime=3105080 stable-mtbf=2450615 fast-speed=55000 guard-wfu=98.000% guard-tk=691200 guard-bw-inc-exits=337000 guard-bw-exc-exits=339000 enough-mtbf=1 ignoring-advertised-bws=0";
        private List<String> statusEntries = new ArrayList<String>();
        private String unrecognizedHeaderLine = null;
        private String unrecognizedStatusEntryLine = null;

        private static BridgeNetworkStatus createWithFileName(String fileName) throws DescriptorParseException {
            StatusBuilder sb = new StatusBuilder();
            sb.fileName = fileName;
            return new BridgeNetworkStatusImpl(sb.buildStatus(), sb.fileName, true);
        }

        private static BridgeNetworkStatus createWithPublishedLine(String line) throws DescriptorParseException {
            StatusBuilder sb = new StatusBuilder();
            sb.publishedLine = line;
            return new BridgeNetworkStatusImpl(sb.buildStatus(), sb.fileName, true);
        }

        private static BridgeNetworkStatus createWithFlagThresholdsLine(String line) throws DescriptorParseException {
            StatusBuilder sb = new StatusBuilder();
            sb.flagThresholdsLine = line;
            return new BridgeNetworkStatusImpl(sb.buildStatus(), sb.fileName, true);
        }

        protected static BridgeNetworkStatus createWithUnrecognizedHeaderLine(String line, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
            StatusBuilder sb = new StatusBuilder();
            sb.unrecognizedHeaderLine = line;
            return new BridgeNetworkStatusImpl(sb.buildStatus(), sb.fileName, failUnrecognizedDescriptorLines);
        }

        protected static BridgeNetworkStatus createWithUnrecognizedStatusEntryLine(String line, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
            StatusBuilder sb = new StatusBuilder();
            sb.unrecognizedStatusEntryLine = line;
            return new BridgeNetworkStatusImpl(sb.buildStatus(), sb.fileName, failUnrecognizedDescriptorLines);
        }

        private StatusBuilder() {
            this.statusEntries.add("r Unnamed ABk0wg4j6BLCdZKleVtmNrfzJGI bh7gVU1Cz6+JG+7j4qGsF4prDi8 2015-11-21 15:46:25 10.153.163.200 443 0\ns Fast Running Stable Valid\nw Bandwidth=264\np reject 1-65535");
        }

        private byte[] buildStatus() {
            StringBuilder sb = new StringBuilder();
            this.appendHeader(sb);
            this.appendStatusEntries(sb);
            return sb.toString().getBytes();
        }

        private void appendHeader(StringBuilder sb) {
            if (this.publishedLine != null) {
                sb.append(this.publishedLine).append("\n");
            }
            if (this.flagThresholdsLine != null) {
                sb.append(this.flagThresholdsLine).append("\n");
            }
            if (this.unrecognizedHeaderLine != null) {
                sb.append(this.unrecognizedHeaderLine).append("\n");
            }
        }

        private void appendStatusEntries(StringBuilder sb) {
            for (String statusEntry : this.statusEntries) {
                sb.append(statusEntry).append("\n");
            }
            if (this.unrecognizedStatusEntryLine != null) {
                sb.append(this.unrecognizedStatusEntryLine).append("\n");
            }
        }
    }
}

