/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.impl.ParseHelper;

public class NetworkStatusEntryImpl
implements NetworkStatusEntry {
    private byte[] statusEntryBytes;
    private boolean microdescConsensus;
    private boolean failUnrecognizedDescriptorLines;
    private List<String> unrecognizedLines;
    private SortedSet<String> atMostOnceKeywords;
    private static Map<String, Integer> flagIndexes = new HashMap<String, Integer>();
    private static Map<Integer, String> flagStrings = new HashMap<Integer, String>();
    private String nickname;
    private String fingerprint;
    private String descriptor;
    private long publishedMillis;
    private String address;
    private int orPort;
    private int dirPort;
    private Set<String> microdescriptorDigests;
    private List<String> orAddresses = new ArrayList<String>();
    private BitSet flags;
    private String version;
    private long bandwidth = -1L;
    private long measured = -1L;
    private boolean unmeasured = false;
    private String defaultPolicy;
    private String portList;

    @Override
    public byte[] getStatusEntryBytes() {
        return this.statusEntryBytes;
    }

    protected List<String> getAndClearUnrecognizedLines() {
        List<String> lines = this.unrecognizedLines;
        this.unrecognizedLines = null;
        return lines;
    }

    protected NetworkStatusEntryImpl(byte[] statusEntryBytes, boolean microdescConsensus, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        this.statusEntryBytes = statusEntryBytes;
        this.microdescConsensus = microdescConsensus;
        this.failUnrecognizedDescriptorLines = failUnrecognizedDescriptorLines;
        this.initializeKeywords();
        this.parseStatusEntryBytes();
        this.clearAtMostOnceKeywords();
    }

    private void initializeKeywords() {
        this.atMostOnceKeywords = new TreeSet<String>();
        this.atMostOnceKeywords.add("s");
        this.atMostOnceKeywords.add("v");
        this.atMostOnceKeywords.add("w");
        this.atMostOnceKeywords.add("p");
    }

    private void parsedAtMostOnceKeyword(String keyword) throws DescriptorParseException {
        if (!this.atMostOnceKeywords.contains(keyword)) {
            throw new DescriptorParseException("Duplicate '" + keyword + "' line in status entry.");
        }
        this.atMostOnceKeywords.remove(keyword);
    }

    private void parseStatusEntryBytes() throws DescriptorParseException {
        Scanner s = new Scanner(new String(this.statusEntryBytes)).useDelimiter("\n");
        String line = null;
        if (!s.hasNext() || !(line = s.next()).startsWith("r ")) {
            throw new DescriptorParseException("Status entry must start with an r line.");
        }
        String[] rLineParts = line.split("[ \t]+");
        this.parseRLine(line, rLineParts);
        while (s.hasNext()) {
            line = s.next();
            String[] parts = !line.startsWith("opt ") ? line.split("[ \t]+") : line.substring("opt ".length()).split("[ \t]+");
            String keyword = parts[0];
            if (keyword.equals("a")) {
                this.parseALine(line, parts);
                continue;
            }
            if (keyword.equals("s")) {
                this.parseSLine(line, parts);
                continue;
            }
            if (keyword.equals("v")) {
                this.parseVLine(line, parts);
                continue;
            }
            if (keyword.equals("w")) {
                this.parseWLine(line, parts);
                continue;
            }
            if (keyword.equals("p")) {
                this.parsePLine(line, parts);
                continue;
            }
            if (keyword.equals("m")) {
                this.parseMLine(line, parts);
                continue;
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in status entry.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList<String>();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseRLine(String line, String[] parts) throws DescriptorParseException {
        if (!this.microdescConsensus && parts.length != 9 || this.microdescConsensus && parts.length != 8) {
            throw new DescriptorParseException("r line '" + line + "' has " + "fewer space-separated elements than expected.");
        }
        this.nickname = ParseHelper.parseNickname(line, parts[1]);
        this.fingerprint = ParseHelper.parseTwentyByteBase64String(line, parts[2]);
        int descriptorOffset = 0;
        if (!this.microdescConsensus) {
            this.descriptor = ParseHelper.parseTwentyByteBase64String(line, parts[3]);
            descriptorOffset = 1;
        }
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 3 + descriptorOffset, 4 + descriptorOffset);
        this.address = ParseHelper.parseIpv4Address(line, parts[5 + descriptorOffset]);
        this.orPort = ParseHelper.parsePort(line, parts[6 + descriptorOffset]);
        this.dirPort = ParseHelper.parsePort(line, parts[7 + descriptorOffset]);
    }

    private void parseALine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Invalid line '" + line + "' in " + "status entry.");
        }
        this.orAddresses.add(parts[1]);
    }

    private void parseSLine(String line, String[] parts) throws DescriptorParseException {
        this.parsedAtMostOnceKeyword("s");
        BitSet flags = new BitSet(flagIndexes.size());
        for (int i = 1; i < parts.length; ++i) {
            String flag = parts[i];
            if (!flagIndexes.containsKey(flag)) {
                flagStrings.put(flagIndexes.size(), flag);
                flagIndexes.put(flag, flagIndexes.size());
            }
            flags.set(flagIndexes.get(flag));
        }
        this.flags = flags;
    }

    private void parseVLine(String line, String[] parts) throws DescriptorParseException {
        this.parsedAtMostOnceKeyword("v");
        String noOptLine = line;
        if (noOptLine.startsWith("opt ")) {
            noOptLine = noOptLine.substring(4);
        }
        if (noOptLine.length() < 3) {
            throw new DescriptorParseException("Invalid line '" + line + "' in " + "status entry.");
        }
        this.version = noOptLine.substring(2);
    }

    private void parseWLine(String line, String[] parts) throws DescriptorParseException {
        this.parsedAtMostOnceKeyword("w");
        SortedMap<String, Integer> pairs = ParseHelper.parseKeyValueIntegerPairs(line, parts, 1, "=");
        if (pairs.isEmpty()) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        if (pairs.containsKey("Bandwidth")) {
            this.bandwidth = ((Integer)pairs.remove("Bandwidth")).intValue();
        }
        if (pairs.containsKey("Measured")) {
            this.measured = ((Integer)pairs.remove("Measured")).intValue();
        }
        if (pairs.containsKey("Unmeasured")) {
            boolean bl = this.unmeasured = (long)((Integer)pairs.remove("Unmeasured")).intValue() == 1L;
        }
        if (!pairs.isEmpty()) {
            // empty if block
        }
    }

    private void parsePLine(String line, String[] parts) throws DescriptorParseException {
        this.parsedAtMostOnceKeyword("p");
        boolean isValid = true;
        if (parts.length != 3) {
            isValid = false;
        } else if (!parts[1].equals("accept") && !parts[1].equals("reject")) {
            isValid = false;
        } else {
            this.defaultPolicy = parts[1];
            this.portList = parts[2];
            String[] ports = parts[2].split(",", -1);
            for (int i = 0; i < ports.length; ++i) {
                if (ports[i].length() >= 1) continue;
                isValid = false;
                break;
            }
        }
        if (!isValid) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseMLine(String line, String[] parts) throws DescriptorParseException {
        if (this.microdescriptorDigests == null) {
            this.microdescriptorDigests = new HashSet<String>();
        }
        if (parts.length == 2) {
            this.microdescriptorDigests.add(ParseHelper.parseThirtyTwoByteBase64String(line, parts[1]));
        } else if (parts.length == 3 && parts[2].length() > 7) {
            this.microdescriptorDigests.add(ParseHelper.parseThirtyTwoByteBase64String(line, parts[2].substring(7)));
        }
    }

    private void clearAtMostOnceKeywords() {
        this.atMostOnceKeywords = null;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public int getOrPort() {
        return this.orPort;
    }

    @Override
    public int getDirPort() {
        return this.dirPort;
    }

    @Override
    public Set<String> getMicrodescriptorDigests() {
        return this.microdescriptorDigests == null ? null : new HashSet<String>(this.microdescriptorDigests);
    }

    @Override
    public List<String> getOrAddresses() {
        return new ArrayList<String>(this.orAddresses);
    }

    @Override
    public SortedSet<String> getFlags() {
        TreeSet<String> result = new TreeSet<String>();
        if (this.flags != null) {
            int i = this.flags.nextSetBit(0);
            while (i >= 0) {
                result.add(flagStrings.get(i));
                i = this.flags.nextSetBit(i + 1);
            }
        }
        return result;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public long getBandwidth() {
        return this.bandwidth;
    }

    @Override
    public long getMeasured() {
        return this.measured;
    }

    @Override
    public boolean getUnmeasured() {
        return this.unmeasured;
    }

    @Override
    public String getDefaultPolicy() {
        return this.defaultPolicy;
    }

    @Override
    public String getPortList() {
        return this.portList;
    }
}

