/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.ExitListEntry;
import org.torproject.descriptor.impl.ParseHelper;

public class ExitListEntryImpl
implements ExitListEntry {
    private byte[] exitListEntryBytes;
    private boolean failUnrecognizedDescriptorLines;
    private List<String> unrecognizedLines;
    private SortedSet<String> exactlyOnceKeywords;
    private String fingerprint;
    private long publishedMillis;
    private long lastStatusMillis;
    private String exitAddress;
    private long scanMillis;

    public byte[] getExitListEntryBytes() {
        return this.exitListEntryBytes;
    }

    protected List<String> getAndClearUnrecognizedLines() {
        List<String> lines = this.unrecognizedLines;
        this.unrecognizedLines = null;
        return lines;
    }

    protected ExitListEntryImpl(byte[] exitListEntryBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        this.exitListEntryBytes = exitListEntryBytes;
        this.failUnrecognizedDescriptorLines = failUnrecognizedDescriptorLines;
        this.initializeKeywords();
        this.parseExitListEntryBytes();
        this.checkAndClearKeywords();
    }

    private void initializeKeywords() {
        this.exactlyOnceKeywords = new TreeSet<String>();
        this.exactlyOnceKeywords.add("ExitNode");
        this.exactlyOnceKeywords.add("Published");
        this.exactlyOnceKeywords.add("LastStatus");
        this.exactlyOnceKeywords.add("ExitAddress");
    }

    private void parsedExactlyOnceKeyword(String keyword) throws DescriptorParseException {
        if (!this.exactlyOnceKeywords.contains(keyword)) {
            throw new DescriptorParseException("Duplicate '" + keyword + "' line in exit list entry.");
        }
        this.exactlyOnceKeywords.remove(keyword);
    }

    private void checkAndClearKeywords() throws DescriptorParseException {
        Iterator iterator = this.exactlyOnceKeywords.iterator();
        if (iterator.hasNext()) {
            String missingKeyword = (String)iterator.next();
            throw new DescriptorParseException("Missing '" + missingKeyword + "' line in exit list entry.");
        }
        this.exactlyOnceKeywords = null;
    }

    private void parseExitListEntryBytes() throws DescriptorParseException {
        Scanner s = new Scanner(new String(this.exitListEntryBytes)).useDelimiter("\n");
        while (s.hasNext()) {
            String line = s.next();
            String[] parts = line.split(" ");
            String keyword = parts[0];
            if (keyword.equals("ExitNode")) {
                this.parseExitNodeLine(line, parts);
                continue;
            }
            if (keyword.equals("Published")) {
                this.parsePublishedLine(line, parts);
                continue;
            }
            if (keyword.equals("LastStatus")) {
                this.parseLastStatusLine(line, parts);
                continue;
            }
            if (keyword.equals("ExitAddress")) {
                this.parseExitAddressLine(line, parts);
                continue;
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in exit list entry.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList<String>();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseExitNodeLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Invalid line '" + line + "' in " + "exit list entry.");
        }
        this.parsedExactlyOnceKeyword(parts[0]);
        this.fingerprint = ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    private void parsePublishedLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Invalid line '" + line + "' in " + "exit list entry.");
        }
        this.parsedExactlyOnceKeyword(parts[0]);
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseLastStatusLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Invalid line '" + line + "' in " + "exit list entry.");
        }
        this.parsedExactlyOnceKeyword(parts[0]);
        this.lastStatusMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseExitAddressLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 4) {
            throw new DescriptorParseException("Invalid line '" + line + "' in " + "exit list entry.");
        }
        this.parsedExactlyOnceKeyword(parts[0]);
        this.exitAddress = ParseHelper.parseIpv4Address(line, parts[1]);
        this.scanMillis = ParseHelper.parseTimestampAtIndex(line, parts, 2, 3);
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public long getLastStatusMillis() {
        return this.lastStatusMillis;
    }

    @Override
    public String getExitAddress() {
        return this.exitAddress;
    }

    @Override
    public long getScanMillis() {
        return this.scanMillis;
    }
}

