/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.relaydescs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.InflaterInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.collector.relaydescs.RelayDescriptorParser;

public class RelayDescriptorDownloader {
    private File missingDescriptorsFile;
    private SortedMap<String, String> missingDescriptors;
    private Map<String, Set<String>> microdescriptorKeys;
    private Set<String> missingMicrodescriptors;
    private File lastDownloadedAllDescriptorsFile;
    private Map<String, String> lastDownloadedAllDescriptors;
    private RelayDescriptorParser rdp;
    private List<String> authorities;
    private List<String> authorityFingerprints;
    private boolean downloadCurrentConsensus;
    private boolean downloadCurrentMicrodescConsensus;
    private boolean downloadCurrentVotes;
    private boolean downloadMissingServerDescriptors;
    private boolean downloadMissingExtraInfos;
    private boolean downloadMissingMicrodescriptors;
    private boolean downloadAllServerDescriptors;
    private boolean downloadAllExtraInfos;
    private boolean downloadCompressed;
    private String currentValidAfter;
    private String descriptorCutOff;
    private String downloadAllDescriptorsCutOff;
    private Set<String> downloadAllDescriptorsFromAuthorities;
    private String currentTimestamp;
    private static final Logger logger = LoggerFactory.getLogger(RelayDescriptorDownloader.class);
    private Map<String, Integer> requestsByAuthority;
    private int oldMissingConsensuses = 0;
    private int oldMissingMicrodescConsensuses = 0;
    private int oldMissingVotes = 0;
    private int oldMissingServerDescriptors = 0;
    private int oldMissingExtraInfoDescriptors = 0;
    private int oldMissingMicrodescriptors = 0;
    private int newMissingConsensuses = 0;
    private int newMissingMicrodescConsensuses = 0;
    private int newMissingVotes = 0;
    private int newMissingServerDescriptors = 0;
    private int newMissingExtraInfoDescriptors = 0;
    private int newMissingMicrodescriptors = 0;
    private int requestedConsensuses = 0;
    private int requestedMicrodescConsensuses = 0;
    private int requestedVotes = 0;
    private int requestedBandwidthFiles = 0;
    private int requestedMissingServerDescriptors = 0;
    private int requestedAllServerDescriptors = 0;
    private int requestedMissingExtraInfoDescriptors = 0;
    private int requestedAllExtraInfoDescriptors = 0;
    private int requestedMissingMicrodescriptors = 0;
    private int downloadedConsensuses = 0;
    private int downloadedMicrodescConsensuses = 0;
    private int downloadedVotes = 0;
    private int downloadedBandwidthFiles = 0;
    private int downloadedMissingServerDescriptors = 0;
    private int downloadedAllServerDescriptors = 0;
    private int downloadedMissingExtraInfoDescriptors = 0;
    private int downloadedAllExtraInfoDescriptors = 0;
    private int downloadedMissingMicrodescriptors = 0;

    public RelayDescriptorDownloader(RelayDescriptorParser rdp, String[] authorities, String[] authorityFingerprints, boolean downloadCurrentConsensus, boolean downloadCurrentMicrodescConsensus, boolean downloadCurrentVotes, boolean downloadMissingServerDescriptors, boolean downloadMissingExtraInfos, boolean downloadMissingMicrodescriptors, boolean downloadAllServerDescriptors, boolean downloadAllExtraInfos, boolean downloadCompressed) {
        String line;
        BufferedReader br;
        this.rdp = rdp;
        this.authorities = Arrays.asList(authorities);
        this.authorityFingerprints = Arrays.asList(authorityFingerprints);
        this.downloadCurrentConsensus = downloadCurrentConsensus;
        this.downloadCurrentMicrodescConsensus = downloadCurrentMicrodescConsensus;
        this.downloadCurrentVotes = downloadCurrentVotes;
        this.downloadMissingServerDescriptors = downloadMissingServerDescriptors;
        this.downloadMissingExtraInfos = downloadMissingExtraInfos;
        this.downloadMissingMicrodescriptors = downloadMissingMicrodescriptors;
        this.downloadAllServerDescriptors = downloadAllServerDescriptors;
        this.downloadAllExtraInfos = downloadAllExtraInfos;
        this.downloadCompressed = downloadCompressed;
        Collections.shuffle(this.authorities);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        long now = System.currentTimeMillis();
        this.currentValidAfter = format.format(now / 3600000L * 3600000L);
        this.descriptorCutOff = format.format(now - 86400000L);
        this.currentTimestamp = format.format(now);
        this.downloadAllDescriptorsCutOff = format.format(now - 82800000L - 1800000L);
        this.missingDescriptors = new TreeMap<String, String>();
        this.microdescriptorKeys = new HashMap<String, Set<String>>();
        this.missingMicrodescriptors = new HashSet<String>();
        this.missingDescriptorsFile = new File("stats/missing-relay-descriptors");
        if (this.missingDescriptorsFile.exists()) {
            try {
                logger.debug("Reading file {}...", (Object)this.missingDescriptorsFile.getAbsolutePath());
                br = new BufferedReader(new FileReader(this.missingDescriptorsFile));
                while ((line = br.readLine()) != null) {
                    if (line.split(",").length > 2) {
                        String published = line.split(",")[1];
                        if ((!line.startsWith("consensus,") && !line.startsWith("consensus-microdesc,") && !line.startsWith("vote,") || !this.currentValidAfter.equals(published)) && (!line.startsWith("server,") && !line.startsWith("extra,") && !line.startsWith("micro,") || this.descriptorCutOff.compareTo(published) >= 0)) continue;
                        if (line.endsWith("NA")) {
                            if (line.startsWith("consensus,")) {
                                ++this.oldMissingConsensuses;
                            } else if (line.startsWith("consensus-microdesc,")) {
                                ++this.oldMissingMicrodescConsensuses;
                            } else if (line.startsWith("vote,")) {
                                ++this.oldMissingVotes;
                            } else if (line.startsWith("server,")) {
                                ++this.oldMissingServerDescriptors;
                            } else if (line.startsWith("extra,")) {
                                ++this.oldMissingExtraInfoDescriptors;
                            }
                        }
                        int separateAt = line.lastIndexOf(",");
                        this.missingDescriptors.put(line.substring(0, separateAt), line.substring(separateAt + 1));
                        if (!line.startsWith("micro,")) continue;
                        String microdescriptorDigest = line.split(",")[3];
                        String microdescriptorKey = line.substring(0, line.lastIndexOf(","));
                        this.microdescriptorKeys.putIfAbsent(microdescriptorDigest, new HashSet());
                        this.microdescriptorKeys.get(microdescriptorDigest).add(microdescriptorKey);
                        if (!line.endsWith("NA") || this.missingMicrodescriptors.contains(microdescriptorDigest)) continue;
                        this.missingMicrodescriptors.add(microdescriptorDigest);
                        ++this.oldMissingMicrodescriptors;
                        continue;
                    }
                    logger.debug("Invalid line '{}' in {}. Ignoring.", (Object)line, (Object)this.missingDescriptorsFile.getAbsolutePath());
                }
                br.close();
                logger.debug("Finished reading file {}.", (Object)this.missingDescriptorsFile.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn("Failed to read file {}! This means that we might forget to dowload relay descriptors we are missing.", (Object)this.missingDescriptorsFile.getAbsolutePath(), (Object)e);
            }
        }
        this.lastDownloadedAllDescriptors = new HashMap<String, String>();
        this.lastDownloadedAllDescriptorsFile = new File("stats/last-downloaded-all-descriptors");
        if (this.lastDownloadedAllDescriptorsFile.exists()) {
            try {
                logger.debug("Reading file {}...", (Object)this.lastDownloadedAllDescriptorsFile.getAbsolutePath());
                br = new BufferedReader(new FileReader(this.lastDownloadedAllDescriptorsFile));
                while ((line = br.readLine()) != null) {
                    if (line.split(",").length != 2) {
                        logger.debug("Invalid line '{}' in {}. Ignoring.", (Object)line, (Object)this.lastDownloadedAllDescriptorsFile.getAbsolutePath());
                        continue;
                    }
                    String[] parts = line.split(",");
                    String authority = parts[0];
                    String lastDownloaded = parts[1];
                    this.lastDownloadedAllDescriptors.put(authority, lastDownloaded);
                }
                br.close();
                logger.debug("Finished reading file {}.", (Object)this.lastDownloadedAllDescriptorsFile.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn("Failed to read file {}! This means that we might download all server and extra-info descriptors more often than we should.", (Object)this.lastDownloadedAllDescriptorsFile.getAbsolutePath(), (Object)e);
            }
        }
        this.downloadAllDescriptorsFromAuthorities = new HashSet<String>();
        for (String authority : this.authorities) {
            if (!this.lastDownloadedAllDescriptors.containsKey(authority) || this.lastDownloadedAllDescriptors.get(authority).compareTo(this.downloadAllDescriptorsCutOff) < 0) {
                this.downloadAllDescriptorsFromAuthorities.add(authority);
            }
            if (this.downloadAllDescriptorsFromAuthorities.size() < 2) continue;
            break;
        }
        this.requestsByAuthority = new HashMap<String, Integer>();
        for (String authority : this.authorities) {
            this.requestsByAuthority.put(authority, 0);
        }
    }

    public void haveParsedConsensus(String validAfter, Set<String> authorities, Set<String> serverDescriptors) {
        if (this.currentValidAfter.equals(validAfter)) {
            String consensusKey = "consensus," + validAfter;
            this.missingDescriptors.put(consensusKey, this.currentTimestamp);
            for (String authority : authorities) {
                String voteKey = "vote," + validAfter + "," + authority;
                if (this.missingDescriptors.containsKey(voteKey)) continue;
                this.missingDescriptors.put(voteKey, "NA");
                ++this.newMissingVotes;
            }
        }
        for (String serverDescriptor : serverDescriptors) {
            String serverDescriptorKey;
            String published = serverDescriptor.split(",")[0];
            if (this.descriptorCutOff.compareTo(published) >= 0 || this.missingDescriptors.containsKey(serverDescriptorKey = "server," + serverDescriptor)) continue;
            this.missingDescriptors.put(serverDescriptorKey, "NA");
            ++this.newMissingServerDescriptors;
        }
    }

    public void haveParsedMicrodescConsensus(String validAfter, Set<String> microdescriptors) {
        if (this.currentValidAfter.equals(validAfter)) {
            String microdescConsensusKey = "consensus-microdesc," + validAfter;
            this.missingDescriptors.put(microdescConsensusKey, this.currentTimestamp);
        }
        if (this.descriptorCutOff.compareTo(validAfter) < 0) {
            String validAfterYearMonth = validAfter.substring(0, "YYYY-MM".length());
            for (String microdescriptor : microdescriptors) {
                String microdescriptorKey = "micro," + microdescriptor;
                String parsed = "NA";
                String microdescriptorDigest = microdescriptor.split(",")[2];
                if (this.microdescriptorKeys.containsKey(microdescriptorDigest)) {
                    for (String otherMicrodescriptorKey : this.microdescriptorKeys.get(microdescriptorDigest)) {
                        String otherParsed;
                        String otherValidAfter = otherMicrodescriptorKey.split(",")[1];
                        if (!otherValidAfter.startsWith(validAfterYearMonth) || (otherParsed = (String)this.missingDescriptors.get(otherMicrodescriptorKey)) == null || otherParsed.equals("NA")) continue;
                        parsed = otherParsed;
                        break;
                    }
                } else {
                    this.microdescriptorKeys.put(microdescriptorDigest, new HashSet());
                }
                this.microdescriptorKeys.get(microdescriptorDigest).add(microdescriptorKey);
                this.missingDescriptors.put(microdescriptorKey, parsed);
                if (!parsed.equals("NA") || this.missingMicrodescriptors.contains(microdescriptorDigest)) continue;
                this.missingMicrodescriptors.add(microdescriptorDigest);
                ++this.newMissingMicrodescriptors;
            }
        }
    }

    public void haveParsedVote(String validAfter, String fingerprint, Set<String> serverDescriptors) {
        if (this.currentValidAfter.equals(validAfter)) {
            String voteKey = "vote," + validAfter + "," + fingerprint;
            this.missingDescriptors.put(voteKey, this.currentTimestamp);
        }
        for (String serverDescriptor : serverDescriptors) {
            String serverDescriptorKey;
            String published = serverDescriptor.split(",")[0];
            if (this.descriptorCutOff.compareTo(published) >= 0 || this.missingDescriptors.containsKey(serverDescriptorKey = "server," + serverDescriptor)) continue;
            this.missingDescriptors.put(serverDescriptorKey, "NA");
            ++this.newMissingServerDescriptors;
        }
    }

    public void haveParsedServerDescriptor(String published, String relayIdentity, String serverDescriptorDigest, String extraInfoDigest) {
        if (this.descriptorCutOff.compareTo(published) < 0) {
            String extraInfoKey;
            String serverDescriptorKey = "server," + published + "," + relayIdentity + "," + serverDescriptorDigest;
            this.missingDescriptors.put(serverDescriptorKey, this.currentTimestamp);
            if (extraInfoDigest != null && !this.missingDescriptors.containsKey(extraInfoKey = "extra," + published + "," + relayIdentity + "," + extraInfoDigest)) {
                this.missingDescriptors.put(extraInfoKey, "NA");
                ++this.newMissingExtraInfoDescriptors;
            }
        }
    }

    public void haveParsedExtraInfoDescriptor(String published, String relayIdentity, String extraInfoDigest) {
        if (this.descriptorCutOff.compareTo(published) < 0) {
            String extraInfoKey = "extra," + published + "," + relayIdentity + "," + extraInfoDigest;
            this.missingDescriptors.put(extraInfoKey, this.currentTimestamp);
        }
    }

    public void haveParsedMicrodescriptor(String descriptorDigest) {
        if (this.microdescriptorKeys.containsKey(descriptorDigest)) {
            for (String microdescriptorKey : this.microdescriptorKeys.get(descriptorDigest)) {
                String validAfter = microdescriptorKey.split(",")[0];
                if (this.descriptorCutOff.compareTo(validAfter) >= 0) continue;
                this.missingDescriptors.put(microdescriptorKey, this.currentTimestamp);
            }
            this.missingMicrodescriptors.remove(descriptorDigest);
        }
    }

    public void downloadDescriptors() {
        String microdescConsensusKey;
        String consensusKey = "consensus," + this.currentValidAfter;
        if (!this.missingDescriptors.containsKey(consensusKey)) {
            this.missingDescriptors.put(consensusKey, "NA");
            ++this.newMissingConsensuses;
        }
        if (!this.missingDescriptors.containsKey(microdescConsensusKey = "consensus-microdesc," + this.currentValidAfter)) {
            this.missingDescriptors.put(microdescConsensusKey, "NA");
            ++this.newMissingMicrodescConsensuses;
        }
        for (String authority : this.authorityFingerprints) {
            String voteKey = "vote," + this.currentValidAfter + "," + authority;
            if (this.missingDescriptors.containsKey(voteKey)) continue;
            this.missingDescriptors.put(voteKey, "NA");
            ++this.newMissingVotes;
        }
        for (String authority : this.authorities) {
            try {
                if (this.downloadCurrentConsensus && this.missingDescriptors.containsKey(consensusKey) && ((String)this.missingDescriptors.get(consensusKey)).equals("NA")) {
                    ++this.requestedConsensuses;
                    this.downloadedConsensuses += this.downloadResourceFromAuthority(authority, "/tor/status-vote/current/consensus");
                }
                if (this.downloadCurrentMicrodescConsensus && this.missingDescriptors.containsKey(microdescConsensusKey) && ((String)this.missingDescriptors.get(microdescConsensusKey)).equals("NA")) {
                    ++this.requestedMicrodescConsensuses;
                    this.downloadedMicrodescConsensuses += this.downloadResourceFromAuthority(authority, "/tor/status-vote/current/consensus-microdesc");
                }
                if (this.downloadCurrentVotes) {
                    String[] voteKeyPrefix = "vote," + this.currentValidAfter;
                    TreeSet<String> fingerprints = new TreeSet<String>();
                    for (Map.Entry<String, String> e : this.missingDescriptors.entrySet()) {
                        if (!e.getValue().equals("NA") || !e.getKey().startsWith((String)voteKeyPrefix)) continue;
                        String fingerprint = e.getKey().split(",")[2];
                        fingerprints.add(fingerprint);
                    }
                    for (String fingerprint : fingerprints) {
                        ++this.requestedVotes;
                        this.downloadedVotes += this.downloadResourceFromAuthority(authority, "/tor/status-vote/current/" + fingerprint);
                    }
                }
                ++this.requestedBandwidthFiles;
                this.downloadedBandwidthFiles += this.downloadResourceFromAuthority(authority, "/tor/status-vote/next/bandwidth");
                block16: for (String type : new String[]{"server", "extra", "micro"}) {
                    if (this.downloadAllDescriptorsFromAuthorities.contains(authority) && (type.equals("server") && this.downloadAllServerDescriptors || type.equals("extra") && this.downloadAllExtraInfos)) {
                        int downloadedAllDescriptors = this.downloadResourceFromAuthority(authority, "/tor/" + type + "/all");
                        if (type.equals("server")) {
                            ++this.requestedAllServerDescriptors;
                            this.downloadedAllServerDescriptors += downloadedAllDescriptors;
                            continue;
                        }
                        if (!type.equals("extra")) continue;
                        ++this.requestedAllExtraInfoDescriptors;
                        this.downloadedAllExtraInfoDescriptors += downloadedAllDescriptors;
                        continue;
                    }
                    if (!(type.equals("server") && this.downloadMissingServerDescriptors || type.equals("extra") && this.downloadMissingExtraInfos) && (!type.equals("micro") || !this.downloadMissingMicrodescriptors)) continue;
                    TreeSet<String> descriptorIdentifiers = new TreeSet<String>();
                    for (Map.Entry<String, String> e : this.missingDescriptors.entrySet()) {
                        if (!e.getValue().equals("NA") || !e.getKey().startsWith(type + ",") || this.descriptorCutOff.compareTo(e.getKey().split(",")[1]) >= 0) continue;
                        String descriptorIdentifier = e.getKey().split(",")[3];
                        descriptorIdentifiers.add(descriptorIdentifier);
                    }
                    StringBuilder combinedResource = null;
                    int descriptorsInCombinedResource = 0;
                    int requestedDescriptors = 0;
                    int downloadedDescriptors = 0;
                    int maxDescriptorsInCombinedResource = type.equals("micro") ? 92 : 96;
                    String separator = type.equals("micro") ? "-" : "+";
                    for (String descriptorIdentifier : descriptorIdentifiers) {
                        if (descriptorsInCombinedResource >= maxDescriptorsInCombinedResource) {
                            requestedDescriptors += descriptorsInCombinedResource;
                            downloadedDescriptors += this.downloadResourceFromAuthority(authority, combinedResource.toString());
                            combinedResource = null;
                            descriptorsInCombinedResource = 0;
                        }
                        if (descriptorsInCombinedResource == 0) {
                            combinedResource = new StringBuilder("/tor/" + type + "/d/" + descriptorIdentifier);
                        } else {
                            combinedResource.append(separator).append(descriptorIdentifier);
                        }
                        ++descriptorsInCombinedResource;
                    }
                    if (descriptorsInCombinedResource > 0) {
                        requestedDescriptors += descriptorsInCombinedResource;
                        downloadedDescriptors += this.downloadResourceFromAuthority(authority, combinedResource.toString());
                    }
                    switch (type) {
                        case "server": {
                            this.requestedMissingServerDescriptors += requestedDescriptors;
                            this.downloadedMissingServerDescriptors += downloadedDescriptors;
                            continue block16;
                        }
                        case "extra": {
                            this.requestedMissingExtraInfoDescriptors += requestedDescriptors;
                            this.downloadedMissingExtraInfoDescriptors += downloadedDescriptors;
                            continue block16;
                        }
                        case "micro": {
                            this.requestedMissingMicrodescriptors += requestedDescriptors;
                            this.downloadedMissingMicrodescriptors += downloadedDescriptors;
                            continue block16;
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.debug("Failed downloading from {}!", (Object)authority, (Object)e);
            }
        }
    }

    private int downloadResourceFromAuthority(String authority, String resource) throws IOException {
        int receivedDescriptors;
        block21: {
            int start;
            byte[] allData;
            block23: {
                int sig;
                int start2;
                block22: {
                    allData = null;
                    this.requestsByAuthority.put(authority, this.requestsByAuthority.get(authority) + 1);
                    boolean isCompressed = this.downloadCompressed && !resource.startsWith("/tor/extra/");
                    String fullUrl = "http://" + authority + resource + (isCompressed ? ".z" : "");
                    URL url = new URL(fullUrl);
                    HttpURLConnection huc = (HttpURLConnection)url.openConnection();
                    huc.setRequestMethod("GET");
                    huc.setReadTimeout(5000);
                    huc.connect();
                    int response = huc.getResponseCode();
                    if (response == 200) {
                        try (BufferedInputStream in = isCompressed ? new BufferedInputStream(new InflaterInputStream(huc.getInputStream())) : new BufferedInputStream(huc.getInputStream());){
                            int len;
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            byte[] data = new byte[1024];
                            while ((len = in.read(data, 0, 1024)) >= 0) {
                                baos.write(data, 0, len);
                            }
                            allData = baos.toByteArray();
                        }
                    }
                    logger.debug("Downloaded {} -> {} ({} bytes)", new Object[]{fullUrl, response, allData == null ? 0 : allData.length});
                    receivedDescriptors = 0;
                    if (allData == null) break block21;
                    if (!resource.startsWith("/tor/status-vote/")) break block22;
                    this.rdp.parse(allData);
                    receivedDescriptors = 1;
                    break block21;
                }
                if (!resource.startsWith("/tor/server/") && !resource.startsWith("/tor/extra/")) break block23;
                if (resource.equals("/tor/server/all") || resource.equals("/tor/extra/all")) {
                    this.lastDownloadedAllDescriptors.put(authority, this.currentTimestamp);
                }
                String ascii = new String(allData, StandardCharsets.US_ASCII);
                int end = -1;
                String startToken = resource.startsWith("/tor/server/") ? "router " : "extra-info ";
                String sigToken = "\nrouter-signature\n";
                String endToken = "\n-----END SIGNATURE-----\n";
                while (end < ascii.length() && (start2 = ascii.indexOf(startToken, end)) >= 0 && (sig = ascii.indexOf(sigToken, start2)) >= 0 && (end = ascii.indexOf(endToken, sig += sigToken.length())) >= 0) {
                    byte[] descBytes = new byte[(end += endToken.length()) - start2];
                    System.arraycopy(allData, start2, descBytes, 0, end - start2);
                    this.rdp.parse(descBytes);
                    ++receivedDescriptors;
                }
                break block21;
            }
            if (!resource.startsWith("/tor/micro/")) break block21;
            SimpleDateFormat parseFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            parseFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String ascii = new String(allData, StandardCharsets.US_ASCII);
            int end = -1;
            String startToken = "onion-key\n";
            while (end < ascii.length() && (start = ascii.indexOf(startToken, end)) >= 0 && ((end = ascii.indexOf(startToken, start + 1)) >= 0 || (end = ascii.length()) > start)) {
                byte[] descBytes = new byte[end - start];
                System.arraycopy(allData, start, descBytes, 0, end - start);
                String digest256Base64 = Base64.encodeBase64String((byte[])DigestUtils.sha256((byte[])descBytes)).replaceAll("=", "");
                if (!this.microdescriptorKeys.containsKey(digest256Base64)) continue;
                String digest256Hex = DigestUtils.sha256Hex((byte[])descBytes);
                for (String microdescriptorKey : this.microdescriptorKeys.get(digest256Base64)) {
                    String validAfterTime = microdescriptorKey.split(",")[1];
                    try {
                        long validAfter = parseFormat.parse(validAfterTime).getTime();
                        this.rdp.storeMicrodescriptor(descBytes, digest256Hex, digest256Base64, validAfter);
                    }
                    catch (ParseException e) {
                        logger.warn("Could not parse valid-after time '{}' in microdescriptor key. Not storing microdescriptor.", (Object)validAfterTime, (Object)e);
                    }
                }
                ++receivedDescriptors;
            }
        }
        return receivedDescriptors;
    }

    public void writeFile() {
        BufferedWriter bw;
        int missingConsensuses = 0;
        int missingMicrodescConsensuses = 0;
        int missingVotes = 0;
        int missingServerDescriptors = 0;
        int missingExtraInfoDescriptors = 0;
        try {
            logger.debug("Writing file {}...", (Object)this.missingDescriptorsFile.getAbsolutePath());
            this.missingDescriptorsFile.getParentFile().mkdirs();
            bw = new BufferedWriter(new FileWriter(this.missingDescriptorsFile));
            for (Map.Entry<String, String> e : this.missingDescriptors.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                if (value.equals("NA")) {
                    if (key.startsWith("consensus,")) {
                        ++missingConsensuses;
                    } else if (key.startsWith("consensus-microdesc,")) {
                        ++missingMicrodescConsensuses;
                    } else if (key.startsWith("vote,")) {
                        ++missingVotes;
                    } else if (key.startsWith("server,")) {
                        ++missingServerDescriptors;
                    } else if (key.startsWith("extra,")) {
                        ++missingExtraInfoDescriptors;
                    } else if (key.startsWith("micro,")) {
                        // empty if block
                    }
                }
                bw.write(key + "," + value + "\n");
            }
            bw.close();
            logger.debug("Finished writing file {}.", (Object)this.missingDescriptorsFile.getAbsolutePath());
        }
        catch (IOException e) {
            logger.warn("Failed writing {}!", (Object)this.missingDescriptorsFile.getAbsolutePath(), (Object)e);
        }
        try {
            logger.debug("Writing file {}...", (Object)this.lastDownloadedAllDescriptorsFile.getAbsolutePath());
            this.lastDownloadedAllDescriptorsFile.getParentFile().mkdirs();
            bw = new BufferedWriter(new FileWriter(this.lastDownloadedAllDescriptorsFile));
            for (Map.Entry<String, String> e : this.lastDownloadedAllDescriptors.entrySet()) {
                String authority = e.getKey();
                String lastDownloaded = e.getValue();
                bw.write(authority + "," + lastDownloaded + "\n");
            }
            bw.close();
            logger.debug("Finished writing file {}.", (Object)this.lastDownloadedAllDescriptorsFile.getAbsolutePath());
        }
        catch (IOException e) {
            logger.warn("Failed writing {}!", (Object)this.lastDownloadedAllDescriptorsFile.getAbsolutePath(), (Object)e);
        }
        logger.info("Finished downloading relay descriptors from the directory authorities.");
        logger.info("At the beginning of this execution, we were missing {} consensus(es), {} microdesc consensus(es), {} vote(s), {} server descriptor(s), {} extra-info descriptor(s), and {} microdescriptor(s).", new Object[]{this.oldMissingConsensuses, this.oldMissingMicrodescConsensuses, this.oldMissingVotes, this.oldMissingServerDescriptors, this.oldMissingExtraInfoDescriptors, this.oldMissingMicrodescriptors});
        logger.info("During this execution, we added {} consensus(es), {} microdesc consensus(es), {} vote(s), {} server descriptor(s), {} extra-info descriptor(s), and {} microdescriptor(s) to the missing list, some of which we also requested and removed from the list again.", new Object[]{this.newMissingConsensuses, this.newMissingMicrodescConsensuses, this.newMissingVotes, this.newMissingServerDescriptors, this.newMissingExtraInfoDescriptors, this.newMissingMicrodescriptors});
        logger.info("We requested {} consensus(es), {} microdesc consensus(es), {} vote(s), {} bandwidth file(s), {} missing server descriptor(s), {} times all server descriptors, {} missing extra-info descriptor(s), {} times all extra-info descriptors, and {} missing microdescriptor(s) from the directory authorities.", new Object[]{this.requestedConsensuses, this.requestedMicrodescConsensuses, this.requestedVotes, this.requestedBandwidthFiles, this.requestedMissingServerDescriptors, this.requestedAllServerDescriptors, this.requestedMissingExtraInfoDescriptors, this.requestedAllExtraInfoDescriptors, this.requestedMissingMicrodescriptors});
        StringBuilder sb = new StringBuilder();
        for (String authority : this.authorities) {
            sb.append(" ").append(authority).append("=").append(this.requestsByAuthority.get(authority));
        }
        logger.info("We sent these numbers of requests to the directory authorities:{}", (Object)sb.toString());
        logger.info("We successfully downloaded {} consensus(es), {} microdesc consensus(es), {} vote(s), {} bandwidth file(s), {} missing server descriptor(s), {} server descriptor(s) when downloading all descriptors, {} missing extra-info descriptor(s), {} extra-info descriptor(s) when downloading all descriptors, and {} missing microdescriptor(s).", new Object[]{this.downloadedConsensuses, this.downloadedMicrodescConsensuses, this.downloadedVotes, this.downloadedBandwidthFiles, this.downloadedMissingServerDescriptors, this.downloadedAllServerDescriptors, this.downloadedMissingExtraInfoDescriptors, this.downloadedAllExtraInfoDescriptors, this.downloadedMissingMicrodescriptors});
        logger.info("At the end of this execution, we are missing {} consensus(es), {} microdesc consensus(es), {} vote(s), {} server descriptor(s), {} extra-info descriptor(s), and {} microdescriptor(s), some of which we may try in the next execution.", new Object[]{missingConsensuses, missingMicrodescConsensuses, missingVotes, missingServerDescriptors, missingExtraInfoDescriptors, this.missingMicrodescriptors.size()});
    }
}

