/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.exitlists;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.ExitList;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.ConfigurationException;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.cron.CollecTorMain;

public class ExitListDownloader
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(ExitListDownloader.class);
    private static final String EXITLISTS = "exit-lists";
    private String outputPathName;
    private String recentPathName;

    public ExitListDownloader(Configuration config) {
        super(config);
        this.mapPathDescriptors.put("recent/exit-lists", ExitList.class);
    }

    @Override
    public String module() {
        return "exitlists";
    }

    @Override
    protected String syncMarker() {
        return "Exitlist";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        File[] outputFiles;
        String downloadedExitList;
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.outputPathName = Paths.get(this.config.getPath(Key.OutputPath).toString(), EXITLISTS).toString();
        this.recentPathName = Paths.get(this.config.getPath(Key.RecentPath).toString(), EXITLISTS).toString();
        Date downloadedDate = new Date();
        logger.debug("Downloading exit list...");
        StringBuilder sb = new StringBuilder();
        sb.append(Annotation.ExitList.toString());
        sb.append("Downloaded ").append(dateTimeFormat.format(downloadedDate)).append("\n");
        URL url = this.config.getUrl(Key.ExitlistUrl);
        try {
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setRequestMethod("GET");
            huc.setReadTimeout(5000);
            huc.connect();
            int response = huc.getResponseCode();
            if (response != 200) {
                logger.warn("Could not download exit list. Response code {}", (Object)response);
                return;
            }
            try (BufferedInputStream in = new BufferedInputStream(huc.getInputStream());){
                int len;
                byte[] data = new byte[1024];
                while ((len = in.read(data, 0, 1024)) >= 0) {
                    sb.append(new String(data, 0, len));
                }
            }
            downloadedExitList = sb.toString();
            logger.debug("Finished downloading exit list.");
        }
        catch (IOException e) {
            logger.warn("Failed downloading exit list", (Throwable)e);
            return;
        }
        if (downloadedExitList == null) {
            logger.warn("Failed downloading exit list.");
            return;
        }
        SimpleDateFormat tarballFormat = new SimpleDateFormat("yyyy/MM/dd/yyyy-MM-dd-HH-mm-ss");
        tarballFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File tarballFile = Paths.get(this.outputPathName, tarballFormat.format(downloadedDate)).toFile();
        DescriptorParser descriptorParser = DescriptorSourceFactory.createDescriptorParser();
        int parsedExitLists = 0;
        int otherDescriptors = 0;
        long maxScanMillis = 0L;
        for (Descriptor descriptor : descriptorParser.parseDescriptors(downloadedExitList.getBytes(), null, tarballFile.getName())) {
            if (descriptor instanceof ExitList) {
                ++parsedExitLists;
                File[] parsedExitList = (File[])descriptor;
                for (ExitList.Entry entry : parsedExitList.getEntries()) {
                    Iterator<Object> iterator = entry.getExitAddresses().values().iterator();
                    while (iterator.hasNext()) {
                        long scanMillis = (Long)iterator.next();
                        maxScanMillis = Math.max(maxScanMillis, scanMillis);
                    }
                }
                continue;
            }
            ++otherDescriptors;
        }
        if (parsedExitLists != 1 || otherDescriptors > 0) {
            logger.warn("Could not parse downloaded exit list");
            return;
        }
        if (maxScanMillis > 0L && maxScanMillis + 19800000L < System.currentTimeMillis()) {
            logger.warn("The last reported scan in the downloaded exit list took place at {}, which is more than 5:30 hours in the past.", (Object)dateTimeFormat.format(maxScanMillis));
        }
        File rsyncFile = new File(this.recentPathName, tarballFile.getName());
        for (File outputFile : outputFiles = new File[]{tarballFile, rsyncFile}) {
            try {
                outputFile.getParentFile().mkdirs();
                BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
                bw.write(downloadedExitList);
                bw.close();
            }
            catch (IOException e) {
                logger.warn("Could not write downloaded exit list to {}", (Object)outputFile.getAbsolutePath(), (Object)e);
            }
        }
        StringBuilder dumpStats = new StringBuilder("Finished downloading exit list.\nLast three exit lists are:");
        Stack<File> filesInInputDir = new Stack<File>();
        filesInInputDir.add(new File(this.outputPathName));
        TreeSet<File> lastThreeExitLists = new TreeSet<File>();
        while (!filesInInputDir.isEmpty()) {
            File pop = (File)filesInInputDir.pop();
            if (pop.isDirectory()) {
                TreeSet<File> lastThreeElements = new TreeSet<File>(Arrays.asList(pop.listFiles()));
                while (lastThreeElements.size() > 3) {
                    lastThreeElements.remove(lastThreeElements.first());
                }
                filesInInputDir.addAll(lastThreeElements);
                continue;
            }
            lastThreeExitLists.add(pop);
            while (lastThreeExitLists.size() > 3) {
                lastThreeExitLists.remove(lastThreeExitLists.first());
            }
        }
        for (File f : lastThreeExitLists) {
            dumpStats.append("\n").append(f.getName());
        }
        logger.info(dumpStats.toString());
        this.cleanUpRsyncDirectory();
    }

    public void cleanUpRsyncDirectory() {
        long cutOffMillis = System.currentTimeMillis() - 259200000L;
        Stack<File> allFiles = new Stack<File>();
        allFiles.add(new File(this.recentPathName));
        while (!allFiles.isEmpty()) {
            File file = (File)allFiles.pop();
            if (file.isDirectory()) {
                allFiles.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            if (file.lastModified() >= cutOffMillis) continue;
            file.delete();
        }
    }
}

