/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.commons.codec.digest.DigestUtils;
import org.torproject.descriptor.BandwidthFile;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.persist.DescriptorPersistence;

public class BandwidthFilePersistence
extends DescriptorPersistence<BandwidthFile> {
    private static final String BANDWIDTH = "bandwidth";
    private static final String BANDWIDTHS = "bandwidths";

    public BandwidthFilePersistence(BandwidthFile desc) {
        super(desc, Annotation.BandwidthFile.bytes());
        this.calculatePaths();
    }

    private void calculatePaths() {
        LocalDateTime fileCreatedOrTimestamp = ((BandwidthFile)this.desc).fileCreated().orElse(((BandwidthFile)this.desc).timestamp());
        DateTimeFormatter directoriesFormatter = DateTimeFormatter.ofPattern("uuuu/MM/dd").withZone(ZoneOffset.UTC);
        String[] directories = fileCreatedOrTimestamp.format(directoriesFormatter).split("/");
        DateTimeFormatter fileFormatter = DateTimeFormatter.ofPattern("uuuu-MM-dd-HH-mm-ss").withZone(ZoneOffset.UTC);
        String bandwidthFileDigest = BandwidthFilePersistence.calcDigestFromBytes(((BandwidthFile)this.desc).getRawDescriptorBytes());
        String fileOut = fileCreatedOrTimestamp.format(fileFormatter) + "-bandwidth-" + bandwidthFileDigest;
        this.recentPath = Paths.get("relay-descriptors", BANDWIDTHS, fileOut).toString();
        this.storagePath = Paths.get("relay-descriptors", BANDWIDTH, directories[0], directories[1], directories[2], fileOut).toString();
    }

    private static String calcDigestFromBytes(byte[] bytes) {
        int start;
        String digest = "";
        for (start = 0; start < bytes.length && bytes[start] == 64; ++start) {
            while (++start < bytes.length && bytes[start] != 10) {
            }
        }
        if (start < bytes.length) {
            byte[] forDigest = new byte[bytes.length - start];
            System.arraycopy(bytes, start, forDigest, 0, forDigest.length);
            digest = DigestUtils.sha256Hex(forDigest).toUpperCase();
        } else {
            log.error("No digest calculation possible.  Returning empty string.");
        }
        return digest;
    }
}

