/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.bridgedescs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.collector.bridgedescs.SanitizedBridgesWriter;

public class BridgeDescriptorParser {
    private SanitizedBridgesWriter sbw;
    private static final Logger logger = LoggerFactory.getLogger(BridgeDescriptorParser.class);

    public BridgeDescriptorParser(SanitizedBridgesWriter sbw) {
        if (null == sbw) {
            throw new IllegalArgumentException("SanitizedBridgesWriter has to be provided, but was null.");
        }
        this.sbw = sbw;
    }

    public void parse(byte[] allData, String dateTime, String authorityFingerprint) {
        try {
            BufferedReader br = new BufferedReader(new StringReader(new String(allData, "US-ASCII")));
            String line = br.readLine();
            if (line == null) {
                return;
            }
            if (line.startsWith("router ")) {
                this.sbw.sanitizeAndStoreServerDescriptor(allData);
            } else if (line.startsWith("extra-info ")) {
                this.sbw.sanitizeAndStoreExtraInfoDescriptor(allData);
            } else {
                this.sbw.sanitizeAndStoreNetworkStatus(allData, dateTime, authorityFingerprint);
            }
        }
        catch (IOException e) {
            logger.warn("Could not parse or write bridge descriptor.", (Throwable)e);
        }
    }
}

