/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.relaydescs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.collector.relaydescs.RelayDescriptorParser;

public class CachedRelayDescriptorReader {
    private static final Logger logger = LoggerFactory.getLogger(CachedRelayDescriptorReader.class);

    public CachedRelayDescriptorReader(RelayDescriptorParser rdp, String[] inputDirectories, File statsDirectory) {
        if (rdp == null || inputDirectories == null || inputDirectories.length == 0 || statsDirectory == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder dumpStats = new StringBuilder("Finished importing relay descriptors from local Tor data directories:");
        HashSet<String> lastImportHistory = new HashSet<String>();
        HashSet<String> currentImportHistory = new HashSet<String>();
        File importHistoryFile = new File(statsDirectory, "cacheddesc-import-history");
        if (importHistoryFile.exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(importHistoryFile));
                while ((line = br.readLine()) != null) {
                    lastImportHistory.add(line);
                }
                br.close();
            }
            catch (IOException e) {
                logger.warn("Could not read import history from " + importHistoryFile.getAbsolutePath() + ".", e);
            }
        }
        for (String inputDirectory : inputDirectories) {
            File cachedDescDir = new File(inputDirectory);
            if (!cachedDescDir.exists()) {
                logger.warn("Directory " + cachedDescDir.getAbsolutePath() + " does not exist. Skipping.");
                continue;
            }
            logger.debug("Reading " + cachedDescDir.getAbsolutePath() + " directory.");
            TreeSet<File> cachedDescFiles = new TreeSet<File>();
            Stack<File> files = new Stack<File>();
            files.add(cachedDescDir);
            while (!files.isEmpty()) {
                File file = (File)files.pop();
                if (file.isDirectory()) {
                    files.addAll(Arrays.asList(file.listFiles()));
                    continue;
                }
                cachedDescFiles.add(file);
            }
            for (File f : cachedDescFiles) {
                try {
                    int len;
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] data = new byte[1024];
                    while ((len = bis.read(data, 0, 1024)) >= 0) {
                        baos.write(data, 0, len);
                    }
                    bis.close();
                    byte[] allData = baos.toByteArray();
                    if (f.getName().equals("cached-consensus")) {
                        BufferedReader br = new BufferedReader(new StringReader(new String(allData, "US-ASCII")));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            if (!line.startsWith("valid-after ")) continue;
                            dumpStats.append("\n" + f.getName() + ": " + line.substring("valid-after ".length()));
                            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                            if (dateTimeFormat.parse(line.substring("valid-after ".length())).getTime() >= System.currentTimeMillis() - 21600000L) break;
                            logger.warn("Cached descriptor files in " + cachedDescDir.getAbsolutePath() + " are stale. The valid-after line in cached-consensus is '" + line + "'.");
                            dumpStats.append(" (stale!)");
                            break;
                        }
                        br.close();
                        if (rdp == null) continue;
                        String digest = Hex.encodeHexString(DigestUtils.sha1(allData));
                        if (!lastImportHistory.contains(digest) && !currentImportHistory.contains(digest)) {
                            rdp.parse(allData);
                        } else {
                            dumpStats.append(" (skipped)");
                        }
                        currentImportHistory.add(digest);
                        continue;
                    }
                    if (f.getName().equals("v3-status-votes")) {
                        int parsedNum = 0;
                        int skippedNum = 0;
                        String ascii = new String(allData, "US-ASCII");
                        String startToken = "network-status-version ";
                        int end = ascii.length();
                        int start = ascii.indexOf(startToken);
                        while (start >= 0 && start < end) {
                            int next = ascii.indexOf(startToken, start + 1);
                            if (next < 0) {
                                next = end;
                            }
                            if (start < next) {
                                byte[] rawNetworkStatusBytes = new byte[next - start];
                                System.arraycopy(allData, start, rawNetworkStatusBytes, 0, next - start);
                                if (rdp != null) {
                                    String digest = Hex.encodeHexString(DigestUtils.sha1(rawNetworkStatusBytes));
                                    if (!lastImportHistory.contains(digest) && !currentImportHistory.contains(digest)) {
                                        rdp.parse(rawNetworkStatusBytes);
                                        ++parsedNum;
                                    } else {
                                        ++skippedNum;
                                    }
                                    currentImportHistory.add(digest);
                                }
                            }
                            start = next;
                        }
                        dumpStats.append("\n" + f.getName() + ": parsed " + parsedNum + ", skipped " + skippedNum + " votes");
                        continue;
                    }
                    if (!f.getName().startsWith("cached-descriptors") && !f.getName().startsWith("cached-extrainfo")) continue;
                    String ascii = new String(allData, "US-ASCII");
                    int start = -1;
                    int sig = -1;
                    int end = -1;
                    String startToken = f.getName().startsWith("cached-descriptors") ? "router " : "extra-info ";
                    String sigToken = "\nrouter-signature\n";
                    String endToken = "\n-----END SIGNATURE-----\n";
                    int parsedNum = 0;
                    int skippedNum = 0;
                    while (end < ascii.length() && (start = ascii.indexOf(startToken, end)) >= 0 && (sig = ascii.indexOf(sigToken, start)) >= 0 && (end = ascii.indexOf(endToken, sig += sigToken.length())) >= 0) {
                        byte[] descBytes = new byte[(end += endToken.length()) - start];
                        System.arraycopy(allData, start, descBytes, 0, end - start);
                        if (rdp == null) continue;
                        String digest = Hex.encodeHexString(DigestUtils.sha1(descBytes));
                        if (!lastImportHistory.contains(digest) && !currentImportHistory.contains(digest)) {
                            rdp.parse(descBytes);
                            ++parsedNum;
                        } else {
                            ++skippedNum;
                        }
                        currentImportHistory.add(digest);
                    }
                    dumpStats.append("\n" + f.getName() + ": parsed " + parsedNum + ", skipped " + skippedNum + " " + (f.getName().startsWith("cached-descriptors") ? "server" : "extra-info") + " descriptors");
                }
                catch (IOException e) {
                    logger.warn("Failed reading " + cachedDescDir.getAbsolutePath() + " directory.", e);
                }
                catch (ParseException e) {
                    logger.warn("Failed reading " + cachedDescDir.getAbsolutePath() + " directory.", e);
                }
            }
            logger.debug("Finished reading " + cachedDescDir.getAbsolutePath() + " directory.");
        }
        try {
            importHistoryFile.getParentFile().mkdirs();
            BufferedWriter bw = new BufferedWriter(new FileWriter(importHistoryFile));
            for (String digest : currentImportHistory) {
                bw.write(digest + "\n");
            }
            bw.close();
        }
        catch (IOException e) {
            logger.warn("Could not write import history to " + importHistoryFile.getAbsolutePath() + ".", e);
        }
        logger.info(dumpStats.toString());
    }
}

