/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public abstract class DescriptorPersistence<T extends Descriptor> {
    protected static final Logger log = LoggerFactory.getLogger(DescriptorPersistence.class);
    protected static final String BRIDGEDESCS = "bridge-descriptors";
    protected static final String DASH = "-";
    protected static final String DOT = ".";
    protected static final String MICRODESC = "microdesc";
    protected static final String MICRODESCS = "microdescs";
    protected static final String RELAYDESCS = "relay-descriptors";
    protected static final String EXTRA_INFO = "extra-info";
    protected static final String EXTRA_INFOS = "extra-infos";
    protected static final String SERVERDESC = "server-descriptor";
    protected static final String SERVERDESCS = "server-descriptors";
    protected static final String WEBSTATS = "webstats";
    protected final T desc;
    protected final byte[] annotation;
    protected String storagePath;
    protected String recentPath;

    protected DescriptorPersistence(T desc, byte[] defaultAnnotation) {
        this.desc = desc;
        List<String> annotations = desc.getAnnotations();
        if (annotations.isEmpty()) {
            this.annotation = defaultAnnotation;
        } else {
            StringBuilder sb = new StringBuilder("");
            for (String annotation : annotations) {
                sb.append(annotation).append("\n");
            }
            this.annotation = sb.toString().getBytes();
        }
    }

    public boolean storeAll(String recentRoot, String outRoot) {
        return this.storeAll(recentRoot, outRoot, StandardOpenOption.APPEND, StandardOpenOption.CREATE_NEW);
    }

    public boolean storeAll(String recentRoot, String outRoot, StandardOpenOption optionRecent, StandardOpenOption optionOut) {
        if (this.storeOut(outRoot, optionOut)) {
            return this.storeRecent(recentRoot, optionRecent);
        }
        return false;
    }

    public boolean storeRecent(String recentRoot) {
        return this.storeRecent(recentRoot, StandardOpenOption.APPEND);
    }

    public boolean storeRecent(String recentRoot, StandardOpenOption option) {
        return PersistenceUtils.storeToFileSystem(this.annotation, this.desc.getRawDescriptorBytes(), Paths.get(recentRoot, this.getRecentPath()), option, true);
    }

    public boolean storeOut(String outRoot) {
        return this.storeOut(outRoot, StandardOpenOption.CREATE_NEW);
    }

    public boolean storeOut(String outRoot, StandardOpenOption option) {
        return PersistenceUtils.storeToFileSystem(this.annotation, this.desc.getRawDescriptorBytes(), Paths.get(outRoot, this.getStoragePath()), option);
    }

    public String getStoragePath() {
        if (null == this.storagePath) {
            throw new RuntimeException("Storage path not initialized!");
        }
        return this.storagePath;
    }

    public String getRecentPath() {
        if (null == this.recentPath) {
            throw new RuntimeException("Recent path not initialized!");
        }
        return this.recentPath;
    }
}

