/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.indexer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.index.DirectoryNode;
import org.torproject.descriptor.index.FileNode;
import org.torproject.descriptor.index.IndexNode;
import org.torproject.descriptor.internal.FileType;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.ConfigurationException;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.cron.CollecTorMain;

public class CreateIndexJson
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(CreateIndexJson.class);
    private static File indexJsonFile;
    private static String basePath;
    private static File[] indexedDirectories;
    private static final String dateTimePattern = "yyyy-MM-dd HH:mm";
    private static final Locale dateTimeLocale;
    private static final TimeZone dateTimezone;
    private static String buildRevision;
    private static DateFormat dateTimeFormat;

    public CreateIndexJson(Configuration conf) {
        super(conf);
        Properties buildProperties = new Properties();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("collector.buildrevision.properties");){
            buildProperties.load(is);
            buildRevision = buildProperties.getProperty("collector.build.revision", null);
        }
        catch (Exception ex) {
            logger.warn("No build revision available.", ex);
            buildRevision = null;
        }
    }

    @Override
    public String module() {
        return "updateindex";
    }

    @Override
    protected String syncMarker() {
        return "IndexJson";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        try {
            indexJsonFile = new File(this.config.getPath(Key.IndexPath).toFile(), "index.json");
            basePath = this.config.getProperty(Key.InstanceBaseUrl.name());
            indexedDirectories = new File[]{this.config.getPath(Key.ArchivePath).toFile(), this.config.getPath(Key.ContribPath).toFile(), this.config.getPath(Key.RecentPath).toFile()};
            this.writeIndex(this.indexDirectories());
        }
        catch (Exception e) {
            logger.error("Cannot run index creation: " + e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private IndexNode indexDirectories() {
        TreeSet<DirectoryNode> directoryNodes = new TreeSet<DirectoryNode>();
        logger.trace("indexing: " + indexedDirectories[0] + " " + indexedDirectories[1]);
        for (File directory : indexedDirectories) {
            DirectoryNode dn;
            if (!directory.exists() || !directory.isDirectory() || null == (dn = this.indexDirectory(directory))) continue;
            directoryNodes.add(dn);
        }
        return new IndexNode(dateTimeFormat.format(System.currentTimeMillis()), buildRevision, basePath, null, directoryNodes);
    }

    private DirectoryNode indexDirectory(File directory) {
        TreeSet<FileNode> fileNodes = new TreeSet<FileNode>();
        TreeSet<DirectoryNode> directoryNodes = new TreeSet<DirectoryNode>();
        logger.trace("indexing: " + directory);
        File[] fileList = directory.listFiles();
        if (null == fileList) {
            logger.warn("Indexing dubious directory: " + directory);
            return null;
        }
        for (File fileOrDirectory : fileList) {
            if (fileOrDirectory.getName().startsWith(".") || fileOrDirectory.getName().endsWith(".tmp")) continue;
            if (fileOrDirectory.isFile()) {
                fileNodes.add(this.indexFile(fileOrDirectory));
                continue;
            }
            DirectoryNode dn = this.indexDirectory(fileOrDirectory);
            if (null == dn) continue;
            directoryNodes.add(dn);
        }
        DirectoryNode directoryNode = new DirectoryNode(directory.getName(), fileNodes.isEmpty() ? null : fileNodes, directoryNodes.isEmpty() ? null : directoryNodes);
        return directoryNode;
    }

    private FileNode indexFile(File file) {
        FileNode fileNode = new FileNode(file.getName(), file.length(), dateTimeFormat.format(file.lastModified()));
        return fileNode;
    }

    private void writeIndex(IndexNode indexNode) throws Exception {
        indexJsonFile.getParentFile().mkdirs();
        String indexNodeString = IndexNode.makeJsonString(indexNode);
        for (String filename : new String[]{indexJsonFile.toString(), indexJsonFile + ".gz", indexJsonFile + ".xz", indexJsonFile + ".bz2"}) {
            FileType type = FileType.valueOf(filename.substring(filename.lastIndexOf(".") + 1).toUpperCase());
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(type.outputStream(new FileOutputStream(filename))));){
                bufferedWriter.write(indexNodeString);
            }
        }
    }

    static {
        dateTimeLocale = Locale.US;
        dateTimezone = TimeZone.getTimeZone("UTC");
        buildRevision = null;
        dateTimeFormat = new SimpleDateFormat(dateTimePattern, dateTimeLocale);
        dateTimeFormat.setLenient(false);
        dateTimeFormat.setTimeZone(dateTimezone);
    }
}

