/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.bridgedescs;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class DescriptorBuilder {
    private List<Object> parts = new ArrayList<Object>();
    private StringBuilder lastPart = new StringBuilder();
    private boolean finalized = false;
    private String value;

    public DescriptorBuilder() {
        this.parts.add(this.lastPart);
    }

    public DescriptorBuilder(String firstString) {
        this();
        this.append(firstString);
    }

    private void throwExceptionIfFinalized() {
        if (this.finalized) {
            throw new IllegalStateException("This DescriptorBuilder is finalized and calling anything other than 'toString' is illegal.");
        }
    }

    public DescriptorBuilder append(String sanitizedString) {
        this.throwExceptionIfFinalized();
        this.lastPart.append(sanitizedString);
        return this;
    }

    public DescriptorBuilder append(StringBuilder placeholder) {
        this.throwExceptionIfFinalized();
        this.parts.add(placeholder);
        this.lastPart = new StringBuilder();
        this.parts.add(this.lastPart);
        return this;
    }

    public DescriptorBuilder append(DescriptorBuilder placeholder) {
        this.throwExceptionIfFinalized();
        this.parts.add(placeholder);
        this.lastPart = new StringBuilder();
        this.parts.add(this.lastPart);
        return this;
    }

    public DescriptorBuilder space() {
        this.throwExceptionIfFinalized();
        this.lastPart.append(' ');
        return this;
    }

    public DescriptorBuilder newLine() {
        this.throwExceptionIfFinalized();
        this.lastPart.append('\n');
        return this;
    }

    public boolean hasContent() {
        return this.parts.size() > 1 || this.lastPart.length() > 0;
    }

    public String toString() {
        if (!this.finalized) {
            this.finalized = true;
            this.value = this.parts.stream().map(part -> part.toString()).collect(Collectors.joining(""));
            this.parts.clear();
            this.lastPart = null;
        }
        return this.value;
    }
}

