/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.webstats;

import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.internal.FileType;

public class LogMetadata {
    private static final Logger log = LoggerFactory.getLogger(LogMetadata.class);
    public static final Pattern filenamePattern = Pattern.compile("(\\S*)-access.log-(\\d{8})(?:\\.?)([a-zA-Z0-9]+)$");
    public final Path path;
    public final LocalDate date;
    public final FileType fileType;
    public final String physicalHost;
    public final String virtualHost;

    private LogMetadata(Path logPath, String physicalHost, String virtualHost, LocalDate logDate, FileType fileType) {
        this.path = logPath;
        this.date = logDate;
        this.fileType = fileType;
        this.physicalHost = physicalHost;
        this.virtualHost = virtualHost;
    }

    public static Optional<LogMetadata> create(Path logPath) {
        LogMetadata metadata = null;
        try {
            Path parentPath = logPath.getName(logPath.getNameCount() - 2);
            Path file = logPath.getFileName();
            if (null != parentPath && null != file) {
                String physicalHost = parentPath.toString();
                Matcher mat = filenamePattern.matcher(file.toString());
                if (mat.find()) {
                    String virtualHost = mat.group(1);
                    LocalDate logDate = LocalDate.parse(mat.group(2), DateTimeFormatter.BASIC_ISO_DATE);
                    if (null == virtualHost || null == physicalHost || null == logDate || virtualHost.isEmpty() || physicalHost.isEmpty()) {
                        log.debug("Non-matching file encountered: '{}/{}'.", (Object)parentPath, (Object)file);
                    } else {
                        metadata = new LogMetadata(logPath, physicalHost, virtualHost, logDate, FileType.findType(mat.group(3)));
                    }
                }
            }
        }
        catch (Throwable ex) {
            metadata = null;
            log.debug("Problem parsing path '{}'.", (Object)logPath, (Object)ex);
        }
        return Optional.ofNullable(metadata);
    }
}

