/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.SnowflakeStats;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.ParseHelper;

public class SnowflakeStatsImpl
extends DescriptorImpl
implements SnowflakeStats {
    private static final long serialVersionUID = 5588809239715099933L;
    private static final Set<Key> atMostOnce = EnumSet.of(Key.SNOWFLAKE_IPS, new Key[]{Key.SNOWFLAKE_IPS_TOTAL, Key.SNOWFLAKE_IPS_STANDALONE, Key.SNOWFLAKE_IPS_BADGE, Key.SNOWFLAKE_IPS_WEBEXT, Key.SNOWFLAKE_IDLE_COUNT, Key.CLIENT_DENIED_COUNT, Key.CLIENT_SNOWFLAKE_MATCH_COUNT});
    private static final Set<Key> exactlyOnce = EnumSet.of(Key.SNOWFLAKE_STATS_END);
    private LocalDateTime snowflakeStatsEnd;
    private Duration snowflakeStatsIntervalLength;
    private SortedMap<String, Long> snowflakeIps;
    private Long snowflakeIpsTotal;
    private Long snowflakeIpsStandalone;
    private Long snowflakeIpsBadge;
    private Long snowflakeIpsWebext;
    private Long snowflakeIdleCount;
    private Long clientDeniedCount;
    private Long clientRestrictedDeniedCount;
    private Long clientUnrestrictedDeniedCount;
    private Long clientSnowflakeMatchCount;
    private Long snowflakeIpsNatRestricted;
    private Long snowflakeIpsNatUnrestricted;
    private Long snowflakeIpsNatUnknown;

    SnowflakeStatsImpl(byte[] rawDescriptorBytes, int[] offsetAndLength, File descriptorFile) throws DescriptorParseException {
        super(rawDescriptorBytes, offsetAndLength, descriptorFile, false);
        this.parseDescriptorBytes();
        this.checkExactlyOnceKeys(exactlyOnce);
        this.checkAtMostOnceKeys(atMostOnce);
        this.checkFirstKey(Key.SNOWFLAKE_STATS_END);
        this.clearParsedKeys();
    }

    SnowflakeStatsImpl(byte[] rawDescriptorBytes, File descriptorFile) throws DescriptorParseException {
        this(rawDescriptorBytes, new int[]{0, rawDescriptorBytes.length}, descriptorFile);
    }

    private void parseDescriptorBytes() throws DescriptorParseException {
        Scanner scanner = this.newScanner().useDelimiter("\n");
        block16: while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.startsWith("@")) continue;
            String[] parts = line.split("[ \t]+");
            Key key = Key.get(parts[0]);
            switch (key) {
                case SNOWFLAKE_STATS_END: {
                    this.parseSnowflakeStatsEnd(line, parts);
                    continue block16;
                }
                case SNOWFLAKE_IPS: {
                    this.parseSnowflakeIps(line, parts);
                    continue block16;
                }
                case SNOWFLAKE_IPS_TOTAL: {
                    this.parseSnowflakeIpsTotal(line, parts);
                    continue block16;
                }
                case SNOWFLAKE_IPS_STANDALONE: {
                    this.parseSnowflakeIpsStandalone(line, parts);
                    continue block16;
                }
                case SNOWFLAKE_IPS_BADGE: {
                    this.parseSnowflakeIpsBadge(line, parts);
                    continue block16;
                }
                case SNOWFLAKE_IPS_WEBEXT: {
                    this.parseSnowflakeIpsWebext(line, parts);
                    continue block16;
                }
                case SNOWFLAKE_IDLE_COUNT: {
                    this.parseSnowflakeIdleCount(line, parts);
                    continue block16;
                }
                case CLIENT_DENIED_COUNT: {
                    this.parseClientDeniedCount(line, parts);
                    continue block16;
                }
                case CLIENT_RESTRICTED_DENIED_COUNT: {
                    this.parseClientRestrictedDeniedCount(line, parts);
                    continue block16;
                }
                case CLIENT_UNRESTRICTED_DENIED_COUNT: {
                    this.parseClientUnrestrictedDeniedCount(line, parts);
                    continue block16;
                }
                case CLIENT_SNOWFLAKE_MATCH_COUNT: {
                    this.parseClientSnowflakeMatchCount(line, parts);
                    continue block16;
                }
                case SNOWFLAKE_IPS_NAT_RESTRICTED: {
                    this.parseSnowflakeIpsNatRestricted(line, parts);
                    continue block16;
                }
                case SNOWFLAKE_IPS_NAT_UNRESTRICTED: {
                    this.parseSnowflakeIpsNatUnrestricted(line, parts);
                    continue block16;
                }
                case SNOWFLAKE_IPS_NAT_UNKNOWN: {
                    this.parseSnowflakeIpsNatUnknown(line, parts);
                    continue block16;
                }
            }
            ParseHelper.parseKeyword(line, parts[0]);
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseSnowflakeStatsEnd(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 5 || parts[3].length() < 2 || !parts[3].startsWith("(") || !parts[4].equals("s)")) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.snowflakeStatsEnd = ParseHelper.parseLocalDateTime(line, parts, 1, 2);
        this.snowflakeStatsIntervalLength = ParseHelper.parseDuration(line, parts[3].substring(1));
    }

    private void parseSnowflakeIps(String line, String[] parts) throws DescriptorParseException {
        this.snowflakeIps = ParseHelper.parseCommaSeparatedKeyLongValueList(line, parts, 1, 2);
    }

    private void parseSnowflakeIpsTotal(String line, String[] parts) throws DescriptorParseException {
        this.snowflakeIpsTotal = ParseHelper.parseLong(line, parts, 1);
    }

    private void parseSnowflakeIpsStandalone(String line, String[] parts) throws DescriptorParseException {
        this.snowflakeIpsStandalone = ParseHelper.parseLong(line, parts, 1);
    }

    private void parseSnowflakeIpsBadge(String line, String[] parts) throws DescriptorParseException {
        this.snowflakeIpsBadge = ParseHelper.parseLong(line, parts, 1);
    }

    private void parseSnowflakeIpsWebext(String line, String[] parts) throws DescriptorParseException {
        this.snowflakeIpsWebext = ParseHelper.parseLong(line, parts, 1);
    }

    private void parseSnowflakeIdleCount(String line, String[] parts) throws DescriptorParseException {
        this.snowflakeIdleCount = ParseHelper.parseLong(line, parts, 1);
    }

    private void parseClientDeniedCount(String line, String[] parts) throws DescriptorParseException {
        this.clientDeniedCount = ParseHelper.parseLong(line, parts, 1);
    }

    private void parseClientRestrictedDeniedCount(String line, String[] parts) throws DescriptorParseException {
        this.clientRestrictedDeniedCount = ParseHelper.parseLong(line, parts, 1);
    }

    private void parseClientUnrestrictedDeniedCount(String line, String[] parts) throws DescriptorParseException {
        this.clientUnrestrictedDeniedCount = ParseHelper.parseLong(line, parts, 1);
    }

    private void parseClientSnowflakeMatchCount(String line, String[] parts) throws DescriptorParseException {
        this.clientSnowflakeMatchCount = ParseHelper.parseLong(line, parts, 1);
    }

    private void parseSnowflakeIpsNatRestricted(String line, String[] parts) throws DescriptorParseException {
        this.snowflakeIpsNatRestricted = ParseHelper.parseLong(line, parts, 1);
    }

    private void parseSnowflakeIpsNatUnrestricted(String line, String[] parts) throws DescriptorParseException {
        this.snowflakeIpsNatUnrestricted = ParseHelper.parseLong(line, parts, 1);
    }

    private void parseSnowflakeIpsNatUnknown(String line, String[] parts) throws DescriptorParseException {
        this.snowflakeIpsNatUnknown = ParseHelper.parseLong(line, parts, 1);
    }

    @Override
    public LocalDateTime snowflakeStatsEnd() {
        return this.snowflakeStatsEnd;
    }

    @Override
    public Duration snowflakeStatsIntervalLength() {
        return this.snowflakeStatsIntervalLength;
    }

    @Override
    public Optional<SortedMap<String, Long>> snowflakeIps() {
        return Optional.ofNullable(this.snowflakeIps);
    }

    @Override
    public Optional<Long> snowflakeIpsTotal() {
        return Optional.ofNullable(this.snowflakeIpsTotal);
    }

    @Override
    public Optional<Long> snowflakeIpsStandalone() {
        return Optional.ofNullable(this.snowflakeIpsStandalone);
    }

    @Override
    public Optional<Long> snowflakeIpsBadge() {
        return Optional.ofNullable(this.snowflakeIpsBadge);
    }

    @Override
    public Optional<Long> snowflakeIpsWebext() {
        return Optional.ofNullable(this.snowflakeIpsWebext);
    }

    @Override
    public Optional<Long> snowflakeIdleCount() {
        return Optional.ofNullable(this.snowflakeIdleCount);
    }

    @Override
    public Optional<Long> clientDeniedCount() {
        return Optional.ofNullable(this.clientDeniedCount);
    }

    @Override
    public Optional<Long> clientRestrictedDeniedCount() {
        return Optional.ofNullable(this.clientRestrictedDeniedCount);
    }

    @Override
    public Optional<Long> clientUnrestrictedDeniedCount() {
        return Optional.ofNullable(this.clientUnrestrictedDeniedCount);
    }

    @Override
    public Optional<Long> clientSnowflakeMatchCount() {
        return Optional.ofNullable(this.clientSnowflakeMatchCount);
    }

    @Override
    public Optional<Long> snowflakeIpsNatRestricted() {
        return Optional.ofNullable(this.snowflakeIpsNatRestricted);
    }

    @Override
    public Optional<Long> snowflakeIpsNatUnrestricted() {
        return Optional.ofNullable(this.snowflakeIpsNatUnrestricted);
    }

    @Override
    public Optional<Long> snowflakeIpsNatUnknown() {
        return Optional.ofNullable(this.snowflakeIpsNatUnknown);
    }
}

