/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.webstats;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.WebServerAccessLog;
import org.torproject.metrics.collector.webstats.FileType;
import org.torproject.metrics.collector.webstats.WebServerAccessLogLine;

public class WebServerAccessLogImpl
implements WebServerAccessLog {
    public static final String SEP = "_";
    public static final String MARKER = "access.log";
    public static final Pattern filenamePattern = Pattern.compile("(\\S*)_(\\S*)_access.log_(\\d*)(?:\\.?)([a-zA-Z]*)");
    private final File descriptorFile;
    private byte[] logBytes;
    private FileType fileType;
    private List<String> unrecognizedLines = new ArrayList<String>();
    private final String physicalHost;
    private final String virtualHost;
    private final LocalDate logDate;
    private static final int LISTLIMIT = 0x3FFFFFFF;

    protected WebServerAccessLogImpl(byte[] logBytes, File descriptorFile, String logName) throws DescriptorParseException {
        this.logBytes = logBytes;
        this.descriptorFile = descriptorFile;
        try {
            Matcher mat = filenamePattern.matcher(logName);
            if (!mat.find()) {
                throw new DescriptorParseException("Log file name doesn't comply to standard: " + logName);
            }
            this.virtualHost = mat.group(1);
            this.physicalHost = mat.group(2);
            if (null == this.virtualHost || null == this.physicalHost || this.virtualHost.isEmpty() || this.physicalHost.isEmpty()) {
                throw new DescriptorParseException("WebServerAccessLog file name doesn't comply to standard: " + logName);
            }
            String ymd = mat.group(3);
            this.logDate = LocalDate.parse(ymd, DateTimeFormatter.BASIC_ISO_DATE);
            this.fileType = FileType.findType(mat.group(4).toUpperCase());
            if (FileType.PLAIN == this.fileType) {
                this.fileType = FileType.XZ;
                this.logBytes = this.fileType.compress(this.logBytes);
            }
        }
        catch (DescriptorParseException dpe) {
            throw dpe;
        }
        catch (Exception pe) {
            throw new DescriptorParseException("Cannot parse WebServerAccessLog file: " + logName, pe);
        }
    }

    protected WebServerAccessLogImpl(String virtualHost, String physicalHost, LocalDate logDate) {
        this.descriptorFile = null;
        this.virtualHost = virtualHost;
        this.physicalHost = physicalHost;
        this.logDate = logDate;
    }

    public InputStream decompressedByteStream() throws DescriptorParseException {
        try {
            return this.fileType.decompress(new ByteArrayInputStream(this.logBytes));
        }
        catch (Exception ex) {
            throw new DescriptorParseException("Cannot provide deflated stream of " + this.descriptorFile + ".", ex);
        }
    }

    public String getCompressionType() {
        return this.fileType.name().toLowerCase();
    }

    public byte[] getRawDescriptorBytes() {
        return this.logBytes;
    }

    public void setRawDescriptorBytes(byte[] bytes) {
        this.logBytes = bytes;
    }

    public int getRawDescriptorLength() {
        return this.logBytes.length;
    }

    public List<String> getAnnotations() {
        return Collections.emptyList();
    }

    public List<String> getUnrecognizedLines() {
        return this.unrecognizedLines;
    }

    public File getDescriptorFile() {
        return this.descriptorFile;
    }

    public String getPhysicalHost() {
        return this.physicalHost;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public LocalDate getLogDate() {
        return this.logDate;
    }

    public Stream<WebServerAccessLog.Line> logLines() throws DescriptorParseException {
        Stream<WebServerAccessLog.Line> stream;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.decompressedByteStream()));
        try {
            ArrayList lists = new ArrayList();
            ArrayList<WebServerAccessLogLine> currentList = new ArrayList<WebServerAccessLogLine>();
            lists.add(currentList);
            String lineStr = br.readLine();
            int count = 0;
            while (null != lineStr) {
                WebServerAccessLogLine wsal = WebServerAccessLogLine.makeLine(lineStr);
                if (wsal.isValid()) {
                    currentList.add(wsal);
                    ++count;
                }
                if (count >= 0x3FFFFFFF) {
                    currentList = new ArrayList();
                    lists.add(currentList);
                    count = 0;
                }
                lineStr = br.readLine();
            }
            br.close();
            stream = lists.stream().flatMap(Collection::stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new DescriptorParseException("Cannot retrieve log lines.", ex);
            }
        }
        br.close();
        return stream;
    }
}

