/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.webstats;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.Method;
import org.torproject.descriptor.WebServerAccessLog;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.conf.SourceType;
import org.torproject.metrics.collector.cron.CollecTorMain;
import org.torproject.metrics.collector.persist.PersistenceUtils;
import org.torproject.metrics.collector.persist.WebServerAccessLogPersistence;
import org.torproject.metrics.collector.webstats.FileType;
import org.torproject.metrics.collector.webstats.LogFileMap;
import org.torproject.metrics.collector.webstats.LogMetadata;
import org.torproject.metrics.collector.webstats.WebServerAccessLogImpl;
import org.torproject.metrics.collector.webstats.WebServerAccessLogLine;

public class SanitizeWeblogs
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(SanitizeWeblogs.class);
    private static final int LIMIT = 2;
    private static final String WEBSTATS = "webstats";
    private Path outputDirectory;
    private Path recentDirectory;
    private Path processedWebstatsFile;
    private boolean limits;
    private static final int BATCH = 100000;
    private static final int LISTLIMIT = 0x3FFFFFFF;

    public SanitizeWeblogs(Configuration conf) {
        super(conf);
        this.mapPathDescriptors.put("recent/webstats", WebServerAccessLog.class);
    }

    @Override
    public String module() {
        return WEBSTATS;
    }

    @Override
    protected String syncMarker() {
        return "Webstats";
    }

    @Override
    protected void startProcessing() {
        try {
            Files.createDirectories(this.config.getPath(Key.OutputPath), new FileAttribute[0]);
            Files.createDirectories(this.config.getPath(Key.RecentPath), new FileAttribute[0]);
            Files.createDirectories(this.config.getPath(Key.StatsPath), new FileAttribute[0]);
            this.outputDirectory = this.config.getPath(Key.OutputPath);
            this.recentDirectory = this.config.getPath(Key.RecentPath);
            this.processedWebstatsFile = this.config.getPath(Key.StatsPath).resolve("processed-webstats");
            this.limits = this.config.getBool(Key.WebstatsLimits);
            Set<SourceType> sources = this.config.getSourceTypeSet(Key.WebstatsSources);
            if (sources.contains((Object)SourceType.Local)) {
                logger.info("Processing logs using batch value {}.", (Object)100000);
                Map<LogMetadata, Set<LocalDate>> previouslyProcessedWebstats = this.readProcessedWebstats();
                Map<LogMetadata, Set<LocalDate>> newlyProcessedWebstats = this.findCleanWrite(this.config.getPath(Key.WebstatsLocalOrigins), previouslyProcessedWebstats);
                this.writeProcessedWebstats(newlyProcessedWebstats);
                PersistenceUtils.cleanDirectory(Paths.get(this.recentDirectory.toString(), WEBSTATS), Instant.now().minus(3L, ChronoUnit.DAYS).toEpochMilli());
                PersistenceUtils.cleanDirectory(Paths.get(this.outputDirectory.toString(), WEBSTATS), Instant.now().minus(49L, ChronoUnit.DAYS).toEpochMilli());
            }
        }
        catch (Exception e) {
            logger.error("Cannot sanitize web-logs: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private Map<LogMetadata, Set<LocalDate>> readProcessedWebstats() {
        HashMap<LogMetadata, Set<LocalDate>> processedWebstats = new HashMap<LogMetadata, Set<LocalDate>>();
        if (Files.exists(this.processedWebstatsFile, new LinkOption[0])) {
            try {
                for (String line : Files.readAllLines(this.processedWebstatsFile)) {
                    String[] lineParts = line.split(",", 2);
                    Optional<LogMetadata> logMetadata = LogMetadata.create(Paths.get(lineParts[1], new String[0]));
                    if (!logMetadata.isPresent()) continue;
                    processedWebstats.putIfAbsent(logMetadata.get(), new HashSet());
                    LocalDate containedLogDate = LocalDate.parse(lineParts[0]);
                    ((Set)processedWebstats.get(logMetadata.get())).add(containedLogDate);
                }
            }
            catch (IOException e) {
                logger.error("Cannot read state file {}.", (Object)this.processedWebstatsFile, (Object)e);
            }
            logger.debug("Read state file containing {} log files.", (Object)processedWebstats.size());
        }
        return processedWebstats;
    }

    private Map<LogMetadata, Set<LocalDate>> findCleanWrite(Path dir, Map<LogMetadata, Set<LocalDate>> previouslyProcessedWebstats) {
        HashMap<LogMetadata, Set<LocalDate>> newlyProcessedWebstats = new HashMap<LogMetadata, Set<LocalDate>>();
        LogFileMap fileMapIn = new LogFileMap(dir);
        logger.info("Found log files for {} virtual hosts.", (Object)fileMapIn.size());
        for (Map.Entry virtualEntry : fileMapIn.entrySet()) {
            String virtualHost = (String)virtualEntry.getKey();
            for (Map.Entry physicalEntry : ((TreeMap)virtualEntry.getValue()).entrySet()) {
                String physicalHost = (String)physicalEntry.getKey();
                logger.info("Processing logs for {} on {}.", (Object)virtualHost, (Object)physicalHost);
                HashMap<LocalDate, Map<String, Long>> sanitizedLinesByDate = new HashMap<LocalDate, Map<String, Long>>();
                HashSet<LogMetadata> previouslyReadFiles = new HashSet<LogMetadata>();
                for (LogMetadata logMetadata : ((TreeMap)physicalEntry.getValue()).values()) {
                    Set<LocalDate> containedLogDates;
                    if (previouslyProcessedWebstats.containsKey(logMetadata)) {
                        containedLogDates = previouslyProcessedWebstats.get(logMetadata);
                        for (LocalDate date : containedLogDates) {
                            sanitizedLinesByDate.putIfAbsent(date, new TreeMap());
                        }
                        previouslyReadFiles.add(logMetadata);
                    } else {
                        containedLogDates = this.sanitizeWebstatsLog(sanitizedLinesByDate, logMetadata);
                    }
                    newlyProcessedWebstats.put(logMetadata, containedLogDates);
                }
                HashSet<LocalDate> storeDates = new HashSet<LocalDate>();
                LocalDate[] interval = this.determineInterval(sanitizedLinesByDate.keySet());
                for (LocalDate newDate : sanitizedLinesByDate.keySet()) {
                    WebServerAccessLogPersistence walp;
                    Path outputPath;
                    if (!newDate.isAfter(interval[0]) || !newDate.isBefore(interval[1]) || Files.exists(outputPath = this.outputDirectory.resolve((walp = new WebServerAccessLogPersistence(new WebServerAccessLogImpl(virtualHost, physicalHost, newDate))).getStoragePath()), new LinkOption[0])) continue;
                    storeDates.add(newDate);
                }
                for (LogMetadata previouslyReadFile : previouslyReadFiles) {
                    if (Collections.disjoint(storeDates, (Collection)newlyProcessedWebstats.get(previouslyReadFile))) continue;
                    this.sanitizeWebstatsLog(sanitizedLinesByDate, previouslyReadFile);
                }
                ((Stream)sanitizedLinesByDate.entrySet().stream().filter(entry -> storeDates.contains(entry.getKey())).parallel()).forEach(entry -> this.storeSortedAndForget(virtualHost, physicalHost, (LocalDate)entry.getKey(), (Map)entry.getValue()));
            }
        }
        return newlyProcessedWebstats;
    }

    private Set<LocalDate> sanitizeWebstatsLog(Map<LocalDate, Map<String, Long>> sanitizedLinesByDate, LogMetadata logFile) {
        Map<LocalDate, Map<String, Long>> newlySanitizedLinesByDate = this.sanitzedLineStream(logFile);
        for (Map.Entry<LocalDate, Map<String, Long>> e : newlySanitizedLinesByDate.entrySet()) {
            sanitizedLinesByDate.putIfAbsent(e.getKey(), new TreeMap());
            Map<String, Long> newlySanitizedLines = sanitizedLinesByDate.get(e.getKey());
            for (Map.Entry<String, Long> e1 : e.getValue().entrySet()) {
                newlySanitizedLines.put(e1.getKey(), newlySanitizedLines.getOrDefault(e1.getKey(), 0L) + e1.getValue());
            }
        }
        return newlySanitizedLinesByDate.keySet();
    }

    private void storeSortedAndForget(String virtualHost, String physicalHost, LocalDate date, Map<String, Long> lineCounts) {
        String name = new StringJoiner("_").add(virtualHost).add(physicalHost).add("access.log").add(date.format(DateTimeFormatter.BASIC_ISO_DATE)).toString() + "." + FileType.XZ.name().toLowerCase();
        logger.debug("Storing {}.", (Object)name);
        TreeMap<String, Long> retainedLines = new TreeMap<String, Long>(lineCounts);
        lineCounts.clear();
        try {
            WebServerAccessLogPersistence walp = new WebServerAccessLogPersistence(new WebServerAccessLogImpl(SanitizeWeblogs.toCompressedBytes(retainedLines), new File(name), name));
            logger.debug("Storing {}.", (Object)name);
            walp.storeOut(this.outputDirectory.toString());
            walp.storeRecent(this.recentDirectory.toString());
        }
        catch (DescriptorParseException dpe) {
            logger.error("Cannot store log desriptor {}.", (Object)name, (Object)dpe);
        }
        catch (Throwable th) {
            logger.error("Serious problem.  Cannot store log desriptor {}.", (Object)name, (Object)th);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] toCompressedBytes(Map<String, Long> lines) throws DescriptorParseException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            block17: {
                OutputStream os = FileType.XZ.outputStream(baos);
                try {
                    block12: for (Map.Entry<String, Long> entry : lines.entrySet()) {
                        byte[] batch = null;
                        for (long count = entry.getValue().longValue(); count > 0L; count -= 100000L) {
                            if (count > 100000L) {
                                if (null == batch) {
                                    batch = SanitizeWeblogs.bytesFor(entry.getKey(), 100000L);
                                }
                                os.write(batch);
                                continue;
                            }
                            os.write(SanitizeWeblogs.bytesFor(entry.getKey(), count));
                            continue block12;
                        }
                    }
                    os.flush();
                    os.close();
                    object = baos.toByteArray();
                    if (os == null) break block17;
                }
                catch (Throwable throwable) {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                os.close();
            }
            return object;
        }
        catch (Exception ex) {
            throw new DescriptorParseException(ex.getMessage());
        }
    }

    public static byte[] bytesFor(String line, long times) {
        return Stream.iterate(line, UnaryOperator.identity()).limit(times).collect(Collectors.joining("\n", "", "\n")).getBytes();
    }

    static Optional<WebServerAccessLogLine> sanitize(WebServerAccessLogLine logLine) {
        int queryStart;
        if (!logLine.isValid() || Method.GET != logLine.getMethod() && Method.HEAD != logLine.getMethod() || !logLine.getProtocol().startsWith("HTTP") || 400 == logLine.getResponse() || 404 == logLine.getResponse()) {
            return Optional.empty();
        }
        if (!logLine.getIp().startsWith("0.0.0.")) {
            logLine.setIp("0.0.0.0");
        }
        if ((queryStart = logLine.getRequest().indexOf("?")) > 0) {
            logLine.setRequest(logLine.getRequest().substring(0, queryStart));
        }
        return Optional.of(logLine);
    }

    LocalDate[] determineInterval(Set<LocalDate> dates) {
        if (dates.isEmpty()) {
            return new LocalDate[]{LocalDate.MAX, LocalDate.MIN};
        }
        TreeSet<LocalDate> sorted = new TreeSet<LocalDate>(dates);
        if (this.limits) {
            for (int i = 0; i < 1; ++i) {
                sorted.remove(sorted.last());
            }
        }
        if (sorted.isEmpty()) {
            return new LocalDate[]{LocalDate.MAX, LocalDate.MIN};
        }
        if (!this.limits) {
            sorted.add(((LocalDate)sorted.first()).minusDays(1L));
            sorted.add(((LocalDate)sorted.last()).plusDays(1L));
        }
        return new LocalDate[]{(LocalDate)sorted.first(), (LocalDate)sorted.last()};
    }

    private Map<LocalDate, Map<String, Long>> sanitzedLineStream(LogMetadata metadata) {
        Map map2;
        logger.debug("Processing file {}.", (Object)metadata.path);
        BufferedReader br = new BufferedReader(new InputStreamReader(metadata.fileType.decompress(Files.newInputStream(metadata.path, new OpenOption[0]))));
        try {
            ArrayList lists = new ArrayList();
            ArrayList<WebServerAccessLogLine> currentList = new ArrayList<WebServerAccessLogLine>();
            lists.add(currentList);
            String lineStr = br.readLine();
            int count = 0;
            while (null != lineStr) {
                WebServerAccessLogLine wsal = WebServerAccessLogLine.makeLine(lineStr);
                if (wsal.isValid()) {
                    currentList.add(wsal);
                    ++count;
                }
                if (count >= 0x3FFFFFFF) {
                    currentList = new ArrayList();
                    lists.add(currentList);
                    count = 0;
                }
                lineStr = br.readLine();
            }
            br.close();
            map2 = ((Stream)lists.parallelStream().map(list -> list.stream().map(SanitizeWeblogs::sanitize).filter(Optional::isPresent).map(Optional::get).collect(Collectors.groupingBy(WebServerAccessLogLine::getDate, Collectors.groupingBy(WebServerAccessLogLine::toLogString, Collectors.counting())))).flatMap(map -> map.entrySet().stream()).parallel()).collect(Collectors.groupingByConcurrent(Map.Entry::getKey, Collectors.reducing(Collections.emptyMap(), Map.Entry::getValue, (e1, e2) -> ((Stream)Stream.concat(e1.entrySet().stream(), e2.entrySet().stream()).parallel()).collect(Collectors.groupingByConcurrent(Map.Entry::getKey, Collectors.summingLong(Map.Entry::getValue))))));
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                logger.debug("Skipping log-file {}.", (Object)metadata.path, (Object)ex);
                return Collections.emptyMap();
            }
        }
        br.close();
        return map2;
    }

    private void writeProcessedWebstats(Map<LogMetadata, Set<LocalDate>> newlyProcessedWebstats) {
        try {
            if (!Files.exists(this.processedWebstatsFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.processedWebstatsFile.getParent(), new FileAttribute[0]);
            }
            ArrayList<String> lines = new ArrayList<String>();
            for (Map.Entry<LogMetadata, Set<LocalDate>> e : newlyProcessedWebstats.entrySet()) {
                for (LocalDate logLineDate : e.getValue()) {
                    lines.add(String.format("%s,%s", logLineDate, e.getKey().path));
                }
            }
            Files.write(this.processedWebstatsFile, lines, new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error("Cannot write state file {}.", (Object)this.processedWebstatsFile, (Object)e);
        }
        logger.debug("Wrote state file containing {} log files.", (Object)newlyProcessedWebstats.size());
    }
}

