/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.relaydescs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.collector.relaydescs.RelayDescriptorParser;

public class ArchiveReader {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveReader.class);
    private Map<String, Set<String>> microdescriptorValidAfterTimes = new HashMap<String, Set<String>>();
    private RelayDescriptorParser rdp;
    private File archivesDirectory;
    private boolean keepImportHistory;
    private int parsedFiles = 0;
    private int ignoredFiles = 0;
    private SortedSet<String> archivesImportHistory = new TreeSet<String>();
    private File archivesImportHistoryFile;

    ArchiveReader(RelayDescriptorParser rdp, File archivesDirectory, File statsDirectory, boolean keepImportHistory) {
        if (rdp == null || archivesDirectory == null || statsDirectory == null) {
            throw new IllegalArgumentException();
        }
        this.rdp = rdp;
        this.rdp.setArchiveReader(this);
        this.archivesDirectory = archivesDirectory;
        this.keepImportHistory = keepImportHistory;
        this.archivesImportHistoryFile = new File(statsDirectory, "archives-import-history");
    }

    public void readDescriptors() {
        this.readHistoryFile();
        this.readDescriptorFiles();
        this.writeHistoryFile();
    }

    private void readHistoryFile() {
        if (this.keepImportHistory && this.archivesImportHistoryFile.exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(this.archivesImportHistoryFile));
                while ((line = br.readLine()) != null) {
                    this.archivesImportHistory.add(line);
                }
                br.close();
            }
            catch (IOException e) {
                logger.warn("Could not read in archives import history file. Skipping.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readDescriptorFiles() {
        if (this.archivesDirectory.exists()) {
            logger.debug("Importing files in directory {}/...", (Object)this.archivesDirectory);
            Stack<File> filesInInputDir = new Stack<File>();
            filesInInputDir.add(this.archivesDirectory);
            ArrayList<Object> problems = new ArrayList<Object>();
            HashSet<Object> filesToRetry = new HashSet<Object>();
            while (!filesInInputDir.isEmpty()) {
                File pop = (File)filesInInputDir.pop();
                if (pop.isDirectory()) {
                    Collections.addAll(filesInInputDir, pop.listFiles());
                    continue;
                }
                try {
                    void var5_8;
                    int n;
                    FileInputStream fis;
                    if (this.keepImportHistory && this.archivesImportHistory.contains(pop.getName())) {
                        ++this.ignoredFiles;
                        continue;
                    }
                    if (pop.getName().endsWith(".tar.bz2")) {
                        logger.warn("Cannot parse compressed tarball {}. Skipping.", (Object)pop.getAbsolutePath());
                        continue;
                    }
                    if (pop.getName().endsWith(".bz2")) {
                        fis = new FileInputStream(pop);
                        BZip2CompressorInputStream bZip2CompressorInputStream = new BZip2CompressorInputStream((InputStream)fis);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)bZip2CompressorInputStream);
                    } else {
                        fis = new FileInputStream(pop);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fis);
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] data = new byte[1024];
                    while ((n = var5_8.read(data, 0, 1024)) >= 0) {
                        baos.write(data, 0, n);
                    }
                    var5_8.close();
                    byte[] allData = baos.toByteArray();
                    boolean stored = this.rdp.parse(allData, pop);
                    if (!stored) {
                        filesToRetry.add(pop);
                        continue;
                    }
                    if (this.keepImportHistory) {
                        this.archivesImportHistory.add(pop.getName());
                    }
                    ++this.parsedFiles;
                }
                catch (IOException iOException) {
                    problems.add(pop);
                    if (problems.size() <= 3) continue;
                    break;
                }
            }
            for (File file : filesToRetry) {
                try {
                    int start;
                    String line;
                    int len;
                    BufferedInputStream bis;
                    if (file.getName().endsWith(".bz2")) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BZip2CompressorInputStream bcis = new BZip2CompressorInputStream((InputStream)fileInputStream);
                        bis = new BufferedInputStream((InputStream)bcis);
                    } else {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        bis = new BufferedInputStream(fileInputStream);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] data = new byte[1024];
                    while ((len = bis.read(data, 0, 1024)) >= 0) {
                        byteArrayOutputStream.write(data, 0, len);
                    }
                    bis.close();
                    byte[] allData = byteArrayOutputStream.toByteArray();
                    BufferedReader br = new BufferedReader(new StringReader(new String(allData, StandardCharsets.US_ASCII)));
                    while ((line = br.readLine()) != null && line.startsWith("@")) {
                    }
                    br.close();
                    if (line == null) {
                        logger.debug("We were given an empty descriptor for parsing. Ignoring.");
                        continue;
                    }
                    if (!line.equals("onion-key")) {
                        logger.debug("Skipping non-recognized descriptor.");
                        continue;
                    }
                    SimpleDateFormat parseFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String ascii = new String(allData, StandardCharsets.US_ASCII);
                    int end = -1;
                    String startToken = "onion-key\n";
                    while (end < ascii.length() && (start = ascii.indexOf(startToken, end)) >= 0 && ((end = ascii.indexOf(startToken, start + 1)) >= 0 || (end = ascii.length()) > start)) {
                        byte[] descBytes = new byte[end - start];
                        System.arraycopy(allData, start, descBytes, 0, end - start);
                        String digest256Base64 = Base64.encodeBase64String((byte[])DigestUtils.sha256((byte[])descBytes)).replaceAll("=", "");
                        String digest256Hex = DigestUtils.sha256Hex((byte[])descBytes);
                        if (!this.microdescriptorValidAfterTimes.containsKey(digest256Hex)) {
                            logger.debug("Could not store microdescriptor '{}', which was not contained in a microdesc consensus.", (Object)digest256Hex);
                            continue;
                        }
                        for (String validAfterTime : this.microdescriptorValidAfterTimes.get(digest256Hex)) {
                            try {
                                long validAfter = parseFormat.parse(validAfterTime).getTime();
                                this.rdp.storeMicrodescriptor(descBytes, digest256Hex, digest256Base64, validAfter);
                            }
                            catch (ParseException e) {
                                logger.warn("Could not parse valid-after time '{}'. Not storing microdescriptor.", (Object)validAfterTime, (Object)e);
                            }
                        }
                    }
                    if (this.keepImportHistory) {
                        this.archivesImportHistory.add(file.getName());
                    }
                    ++this.parsedFiles;
                }
                catch (IOException e) {
                    problems.add(file);
                    if (problems.size() <= 3) continue;
                    break;
                }
            }
            if (problems.isEmpty()) {
                logger.debug("Finished importing files in directory {}/.", (Object)this.archivesDirectory);
            } else {
                StringBuilder sb = new StringBuilder("Failed importing files in directory " + this.archivesDirectory + "/:");
                boolean bl = false;
                for (File file : problems) {
                    void var5_13;
                    sb.append("\n  ").append(file.getAbsolutePath());
                    if (++var5_13 < 3) continue;
                    sb.append("\n  ... more");
                    break;
                }
                logger.warn(sb.toString());
            }
        }
    }

    private void writeHistoryFile() {
        if (this.keepImportHistory) {
            try {
                this.archivesImportHistoryFile.getParentFile().mkdirs();
                BufferedWriter bw = new BufferedWriter(new FileWriter(this.archivesImportHistoryFile));
                for (String line : this.archivesImportHistory) {
                    bw.write(line + "\n");
                }
                bw.close();
            }
            catch (IOException e) {
                logger.warn("Could not write archives import history file.");
            }
        }
        logger.info("Finished importing relay descriptors from local directory:\nParsed {}, ignored {} files.", (Object)this.parsedFiles, (Object)this.ignoredFiles);
    }

    void haveParsedMicrodescConsensus(String validAfterTime, SortedSet<String> microdescriptorDigests) {
        for (String microdescriptor : microdescriptorDigests) {
            this.microdescriptorValidAfterTimes.putIfAbsent(microdescriptor, new HashSet());
            this.microdescriptorValidAfterTimes.get(microdescriptor).add(validAfterTime);
        }
    }
}

