/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.DirectorySignature;
import org.torproject.descriptor.RelayNetworkStatusVote;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.persist.DescriptorPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class VotePersistence
extends DescriptorPersistence<RelayNetworkStatusVote> {
    private static final Logger logger = LoggerFactory.getLogger(VotePersistence.class);
    private static final String VOTE = "vote";
    private static final String VOTES = "votes";

    public VotePersistence(RelayNetworkStatusVote desc, long received) {
        super(desc, Annotation.Vote.bytes());
        this.calculatePaths(received);
    }

    private void calculatePaths(long received) {
        String fileOut = PersistenceUtils.dateTime(((RelayNetworkStatusVote)this.desc).getValidAfterMillis());
        String[] parts = fileOut.split("-");
        String digest = VotePersistence.calcDigestFromBytes(((RelayNetworkStatusVote)this.desc).getRawDescriptorBytes());
        fileOut = fileOut + "-vote-" + ((DirectorySignature)((RelayNetworkStatusVote)this.desc).getSignatures().get(0)).getIdentity() + "-" + digest;
        this.recentPath = Paths.get("relay-descriptors", VOTES, fileOut).toString();
        this.storagePath = Paths.get("relay-descriptors", VOTE, parts[0], parts[1], parts[2], fileOut).toString();
    }

    private static String calcDigestFromBytes(byte[] bytes) {
        String digest = "";
        String startToken = "network-status-version ";
        String sigToken = "directory-signature ";
        String ascii = new String(bytes, StandardCharsets.US_ASCII);
        int start = ascii.indexOf(startToken);
        int sig = ascii.indexOf(sigToken);
        if (start >= 0 && sig >= 0 && sig > start) {
            byte[] forDigest = new byte[(sig += sigToken.length()) - start];
            System.arraycopy(bytes, start, forDigest, 0, sig - start);
            digest = DigestUtils.sha1Hex((byte[])forDigest).toUpperCase();
        } else {
            logger.error("No digest calculation possible.  Returning empty string.");
        }
        return digest;
    }
}

