/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.file.Paths;
import org.torproject.descriptor.Microdescriptor;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.persist.DescriptorPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class MicrodescriptorPersistence
extends DescriptorPersistence<Microdescriptor> {
    private static final String RELAY_DESCRIPTORS = "relay-descriptors";

    public MicrodescriptorPersistence(Microdescriptor descriptor, long received, String year, String month) {
        super(descriptor, Annotation.Microdescriptor.bytes());
        this.calculatePaths(received, year, month);
    }

    private void calculatePaths(long received, String year, String month) {
        String file = PersistenceUtils.dateTime(received);
        this.recentPath = Paths.get(RELAY_DESCRIPTORS, "microdescs", "micro", file + "-micro-" + year + "-" + month).toString();
        String digest = ((Microdescriptor)this.desc).getDigestSha256Hex();
        this.storagePath = Paths.get(RELAY_DESCRIPTORS, "microdesc", year, month, "micro", digest.substring(0, 1), digest.substring(1, 2), digest).toString();
    }
}

