/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.torproject.descriptor.Descriptor;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public abstract class DescriptorPersistence<T extends Descriptor> {
    protected static final String BRIDGEDESCS = "bridge-descriptors";
    protected static final String BRIDGEPOOLASSIGNMENTS = "bridge-pool-assignments";
    protected static final String BRIDGEDBSTATS = "bridgedb-stats";
    protected static final String DASH = "-";
    protected static final String DOT = ".";
    protected static final String MICRODESC = "microdesc";
    protected static final String MICRODESCS = "microdescs";
    protected static final String RELAYDESCS = "relay-descriptors";
    protected static final String EXTRA_INFO = "extra-info";
    protected static final String EXTRA_INFOS = "extra-infos";
    protected static final String SERVERDESC = "server-descriptor";
    protected static final String SERVERDESCS = "server-descriptors";
    protected static final String WEBSTATS = "webstats";
    protected T desc;
    protected final byte[] annotationBytes;
    protected final byte[] descriptorBytes;
    protected String storagePath;
    protected String recentPath;
    protected static final byte[] EMPTY_ANNOTATION = new byte[0];

    protected DescriptorPersistence(T descriptor, byte[] defaultAnnotationBytes) {
        this.desc = descriptor;
        List annotations = descriptor.getAnnotations();
        if (annotations.isEmpty()) {
            this.annotationBytes = defaultAnnotationBytes;
        } else {
            StringBuilder sb = new StringBuilder();
            for (String annotation : annotations) {
                sb.append(annotation).append("\n");
            }
            this.annotationBytes = sb.toString().getBytes();
        }
        this.descriptorBytes = descriptor.getRawDescriptorBytes();
    }

    protected DescriptorPersistence(byte[] descriptorBytes) {
        this.annotationBytes = EMPTY_ANNOTATION;
        this.descriptorBytes = descriptorBytes;
    }

    public boolean storeAll(Path recentRoot, Path outRoot) {
        return this.storeAll(recentRoot.toString(), outRoot.toString());
    }

    public boolean storeAll(String recentRoot, String outRoot) {
        return this.storeAll(recentRoot, outRoot, StandardOpenOption.APPEND, StandardOpenOption.CREATE_NEW);
    }

    public boolean storeAll(String recentRoot, String outRoot, StandardOpenOption optionRecent, StandardOpenOption optionOut) {
        if (this.storeOut(outRoot, optionOut)) {
            return this.storeRecent(recentRoot, optionRecent);
        }
        return false;
    }

    public boolean storeRecent(String recentRoot) {
        return this.storeRecent(recentRoot, StandardOpenOption.APPEND);
    }

    public boolean storeRecent(String recentRoot, StandardOpenOption option) {
        return PersistenceUtils.storeToFileSystem(this.annotationBytes, this.descriptorBytes, Paths.get(recentRoot, this.getRecentPath()), option, true);
    }

    public boolean storeOut(String outRoot) {
        return this.storeOut(outRoot, StandardOpenOption.CREATE_NEW);
    }

    public boolean storeOut(String outRoot, StandardOpenOption option) {
        return PersistenceUtils.storeToFileSystem(this.annotationBytes, this.descriptorBytes, Paths.get(outRoot, this.getStoragePath()), option);
    }

    public String getStoragePath() {
        if (null == this.storagePath) {
            throw new RuntimeException("Storage path not initialized!");
        }
        return this.storagePath;
    }

    public String getRecentPath() {
        if (null == this.recentPath) {
            throw new RuntimeException("Recent path not initialized!");
        }
        return this.recentPath;
    }
}

