/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.file.Paths;
import org.torproject.descriptor.BridgeServerDescriptor;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.persist.DescriptorPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class BridgeServerDescriptorPersistence
extends DescriptorPersistence<BridgeServerDescriptor> {
    public BridgeServerDescriptorPersistence(BridgeServerDescriptor descriptor, long received) {
        super(descriptor, Annotation.BridgeServer.bytes());
        this.calculatePaths(PersistenceUtils.dateTimeParts(descriptor.getPublishedMillis()), PersistenceUtils.dateTime(received), descriptor.getDigestSha1Hex().toLowerCase());
    }

    public BridgeServerDescriptorPersistence(byte[] descriptorBytes, String publishedString, String receivedString, String descriptorDigest) {
        super(descriptorBytes);
        this.calculatePaths(publishedString.split("[ :-]"), receivedString, descriptorDigest.toLowerCase());
    }

    private void calculatePaths(String[] publishedParts, String receivedString, String descriptorDigest) {
        this.recentPath = Paths.get("bridge-descriptors", "server-descriptors", receivedString + "-" + "server-descriptors").toString();
        this.storagePath = Paths.get("bridge-descriptors", publishedParts[0], publishedParts[1], "server-descriptors", descriptorDigest.substring(0, 1), descriptorDigest.substring(1, 2), descriptorDigest).toString();
    }
}

