/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.indexer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.Instant;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Future;

@JsonPropertyOrder(value={"path", "size", "last_modified", "types", "first_published", "last_published", "sha256"})
class FileNode {
    @JsonProperty(value="path")
    String path;
    @JsonProperty(value="size")
    Long size;
    @JsonProperty(value="last_modified")
    String lastModified;
    @JsonProperty(value="types")
    SortedSet<String> types;
    @JsonProperty(value="first_published")
    String firstPublished;
    @JsonProperty(value="last_published")
    String lastPublished;
    @JsonProperty(value="sha256")
    String sha256;
    @JsonIgnore
    Future<FileNode> indexerResult;
    @JsonIgnore
    Instant markedForDeletion;

    FileNode() {
    }

    static FileNode of(String path, Long size, String lastModified, Iterable<String> types, String firstPublished, String lastPublished, String sha256) {
        FileNode fileNode = new FileNode();
        fileNode.path = path;
        fileNode.size = size;
        fileNode.lastModified = lastModified;
        fileNode.types = new TreeSet<String>();
        for (String type : types) {
            fileNode.types.add(type);
        }
        fileNode.firstPublished = firstPublished;
        fileNode.lastPublished = lastPublished;
        fileNode.sha256 = sha256;
        return fileNode;
    }
}

